/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.fileSystem;

import edu.xtec.jclic.clic3.Clic3;
import edu.xtec.jclic.fileSystem.FilePCC;
import edu.xtec.jclic.fileSystem.FileSystem;
import edu.xtec.jclic.fileSystem.UrlPCC;
import edu.xtec.util.ResourceBridge;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.IOException;

public abstract class PCCFileSystem
extends FileSystem {
    String pccName;
    public String pccVersion;
    public String pccDescription;
    public int numFiles;
    public int baseOffset;
    PCCFileEntry[] fe;

    public PCCFileSystem(ResourceBridge rb) {
        super("", rb);
    }

    public PCCFileSystem(String rootPath, String pccFileName, ResourceBridge rb) {
        super(rootPath, rb);
        this.pccName = this.getCanonicalNameOf(pccFileName);
    }

    public static PCCFileSystem createPCCFileSystem(String rootPath, String pccFileName, ResourceBridge rb) throws Exception {
        if (PCCFileSystem.isStrUrl(rootPath)) {
            return new UrlPCC(rootPath, pccFileName, rb);
        }
        return new FilePCC(rootPath, pccFileName, rb);
    }

    @Override
    public String getFullRoot() {
        return this.root + this.pccName;
    }

    void initPCC(DataInputStream dis) throws Exception {
        this.pccVersion = this.extractLineFromDIS(dis);
        if (this.pccVersion != null && this.pccVersion.compareTo("PCC00") == 0) {
            this.pccDescription = this.extractLineFromDIS(dis);
            this.numFiles = this.extractShortInt(dis);
            this.baseOffset = (int)this.extractShortLong(dis);
            this.fe = new PCCFileEntry[this.numFiles];
            for (int i = 0; i < this.numFiles; ++i) {
                this.fe[i] = new PCCFileEntry(Clic3.validFileName(this.extractSzString(dis)), this.extractShortLong(dis), this.extractShortLong(dis));
                if (this.fe[i].fileName.length() == 0) break;
            }
        }
    }

    public String getEntryInfo(int n) {
        return n < 0 || n >= this.numFiles ? "OUT OF INDEX!" : this.fe[n].toString();
    }

    public String getEntryName(int n) {
        return n < 0 || n >= this.numFiles ? "OUT OF INDEX!" : this.fe[n].fileName;
    }

    public int getEntryNum(String fName) {
        int i = -1;
        String normalizedFName = PCCFileSystem.stdFn(fName);
        if (this.numFiles > 0) {
            for (i = 0; i < this.numFiles && !this.fe[i].fileName.equals(normalizedFName); ++i) {
            }
        }
        if (i == this.numFiles && altFileNames.get(fName) != null) {
            normalizedFName = PCCFileSystem.stdFn((String)altFileNames.get(fName));
            for (i = 0; i < this.numFiles && !this.fe[i].fileName.equals(normalizedFName); ++i) {
            }
        }
        return i == this.numFiles ? -1 : i;
    }

    protected abstract byte[] getBytes(int var1) throws IOException;

    @Override
    public byte[] getBytes(String fileName) throws IOException {
        int entryNum = this.getEntryNum(fileName);
        if (entryNum == -1) {
            return super.getBytes(fileName);
        }
        return this.getBytes(entryNum);
    }

    @Override
    public long getFileLength(String fileName) throws IOException {
        int entryNum = this.getEntryNum(fileName);
        return entryNum == -1 ? super.getFileLength(fileName) : this.fe[entryNum].size;
    }

    @Override
    public Image getImageFile(String fName) throws Exception {
        int entryNum = this.getEntryNum(fName);
        return entryNum == -1 ? super.getImageFile(fName) : Toolkit.getDefaultToolkit().createImage(this.getBytes(entryNum));
    }

    public DataInputStream getDataInputStream(String fName) throws IOException {
        return new DataInputStream(super.getInputStream(fName));
    }

    public String extractLine(BufferedReader bfr) throws IOException {
        return bfr.readLine();
    }

    public String extractLineFromDIS(DataInputStream dis) throws IOException {
        StringBuilder str = new StringBuilder();
        boolean skipNext = false;
        while (true) {
            byte b = dis.readByte();
            if (skipNext) break;
            if (b == 13) {
                skipNext = true;
                continue;
            }
            str.append((char)b);
        }
        return str.substring(0);
    }

    public String extractSzString(BufferedReader bfr) throws IOException {
        StringBuilder str = new StringBuilder();
        char[] b = new char[1];
        while (true) {
            bfr.read(b, 0, 1);
            if (b[0] == '\u0000') break;
            str.append(b[0]);
        }
        return str.substring(0);
    }

    public String extractSzString(DataInputStream dis) throws IOException {
        byte b;
        StringBuilder str = new StringBuilder();
        while ((b = dis.readByte()) != 0) {
            str.append((char)b);
        }
        return str.substring(0);
    }

    public int extractShortInt(DataInputStream bfr) throws IOException {
        int bt;
        int r = bt = bfr.readUnsignedByte();
        bt = bfr.readUnsignedByte();
        return r += bt << 8;
    }

    public long extractShortLong(DataInputStream bfr) throws IOException {
        long bt;
        long r = bt = (long)bfr.readUnsignedByte();
        bt = bfr.readUnsignedByte();
        r += bt << 8;
        bt = bfr.readUnsignedByte();
        r += bt << 16;
        bt = bfr.readUnsignedByte();
        return r += bt << 24;
    }

    @Override
    public void close() {
        this.fe = null;
        super.close();
    }

    protected class PCCFileEntry {
        String fileName;
        long size;
        long offset;

        public PCCFileEntry(String fName, long o, long s) {
            this.fileName = FileSystem.stdFn(fName);
            this.size = s;
            this.offset = o;
        }
    }
}

