/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.fileSystem;

import edu.xtec.jclic.fileSystem.PCCFileSystem;
import edu.xtec.util.ResourceBridge;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;

public class UrlPCC
extends PCCFileSystem {
    byte[] pccBytes = super.getBytes(this.pccName);

    public UrlPCC(String rootPath, String fName, ResourceBridge rb) throws Exception {
        super(rootPath, fName, rb);
        ByteArrayInputStream bais = new ByteArrayInputStream(this.pccBytes);
        DataInputStream dis = new DataInputStream(bais);
        this.initPCC(dis);
        dis.close();
    }

    @Override
    protected byte[] getBytes(int entryNum) throws IOException {
        long fileSize = this.fe[entryNum].size;
        long offset = this.fe[entryNum].offset;
        byte[] b = new byte[(int)fileSize];
        if (fileSize > 0L) {
            System.arraycopy(this.pccBytes, (int)offset, b, 0, (int)fileSize);
        }
        return b;
    }

    @Override
    public void close() {
        this.pccBytes = null;
        super.close();
    }
}

