/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.fileSystem;

import edu.xtec.jclic.fileSystem.FileSystem;
import edu.xtec.jclic.fileSystem.FileZip;
import edu.xtec.jclic.fileSystem.UrlZip;
import edu.xtec.util.ExtendedByteArrayInputStream;
import edu.xtec.util.ResourceBridge;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.zip.ZipEntry;

public abstract class ZipFileSystem
extends FileSystem {
    String zipName;
    protected boolean loaded;
    ExtendedZipEntry[] entries;

    public ZipFileSystem(ResourceBridge rb) {
        super("", rb);
        this.entries = null;
        this.zipName = null;
        this.loaded = false;
    }

    public ZipFileSystem(String rootPath, String zipFileName, ResourceBridge rb) {
        super(rootPath, rb);
        this.zipName = this.getCanonicalNameOf(zipFileName);
        this.entries = null;
        this.loaded = false;
    }

    public static ZipFileSystem createZipFileSystem(String rootPath, String zipFileName, ResourceBridge rb) throws Exception {
        if (ZipFileSystem.isStrUrl(rootPath)) {
            return new UrlZip(rootPath, zipFileName, rb);
        }
        return new FileZip(rootPath, zipFileName, rb);
    }

    @Override
    public String getFullRoot() {
        return this.root + this.zipName;
    }

    public String getZipName() {
        return this.zipName;
    }

    public ExtendedZipEntry getEntry(String fName) {
        if (fName == null || fName.length() == 0 || this.entries == null) {
            return null;
        }
        String name = this.getCanonicalNameOf(fName);
        for (ExtendedZipEntry eze : this.entries) {
            if (eze.ignore || !eze.getName().equals(name)) continue;
            return eze;
        }
        return null;
    }

    @Override
    public byte[] getBytes(String fileName) throws IOException {
        ExtendedZipEntry entry = this.getEntry(fileName);
        if (entry == null) {
            return super.getBytes(fileName);
        }
        return entry.getBytes();
    }

    @Override
    public boolean fileExists(String fName) {
        return this.getEntry(fName) != null;
    }

    @Override
    public boolean realFileExists(String fName) {
        return super.fileExists(fName);
    }

    @Override
    public long getFileLength(String fileName) throws IOException {
        ExtendedZipEntry entry = this.getEntry(fileName);
        if (entry == null) {
            return super.getFileLength(fileName);
        }
        return entry.getSize();
    }

    @Override
    public Image getImageFile(String fName) throws Exception {
        ExtendedZipEntry entry = this.getEntry(fName);
        if (entry == null) {
            return super.getImageFile(fName);
        }
        return Toolkit.getDefaultToolkit().createImage(entry.getBytes());
    }

    @Override
    public InputStream getInputStream(String fName) throws IOException {
        ExtendedZipEntry entry = this.getEntry(fName);
        if (entry == null) {
            return super.getInputStream(fName);
        }
        return entry.getInputStream();
    }

    @Override
    public Object getMediaDataSource(String fName) throws Exception {
        ExtendedZipEntry entry = this.getEntry(fName);
        if (entry == null) {
            return super.getMediaDataSource(fName);
        }
        return new ExtendedByteArrayInputStream(entry.getBytes(), fName);
    }

    public String[] getEntries(String ext) throws Exception {
        String[] result = null;
        if (this.entries != null && this.entries.length > 0) {
            ArrayList<String> v = new ArrayList<String>();
            for (ExtendedZipEntry eze : this.entries) {
                String entryName = eze.getName();
                if (ext != null && !entryName.endsWith(ext)) continue;
                v.add(entryName);
            }
            if (!v.isEmpty()) {
                result = v.toArray(new String[v.size()]);
            }
        }
        return result;
    }

    @Override
    public void close() {
        this.entries = null;
        super.close();
    }

    public abstract class ExtendedZipEntry
    extends ZipEntry {
        public boolean ignore;

        ExtendedZipEntry(ZipEntry entry) {
            super(entry);
        }

        public abstract byte[] getBytes() throws IOException;

        public abstract InputStream getInputStream() throws IOException;

        @Override
        public String getName() {
            return FileSystem.stdFn(super.getName());
        }
    }
}

