/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.media;

import edu.xtec.jclic.media.QT61Tools;
import edu.xtec.util.Check;
import edu.xtec.util.Options;

public final class CheckMediaSystem {
    public static final String QTLOCK = "QTLOCK";
    static final String BUNDLE = "messages.CheckMediaSystemMessages";
    public static Object qtLock = null;
    public static Object qt61Lock = null;

    public static boolean check(Options options, boolean showWarning) {
        boolean checkQT;
        boolean result = false;
        boolean qt = qtLock != null;
        boolean qt61 = qt61Lock != null;
        boolean bl = checkQT = options.getBoolean("Mac") && !options.getBoolean("arch64bit") || "true".equalsIgnoreCase(System.getProperty("FORCE_USE_QT"));
        if (checkQT && !qt61) {
            try {
                if (CheckMediaSystem.class.getResource("/quicktime/app/view/QTFactory.class") != null) {
                    Class.forName("quicktime.app.view.QTFactory");
                    qt61 = true;
                    qt = false;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        options.put("QuickTime 6.1", qt61);
        options.put("QuickTime", qt);
        boolean jmf = false;
        try {
            if (CheckMediaSystem.class.getResource("/javax/media/Player.class") != null) {
                Class.forName("javax.media.Player");
                jmf = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        options.put("Java Media Framework", jmf);
        String mediaSystem = (String)options.get("mediaSystem");
        if (mediaSystem != null) {
            if (mediaSystem.equals("QuickTime")) {
                if (qt61) {
                    mediaSystem = "QuickTime 6.1";
                } else if (!qt) {
                    mediaSystem = null;
                }
            } else if (mediaSystem.equals("Java Media Framework")) {
                if (!jmf) {
                    mediaSystem = null;
                }
            } else {
                mediaSystem = null;
            }
        }
        if (mediaSystem == null) {
            String string = qt61 ? "QuickTime 6.1" : (mediaSystem = jmf ? "Java Media Framework" : null);
        }
        if (mediaSystem != null && mediaSystem.equals("QuickTime 6.1") && qt61Lock == null) {
            try {
                qt61Lock = new QT61Tools();
                options.put(QTLOCK, qt61Lock);
            }
            catch (Exception ex) {
                options.getMessages().showErrorWarning(options.getMainComponent(), "media_qt_error_initializing", ex);
                mediaSystem = jmf ? "Java Media Framework" : null;
            }
        }
        options.put("mediaSystem", mediaSystem);
        if (showWarning && mediaSystem == null) {
            CheckMediaSystem.warn(options);
        }
        return mediaSystem != null;
    }

    public static void warn(Options options) {
        if (!options.getBoolean("NoMediaSystemWarn")) {
            Check.showUrlPane(options, "media_check_url");
            options.putBoolean("NoMediaSystemWarn", true);
        }
    }
}

