/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.misc;

import edu.xtec.jclic.Constants;
import edu.xtec.util.Messages;
import edu.xtec.util.Options;
import edu.xtec.util.ResourceManager;
import edu.xtec.util.SimpleFileFilter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.IllegalComponentStateException;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.geom.Area;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import javax.swing.ImageIcon;

public abstract class Utils
implements Constants {
    public static final int JCLIC_FF = 0;
    public static final int JCLIC_ZIP_FF = 1;
    public static final int PAC_FF = 2;
    public static final int PCC_FF = 3;
    public static final int ALL_JCLIC_FF = 4;
    public static final int ALL_CLIC_FF = 5;
    public static final int ALL_JCLIC_CLIC_FF = 6;
    public static final int INSTALL_FF = 7;
    public static final int GIF_FF = 8;
    public static final int JPG_FF = 9;
    public static final int PNG_FF = 10;
    public static final int ALL_IMAGES_FF = 11;
    public static final int ALL_FF = 12;
    public static final int ALL_SOUNDS_FF = 13;
    public static final int MIDI_FF = 14;
    public static final int ALL_VIDEO_FF = 15;
    public static final int ALL_ANIM_FF = 16;
    public static final int SKINS_FF = 17;
    public static final int FONTS_FF = 18;
    public static final int ALL_MEDIA_FF = 19;
    public static final int ALL_MULTIMEDIA_FF = 20;
    public static final int ALL_HTML_FF = 21;
    public static final int TEXT_FF = 22;
    public static final int ALL_JCLIC_SCORM_FF = 23;
    public static final int NUM_FILE_FILTERS = 24;
    private static SimpleFileFilter[] fileFilters = new SimpleFileFilter[24];
    public static final String EXT_JCLIC = ".jclic";
    public static final String EXT_JCLIC_ZIP = ".jclic.zip";
    public static final String EXT_SCORM_ZIP = ".scorm.zip";
    public static final String EXT_PAC = ".pac";
    public static final String EXT_PCC = ".pcc";
    public static final String EXT_INSTALL = ".jclic.inst";
    public static final String EXT_GIF = ".gif";
    public static final String EXT_JPG = ".jpg";
    public static final String EXT_PNG = ".png";
    public static final String EXT_BMP = ".bmp";
    public static final String EXT_ICO = ".ico";
    public static final String EXT_WAV = ".wav";
    public static final String EXT_AU = ".au";
    public static final String EXT_MP3 = ".mp3";
    public static final String EXT_AIFF = ".aiff";
    public static final String EXT_MID = ".mid";
    public static final String EXT_OGG = ".ogg";
    public static final String EXT_AVI = ".avi";
    public static final String EXT_MOV = ".mov";
    public static final String EXT_MPEG = ".mpeg";
    public static final String EXT_SWF = ".swf";
    public static final String EXT_XML = ".xml";
    public static final String EXT_TTF = ".ttf";
    public static final String EXT_HTM = ".htm";
    public static final String EXT_HTML = ".html";
    public static final String EXT_TXT = ".txt";
    public static final String EXT_ALL = ".*";
    public static final String[] EXT_ALL_JCLIC = new String[]{".jclic", ".jclic.zip"};
    public static final String[] EXT_ALL_JCLIC_SCORM = new String[]{".jclic", ".jclic.zip", ".scorm.zip"};
    public static final String[] EXT_ALL_CLIC = new String[]{".pac", ".pcc"};
    public static final String[] EXT_ALL_JCLIC_CLIC = new String[]{".jclic", ".jclic.zip", ".pac", ".pcc"};
    public static final String[] EXT_ALL_IMAGES = new String[]{".gif", ".jpg", ".png", ".bmp", ".ico"};
    public static final String[] EXT_ALL_SOUNDS = new String[]{".wav", ".au", ".mp3", ".ogg", ".aiff"};
    public static final String[] EXT_ALL_VIDEO = new String[]{".avi", ".mov", ".mpeg", ".swf"};
    public static final String[] EXT_ALL_ANIM = new String[]{".swf"};
    public static final String[] EXT_ALL_MEDIA = new String[]{".gif", ".jpg", ".png", ".bmp", ".ico", ".wav", ".au", ".mp3", ".ogg", ".aiff", ".mid", ".avi", ".mov", ".mpeg", ".swf", ".ttf", ".xml"};
    public static final String[] EXT_ALL_MULTIMEDIA = new String[]{".wav", ".au", ".mp3", ".ogg", ".aiff", ".mid", ".avi", ".mov", ".mpeg", ".swf"};
    public static final String[] EXT_ALL_HTML = new String[]{".htm", ".html"};
    public static final int TYPE_IMAGE = 0;
    public static final int TYPE_AUDIO = 1;
    public static final int TYPE_MIDI = 2;
    public static final int TYPE_VIDEO = 3;
    public static final int TYPE_ANIM = 4;
    public static final int TYPE_XML = 5;
    public static final int TYPE_FONT = 6;
    public static final int TYPE_JCLIC = 7;
    public static final int TYPE_CLIC = 8;
    public static final int TYPE_INST = 9;
    public static final int TYPE_TEXT = 10;
    public static final int TYPE_UNKNOWN = 11;
    public static final String[] TYPE_CODES = new String[]{"ftype_image", "ftype_audio", "ftype_midi", "ftype_video", "ftype_anim", "ftype_xml", "ftype_font", "ftype_jclic", "ftype_clic", "ftype_inst", "ftype_text", "ftype_unknown"};
    public static final int[] T_CODES = new int[]{16, 32, 64, 128, 256, 512, 1024, 2048, 4096, 8192, 32768, 16384};
    public static final long LOW_MEMORY_THRESHOLD = 0x400000L;

    public static int getFileType(String fileName) {
        int dot;
        int result = 11;
        if (fileName != null && (dot = fileName.lastIndexOf(46)) > 0) {
            String fn;
            if (fileName.substring(0, dot).toLowerCase().endsWith(EXT_JCLIC)) {
                dot -= 6;
            }
            if ((fn = fileName.substring(dot).toLowerCase()).equals(EXT_GIF) || fn.equals(EXT_JPG) || fn.equals(EXT_PNG) || fn.equals(EXT_BMP) || fn.equals(EXT_ICO)) {
                result = 0;
            } else if (fn.equals(EXT_WAV) || fn.equals(EXT_AU) || fn.equals(EXT_MP3) || fn.equals(EXT_OGG) || fn.equals(EXT_AIFF)) {
                result = 1;
            } else if (fn.equals(EXT_MID)) {
                result = 2;
            } else if (fn.equals(EXT_AVI) || fn.equals(EXT_MOV) || fn.equals(EXT_MPEG)) {
                result = 3;
            } else if (fn.equals(EXT_SWF)) {
                result = 4;
            } else if (fn.equals(EXT_XML)) {
                result = 5;
            } else if (fn.equals(EXT_TTF)) {
                result = 6;
            } else if (fn.equals(EXT_JCLIC) || fn.equals(EXT_JCLIC_ZIP)) {
                result = 7;
            } else if (fn.equals(EXT_PAC) || fn.equals(EXT_PCC)) {
                result = 8;
            } else if (fn.equals(EXT_INSTALL)) {
                result = 9;
            } else if (fn.equals(EXT_TXT)) {
                result = 10;
            }
        }
        return result;
    }

    public static ImageIcon getFileIcon(String forFileName) {
        String imgKey = "icons/icounknown.png";
        switch (Utils.getFileType(forFileName)) {
            case 1: {
                imgKey = "icons/icowave.png";
                break;
            }
            case 2: {
                imgKey = "icons/icomidi.png";
                break;
            }
            case 3: 
            case 4: {
                imgKey = "icons/icomci.png";
                break;
            }
            case 6: {
                imgKey = "icons/icottf.png";
                break;
            }
            case 5: {
                imgKey = "icons/icoxml.png";
            }
        }
        return ResourceManager.getImageIcon(imgKey);
    }

    public static int getFileFilterCode(String forFileName) {
        int result = 12;
        switch (Utils.getFileType(forFileName)) {
            case 0: {
                result = 11;
                break;
            }
            case 1: {
                result = 13;
                break;
            }
            case 2: {
                result = 14;
                break;
            }
            case 3: {
                result = 15;
                break;
            }
            case 4: {
                result = 16;
                break;
            }
            case 5: {
                result = 17;
                break;
            }
            case 6: {
                result = 18;
                break;
            }
            case 7: {
                result = 4;
                break;
            }
            case 8: {
                result = 5;
                break;
            }
            case 9: {
                result = 7;
                break;
            }
            case 10: {
                result = 22;
            }
        }
        return result;
    }

    public static SimpleFileFilter getFileFilter(int fileFilterCode, Messages msg) {
        if (fileFilterCode < 0 || fileFilterCode >= 24) {
            return null;
        }
        if (fileFilters[fileFilterCode] == null) {
            switch (fileFilterCode) {
                case 0: {
                    Utils.fileFilters[fileFilterCode] = new SimpleFileFilter(EXT_JCLIC, msg.get("filefilter_jclic"));
                    break;
                }
                case 1: {
                    Utils.fileFilters[fileFilterCode] = new SimpleFileFilter(EXT_JCLIC_ZIP, msg.get("filefilter_jclic_zip"));
                    break;
                }
                case 2: {
                    Utils.fileFilters[fileFilterCode] = new SimpleFileFilter(EXT_PAC, msg.get("filefilter_pac"));
                    break;
                }
                case 3: {
                    Utils.fileFilters[fileFilterCode] = new SimpleFileFilter(EXT_PCC, msg.get("filefilter_pcc"));
                    break;
                }
                case 4: {
                    Utils.fileFilters[fileFilterCode] = new SimpleFileFilter(EXT_ALL_JCLIC, msg.get("filefilter_all_jclic"));
                    break;
                }
                case 23: {
                    Utils.fileFilters[fileFilterCode] = new SimpleFileFilter(EXT_ALL_JCLIC_SCORM, msg.get("filefilter_all_jclic_scorm"));
                    break;
                }
                case 5: {
                    Utils.fileFilters[fileFilterCode] = new SimpleFileFilter(EXT_ALL_CLIC, msg.get("filefilter_all_clic"));
                    break;
                }
                case 6: {
                    Utils.fileFilters[fileFilterCode] = new SimpleFileFilter(EXT_ALL_JCLIC_CLIC, msg.get("filefilter_all_jclic_clic"));
                    break;
                }
                case 7: {
                    Utils.fileFilters[fileFilterCode] = new SimpleFileFilter(EXT_INSTALL, msg.get("filefilter_install"));
                    break;
                }
                case 8: {
                    Utils.fileFilters[fileFilterCode] = new SimpleFileFilter(EXT_GIF, msg.get("filefilter_gif"));
                    break;
                }
                case 9: {
                    Utils.fileFilters[fileFilterCode] = new SimpleFileFilter(EXT_JPG, msg.get("filefilter_jpg"));
                    break;
                }
                case 10: {
                    Utils.fileFilters[fileFilterCode] = new SimpleFileFilter(EXT_PNG, msg.get("filefilter_png"));
                    break;
                }
                case 11: {
                    Utils.fileFilters[fileFilterCode] = new SimpleFileFilter(EXT_ALL_IMAGES, msg.get("filefilter_all_images"));
                    break;
                }
                case 13: {
                    Utils.fileFilters[fileFilterCode] = new SimpleFileFilter(EXT_ALL_SOUNDS, msg.get("filefilter_all_sounds"));
                    break;
                }
                case 14: {
                    Utils.fileFilters[fileFilterCode] = new SimpleFileFilter(EXT_MID, msg.get("filefilter_midi"));
                    break;
                }
                case 15: {
                    Utils.fileFilters[fileFilterCode] = new SimpleFileFilter(EXT_ALL_VIDEO, msg.get("filefilter_all_video"));
                    break;
                }
                case 16: {
                    Utils.fileFilters[fileFilterCode] = new SimpleFileFilter(EXT_ALL_ANIM, msg.get("filefilter_all_anim"));
                    break;
                }
                case 17: {
                    Utils.fileFilters[fileFilterCode] = new SimpleFileFilter(EXT_XML, msg.get("filefilter_skins"));
                    break;
                }
                case 18: {
                    Utils.fileFilters[fileFilterCode] = new SimpleFileFilter(EXT_TTF, msg.get("filefilter_fonts"));
                    break;
                }
                case 19: {
                    Utils.fileFilters[fileFilterCode] = new SimpleFileFilter(EXT_ALL_MEDIA, msg.get("filefilter_all_media"));
                    break;
                }
                case 20: {
                    Utils.fileFilters[fileFilterCode] = new SimpleFileFilter(EXT_ALL_MULTIMEDIA, msg.get("filefilter_all_media"));
                    break;
                }
                case 21: {
                    Utils.fileFilters[fileFilterCode] = new SimpleFileFilter(EXT_ALL_HTML, msg.get("filefilter_all_html"));
                    break;
                }
                case 22: {
                    Utils.fileFilters[fileFilterCode] = new SimpleFileFilter(EXT_TXT, msg.get("filefilter_text"));
                    break;
                }
                case 12: {
                    Utils.fileFilters[fileFilterCode] = new SimpleFileFilter(EXT_ALL, msg.get("filefilter_all"));
                }
            }
        }
        return fileFilters[fileFilterCode];
    }

    public static String[] getFileFilterExtensions(int fileFilterCode) {
        String[] result = null;
        if (fileFilterCode >= 0 && fileFilterCode < 24) {
            switch (fileFilterCode) {
                case 0: {
                    result = new String[]{EXT_JCLIC};
                    break;
                }
                case 1: {
                    result = new String[]{EXT_JCLIC_ZIP};
                    break;
                }
                case 2: {
                    result = new String[]{EXT_PAC};
                    break;
                }
                case 3: {
                    result = new String[]{EXT_PCC};
                    break;
                }
                case 4: {
                    result = EXT_ALL_JCLIC;
                    break;
                }
                case 23: {
                    result = EXT_ALL_JCLIC_SCORM;
                    break;
                }
                case 5: {
                    result = EXT_ALL_CLIC;
                    break;
                }
                case 6: {
                    result = EXT_ALL_JCLIC_CLIC;
                    break;
                }
                case 7: {
                    result = new String[]{EXT_INSTALL};
                    break;
                }
                case 8: {
                    result = new String[]{EXT_GIF};
                    break;
                }
                case 9: {
                    result = new String[]{EXT_JPG};
                    break;
                }
                case 10: {
                    result = new String[]{EXT_PNG};
                    break;
                }
                case 11: {
                    result = EXT_ALL_IMAGES;
                    break;
                }
                case 13: {
                    result = EXT_ALL_SOUNDS;
                    break;
                }
                case 14: {
                    result = new String[]{EXT_MID};
                    break;
                }
                case 15: {
                    result = EXT_ALL_VIDEO;
                    break;
                }
                case 16: {
                    result = EXT_ALL_ANIM;
                    break;
                }
                case 17: {
                    result = new String[]{EXT_XML};
                    break;
                }
                case 18: {
                    result = new String[]{EXT_TTF};
                    break;
                }
                case 19: {
                    result = EXT_ALL_MEDIA;
                    break;
                }
                case 20: {
                    result = EXT_ALL_MULTIMEDIA;
                    break;
                }
                case 22: {
                    result = new String[]{EXT_TXT};
                }
            }
        }
        return result;
    }

    public static BufferedImage toBufferedImage(Image image, Color bgColor, ImageObserver io) {
        int w = image.getWidth(io);
        int h = image.getHeight(io);
        BufferedImage bufferedImage = new BufferedImage(w, h, 1);
        Graphics2D g = bufferedImage.createGraphics();
        g.drawImage(image, 0, 0, bgColor, io);
        g.dispose();
        return bufferedImage;
    }

    public static void drawImage(Graphics g, Image img, Rectangle dest, Rectangle source, ImageObserver io) {
        if (g.getClip().intersects(dest)) {
            g.drawImage(img, dest.x, dest.y, dest.x + dest.width, dest.y + dest.height, source.x, source.y, source.x + source.width, source.y + source.height, io);
        }
    }

    public static void tileImage(Graphics g, Image img, Rectangle dest, Rectangle source, ImageObserver io) {
        if (g.getClip().intersects(dest)) {
            Area saveClip = new Area(g.getClip());
            Area newClip = new Area(saveClip);
            newClip.intersect(new Area(dest));
            g.setClip(newClip);
            Rectangle floatDest = new Rectangle(dest.x, dest.y, source.width, source.height);
            for (int y = 0; y < dest.height; y += source.height) {
                for (int x = 0; x < dest.width; x += source.width) {
                    floatDest.setLocation(dest.x + x, dest.y + y);
                    Utils.drawImage(g, img, floatDest, source, io);
                }
            }
            g.setClip(saveClip);
        }
    }

    public static Point mapPointTo(Component srcCmp, Point offset, Component destCmp) {
        Point p = new Point();
        try {
            p = new Point(srcCmp.getLocationOnScreen());
        }
        catch (IllegalComponentStateException illegalComponentStateException) {
            // empty catch block
        }
        p.x += offset.x;
        p.y += offset.y;
        Point pd = new Point();
        try {
            pd = destCmp.getLocationOnScreen();
        }
        catch (IllegalComponentStateException illegalComponentStateException) {
            // empty catch block
        }
        p.x -= pd.x;
        p.y -= pd.y;
        return p;
    }

    public static void refreshAnimatedImage(Image img) {
        if (img != null && (Toolkit.getDefaultToolkit().checkImage(img, -1, -1, null) & 0x20) != 0) {
            img.flush();
        }
    }

    public static void checkRenderingHints(Options options) {
        if (DEFAULT_RENDERING_HINTS.isEmpty()) {
            if (options == null) {
                options = new Options();
            }
            boolean win = options.getBoolean("Windows");
            DEFAULT_RENDERING_HINTS.put(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            if (win) {
                DEFAULT_RENDERING_HINTS.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                DEFAULT_RENDERING_HINTS.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
                DEFAULT_RENDERING_HINTS.put(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
                DEFAULT_RENDERING_HINTS.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            }
        }
    }

    public static long getTotalFreeMemory() {
        Runtime r = Runtime.getRuntime();
        return r.maxMemory() - r.totalMemory() + r.freeMemory();
    }

    public static boolean lowMemoryCondition() {
        return Utils.getTotalFreeMemory() < 0x400000L;
    }
}

