/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.project;

import edu.xtec.jclic.PlayerSettings;
import edu.xtec.jclic.project.LibraryManager;
import edu.xtec.jclic.project.LibraryManagerElement;
import edu.xtec.util.Messages;
import edu.xtec.util.Options;
import edu.xtec.util.StrUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class NewLibraryDlg
extends JPanel {
    PlayerSettings settings;
    Options options;
    private JRadioButton btOptionLink;
    private JRadioButton btOptionNew;
    private JButton fileBrowseBtn;
    private JTextField fileText;

    public NewLibraryDlg(PlayerSettings settings) {
        this.settings = settings;
        this.options = settings.rb.getOptions();
        this.initComponents();
    }

    private void initComponents() {
        ButtonGroup bg = new ButtonGroup();
        this.btOptionNew = new JRadioButton();
        this.btOptionLink = new JRadioButton();
        JLabel fileLabel = new JLabel();
        this.fileText = new JTextField();
        this.fileBrowseBtn = new JButton();
        this.setLayout(new GridBagLayout());
        this.btOptionNew.setSelected(true);
        this.btOptionNew.setText(this.options.getMsg("libraryManager_newLibaryOption"));
        bg.add(this.btOptionNew);
        this.btOptionNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewLibraryDlg.this.btOptionNewActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(2, 2, 6, 2);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.btOptionNew, gridBagConstraints);
        this.btOptionLink.setText(this.options.getMsg("libraryManager_connectToExistingOption"));
        bg.add(this.btOptionLink);
        this.btOptionLink.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewLibraryDlg.this.btOptionLinkActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(6, 2, 2, 2);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.btOptionLink, gridBagConstraints);
        fileLabel.setText(this.options.getMsg("libraryManager_fileOrUrlCaption"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 20, 2, 2);
        this.add((Component)fileLabel, gridBagConstraints);
        this.fileText.setPreferredSize(new Dimension(200, 20));
        this.fileText.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.fileText, gridBagConstraints);
        this.fileBrowseBtn.setText("...");
        this.fileBrowseBtn.setToolTipText(this.options.getMsg("BROWSE_FILES"));
        this.fileBrowseBtn.setEnabled(false);
        this.fileBrowseBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewLibraryDlg.this.fileBrowseBtnActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.fileBrowseBtn, gridBagConstraints);
    }

    private void fileBrowseBtnActionPerformed(ActionEvent evt) {
        int[] filters = new int[]{0};
        String result = this.settings.fileSystem.chooseFile(this.settings.rootPath + File.separator + ".", false, filters, this.settings.rb.getOptions(), null, this, false);
        if (result != null) {
            this.fileText.setText(this.settings.fileSystem.getFullFileNamePath(result));
        }
    }

    private void btOptionLinkActionPerformed(ActionEvent evt) {
        this.checkEnabled();
    }

    private void btOptionNewActionPerformed(ActionEvent evt) {
        this.checkEnabled();
    }

    public void checkEnabled() {
        this.fileText.setEnabled(this.btOptionLink.isSelected());
        this.fileBrowseBtn.setEnabled(this.btOptionLink.isSelected());
    }

    public static LibraryManagerElement getLibraryManagerElement(LibraryManager lm, Component parent) {
        NewLibraryDlg dlg = new NewLibraryDlg(lm.settings);
        Messages msg = lm.settings.rb.getOptions().getMessages();
        LibraryManagerElement result = null;
        while (result == null && msg.showInputDlg(parent, dlg, "libraryManager_newLibraryTitle")) {
            if (dlg.btOptionNew.isSelected()) {
                result = lm.createNewProjectLibrary(null, null);
                break;
            }
            String path = StrUtils.nullableString(dlg.fileText.getText());
            if (path == null) {
                msg.showAlert(parent, "libraryManager_warnNoFileSelected");
                continue;
            }
            result = lm.locateNewProjectLibrary(path);
        }
        return result;
    }
}

