/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.project;

import edu.xtec.util.Domable;
import edu.xtec.util.Html;
import edu.xtec.util.JDomUtility;
import edu.xtec.util.Messages;
import org.jdom.Element;

public class Organization
implements Domable {
    public String name = new String();
    public String mail = null;
    public String url = null;
    public String address = null;
    public String pc = null;
    public String city = null;
    public String country = null;
    public String state = null;
    public String comments = null;
    public static final String ELEMENT_NAME = "organization";
    public static final String NAME = "name";
    public static final String MAIL = "mail";
    public static final String URL = "url";
    public static final String ADDRESS = "address";
    public static final String PC = "pc";
    public static final String CITY = "city";
    public static final String COUNTRY = "country";
    public static final String STATE = "state";
    public static final String COMMENTS = "comments";

    @Override
    public Element getJDomElement() {
        Element e = new Element(ELEMENT_NAME);
        e.setAttribute(NAME, this.name);
        if (this.mail != null) {
            e.setAttribute(MAIL, this.mail);
        }
        if (this.url != null) {
            e.setAttribute(URL, this.url);
        }
        if (this.address != null) {
            e.setAttribute(ADDRESS, this.address);
        }
        if (this.pc != null) {
            e.setAttribute(PC, this.pc);
        }
        if (this.city != null) {
            e.setAttribute(CITY, this.city);
        }
        if (this.country != null) {
            e.setAttribute(COUNTRY, this.country);
        }
        if (this.state != null) {
            e.setAttribute(STATE, this.state);
        }
        if (this.comments != null) {
            JDomUtility.addParagraphs(e, COMMENTS, this.comments);
        }
        return e;
    }

    public static Organization getOrganization(Element e) throws Exception {
        Organization o = new Organization();
        o.setProperties(e, null);
        return o;
    }

    @Override
    public void setProperties(Element e, Object aux) throws Exception {
        JDomUtility.checkName(e, ELEMENT_NAME);
        this.name = JDomUtility.getStringAttr(e, NAME, this.name, true);
        this.mail = JDomUtility.getStringAttr(e, MAIL, this.mail, false);
        this.url = JDomUtility.getStringAttr(e, URL, this.url, false);
        this.address = JDomUtility.getStringAttr(e, ADDRESS, this.address, false);
        this.pc = JDomUtility.getStringAttr(e, PC, this.pc, false);
        this.city = JDomUtility.getStringAttr(e, CITY, this.city, false);
        this.state = JDomUtility.getStringAttr(e, STATE, this.state, false);
        this.country = JDomUtility.getStringAttr(e, COUNTRY, this.country, false);
        this.comments = JDomUtility.getParagraphs(e.getChild(COMMENTS));
    }

    public String toHtmlString(Messages msg) {
        Html html = new Html(300);
        html.append(this.name);
        if (this.mail != null && this.mail.length() > 0) {
            html.sp().mailTo(this.mail, true);
        }
        if (this.url != null && this.url.length() > 0) {
            html.br().linkTo(this.url, null);
        }
        if (this.address != null) {
            html.br().appendParagraphs(this.address);
        }
        if (this.pc != null || this.city != null) {
            html.br();
            if (this.pc != null) {
                html.append(this.pc).nbsp();
            }
            if (this.city != null) {
                html.appendParagraphs(this.city);
            }
        }
        if (this.state != null) {
            html.br().appendParagraphs(this.state);
        }
        if (this.country != null) {
            html.br().appendParagraphs(this.country);
        }
        if (this.comments != null) {
            html.br().appendParagraphs(this.comments);
        }
        return html.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.name);
        if (this.city != null && this.city.length() > 0) {
            sb.append(" (").append(this.city).append(")");
        }
        return sb.toString();
    }

    public static Organization fromString(String str) {
        Organization result = new Organization();
        int p = (str = str.trim()).indexOf(" (");
        if (p > 0) {
            result.name = str.substring(0, p);
            result.city = str.substring(p + 2, str.length() - 1);
        } else {
            result.name = str;
        }
        return result;
    }
}

