/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.report;

import edu.xtec.jclic.Activity;
import edu.xtec.jclic.report.ActionReg;
import edu.xtec.util.Domable;
import edu.xtec.util.Html;
import edu.xtec.util.JDomUtility;
import edu.xtec.util.Messages;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jdom.Element;

public class ActivityReg
implements Serializable,
Domable {
    String name;
    String code;
    long startTime;
    long totalTime;
    List<ActionReg> actions;
    boolean solved;
    ActionReg lastAction;
    int score;
    int minActions;
    boolean closed;
    boolean reportActions;
    int numActions;
    public static final String ELEMENT_NAME = "activity";
    public static final String NAME = "name";
    public static final String CODE = "code";
    public static final String START = "start";
    public static final String TIME = "time";
    public static final String SOLVED = "solved";
    public static final String SCORE = "score";
    public static final String MIN_ACTIONS = "minActions";
    public static final String CLOSED = "closed";
    public static final String REPORT_ACTIONS = "reportActions";
    public static final String ACTIONS = "actions";
    private static final String okTd = "BGCOLOR=\"#90FF90\"";
    private static final String badTd = "BGCOLOR=\"#FF9090\"";

    public ActivityReg(Activity act) {
        this.name = act.name;
        this.code = act.code;
        this.actions = new ArrayList<ActionReg>();
        this.startTime = System.currentTimeMillis();
        this.totalTime = 0L;
        this.solved = false;
        this.score = 0;
        this.lastAction = null;
        this.closed = false;
        this.minActions = act.getMinNumActions();
        this.reportActions = act.reportActions;
        this.numActions = 0;
    }

    public ActivityReg(Element e) throws Exception {
        this.actions = new ArrayList<ActionReg>();
        this.setProperties(e, null);
    }

    @Override
    public Element getJDomElement() {
        Element e = new Element(ELEMENT_NAME);
        JDomUtility.setStringAttr(e, NAME, this.name, false);
        JDomUtility.setStringAttr(e, CODE, this.code, false);
        JDomUtility.setStringAttr(e, START, Long.toString(this.startTime), false);
        JDomUtility.setStringAttr(e, TIME, Long.toString(this.totalTime), false);
        e.setAttribute(SOLVED, JDomUtility.boolString(this.solved));
        JDomUtility.setStringAttr(e, SCORE, Integer.toString(this.score), false);
        JDomUtility.setStringAttr(e, MIN_ACTIONS, Integer.toString(this.minActions), false);
        if (!this.closed) {
            e.setAttribute(CLOSED, JDomUtility.BOOL_STR[0]);
        }
        if (this.reportActions) {
            e.setAttribute(REPORT_ACTIONS, JDomUtility.BOOL_STR[1]);
        }
        JDomUtility.setStringAttr(e, ACTIONS, Integer.toString(this.numActions), false);
        Iterator<ActionReg> it = this.actions.iterator();
        while (it.hasNext()) {
            e.addContent(it.next().getJDomElement());
        }
        return e;
    }

    @Override
    public void setProperties(Element e, Object aux) throws Exception {
        JDomUtility.checkName(e, ELEMENT_NAME);
        this.name = JDomUtility.getStringAttr(e, NAME, this.name, false);
        this.code = JDomUtility.getStringAttr(e, CODE, this.code, false);
        this.startTime = JDomUtility.getLongAttr(e, START, this.startTime);
        this.totalTime = JDomUtility.getLongAttr(e, TIME, this.totalTime);
        this.solved = JDomUtility.getBoolAttr(e, SOLVED, this.solved);
        this.score = JDomUtility.getIntAttr(e, SCORE, this.score);
        this.minActions = JDomUtility.getIntAttr(e, MIN_ACTIONS, this.minActions);
        this.closed = JDomUtility.getBoolAttr(e, CLOSED, true);
        this.reportActions = JDomUtility.getBoolAttr(e, REPORT_ACTIONS, false);
        this.numActions = JDomUtility.getIntAttr(e, ACTIONS, this.numActions);
        Iterator it = e.getChildren("action").iterator();
        while (it.hasNext()) {
            this.lastAction = new ActionReg((Element)it.next());
            this.actions.add(this.lastAction);
        }
    }

    public String toHtmlString(Messages msg, String firstTd) {
        Html html = new Html(300);
        html.tr(true);
        if (firstTd != null) {
            html.append(firstTd);
        }
        html.td(this.name, false);
        if (this.closed) {
            html.td(msg.get(this.solved ? "YES" : "NO"), 1, true, this.solved ? okTd : badTd);
            html.td(msg.getNumber(this.numActions), 2, false, null);
            html.td(msg.getPercent(this.getPrecision()), 2, false, null);
            html.td(msg.getHmsTime(this.totalTime), 2, false, null);
        } else {
            html.append("<TD COLSPAN=\"4\" ALIGN=\"center\">").append(msg.get("report_not_finished")).td(false);
        }
        html.tr(false);
        return html.toString();
    }

    public void newAction(String type, String source, String dest, boolean ok) {
        if (!this.closed) {
            this.lastAction = new ActionReg(type, source, dest, ok);
            this.actions.add(this.lastAction);
        }
    }

    public ActionReg getActionReg(int index) {
        return index >= this.actions.size() ? null : this.actions.get(index);
    }

    public void closeActivity() {
        if (!this.closed) {
            this.totalTime = this.lastAction != null ? this.lastAction.time - this.startTime : System.currentTimeMillis() - this.startTime;
            this.closed = true;
        }
    }

    public int getPrecision() {
        int result = 0;
        if (this.closed && this.minActions > 0 && this.numActions > 0) {
            result = this.solved ? (this.numActions < this.minActions ? 100 : this.minActions * 100 / this.numActions) : 100 * (this.score * this.score) / (this.minActions * this.numActions);
        }
        return result;
    }

    public void endActivity(int setScore, int setNumActions, boolean isSolved) {
        if (!this.closed) {
            this.solved = isSolved;
            this.numActions = setNumActions;
            this.score = setScore;
            this.closeActivity();
        }
    }

    public String toString() {
        StringBuilder result = new StringBuilder("ACTIVITY: ");
        result.append(this.name);
        return result.substring(0);
    }
}

