/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.report;

import edu.xtec.jclic.Activity;
import edu.xtec.jclic.bags.ActivitySequenceElement;
import edu.xtec.jclic.project.JClicProject;
import edu.xtec.jclic.report.SequenceReg;
import edu.xtec.util.Html;
import edu.xtec.util.Messages;
import java.io.Serializable;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class SessionReg
implements Serializable {
    List<SequenceReg> sequences = new CopyOnWriteArrayList<SequenceReg>();
    SequenceReg currentSequence = null;
    public Date started = new Date();
    protected long timeMillis = System.currentTimeMillis();
    String projectName;
    protected transient Info info;
    String code;

    public SessionReg(JClicProject jcp) {
        this(jcp.getName(), jcp.code);
    }

    public SessionReg(String projectName, String code) {
        this.projectName = projectName;
        this.code = code;
        this.info = new Info();
    }

    public String toHtmlString(Messages msg, boolean recalcInfo, boolean writeProjectName) {
        String prefix = "report_";
        Html html = new Html(3000);
        if (recalcInfo) {
            this.info.recalc();
        }
        if (this.info.numSequences > 0) {
            if (writeProjectName) {
                html.append("<TR STYLE=\"").append(msg.get("about_window_html_style_table_header2")).append("\">");
                html.append("<TD COLSPAN=\"6\">");
                html.bold(msg.get(prefix + "project") + "&nbsp;" + this.projectName);
                html.td(false).tr(false);
            }
            html.append("<TR STYLE=\"").append(msg.get("about_window_html_style_table_header")).append("\">");
            html.td(msg.get(prefix + "lb_sequence"), 1, true, null);
            html.td(msg.get(prefix + "lb_activity"), 1, true, null);
            html.td(msg.get(prefix + "lb_solved"), 1, true, null);
            html.td(msg.get(prefix + "lb_actions"), 1, true, null);
            html.td(msg.get(prefix + "lb_score"), 1, true, null);
            html.td(msg.get(prefix + "lb_time"), 1, true, null);
            html.tr(false);
            Iterator<SequenceReg> it = this.sequences.iterator();
            while (it.hasNext()) {
                html.append(it.next().toHtmlString(msg));
            }
            html.append("<TR STYLE=\"").append(msg.get("about_window_html_style_table_totals")).append("\">");
            html.td(msg.get(prefix + "lb_totals"), 0, true, null);
            html.td(msg.getNumber(this.info.nActivities), 2, true, null);
            html.td(msg.getNumber(this.info.nActSolved) + " (" + msg.getPercent(this.info.percentSolved) + ")", 2, true, null);
            html.td(msg.getNumber(this.info.nActions), 2, true, null);
            html.td(msg.getPercent(this.info.tScore), 2, true, null);
            html.td(msg.getHmsTime(this.info.tTime), 2, true, null);
            html.tr(false);
        }
        return html.toString();
    }

    public Info getInfo(boolean recalc) {
        if (recalc) {
            this.info.recalc();
        }
        return this.info;
    }

    protected void finalize() throws Throwable {
        this.end();
        super.finalize();
    }

    public void end() {
        this.endSequence();
    }

    public void endSequence() {
        if (this.currentSequence != null && this.currentSequence.totalTime == 0L) {
            this.currentSequence.endSequence();
        }
        this.currentSequence = null;
    }

    public void newSequence(ActivitySequenceElement ase) {
        this.endSequence();
        this.currentSequence = new SequenceReg(ase);
        this.sequences.add(this.currentSequence);
    }

    public void newActivity(Activity act) {
        if (this.currentSequence != null) {
            this.currentSequence.newActivity(act);
        }
    }

    public void endActivity(int score, int numActions, boolean solved) {
        if (this.currentSequence != null) {
            this.currentSequence.endActivity(score, numActions, solved);
        }
    }

    public void newAction(String type, String source, String dest, boolean ok) {
        if (this.currentSequence != null) {
            this.currentSequence.newAction(type, source, dest, ok);
        }
    }

    public String getCurrentSequenceTag() {
        if (this.currentSequence == null) {
            return null;
        }
        return this.currentSequence.name;
    }

    public SequenceReg.Info getCurrentSequenceInfo() {
        return this.currentSequence == null ? null : this.currentSequence.getInfo(true);
    }

    public class Info {
        public int numSequences;
        public int nActivities;
        public int nActSolved;
        public int nActScore;
        public int percentSolved;
        public int nActions;
        public long tScore;
        public long tTime;

        protected Info() {
            this.clear();
        }

        protected void clear() {
            this.nActions = 0;
            this.percentSolved = 0;
            this.nActScore = 0;
            this.nActSolved = 0;
            this.nActivities = 0;
            this.numSequences = 0;
            this.tTime = 0L;
            this.tScore = 0L;
        }

        public void recalc() {
            this.clear();
            Iterator<SequenceReg> it = SessionReg.this.sequences.iterator();
            while (it.hasNext()) {
                SequenceReg.Info sri = it.next().getInfo(true);
                if (sri.nActivities <= 0) continue;
                ++this.numSequences;
                if (sri.nActClosed <= 0) continue;
                this.nActivities += sri.nActClosed;
                this.nActions += sri.nActions;
                if (sri.nActScore > 0) {
                    this.nActScore += sri.nActScore;
                    this.tScore += sri.tScore * (long)sri.nActScore;
                }
                this.tTime += sri.tTime;
                this.nActSolved += sri.nActSolved;
            }
            if (this.nActScore > 0) {
                this.tScore /= (long)this.nActScore;
            }
            if (this.nActivities > 0) {
                this.percentSolved = this.nActSolved * 100 / this.nActivities;
            }
        }
    }
}

