/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.report;

import edu.xtec.jclic.Activity;
import edu.xtec.jclic.project.JClicProject;
import edu.xtec.jclic.report.ActivityReg;
import edu.xtec.jclic.report.GroupData;
import edu.xtec.jclic.report.Reporter;
import edu.xtec.jclic.report.TCPReportBean;
import edu.xtec.jclic.report.UserData;
import edu.xtec.util.Domable;
import edu.xtec.util.JDomUtility;
import edu.xtec.util.Messages;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.Timer;
import org.jdom.Document;

public class TCPReporter
extends Reporter {
    protected String currentSessionId = null;
    protected ActivityReg lastActivity = null;
    protected int actCount = 0;
    protected URL serviceUrl = null;
    protected HashMap<String, String> dbProperties;
    protected List<TCPReportBean> tasks = new ArrayList<TCPReportBean>();
    protected Component parent;
    protected Messages msg;
    protected Timer timer;
    protected int timerLap = 20;
    public static final String SERVER_PATH = "path";
    public static final String DEFAULT_SERVER_PATH = "localhost:9000";
    public static final String SERVER_PROTOCOL = "protocol";
    public static final String DEFAULT_SERVER_PROTOCOL = "http";
    public static final String SERVER_SERVICE = "service";
    public static final String DEFAULT_SERVER_SERVICE = "/JClicReportService";
    public static final String TIMER_LAP = "lap";
    public static final int DEFAULT_TIMER_LAP = 20;

    protected synchronized void flushTasks() {
        if (!this.tasks.isEmpty() && this.serviceUrl != null) {
            TCPReportBean[] items;
            TCPReportBean bean = new TCPReportBean("multiple");
            for (TCPReportBean item : items = this.tasks.toArray(new TCPReportBean[this.tasks.size()])) {
                bean.addElement(item.getJDomElement());
            }
            if (this.transaction(bean) != null) {
                for (TCPReportBean item : items) {
                    this.tasks.remove(item);
                }
            }
        }
    }

    @Override
    public void end() {
        super.end();
        this.reportActivity();
        this.flushTasks();
        this.stopReporting();
    }

    protected void checkUrl() throws Exception {
        if (this.serviceUrl == null) {
            throw new Exception("Service not available!!");
        }
    }

    protected TCPReportBean transaction(String key, Domable[] data) {
        return this.transaction(new TCPReportBean(key, data));
    }

    protected TCPReportBean transaction(TCPReportBean request) {
        if (this.serviceUrl == null) {
            return null;
        }
        TCPReportBean result = null;
        boolean loop = true;
        while (result == null && loop) {
            try {
                HttpURLConnection con = (HttpURLConnection)this.serviceUrl.openConnection();
                con.setDoOutput(true);
                con.setRequestProperty("Content-type", "text/xml");
                OutputStream out = con.getOutputStream();
                JDomUtility.saveDocument(out, request.getJDomElement());
                out.flush();
                out.close();
                InputStream in = con.getInputStream();
                Document doc = JDomUtility.getSAXBuilder().build(con.getInputStream());
                result = new TCPReportBean(doc.getRootElement());
            }
            catch (Exception ex) {
                if (this.msg != null) {
                    int r = this.msg.showErrorWarning(this.parent, "report_err_connect", ex, "ric");
                    switch (r) {
                        case 2: {
                            break;
                        }
                        case 4: {
                            loop = false;
                            break;
                        }
                        default: {
                            this.stopReporting();
                            loop = false;
                            break;
                        }
                    }
                    continue;
                }
                this.stopReporting();
                loop = false;
            }
        }
        return result;
    }

    protected void stopReporting() {
        if (this.serviceUrl != null) {
            this.serviceUrl = null;
            if (this.description != null && this.msg != null) {
                this.description = this.description + " (" + this.msg.get("report_not_connected") + ")";
            }
        }
        if (this.timer != null && this.timer.isRunning()) {
            this.timer.stop();
        }
        this.initiated = false;
    }

    @Override
    public void init(HashMap properties, Component parent, Messages msg) throws Exception {
        this.parent = parent;
        this.msg = msg;
        boolean success = false;
        try {
            String serverProtocol;
            super.init(properties, parent, msg);
            String serverPath = (String)properties.get(SERVER_PATH);
            if (serverPath == null) {
                serverPath = DEFAULT_SERVER_PATH;
            }
            this.description = "TCP/IP " + serverPath;
            String serverService = (String)properties.get(SERVER_SERVICE);
            if (serverService == null) {
                serverService = DEFAULT_SERVER_SERVICE;
            }
            if (serverPath.length() < 1 || serverService.length() < 1) {
                throw new Exception("Bad server specification!");
            }
            if (!serverService.startsWith("/")) {
                serverService = serverService + "/";
            }
            if ((serverProtocol = (String)properties.get(SERVER_PROTOCOL)) == null) {
                serverProtocol = DEFAULT_SERVER_PROTOCOL;
            }
            this.serviceUrl = new URL(serverProtocol + "://" + serverPath + serverService);
            if (this.userId == null) {
                this.userId = this.promptUserId(parent, msg);
            }
            if (this.userId != null) {
                success = true;
            }
        }
        catch (Exception ex) {
            msg.showErrorWarning(parent, "report_err_init", this.description, ex, null);
        }
        if (success) {
            String tl = this.getProperty("TIME_LAP", Integer.toString(this.timerLap));
            this.timerLap = Math.min(300, Math.max(1, Integer.parseInt(tl)));
            this.timer = new Timer(this.timerLap * 1000, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    TCPReporter.this.flushTasks();
                }
            });
            this.timer.setRepeats(true);
            this.timer.start();
        } else {
            this.stopReporting();
        }
    }

    @Override
    public void newSession(JClicProject jcp, Component parent, Messages msg) {
        super.newSession(jcp, parent, msg);
        if (this.serviceUrl == null) {
            return;
        }
        if (this.userId == null) {
            try {
                this.userId = this.promptUserId(parent, msg);
            }
            catch (Exception ex) {
                msg.showErrorWarning(parent, "error_getting_user", ex);
            }
        }
        if (this.userId != null) {
            this.currentSessionId = null;
        }
    }

    public void createDBSession() {
        if (this.initiated && this.userId != null) {
            this.flushTasks();
            this.currentSessionId = null;
            this.actCount = 0;
            TCPReportBean bean = new TCPReportBean("add session");
            bean.setParam("project", this.currentSession.projectName);
            bean.setParam("time", Long.toString(this.currentSession.timeMillis));
            bean.setParam("code", this.currentSession.code);
            bean.setParam("user", this.userId);
            bean.setParam("key", this.sessionKey);
            bean.setParam("context", this.sessionContext);
            bean = this.transaction(bean);
            if (bean != null) {
                this.currentSessionId = bean.getParam("session");
            }
            if (this.currentSessionId == null) {
                this.stopReporting();
            }
        }
    }

    protected void reportActivity() {
        if (this.lastActivity != null) {
            if (!this.lastActivity.closed) {
                this.lastActivity.closeActivity();
            }
            if (this.currentSessionId == null) {
                this.createDBSession();
            }
            if (this.currentSessionId != null) {
                TCPReportBean bean = new TCPReportBean("add activity");
                bean.setParam("session", this.currentSessionId);
                bean.setParam("num", Integer.toString(this.actCount++));
                bean.setData(this.lastActivity);
                this.tasks.add(bean);
            }
        }
        this.lastActivity = this.currentSession != null && this.currentSession.currentSequence != null && this.currentSession.currentSequence.currentActivity != this.lastActivity ? this.currentSession.currentSequence.currentActivity : null;
    }

    @Override
    public String getProperty(String key, String defaultValue) throws Exception {
        String result;
        if (this.dbProperties == null) {
            this.dbProperties = new HashMap();
            TCPReportBean bean = this.transaction(new TCPReportBean("get_properties"));
            if (bean == null) {
                return defaultValue;
            }
            this.dbProperties.putAll(bean.getParams());
        }
        if ((result = this.dbProperties.get(key)) == null) {
            result = defaultValue;
        }
        return result;
    }

    @Override
    public List<GroupData> getGroups() throws Exception {
        TCPReportBean bean = this.transaction("get groups", null);
        if (bean == null) {
            return new ArrayList<GroupData>();
        }
        Domable[] data = bean.getData();
        ArrayList<GroupData> result = new ArrayList<GroupData>(data.length);
        for (Domable d : data) {
            if (!(d instanceof GroupData)) continue;
            result.add((GroupData)d);
        }
        return result;
    }

    @Override
    public List<UserData> getUsers(String groupId) throws Exception {
        TCPReportBean bean = new TCPReportBean("get users");
        bean.setParam("group", groupId);
        bean = this.transaction(bean);
        if (bean == null) {
            return new ArrayList<UserData>();
        }
        Domable[] data = bean.getData();
        ArrayList<UserData> result = new ArrayList<UserData>(data.length);
        for (Domable d : data) {
            if (!(d instanceof UserData)) continue;
            result.add((UserData)d);
        }
        return result;
    }

    @Override
    public UserData getUserData(String userId) throws Exception {
        UserData result = null;
        TCPReportBean bean = new TCPReportBean("get user data");
        bean.setParam("user", userId);
        bean = this.transaction(bean);
        if (bean != null) {
            result = (UserData)bean.getSingleData();
        }
        return result;
    }

    @Override
    public GroupData getGroupData(String groupId) throws Exception {
        GroupData result = null;
        TCPReportBean bean = new TCPReportBean("get group data");
        bean.setParam("group", groupId);
        bean = this.transaction(bean);
        if (bean != null) {
            result = (GroupData)bean.getSingleData();
        }
        return result;
    }

    @Override
    public String newGroup(GroupData gd) throws Exception {
        String result = null;
        TCPReportBean bean = new TCPReportBean("new group");
        bean.setData(gd);
        bean = this.transaction(bean);
        if (bean != null) {
            result = bean.getParam("group");
        }
        return result;
    }

    @Override
    public String newUser(UserData ud) throws Exception {
        String result = null;
        TCPReportBean bean = new TCPReportBean("new user");
        bean.setData(ud);
        bean = this.transaction(bean);
        if (bean != null) {
            result = bean.getParam("user");
        }
        return result;
    }

    @Override
    public void newActivity(Activity act) {
        super.newActivity(act);
        this.reportActivity();
    }
}

