/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.shapers;

import edu.xtec.jclic.shapers.ShapeData;
import edu.xtec.jclic.shapers.Shaper;
import edu.xtec.util.JDomUtility;
import java.util.List;
import org.jdom.Element;

public class Holes
extends Shaper {
    protected double scaleW = 1.0;
    protected double scaleH = 1.0;
    protected ShapeData enclosingShapeData = null;
    protected boolean showEnclosure = true;
    public static final String SHAPE = "shape";
    public static final String SHOW_ENCLOSURE = "showEnclosure";
    protected static final String SCALE_W = "scaleX";
    protected static final String SCALE_H = "scaleY";
    protected static final String ENCLOSING = "enclosing";

    public Holes(int nx, int ny) {
        super(1, 1);
        this.shapeData = new ShapeData[0];
        this.nCols = nx;
        this.nRows = ny;
    }

    @Override
    public void reset(int nCols, int nRows) {
        this.nCols = nCols;
        this.nRows = nRows;
        this.initiated = false;
    }

    @Override
    public String getEditorPanelClassName() {
        return this.getClass().getPackage().getName() + ".HolesEditorPanel";
    }

    @Override
    public Element getJDomElement() {
        Element e = super.getJDomElement();
        if (!this.showEnclosure) {
            e.setAttribute(SHOW_ENCLOSURE, JDomUtility.boolString(this.showEnclosure));
        }
        if (this.scaleW != 1.0) {
            e.setAttribute(SCALE_W, Double.toString(this.scaleW));
        }
        if (this.scaleH != 1.0) {
            e.setAttribute(SCALE_H, Double.toString(this.scaleH));
        }
        if (this.enclosingShapeData != null) {
            e.addContent(new Element(ENCLOSING).addContent(this.enclosingShapeData.getJDomElement(this.scaleW, this.scaleH)));
        }
        if (this.shapeData != null) {
            for (int i = 0; i < this.nCells; ++i) {
                e.addContent(this.shapeData[i].getJDomElement(this.scaleW, this.scaleH));
            }
        }
        return e;
    }

    @Override
    public void setProperties(Element e, Object aux) throws Exception {
        List childs;
        this.scaleW = JDomUtility.getDoubleAttr(e, SCALE_W, this.scaleW);
        this.scaleH = JDomUtility.getDoubleAttr(e, SCALE_H, this.scaleH);
        this.showEnclosure = JDomUtility.getBoolAttr(e, SHOW_ENCLOSURE, this.showEnclosure);
        Element child = e.getChild(ENCLOSING);
        if (child != null) {
            child = child.getChild(SHAPE);
            this.enclosingShapeData = ShapeData.getShapeData(child, this.scaleW, this.scaleH);
            this.showEnclosure = true;
        }
        if (!(childs = e.getChildren(SHAPE)).isEmpty()) {
            this.nCells = childs.size();
            this.shapeData = new ShapeData[this.nCells];
            for (int i = 0; i < this.nCells; ++i) {
                this.shapeData[i] = ShapeData.getShapeData((Element)childs.get(i), this.scaleW, this.scaleH);
            }
        } else {
            this.nCells = 0;
            this.nRows = 0;
            this.nCols = 0;
            this.shapeData = null;
        }
    }

    @Override
    protected void buildShapes() {
        if (this.nCells > 0) {
            this.initiated = true;
        }
    }

    @Override
    public boolean hasRemainder() {
        return this.showEnclosure;
    }

    @Override
    protected ShapeData getEnclosingShapeData() {
        if (!this.showEnclosure) {
            return null;
        }
        return this.enclosingShapeData != null ? this.enclosingShapeData : super.getEnclosingShapeData();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        Holes clon = (Holes)super.clone();
        if (this.enclosingShapeData != null) {
            this.enclosingShapeData = (ShapeData)this.enclosingShapeData.clone();
        }
        return clon;
    }

    public void removeShape(int iIndex) {
        if (this.shapeData == null || iIndex < 0 || iIndex >= this.shapeData.length) {
            return;
        }
        ShapeData[] newShapeData = new ShapeData[this.shapeData.length - 1];
        System.arraycopy(this.shapeData, 0, newShapeData, 0, iIndex);
        System.arraycopy(this.shapeData, iIndex + 1, newShapeData, iIndex, this.shapeData.length - iIndex - 1);
        this.nCells = newShapeData.length;
        this.shapeData = newShapeData;
    }

    public void addShape(ShapeData sd) {
        ShapeData[] newShapeData = new ShapeData[this.shapeData.length + 1];
        System.arraycopy(this.shapeData, 0, newShapeData, 0, this.shapeData.length);
        newShapeData[this.shapeData.length] = sd;
        this.nCells = newShapeData.length;
        this.shapeData = newShapeData;
    }

    public void modifyShape(int iIndex, ShapeData sd) {
        if (iIndex >= 0 && iIndex < this.shapeData.length) {
            sd.comment = this.shapeData[iIndex] != null ? this.shapeData[iIndex].comment : "";
            this.shapeData[iIndex] = sd;
        }
    }
}

