/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.shapers;

import edu.xtec.jclic.shapers.ShapeData;
import edu.xtec.jclic.shapers.Shaper;
import edu.xtec.util.JDomUtility;
import org.jdom.Element;

public class JigSaw
extends Shaper {
    protected double baseWidthFactor = this.getDefaultBaseWidthFactor();
    protected double toothHeightFactor = this.getDefaultToothHeightFactor();
    protected boolean randomLines = false;
    protected static final String BASE_WIDTH_FACTOR = "baseWidthFactor";
    protected static final String TOOTH_HEIGHT_FACTOR = "toothHeightFactor";
    protected static final String RANDOM_LINES = "randomLines";

    public JigSaw(int nx, int ny) {
        super(nx, ny);
    }

    protected int getBaseFactor() {
        return 50;
    }

    @Override
    public String getEditorPanelClassName() {
        return this.getClass().getPackage().getName() + ".JigSawEditorPanel";
    }

    protected double getDefaultBaseWidthFactor() {
        return 0.3333333432674408;
    }

    protected double getDefaultToothHeightFactor() {
        return 0.1666666716337204;
    }

    @Override
    public Element getJDomElement() {
        Element e = super.getJDomElement();
        if (this.baseWidthFactor != this.getDefaultBaseWidthFactor()) {
            e.setAttribute(BASE_WIDTH_FACTOR, Double.toString(this.baseWidthFactor));
        }
        if (this.toothHeightFactor != this.getDefaultToothHeightFactor()) {
            e.setAttribute(TOOTH_HEIGHT_FACTOR, Double.toString(this.toothHeightFactor));
        }
        if (this.randomLines) {
            e.setAttribute(RANDOM_LINES, JDomUtility.boolString(this.randomLines));
        }
        return e;
    }

    @Override
    public void setProperties(Element e, Object aux) throws Exception {
        this.initiated = false;
        this.baseWidthFactor = JDomUtility.getDoubleAttr(e, BASE_WIDTH_FACTOR, this.baseWidthFactor);
        this.toothHeightFactor = JDomUtility.getDoubleAttr(e, TOOTH_HEIGHT_FACTOR, this.toothHeightFactor);
        this.randomLines = JDomUtility.getBoolAttr(e, RANDOM_LINES, this.randomLines);
    }

    @Override
    protected void buildShapes() {
        int[][] hLineType = new int[this.nRows + 1][this.nCols + 1];
        int[][] vLineType = new int[this.nRows + 1][this.nCols + 1];
        for (int row = 0; row < this.nRows; ++row) {
            for (int col = 0; col < this.nCols; ++col) {
                hLineType[row][col] = row == 0 ? 0 : 1 + (this.randomLines ? (int)(Math.random() * 9.0) : row + col) % 2;
                vLineType[row][col] = col == 0 ? 0 : 1 + (this.randomLines ? (int)(Math.random() * 9.0) : col + row + 1) % 2;
                if (col == this.nCols - 1) {
                    vLineType[row][col + 1] = 0;
                }
                if (row != this.nRows - 1) continue;
                hLineType[row + 1][col] = 0;
            }
        }
        double w = 1.0 / (double)this.nCols;
        double h = 1.0 / (double)this.nRows;
        for (int r = 0; r < this.nRows; ++r) {
            for (int c = 0; c < this.nCols; ++c) {
                double x = w * (double)c;
                double y = h * (double)r;
                ShapeData sd = this.shapeData[r * this.nCols + c];
                sd.moveTo(x, y);
                this.hLine(sd, hLineType[r][c], x + 0.0, y + 0.0, w, h, false);
                this.vLine(sd, vLineType[r][c + 1], x + w, y + 0.0, w, h, false);
                this.hLine(sd, hLineType[r + 1][c], x + w, y + h, w, h, true);
                this.vLine(sd, vLineType[r][c], x + 0.0, y + h, w, h, true);
                sd.closePath();
            }
        }
        this.initiated = true;
    }

    protected void hLine(ShapeData sd, int type, double x, double y, double w, double h, boolean inv) {
        int ky;
        int kx = inv ? -1 : 1;
        int n = ky = type == 1 ? 1 : -1;
        if (type == 0) {
            sd.lineTo(x + w * (double)kx, y);
        } else {
            double x0 = x + (w - w * this.baseWidthFactor) / 2.0 * (double)kx;
            double wb = w * this.baseWidthFactor * (double)kx;
            sd.lineTo(x0, y);
            double hb = h * this.toothHeightFactor * (double)ky;
            sd.lineTo(x0, y + hb);
            sd.lineTo(x0 + wb, y + hb);
            sd.lineTo(x0 + wb, y);
            sd.lineTo(x + w * (double)kx, y);
        }
    }

    protected void vLine(ShapeData sd, int type, double x, double y, double w, double h, boolean inv) {
        int kx;
        int ky = inv ? -1 : 1;
        int n = kx = type == 1 ? 1 : -1;
        if (type == 0) {
            sd.lineTo(x, y + h * (double)ky);
        } else {
            double y0 = y + (h - h * this.baseWidthFactor) / 2.0 * (double)ky;
            double hb = h * this.baseWidthFactor * (double)ky;
            sd.lineTo(x, y0);
            double wb = w * this.toothHeightFactor * (double)kx;
            sd.lineTo(x + wb, y0);
            sd.lineTo(x + wb, y0 + hb);
            sd.lineTo(x, y0 + hb);
            sd.lineTo(x, y + h * (double)ky);
        }
    }
}

