/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.util;

import edu.xtec.util.Domable;
import edu.xtec.util.JDomUtility;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jdom.Element;

public class DomableBean
implements Domable,
Serializable {
    public static final String ELEMENT_NAME = "bean";
    public static final String ID = "id";
    public static final String PARAM = "param";
    public static final String NAME = "name";
    public static final String VALUE = "value";
    private String id;
    private Map<String, String> params;
    private List<Element> elements;

    public DomableBean() {
    }

    public DomableBean(String id) {
        this.setId(id);
    }

    private List<Element> chkElements() {
        if (this.elements == null) {
            this.elements = new ArrayList<Element>();
        }
        return this.elements;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public Element getJDomElement() {
        Element e = new Element(ELEMENT_NAME);
        if (this.id != null) {
            e.setAttribute(ID, this.id);
        }
        if (this.params != null) {
            for (String key : this.params.keySet()) {
                String value = this.params.get(key);
                if (value == null) continue;
                Element child = new Element(PARAM);
                child.setAttribute(NAME, key);
                child.setAttribute(VALUE, value);
                e.addContent(child);
            }
        }
        if (this.elements != null) {
            Iterator<Object> it = this.elements.iterator();
            while (it.hasNext()) {
                e.addContent(((Element)it.next()).detach());
            }
        }
        return e;
    }

    @Override
    public void setProperties(Element e, Object aux) throws Exception {
        JDomUtility.checkName(e, ELEMENT_NAME);
        this.setId(e.getAttributeValue(ID));
        List children = e.getChildren();
        for (Element child : children) {
            if (PARAM.equals(child.getName())) {
                this.getParams().put(JDomUtility.getStringAttr(child, NAME, "DEFAULT", false), JDomUtility.getStringAttr(child, VALUE, "", false));
                continue;
            }
            this.chkElements().add(child);
        }
    }

    public static DomableBean getDomableBean(Element e) throws Exception {
        DomableBean db = new DomableBean(null);
        db.setProperties(e, null);
        return db;
    }

    public void setParam(String key, String value) {
        if (key != null) {
            this.getParams().put(key, value);
        }
    }

    public String getParam(String key) {
        return key == null ? null : this.getParams().get(key);
    }

    public Map<String, String> getParams() {
        if (this.params == null) {
            this.params = new HashMap<String, String>();
        }
        return this.params;
    }

    public void addElement(Element e) {
        this.chkElements().add(e);
    }

    public Element[] getElements() {
        Element[] result = this.elements != null ? this.elements.toArray(new Element[this.elements.size()]) : new Element[]{};
        return result;
    }
}

