/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.util;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class ProgressInputStream
extends FilterInputStream {
    private int nread;
    private int size;
    private boolean started;
    private List<ProgressInputStreamListener> listeners = new ArrayList<ProgressInputStreamListener>();
    private String name;
    protected static final int MAX = 0;
    protected static final int VALUE = 1;
    protected static final int START = 2;
    protected static final int END = 3;

    public ProgressInputStream(InputStream in, int expectedLength, String name) {
        super(in);
        this.name = name;
        this.started = false;
        this.nread = 0;
        this.size = expectedLength;
        if (this.size <= 0) {
            try {
                this.size = in.available();
            }
            catch (IOException ioe) {
                this.size = 0;
            }
        }
    }

    public void addProgressInputStreamListener(ProgressInputStreamListener isl) {
        if (!this.listeners.contains(isl)) {
            this.listeners.add(isl);
        }
    }

    private void start() {
        if (!this.started) {
            this.notifyListeners(0, this.size);
            this.notifyListeners(1, 0);
            this.notifyListeners(2, 0);
            this.started = true;
        }
    }

    @Override
    public int read() throws IOException {
        int c;
        if (!this.started) {
            this.start();
        }
        if ((c = this.in.read()) >= 0) {
            this.notifyListeners(1, this.size);
        }
        return c;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int nr;
        if (!this.started) {
            this.start();
        }
        if ((nr = this.in.read(b)) > 0) {
            this.notifyListeners(1, this.nread += nr);
        }
        return nr;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int nr;
        if (!this.started) {
            this.start();
        }
        if ((nr = this.in.read(b, off, len)) > 0) {
            this.notifyListeners(1, this.nread += nr);
        }
        return nr;
    }

    @Override
    public long skip(long n) throws IOException {
        long nr;
        if (!this.started) {
            this.start();
        }
        if ((nr = this.in.skip(n)) > 0L) {
            this.nread = (int)((long)this.nread + nr);
            this.notifyListeners(1, this.nread);
        }
        return nr;
    }

    @Override
    public void close() throws IOException {
        if (!this.started) {
            this.start();
        }
        this.in.close();
        this.notifyListeners(3, 0);
    }

    @Override
    public synchronized void reset() throws IOException {
        if (!this.started) {
            this.start();
        }
        this.in.reset();
        this.nread = this.size - this.in.available();
        this.notifyListeners(1, this.nread);
    }

    private void notifyListeners(int action, int value) {
        for (ProgressInputStreamListener isl : this.listeners) {
            switch (action) {
                case 0: {
                    isl.setProgressMax(value);
                    break;
                }
                case 1: {
                    isl.setProgressValue(value);
                    break;
                }
                case 2: {
                    isl.startProgress(this.name);
                    break;
                }
                case 3: {
                    isl.endProgress();
                    break;
                }
            }
        }
    }

    public static interface ProgressInputStreamListener {
        public void setProgressMax(int var1);

        public void setProgressValue(int var1);

        public void startProgress(String var1);

        public void endProgress();
    }
}

