/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.util;

import edu.xtec.util.ExtendedByteArrayInputStream;
import edu.xtec.util.StreamIO;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;

public abstract class ResourceManager {
    public static final String RESOURCE_ROOT = "/edu/xtec/resources/";
    public static final String RESOURCE_CLASS_ROOT = "edu.xtec.resources.";
    public static final StreamIO.InputStreamProvider STREAM_PROVIDER = new StreamIO.InputStreamProvider(){

        @Override
        public InputStream getInputStream(String resourceName) throws Exception {
            return ResourceManager.getResourceAsStream(resourceName);
        }
    };
    public static final String DEFAULT_LOCALE = "en";
    private static Map<String, ImageIcon> icons = new HashMap<String, ImageIcon>();

    public static ImageIcon getImageIcon(String name) {
        ImageIcon result = icons.get(name);
        if (result == null) {
            try {
                result = new ImageIcon(ResourceManager.getResource(name));
                String s = name;
                if (s.startsWith("icons/")) {
                    s = new StringBuilder("@").append(s.substring(6)).substring(0);
                }
                result.setDescription(s);
                icons.put(name, result);
            }
            catch (Exception ex) {
                System.err.println("unable to get image " + name);
                System.err.println(ex);
            }
        }
        return result;
    }

    public static URL getResource(String name) throws Exception {
        URL result = ResourceManager.class.getResource(RESOURCE_ROOT + name);
        if (result == null) {
            throw ResourceManager.buildException(name);
        }
        return result;
    }

    public static InputStream getResourceAsStream(String name) throws Exception {
        InputStream result = ResourceManager.class.getResourceAsStream(RESOURCE_ROOT + name);
        if (result == null) {
            throw ResourceManager.buildException(name);
        }
        return result;
    }

    public static byte[] getResourceBytes(String name) throws Exception {
        return StreamIO.readInputStream(ResourceManager.getResourceAsStream(name));
    }

    public static ExtendedByteArrayInputStream getResourceAsByteArray(String name) throws Exception {
        return new ExtendedByteArrayInputStream(ResourceManager.getResourceBytes(name), name);
    }

    public static String getResourceText(String name, boolean useCRLF) throws Exception {
        String line;
        String lineEnding = useCRLF ? "\r\n" : System.getProperty("line.separator");
        BufferedReader in = new BufferedReader(new InputStreamReader(ResourceManager.getResourceAsStream(name)));
        StringBuilder sb = new StringBuilder();
        while ((line = in.readLine()) != null) {
            sb.append(line).append(lineEnding);
        }
        in.close();
        return sb.substring(0);
    }

    public static ResourceBundle getBundle(String name, Locale locale) throws Exception {
        ResourceBundle result;
        if (locale != null && DEFAULT_LOCALE.equals(locale.getLanguage())) {
            Locale.setDefault(locale);
        }
        if ((result = ResourceBundle.getBundle(RESOURCE_CLASS_ROOT + name, locale)) == null) {
            throw ResourceManager.buildException(name);
        }
        return result;
    }

    private static Exception buildException(String name) {
        return new Exception("Unable to load resource: " + name);
    }
}

