/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.util;

import edu.xtec.util.Messages;
import edu.xtec.util.Options;
import edu.xtec.util.SwingWorker;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;

public class StreamIO {
    private static boolean cancel = false;
    public static final int DEFAULT_READ_STEP_SIZE = 4096;

    private StreamIO() {
    }

    public static void setCancel(boolean value) {
        cancel = value;
    }

    public static byte[] readInputStream(InputStream is) throws IOException {
        return StreamIO.readInputStream(is, null, 4096);
    }

    public static byte[] readInputStream(InputStream is, InputStreamListener lst, int stepSize) throws IOException {
        cancel = false;
        BufferedInputStream bufferedStream = is instanceof BufferedInputStream ? (BufferedInputStream)is : new BufferedInputStream(is);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        byte[] buffer = new byte[stepSize];
        while (!cancel) {
            int bytesRead = bufferedStream.read(buffer);
            if (lst != null) {
                lst.notify(is, bytesRead);
            }
            if (bytesRead <= 0) break;
            os.write(buffer, 0, bytesRead);
            Thread.yield();
        }
        buffer = os.toByteArray();
        os.close();
        bufferedStream.close();
        if (cancel) {
            throw new InterruptedIOException("Cancelled by user");
        }
        return buffer;
    }

    public static byte[] readFile(File file) throws IOException {
        return StreamIO.readFile(file, null, 0);
    }

    public static byte[] readFile(File file, InputStreamListener lst, int stepSize) throws IOException {
        cancel = false;
        long fileLength = file.length();
        if (fileLength > Integer.MAX_VALUE) {
            throw new IOException();
        }
        int intFileLength = (int)fileLength;
        byte[] result = new byte[intFileLength];
        BufferedInputStream fis = new BufferedInputStream(new FileInputStream(file));
        int bytesRead = 0;
        int k = 0;
        while ((long)k < fileLength && !cancel) {
            int bytesToRead = intFileLength - k;
            if (stepSize > 0 && stepSize < bytesToRead) {
                bytesToRead = stepSize;
            }
            if ((bytesRead = fis.read(result, k, bytesToRead)) < 0) break;
            if (lst != null) {
                lst.notify(fis, bytesRead);
            }
            Thread.yield();
            k += bytesRead;
        }
        fis.close();
        if (cancel) {
            throw new InterruptedIOException("Cancelled by user");
        }
        return result;
    }

    public static byte[] getResourceBytes(Object caller, String packageName, String resourceName) throws IOException {
        return StreamIO.readInputStream(caller.getClass().getResourceAsStream(packageName + "/" + resourceName));
    }

    public static long writeStreamTo(InputStream is, OutputStream os) throws IOException {
        return StreamIO.writeStreamTo(is, os, null, 4096);
    }

    public static long writeStreamTo(InputStream is, OutputStream os, InputStreamListener lst, int stepSize) throws IOException {
        cancel = false;
        long result = 0L;
        BufferedInputStream bufferedStream = is instanceof BufferedInputStream ? (BufferedInputStream)is : new BufferedInputStream(is);
        byte[] buf = new byte[stepSize];
        while (!cancel) {
            int bytesRead = bufferedStream.read(buf, 0, stepSize);
            if (lst != null) {
                lst.notify(is, bytesRead);
            }
            if (bytesRead <= 0) break;
            os.write(buf, 0, bytesRead);
            result += (long)bytesRead;
            Thread.yield();
        }
        bufferedStream.close();
        os.flush();
        os.close();
        if (cancel) {
            throw new InterruptedIOException("Cancelled by user");
        }
        return result;
    }

    public static boolean writeStreamDlg(final InputStream is, final OutputStream os, int knownSize, String mainMsg, Component dlgOwner, Options options) {
        final Messages msg = options.getMessages();
        String title = msg.get("WRITING_FILE");
        JDialog dialog = dlgOwner instanceof Dialog ? new JDialog((Dialog)dlgOwner, title, true) : (dlgOwner != null ? new JDialog(JOptionPane.getFrameForComponent(dlgOwner), title, true) : new JDialog((Frame)null, title, true));
        if (mainMsg != null) {
            dialog.getContentPane().add(new JLabel(mainMsg));
        }
        final JProgressBar progress = new JProgressBar();
        if (knownSize > 0) {
            progress.setMinimum(0);
            progress.setMaximum(knownSize);
            progress.setIndeterminate(false);
        } else {
            progress.setIndeterminate(true);
        }
        InputStreamListener isl = new InputStreamListener(){

            @Override
            public void notify(InputStream in, int bytesRead) {
                progress.setValue(bytesRead);
            }
        };
        dialog.getContentPane().add(progress);
        final InputStreamListener iis = isl;
        JButton cancelButton = new JButton(msg.get("CANCEL"));
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                cancel = true;
            }
        });
        dialog.getContentPane().add(cancelButton);
        dialog.pack();
        final JDialog dlg = dialog;
        SwingWorker sw = new SwingWorker(){
            private boolean result = false;

            @Override
            public Object construct() {
                try {
                    StreamIO.writeStreamTo(is, os, iis, 4096);
                    this.result = !cancel;
                }
                catch (Exception ex) {
                    this.result = false;
                    msg.showErrorWarning(dlg, "ERROR", ex);
                }
                dlg.setVisible(false);
                return this.result;
            }
        };
        sw.startLater();
        dialog.setVisible(true);
        return (Boolean)sw.get();
    }

    public static Object cloneObject(Serializable obj) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(512);
        ObjectOutputStream out = new ObjectOutputStream(baos);
        out.writeObject(obj);
        out.close();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        ObjectInputStream in = new ObjectInputStream(bais);
        return in.readObject();
    }

    public static interface InputStreamProvider {
        public InputStream getInputStream(String var1) throws Exception;
    }

    public static interface InputStreamListener {
        public void notify(InputStream var1, int var2);
    }
}

