/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.report.rp;

import edu.xtec.jclic.report.ActivityData;
import edu.xtec.jclic.report.SessionData;
import edu.xtec.jclic.report.rp.BasicReport;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import javax.imageio.ImageIO;

public class Img
extends BasicReport {
    public static final String URL = "img";
    public static final String TYPE = "type";
    public static final String HEADER = "header";
    public static final String GRAPH = "graph";
    public static final String TEXT = "text";
    public static final String DIST = "dist";
    public static final String WIDTH = "w";
    public static final String HEIGHT = "h";
    public static final String USER_GRAPH = "userGraph";
    public static final String GROUP_GRAPH = "groupGraph";
    public static final String PROJECT_GRAPH = "projectGraph";
    public static int DEFAULT_WIDTH = 0;
    public static int DIST_WIDTH;
    public static int DEFAULT_HEIGHT;
    public static int DEFAULT_HEADER_HEIGHT;
    public static int MRG;
    public static Color BG_COLOR;
    public static Color TEXT_COLOR;
    public static Color BORDER_COLOR;
    public static Color HEADER_BG_COLOR;
    public static Color HEADER_TEXT_COLOR;
    public static Color V1_COLOR;
    public static Color V2_COLOR;
    public static Color DIST_COLOR;
    public static Color ALERT_COLOR;
    public static Stroke THIN_STROKE;
    public static Stroke BOLD_STROKE;
    public static Font STD_FONT;
    public static Font BOLD_FONT;
    public static Font ALERT_FONT;
    public static int MARGE_X;
    public static int MARGE_Y;
    public static int NUM_DIVISIONS_Y;
    public static int MAX_COLS;
    public static int M_X_DIST;
    public static int M_Y_DIST;
    boolean withHeader;
    boolean isDist;
    int width;
    int height;
    String titleKey;
    public static final int N_DIST_ELEMENTS = 5;
    private static DecimalFormat DF;

    @Override
    public String getTitle(ResourceBundle bundle) {
        return "";
    }

    @Override
    public String getUrl() {
        return URL;
    }

    @Override
    public boolean noCache() {
        return false;
    }

    public static void loadSettings(String file) throws Exception {
        Img.loadProperties(file);
        DEFAULT_WIDTH = Integer.parseInt(prop.getProperty("graph_width", "440"));
        DIST_WIDTH = Integer.parseInt(prop.getProperty("graph_dist_width", "192"));
        DEFAULT_HEIGHT = Integer.parseInt(prop.getProperty("graph_height", "155"));
        DEFAULT_HEADER_HEIGHT = Integer.parseInt(prop.getProperty("graph_header_height", "25"));
        MRG = Integer.parseInt(prop.getProperty("graph_margin", "8"));
        BG_COLOR = new Color(Integer.parseInt(prop.getProperty("graph_color_bg", "008080"), 16));
        TEXT_COLOR = new Color(Integer.parseInt(prop.getProperty("graph_color_text", "FFFFFF"), 16));
        HEADER_BG_COLOR = new Color(Integer.parseInt(prop.getProperty("graph_color_header_bg", "008080"), 16));
        HEADER_TEXT_COLOR = new Color(Integer.parseInt(prop.getProperty("graph_color_header_text", "FFFFFF"), 16));
        BORDER_COLOR = new Color(Integer.parseInt(prop.getProperty("graph_color_border", "000000"), 16));
        V1_COLOR = new Color(Integer.parseInt(prop.getProperty("graph_color_v1", "00FF00"), 16));
        V2_COLOR = new Color(Integer.parseInt(prop.getProperty("graph_color_v2", "0000FF"), 16));
        DIST_COLOR = new Color(Integer.parseInt(prop.getProperty("graph_color_dist", "0000FF"), 16));
        ALERT_COLOR = new Color(Integer.parseInt(prop.getProperty("graph_color_alert", "FF0000"), 16));
        BOLD_STROKE = new BasicStroke(Float.parseFloat(prop.getProperty("graph_stroke_width", "3.0")));
        THIN_STROKE = new BasicStroke(1.0f);
        try {
            String fontFamily = prop.getProperty("graph_font_family", "Dialog");
            int fontSize = Integer.parseInt(prop.getProperty("graph_font_size", "11"));
            STD_FONT = new Font(fontFamily, 0, fontSize);
            BOLD_FONT = new Font(fontFamily, 1, fontSize);
            ALERT_FONT = new Font(fontFamily, 1, 24);
        }
        catch (Exception exception) {
            // empty catch block
        }
        MARGE_X = Integer.parseInt(prop.getProperty("graph_margin_x", "50"));
        MARGE_Y = Integer.parseInt(prop.getProperty("graph_margin_y", "20"));
        NUM_DIVISIONS_Y = Integer.parseInt(prop.getProperty("graph_div_y", "4"));
        MAX_COLS = Integer.parseInt(prop.getProperty("graph_max_cols", "10"));
        M_X_DIST = Integer.parseInt(prop.getProperty("graph_margin_dist_x", "15"));
        M_Y_DIST = Integer.parseInt(prop.getProperty("graph_margin_dist_y", "20"));
    }

    @Override
    public boolean init() throws Exception {
        if (!super.init()) {
            return false;
        }
        this.withHeader = this.getBoolParam(HEADER, "true");
        this.isDist = this.getBoolParam(DIST, "true");
        this.type = -1;
        String s = this.getParam(TYPE);
        if (USER_GRAPH.equals(s)) {
            this.type = 0;
            this.titleKey = "report_user_evolution";
        } else if (GROUP_GRAPH.equals(s)) {
            this.type = 1;
            this.titleKey = "report_group_evolution";
        } else if (PROJECT_GRAPH.equals(s)) {
            this.type = 2;
            this.titleKey = "report_project_evolution";
        } else {
            this.type = -1;
            this.errCode = 400;
            throw new Exception();
        }
        if (this.isDist) {
            this.titleKey = "report_result_distribution";
        }
        this.width = this.getIntParam(WIDTH, this.isDist ? DIST_WIDTH : DEFAULT_WIDTH);
        this.height = this.getIntParam(HEIGHT, DEFAULT_HEIGHT);
        if (this.width <= 0 || this.height <= 0) {
            System.err.println("EP!!");
        }
        return true;
    }

    @Override
    public void header(List<String[]> v) {
        v.add(new String[]{"CONTENT_TYPE", "image/png"});
    }

    @Override
    public boolean usesWriter() {
        return false;
    }

    @Override
    public void process(OutputStream out) throws Exception {
        BufferedImage bi = new BufferedImage(this.width, this.height, 1);
        Graphics2D g2 = (Graphics2D)bi.getGraphics();
        int h = this.withHeader ? DEFAULT_HEADER_HEIGHT : 0;
        Rectangle allRect = new Rectangle(0, 0, this.width, this.height);
        Rectangle hr = new Rectangle(0, 0, this.width, h);
        Rectangle gr = new Rectangle(0, h, this.width, this.height - h);
        g2.setColor(BG_COLOR);
        g2.fill(allRect);
        if (this.withHeader) {
            g2.setColor(HEADER_BG_COLOR);
            g2.fill(hr);
        }
        g2.setColor(BORDER_COLOR);
        g2.draw(new Rectangle(0, 0, this.width - 1, this.height - 1));
        if (this.withHeader) {
            this.drawHeader(g2, hr);
            g2.setColor(BORDER_COLOR);
            g2.drawLine(0, h, this.width, h);
        }
        if (this.isDist) {
            this.dibuixaDistribucio(g2, this.getSessionList(), gr);
        } else {
            this.dibuixaImatge(g2, this.getSessionList(), gr);
        }
        g2.dispose();
        ImageIO.write((RenderedImage)bi, "png", out);
    }

    protected void drawHeader(Graphics2D g2, Rectangle box) throws Exception {
        FontMetrics fm = g2.getFontMetrics(STD_FONT);
        int fh = fm.getHeight();
        int rs = fh / 2;
        int dy = (box.height - fh) / 2;
        int dyr = (box.height - rs) / 2;
        if (!this.isDist) {
            String var1 = this.bundle.getString("report_global_precision");
            String var2 = this.bundle.getString("report_solved_activities");
            int lvar1 = fm.stringWidth(var1);
            int lvar2 = fm.stringWidth(var2);
            Rectangle r1 = new Rectangle(box.x + box.width - MRG - lvar2 - 6 - rs - 2 * MRG - lvar1 - 6 - fh, box.y + dyr, rs, rs);
            Rectangle r2 = new Rectangle(box.x + box.width - MRG - lvar2 - 6 - rs, box.y + dyr, rs, rs);
            g2.setColor(V1_COLOR);
            g2.fill(r1);
            g2.setColor(V2_COLOR);
            g2.fill(r2);
            g2.setColor(BORDER_COLOR);
            g2.draw(r1);
            g2.draw(r2);
            g2.setFont(STD_FONT);
            g2.setColor(HEADER_TEXT_COLOR);
            g2.drawString(var1, box.x + r1.x + rs + 6, box.y + dy + fm.getAscent());
            g2.drawString(var2, box.x + r2.x + rs + 6, box.y + dy + fm.getAscent());
        }
        g2.setColor(HEADER_TEXT_COLOR);
        g2.setFont(BOLD_FONT);
        g2.drawString(this.bundle.getString(this.titleKey), box.x + MRG, box.y + dy + fm.getAscent());
    }

    public void dibuixaImatge(Graphics2D g2, List<SessionData> v, Rectangle box) throws Exception {
        g2.setColor(TEXT_COLOR);
        g2.setStroke(THIN_STROKE);
        int gWidth = box.width - 2 * MARGE_X;
        int gHeight = box.height - 2 * MARGE_Y;
        g2.drawRect(box.x + MARGE_X, box.y + MARGE_Y, gWidth, gHeight);
        if (v.size() > 0) {
            float lDivY = gHeight / NUM_DIVISIONS_Y;
            for (int i = 1; i < NUM_DIVISIONS_Y; ++i) {
                int y = (int)((float)MARGE_Y + (float)i * lDivY);
                g2.drawLine(box.x + MARGE_X, box.y + y, box.x + MARGE_X + gWidth, box.y + y);
            }
            g2.setFont(STD_FONT);
            FontMetrics fm = g2.getFontMetrics();
            for (int i = 0; i <= NUM_DIVISIONS_Y; ++i) {
                String num = Integer.toString(100 - i * (100 / NUM_DIVISIONS_Y));
                int l = fm.stringWidth(num);
                g2.drawString(num, box.x + MARGE_X - 5 - l, box.y + MARGE_Y + (int)(lDivY * (float)i) + 3);
            }
            int numArgs = v.size();
            if (numArgs == 1) {
                v.add(v.get(0));
                ++numArgs;
            }
            int columnesArgs = numArgs - 1;
            int numColumnesX = Math.min(MAX_COLS, columnesArgs);
            float longColumnaX = gWidth / numColumnesX;
            float increment = (float)columnesArgs / (float)numColumnesX;
            int[] puntsDePas = new int[numColumnesX + 2];
            int i = 0;
            for (float f = 0.0f; f <= (float)(columnesArgs + 1); f += increment) {
                puntsDePas[i++] = Math.round(f);
            }
            int[] abscises = new int[numArgs];
            int j = 0;
            for (int k = 0; k <= columnesArgs; ++k) {
                if (puntsDePas[j] == k) {
                    abscises[k] = (int)((float)MARGE_X + (float)j++ * longColumnaX);
                    continue;
                }
                int properPunt = puntsDePas[j];
                int anteriorPunt = puntsDePas[j - 1];
                float x = (float)(k - anteriorPunt) * (longColumnaX / (float)(properPunt - anteriorPunt));
                abscises[k] = (int)((float)MARGE_X + (float)(j - 1) * longColumnaX + x);
            }
            j = 0;
            Date dataFinal = null;
            boolean validat = true;
            for (i = 0; i < columnesArgs && validat; ++i) {
                SessionData sd1 = v.get(i);
                SessionData sd2 = v.get(i + 1);
                if (puntsDePas[j] == i) {
                    g2.setColor(TEXT_COLOR);
                    g2.setStroke(THIN_STROKE);
                    g2.drawLine(box.x + abscises[i], box.y + MARGE_Y, box.x + abscises[i], box.y + MARGE_Y + gHeight);
                }
                g2.setStroke(BOLD_STROKE);
                g2.setColor(V2_COLOR);
                g2.drawLine(box.x + abscises[i], box.y + MARGE_Y + gHeight - sd1.percentSolved() * gHeight / 100, box.x + abscises[i + 1], box.y + MARGE_Y + gHeight - sd2.percentSolved() * gHeight / 100);
                g2.setColor(V1_COLOR);
                g2.drawLine(box.x + abscises[i], box.y + MARGE_Y + gHeight - sd1.percentPrec() * gHeight / 100, box.x + abscises[i + 1], box.y + MARGE_Y + gHeight - sd2.percentPrec() * gHeight / 100);
                if (puntsDePas[j] == i) {
                    g2.setColor(TEXT_COLOR);
                    g2.drawString(this.veryShortDateFormat.format(sd1.date), box.x + abscises[i], box.y + MARGE_Y + gHeight + 15);
                    ++j;
                }
                dataFinal = sd2.date;
            }
            g2.setColor(TEXT_COLOR);
            g2.drawString(this.veryShortDateFormat.format(dataFinal), box.x + abscises[i], box.y + MARGE_Y + gHeight + 15);
        } else {
            String noDades = this.bundle.getString("report_no_data");
            g2.setColor(ALERT_COLOR);
            g2.setFont(ALERT_FONT);
            Rectangle r = ALERT_FONT.getStringBounds(noDades, g2.getFontRenderContext()).getBounds();
            g2.drawString(noDades, box.x + MARGE_X + (gWidth - r.width) / 2, box.y + MARGE_Y + gHeight / 2 + r.height / 4);
        }
    }

    public void dibuixaDistribucio(Graphics2D g2, List v, Rectangle box) {
        int i;
        int[] dist = new int[5];
        Iterator it = v.iterator();
        int vc = 20;
        while (it.hasNext()) {
            SessionData sd = (SessionData)it.next();
            if (sd.actData != null && sd.actData.size() > 0) {
                Iterator<ActivityData> it2 = sd.actData.iterator();
                while (it.hasNext()) {
                    ActivityData ad = (ActivityData)it.next();
                    int n = Math.min(99, ad.qualification) / vc;
                    dist[n] = dist[n] + 1;
                }
                continue;
            }
            int n = Math.min(99, sd.percentPrec()) / vc;
            dist[n] = dist[n] + sd.numActs;
        }
        int leftMargin = M_X_DIST;
        int topMargin = M_Y_DIST;
        g2.setColor(TEXT_COLOR);
        g2.setStroke(THIN_STROKE);
        g2.setFont(STD_FONT);
        float max = 0.0f;
        float maxOrdenades = 0.0f;
        float maxDivisio = 0.0f;
        boolean data = false;
        for (i = 0; i < dist.length && !data; ++i) {
            data = dist[i] > 0;
        }
        if (data) {
            max = dist[0];
            for (i = 1; i < dist.length; ++i) {
                max = Math.max(max, (float)dist[i]);
            }
            maxOrdenades = Img.getMaximOrdenades(max, false);
            maxDivisio = Img.getMaximOrdenades(max, true);
            String sNum = Img.formatNumber(maxDivisio);
            leftMargin += g2.getFontMetrics().stringWidth(sNum);
        }
        int gWidth = box.width - leftMargin - 10;
        int gHeight = box.height - 2 * topMargin;
        g2.drawRect(box.x + leftMargin, box.y + topMargin, gWidth, gHeight);
        if (data) {
            int i2;
            int numDivisionsY = 0;
            float f = max;
            while ((double)f > 0.01) {
                ++numDivisionsY;
                f -= maxDivisio;
            }
            if (numDivisionsY > 0) {
                float longdivisioY = gHeight / numDivisionsY;
                for (i2 = 1; i2 < numDivisionsY; ++i2) {
                    g2.drawLine(box.x + leftMargin, box.y + topMargin + (int)((float)i2 * longdivisioY), box.x + leftMargin + gWidth, box.y + topMargin + (int)((float)i2 * longdivisioY));
                }
                for (i2 = 0; i2 <= numDivisionsY; ++i2) {
                    float num = maxDivisio * (float)numDivisionsY - (float)i2 * maxDivisio;
                    String sNum = Img.formatNumber(num);
                    g2.drawString(sNum, box.x + leftMargin - 5 - g2.getFontMetrics().stringWidth(sNum), box.y + topMargin + (int)(longdivisioY * (float)i2) + 3);
                }
            }
            float longColumnaX = gWidth / 5;
            for (i2 = 0; i2 < 5; ++i2) {
                g2.setColor(TEXT_COLOR);
                g2.setStroke(THIN_STROKE);
                g2.drawLine(box.x + leftMargin + (int)((float)i2 * longColumnaX), box.y + topMargin, box.x + leftMargin + (int)((float)i2 * longColumnaX), box.y + topMargin + gHeight);
                StringBuilder sb = new StringBuilder(Integer.toString(i2 * 20));
                sb.append("%");
                g2.drawString(sb.substring(0), box.x + leftMargin + (int)((float)i2 * longColumnaX), box.y + topMargin + gHeight + 15);
                g2.setColor(DIST_COLOR);
                int alt = (dist[i2] * 100 / (int)(maxDivisio * (float)numDivisionsY) * gHeight - 1) / 100;
                int ample = i2 == 4 ? (int)((float)gWidth - longColumnaX * (float)i2 - 1.0f) : (int)(longColumnaX - 1.0f);
                g2.fillRect(box.x + leftMargin + (int)((float)i2 * longColumnaX) + 1, box.y + topMargin + gHeight - alt, ample, alt);
            }
        } else {
            String noDades = this.bundle.getString("report_no_data");
            g2.setColor(ALERT_COLOR);
            g2.setFont(STD_FONT);
            Rectangle r = STD_FONT.getStringBounds(noDades, g2.getFontRenderContext()).getBounds();
            g2.drawString(noDades, box.x + leftMargin + (gWidth - r.width) / 2, box.y + topMargin + gHeight / 2 + r.height / 4);
        }
    }

    public static float getMaximOrdenades(float maxim, boolean divisio) {
        float f = maxim * 100.0f;
        if (divisio) {
            f /= 6.0f;
        }
        int i = (int)f;
        int xifresTretes = 0;
        while (i > 9) {
            i = (int)f;
            f /= 10.0f;
            ++xifresTretes;
        }
        i = i == 1 ? 2 : (i > 1 && i < 5 ? 5 : 10);
        for (int k = 1; k < xifresTretes; ++k) {
            i *= 10;
        }
        return (float)i / 100.0f;
    }

    protected static String formatNumber(float n) {
        if (DF == null) {
            DF = new DecimalFormat();
            DF.setMaximumFractionDigits(1);
            DF.setGroupingUsed(false);
        }
        return DF.format(n);
    }

    static {
        if (DEFAULT_WIDTH == 0) {
            try {
                Img.loadSettings(null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        DF = null;
    }
}

