/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.report.rp;

import edu.xtec.jclic.report.ActionReg;
import edu.xtec.jclic.report.ActivityReg;
import edu.xtec.jclic.report.GroupData;
import edu.xtec.jclic.report.ReportServerEventMaker;
import edu.xtec.jclic.report.TCPReportBean;
import edu.xtec.jclic.report.UserData;
import edu.xtec.jclic.report.rp.ReportsRequestProcessor;
import edu.xtec.util.Domable;
import edu.xtec.util.JDomUtility;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import org.jdom.Document;

public class JClicReportService
extends ReportsRequestProcessor {
    TCPReportBean request = null;
    TCPReportBean response = null;
    public static ReportServerEventMaker eventMaker = new ReportServerEventMaker();
    boolean trustClientDateTime = false;

    @Override
    public boolean init() throws Exception {
        if (!super.init()) {
            return false;
        }
        InputStream is = this.getInputStream();
        if (is != null) {
            if (prop != null) {
                this.trustClientDateTime = "true".equalsIgnoreCase((String)prop.get("trustClientDateTime"));
            }
            Document doc = JDomUtility.getSAXBuilder().build(is);
            this.request = new TCPReportBean(doc.getRootElement());
            this.response = this.processRequest(this.request);
        } else {
            this.response = new TCPReportBean();
        }
        return true;
    }

    @Override
    public boolean usesWriter() {
        return false;
    }

    @Override
    public boolean wantsInputStream() {
        return true;
    }

    @Override
    public void process(OutputStream out) throws Exception {
        JDomUtility.saveDocument(out, this.response.getJDomElement());
    }

    @Override
    public void header(List<String[]> v) {
        super.header(v);
        v.add(new String[]{"CONTENT_TYPE", "text/xml"});
        v.add(new String[]{"EXTRA", "Access-Control-Allow-Origin", "*"});
        v.add(new String[]{"EXTRA", "Access-Control-Allow-Methods", "POST, OPTIONS"});
        v.add(new String[]{"EXTRA", "Access-Control-Allow-Headers", "Content-Type"});
        v.add(new String[]{"EXTRA", "Access-Control-Allow-Max-Age", "1728000"});
    }

    private TCPReportBean processRequest(TCPReportBean bean) throws Exception {
        TCPReportBean result = new TCPReportBean("error");
        String id = bean.getId();
        if ("multiple".equals(id)) {
            Domable[] beans = bean.getData();
            for (int i = 0; i < beans.length; ++i) {
                result = this.processRequest((TCPReportBean)beans[i]);
            }
        } else if ("add session".equals(id)) {
            String sessionId = bridge.addSession(bean.getParam("user"), this.trustClientDateTime ? Long.parseLong(bean.getParam("time")) : System.currentTimeMillis(), bean.getParam("project"), bean.getParam("code"), bean.getParam("key"), bean.getParam("context"));
            result.setParam("session", sessionId);
            result.setId("add session");
        } else if ("add activity".equals(id)) {
            ActionReg actReg;
            ActivityReg ar = (ActivityReg)bean.getSingleData();
            int actId = Integer.parseInt(bean.getParam("num"));
            String sessionId = bean.getParam("session");
            int actIdR = bridge.addActivity(actId, sessionId, ar);
            int arc = 0;
            while ((actReg = ar.getActionReg(arc)) != null) {
                bridge.addAction(actId, sessionId, arc, actReg);
                ++arc;
            }
            result.setParam("activity", Integer.toString(actIdR));
            result.setId("add activity");
        } else if ("new group".equals(id)) {
            String groupId = bridge.newGroup((GroupData)bean.getSingleData());
            result.setParam("group", groupId);
            result.setId("new group");
        } else if ("new user".equals(id)) {
            String userId = bridge.newUser((UserData)bean.getSingleData());
            result.setParam("user", userId);
            result.setId("new user");
        } else if ("get user data".equals(id)) {
            result.setData(bridge.getUserData(bean.getParam("user")));
            result.setId("get user data");
        } else if ("get group data".equals(id)) {
            result.setData(bridge.getGroupData(bean.getParam("group")));
            result.setId("get group data");
        } else if ("get property".equals(id)) {
            String k = bean.getParam("key");
            String dv = bean.getParam("default");
            result.setParam("result", bridge.getProperty(k, dv));
            result.setId("get property");
        } else if ("get_properties".equals(id)) {
            Map<String, String> map = bridge.getProperties();
            for (String key : map.keySet()) {
                result.setParam(key, map.get(key));
            }
            result.setId("get_properties");
        } else if ("get groups".equals(id)) {
            List<GroupData> v = bridge.getGroups();
            result.setData(v.toArray(new GroupData[v.size()]));
            result.setId("get groups");
        } else if ("get users".equals(id)) {
            List<UserData> v = bridge.getUsers(bean.getParam("group"));
            result.setData(v.toArray(new UserData[v.size()]));
            result.setId("get users");
        } else {
            result.setParam("error", "unknown command");
        }
        eventMaker.fireReportServerSystemEvent(id);
        return result;
    }
}

