/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.report.rp;

import edu.xtec.jclic.ReportServerConstants;
import edu.xtec.jclic.report.ReportServerJDBCBridge;
import edu.xtec.servlet.RequestProcessor;
import edu.xtec.util.Options;
import edu.xtec.util.db.ConnectionBeanProvider;
import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;

public abstract class ReportsRequestProcessor
extends RequestProcessor
implements ReportServerConstants {
    protected static ReportServerJDBCBridge bridge;
    protected static Properties prop;

    public static synchronized void setProperties(Properties prop) {
        if (prop != null && bridge != null) {
            bridge.end();
            bridge = null;
        }
        ReportsRequestProcessor.prop = prop;
    }

    public static synchronized Properties getProperties() {
        if (prop == null) {
            prop = new Properties();
        }
        return prop;
    }

    public static synchronized void loadProperties(String file) throws Exception {
        if (prop == null) {
            prop = new Properties();
            prop.load(ReportServerConstants.class.getResourceAsStream("jclicReports.properties"));
            ReportsRequestProcessor.loadLocalProperties(file);
        }
    }

    public static synchronized void loadLocalProperties(String file) throws Exception {
        if (prop == null) {
            prop = new Properties();
        }
        if (file == null) {
            file = "jclicReports.properties";
        }
        if (file != null) {
            File f = new File(file);
            if (!f.isAbsolute()) {
                f = new File(System.getProperty("user.home"), file);
            }
            if (f.exists()) {
                FileInputStream is = new FileInputStream(f);
                prop.load(is);
                is.close();
            }
        }
    }

    public static synchronized void initJDBCBridge(String propFile) throws Exception {
        if (prop == null) {
            ReportsRequestProcessor.loadProperties(propFile);
        }
        if (bridge == null) {
            ConnectionBeanProvider cbp = ConnectionBeanProvider.getConnectionBeanProvider(true, Options.toStringMap(prop));
            boolean createTables = !"false".equalsIgnoreCase((String)prop.get("createTables"));
            String tablePrefix = (String)prop.get("tablePrefix");
            bridge = new ReportServerJDBCBridge(cbp, createTables, tablePrefix);
        }
    }

    @Override
    public boolean init() throws Exception {
        if (!super.init()) {
            return false;
        }
        if (bridge == null) {
            ReportsRequestProcessor.initJDBCBridge(null);
        }
        return true;
    }
}

