/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.servlet;

import edu.xtec.servlet.RequestProcessor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class AbstractServlet
extends HttpServlet {
    public AbstractServlet() {
        RequestProcessor.setDirectResources(true);
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        Enumeration en = config.getInitParameterNames();
        if (en.hasMoreElements()) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            while (en.hasMoreElements()) {
                String key = (String)en.nextElement();
                String string = config.getInitParameter(key);
            }
            RequestProcessor.config(map);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        RequestProcessor rp = null;
        try {
            rp = this.createRP();
            if (rp.wantsInputStream()) {
                rp.setInputStream((InputStream)request.getInputStream());
            } else {
                HashMap<String, Object> v = new HashMap<String, Object>();
                Map parameters = request.getParameterMap();
                for (Object k : parameters.keySet()) {
                    v.put((String)k, parameters.get(k));
                }
                rp.setParams(v);
            }
            Cookie[] ck = request.getCookies();
            if (ck != null) {
                for (int i = 0; i < ck.length; ++i) {
                    rp.setCookie(ck[i].getName(), ck[i].getValue());
                }
            }
            Enumeration en = request.getHeaderNames();
            HashMap<String, Object> map = new HashMap<String, Object>();
            while (en.hasMoreElements()) {
                String name = (String)en.nextElement();
                Enumeration enh = request.getHeaders(name);
                ArrayList<String> v = new ArrayList<String>();
                while (enh.hasMoreElements()) {
                    v.add((String)enh.nextElement());
                }
                map.put(name.toLowerCase(), v);
            }
            rp.setHeaders(map);
            rp.init();
            if (rp.noCache()) {
                response.setHeader("Pragma", "no-cache");
                response.setHeader("Cache-Control", "no-cache");
                response.setHeader("Expires", "0");
            }
            ArrayList<String[]> v = new ArrayList<String[]>();
            rp.header(v);
            if (!v.isEmpty()) {
                Iterator it = v.iterator();
                while (it.hasNext() && !response.isCommitted()) {
                    String[] h = (String[])it.next();
                    if (h[0].equals("ERROR")) {
                        int code = Integer.parseInt(h[1]);
                        response.sendError(code, h[2]);
                    }
                    if (h[0].equals("REDIRECT")) {
                        response.sendRedirect(h[1]);
                        break;
                    }
                    if (h[0].equals("CONTENT_TYPE")) {
                        response.setContentType(h[1]);
                        continue;
                    }
                    if (h[0].equals("CONTENT_LENGTH")) {
                        response.setContentLength(Integer.parseInt(h[1]));
                        continue;
                    }
                    if (h[0].equals("EXTRA")) {
                        response.setHeader(h[1], h[2]);
                        continue;
                    }
                    if (!h[0].equals("COOKIE")) continue;
                    response.addCookie(new Cookie(h[1], h[2]));
                }
            }
            if (!response.isCommitted()) {
                if (rp.usesWriter()) {
                    PrintWriter pw = response.getWriter();
                    rp.process(pw);
                    try {
                        pw.flush();
                        pw.close();
                    }
                    catch (Exception exception) {}
                } else {
                    ServletOutputStream os = response.getOutputStream();
                    rp.process((OutputStream)os);
                    try {
                        os.flush();
                        os.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            rp.end();
            rp = null;
        }
        catch (Exception ex) {
            String errMsg;
            int errCode = rp != null && rp.errCode >= 0 ? rp.errCode : 500;
            String string = errMsg = rp != null && rp.errMsg != null ? rp.errMsg : ex.getMessage();
            if (!response.isCommitted()) {
                response.sendError(errCode, errMsg);
            }
            System.err.println("ERROR " + errCode + ": " + errMsg);
            ex.printStackTrace(System.err);
        }
        finally {
            if (rp != null) {
                rp.end();
            }
        }
    }

    protected abstract RequestProcessor createRP() throws Exception;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }
}

