/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic;

import edu.xtec.jclic.Activity;
import edu.xtec.jclic.ActivityEditor;
import edu.xtec.jclic.ActivityEditorInternalPanel;
import edu.xtec.jclic.ActivityEditorPanel;
import edu.xtec.jclic.automation.AutoContentProvider;
import edu.xtec.jclic.automation.AutoContentProviderEditor;
import edu.xtec.jclic.bags.ActivityBagElementEditor;
import edu.xtec.jclic.bags.SelectActivityClass;
import edu.xtec.jclic.beans.EventSoundsButton;
import edu.xtec.jclic.beans.RollPanel;
import edu.xtec.jclic.beans.SmallIntEditor;
import edu.xtec.jclic.skins.Skin;
import edu.xtec.util.ProgressDialog;
import edu.xtec.util.ResourceManager;
import edu.xtec.util.StrUtils;
import edu.xtec.util.SwingWorker;
import edu.xtec.util.TripleString;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;

public class ActivityEditorOptionsPanel
extends ActivityEditorInternalPanel {
    List<TripleString> contentProviders;
    List<TripleString> allContentProviders;
    private static SelectActivityClass sac;
    private JCheckBox actionsCounterChk;
    private JComboBox<Object> autoCpCombo;
    private JButton autoCpEditBtn;
    private RollPanel autoCpPanel;
    private JCheckBox bIncludeInReportsChk;
    private JCheckBox bRegisterActionsChk;
    private RollPanel behaviorPanel;
    private RollPanel buttonsPanel;
    private JButton chClassBtn;
    private JButton chNameBtn;
    private JLabel className;
    private JTextField codeText;
    private JCheckBox countdownActionsChk;
    private JCheckBox countdownTimeChk;
    private RollPanel countersPanel;
    private RollPanel descPanel;
    private JScrollPane descScroll;
    private JTextPane descText;
    private JCheckBox dragCellsChk;
    private EventSoundsButton evSoundsBtn;
    private JCheckBox helpBtnChk;
    private JRadioButton helpBtnMsg;
    private JScrollPane helpBtnMsgScroll;
    private JTextArea helpBtnMsgText;
    private JRadioButton helpBtnSolution;
    private JCheckBox infoBtnChk;
    private JRadioButton infoBtnCmdChk;
    private JTextField infoBtnCmdTxt;
    private JRadioButton infoBtnUrlChk;
    private JTextField infoBtnUrlTxt;
    private SmallIntEditor maxActionsInt;
    private SmallIntEditor maxTimeInt;
    private JLabel nameText;
    private JCheckBox orderChk;
    private RollPanel reportPanel;
    private JCheckBox scoreCounterChk;
    private SmallIntEditor scrambleTimesInt;
    private JScrollPane scroll;
    private JComboBox skinCombo;
    private JCheckBox timeCounterChk;
    private RollPanel uiPanel;

    public ActivityEditorOptionsPanel(ActivityEditorPanel parent) {
        super(parent);
        this.allContentProviders = AutoContentProviderEditor.getSystemContentProvidersList(this.options);
        this.initComponents();
        this.checkContentProviders();
        this.evSoundsBtn.setOptions(this.options);
        this.setEnabled(false);
    }

    private void initComponents() {
        ButtonGroup helpBtnButtonGroup = new ButtonGroup();
        ButtonGroup infoBtnButtonGroup = new ButtonGroup();
        this.scroll = new JScrollPane();
        this.scroll.getVerticalScrollBar().setUnitIncrement(16);
        JPanel mainPanel = new JPanel();
        this.descPanel = new RollPanel();
        JLabel classLb = new JLabel();
        this.className = new JLabel();
        this.chClassBtn = new JButton();
        this.chClassBtn.addActionListener(this);
        JLabel nameLb = new JLabel();
        this.nameText = new JLabel();
        this.chNameBtn = new JButton();
        this.chNameBtn.addActionListener(this);
        JLabel descLb = new JLabel();
        this.descScroll = new JScrollPane();
        this.descText = new JTextPane();
        this.reportPanel = new RollPanel();
        this.bIncludeInReportsChk = new JCheckBox();
        JLabel codeLb = new JLabel();
        this.codeText = new JTextField();
        this.bRegisterActionsChk = new JCheckBox();
        this.uiPanel = new RollPanel();
        JLabel skinLb = new JLabel();
        this.skinCombo = new JComboBox<String>(Skin.getSystemSkinList(true));
        JLabel evSoundsLb = new JLabel();
        this.evSoundsBtn = new EventSoundsButton();
        this.autoCpPanel = new RollPanel();
        JLabel autoCpLb = new JLabel();
        this.autoCpCombo = new JComboBox();
        this.autoCpEditBtn = new JButton();
        this.countersPanel = new RollPanel();
        this.timeCounterChk = new JCheckBox();
        JLabel maxTimeLb = new JLabel();
        this.maxTimeInt = new SmallIntEditor();
        this.countdownTimeChk = new JCheckBox();
        this.actionsCounterChk = new JCheckBox();
        JLabel maxActionsLb = new JLabel();
        this.maxActionsInt = new SmallIntEditor();
        this.countdownActionsChk = new JCheckBox();
        this.scoreCounterChk = new JCheckBox();
        this.buttonsPanel = new RollPanel();
        this.helpBtnChk = new JCheckBox();
        this.helpBtnMsg = new JRadioButton();
        this.helpBtnSolution = new JRadioButton();
        this.helpBtnMsgScroll = new JScrollPane();
        this.helpBtnMsgText = new JTextArea();
        this.infoBtnChk = new JCheckBox();
        this.infoBtnUrlChk = new JRadioButton();
        this.infoBtnUrlTxt = new JTextField();
        this.infoBtnCmdChk = new JRadioButton();
        this.infoBtnCmdTxt = new JTextField();
        this.behaviorPanel = new RollPanel();
        JLabel scrambleTimesLb = new JLabel();
        this.scrambleTimesInt = new SmallIntEditor();
        this.dragCellsChk = new JCheckBox();
        this.orderChk = new JCheckBox();
        JLabel spacer = new JLabel();
        this.setLayout(new BoxLayout(this, 2));
        mainPanel.setLayout(new GridBagLayout());
        this.descPanel.setTitle(this.options.getMsg("edit_act_description_block"));
        this.descPanel.getMainPanel().setLayout(new GridBagLayout());
        classLb.setText(this.options.getMsg("edit_act_class"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 4, 2, 2);
        this.descPanel.getMainPanel().add((Component)classLb, gridBagConstraints);
        this.className.setText(" ");
        this.className.setPreferredSize(new Dimension(200, 21));
        this.className.setBorder(BorderFactory.createTitledBorder(""));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.descPanel.getMainPanel().add((Component)this.className, gridBagConstraints);
        this.chClassBtn.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/edit.gif")));
        this.chClassBtn.setToolTipText(this.options.getMsg("edit_act_changeType"));
        this.chClassBtn.setText("");
        this.chClassBtn.setMargin(new Insets(2, 2, 2, 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.descPanel.getMainPanel().add((Component)this.chClassBtn, gridBagConstraints);
        nameLb.setText(this.options.getMsg("edit_act_name"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 4, 2, 2);
        this.descPanel.getMainPanel().add((Component)nameLb, gridBagConstraints);
        this.nameText.setPreferredSize(new Dimension(200, 21));
        this.nameText.setBorder(BorderFactory.createTitledBorder(""));
        this.nameText.setMinimumSize(new Dimension(110, 21));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.descPanel.getMainPanel().add((Component)this.nameText, gridBagConstraints);
        this.chNameBtn.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/edit.gif")));
        this.chNameBtn.setToolTipText(this.options.getMsg("edit_media_change_name"));
        this.chNameBtn.setText("");
        this.chNameBtn.setMargin(new Insets(2, 2, 2, 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.descPanel.getMainPanel().add((Component)this.chNameBtn, gridBagConstraints);
        descLb.setText(this.options.getMsg("edit_act_description"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(2, 4, 2, 2);
        this.descPanel.getMainPanel().add((Component)descLb, gridBagConstraints);
        this.descScroll.setHorizontalScrollBarPolicy(31);
        this.descScroll.setPreferredSize(new Dimension(300, 60));
        this.descScroll.setMinimumSize(new Dimension(150, 60));
        this.descText.setToolTipText(this.options.getMsg("edit_act_description_tooltip"));
        this.descText.getDocument().addDocumentListener(this);
        this.descScroll.setViewportView(this.descText);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.descPanel.getMainPanel().add((Component)this.descScroll, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        mainPanel.add((Component)this.descPanel, gridBagConstraints);
        this.reportPanel.setTitle(this.options.getMsg("edit_act_reports_block"));
        this.reportPanel.getMainPanel().setLayout(new GridBagLayout());
        this.bIncludeInReportsChk.setToolTipText(this.options.getMsg("edit_act_includeInReports_tooltip"));
        this.bIncludeInReportsChk.setText(this.options.getMsg("edit_act_includeInReports"));
        this.bIncludeInReportsChk.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.reportPanel.getMainPanel().add((Component)this.bIncludeInReportsChk, gridBagConstraints);
        codeLb.setLabelFor(this.codeText);
        codeLb.setText(this.options.getMsg("edit_act_code"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 4, 2, 2);
        this.reportPanel.getMainPanel().add((Component)codeLb, gridBagConstraints);
        this.codeText.setToolTipText(this.options.getMsg("edit_act_code_tooltip"));
        this.codeText.setPreferredSize(new Dimension(80, 21));
        this.codeText.setMinimumSize(new Dimension(80, 21));
        this.codeText.getDocument().addDocumentListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 4);
        this.reportPanel.getMainPanel().add((Component)this.codeText, gridBagConstraints);
        this.bRegisterActionsChk.setToolTipText(this.options.getMsg("edit_act_reportActions_tooltip"));
        this.bRegisterActionsChk.setText(this.options.getMsg("edit_act_reportActions"));
        this.bRegisterActionsChk.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 13);
        this.reportPanel.getMainPanel().add((Component)this.bRegisterActionsChk, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        mainPanel.add((Component)this.reportPanel, gridBagConstraints);
        this.uiPanel.setTitle(this.options.getMsg("edit_act_ui_block"));
        this.uiPanel.getMainPanel().setLayout(new GridBagLayout());
        skinLb.setText(this.options.getMsg("settings_skin"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.uiPanel.getMainPanel().add((Component)skinLb, gridBagConstraints);
        this.skinCombo.setEditable(true);
        this.skinCombo.setToolTipText(this.options.getMsg("settings_skin_tooltip"));
        this.skinCombo.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.uiPanel.getMainPanel().add((Component)this.skinCombo, gridBagConstraints);
        evSoundsLb.setLabelFor(this.evSoundsBtn);
        evSoundsLb.setText(this.options.getMsg("edit_act_evsounds"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.uiPanel.getMainPanel().add((Component)evSoundsLb, gridBagConstraints);
        this.evSoundsBtn.setToolTipText(this.options.getMsg("edit_act_evsounds_tooltip"));
        this.evSoundsBtn.addPropertyChangeListener("eventSounds", this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.uiPanel.getMainPanel().add((Component)this.evSoundsBtn, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        mainPanel.add((Component)this.uiPanel, gridBagConstraints);
        this.autoCpPanel.setTitle(this.options.getMsg("edit_autocp_block"));
        this.autoCpPanel.getMainPanel().setLayout(new GridBagLayout());
        autoCpLb.setText(this.options.getMsg("edit_autocp"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.autoCpPanel.getMainPanel().add((Component)autoCpLb, gridBagConstraints);
        this.autoCpCombo.setPreferredSize(new Dimension(200, 26));
        this.autoCpCombo.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.autoCpPanel.getMainPanel().add(this.autoCpCombo, gridBagConstraints);
        this.autoCpEditBtn.setToolTipText(this.options.getMsg("edit_autocp_btn_tooltip"));
        this.autoCpEditBtn.setText(this.options.getMsg("edit_autocp_btn"));
        this.autoCpEditBtn.setEnabled(false);
        this.autoCpEditBtn.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.autoCpPanel.getMainPanel().add((Component)this.autoCpEditBtn, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        mainPanel.add((Component)this.autoCpPanel, gridBagConstraints);
        this.countersPanel.setTitle(this.options.getMsg("edit_act_counters_block"));
        this.countersPanel.getMainPanel().setLayout(new GridBagLayout());
        this.timeCounterChk.setToolTipText(this.options.getMsg("edit_act_timeCounter_tooltip"));
        this.timeCounterChk.setText(this.options.getMsg("edit_act_timeCounter"));
        this.timeCounterChk.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.countersPanel.getMainPanel().add((Component)this.timeCounterChk, gridBagConstraints);
        maxTimeLb.setText(this.options.getMsg("edit_act_maxTime"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.countersPanel.getMainPanel().add((Component)maxTimeLb, gridBagConstraints);
        this.maxTimeInt.setToolTipText(this.options.getMsg("edit_act_maxTime_tooltip"));
        this.maxTimeInt.setMax(999);
        this.maxTimeInt.addPropertyChangeListener("value", this);
        this.countersPanel.getMainPanel().add((Component)this.maxTimeInt, new GridBagConstraints());
        this.countdownTimeChk.setToolTipText(this.options.getMsg("edit_act_countdown_tooltip"));
        this.countdownTimeChk.setText(this.options.getMsg("edit_act_countdown"));
        this.countdownTimeChk.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.countersPanel.getMainPanel().add((Component)this.countdownTimeChk, gridBagConstraints);
        this.actionsCounterChk.setToolTipText(this.options.getMsg("edit_act_actionsCounter_tooltip"));
        this.actionsCounterChk.setText(this.options.getMsg("edit_act_actionsCounter"));
        this.actionsCounterChk.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.countersPanel.getMainPanel().add((Component)this.actionsCounterChk, gridBagConstraints);
        maxActionsLb.setText(this.options.getMsg("edit_act_maxActions"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.countersPanel.getMainPanel().add((Component)maxActionsLb, gridBagConstraints);
        this.maxActionsInt.setToolTipText(this.options.getMsg("edit_act_maxActions_tooltip"));
        this.maxActionsInt.setMax(999);
        this.maxActionsInt.addPropertyChangeListener("value", this);
        this.countersPanel.getMainPanel().add((Component)this.maxActionsInt, new GridBagConstraints());
        this.countdownActionsChk.setToolTipText(this.options.getMsg("edit_act_countdown_tooltip"));
        this.countdownActionsChk.setText(this.options.getMsg("edit_act_countdown"));
        this.countdownActionsChk.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.countersPanel.getMainPanel().add((Component)this.countdownActionsChk, gridBagConstraints);
        this.scoreCounterChk.setText(this.options.getMsg("edit_act_scoreCounter"));
        this.scoreCounterChk.setToolTipText(this.options.getMsg("edit_act_scoreCounter_tooltip"));
        this.scoreCounterChk.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.countersPanel.getMainPanel().add((Component)this.scoreCounterChk, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        mainPanel.add((Component)this.countersPanel, gridBagConstraints);
        this.buttonsPanel.setTitle(this.options.getMsg("edit_act_buttons_block"));
        this.buttonsPanel.getMainPanel().setLayout(new GridBagLayout());
        this.helpBtnChk.setText(this.options.getMsg("edit_act_helpBtn"));
        this.helpBtnChk.setToolTipText(this.options.getMsg("edit_act_helpBtn_tooltip"));
        this.helpBtnChk.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.buttonsPanel.getMainPanel().add((Component)this.helpBtnChk, gridBagConstraints);
        helpBtnButtonGroup.add(this.helpBtnMsg);
        this.helpBtnMsg.setText(this.options.getMsg("edit_act_helpBtn_msg"));
        this.helpBtnMsg.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.buttonsPanel.getMainPanel().add((Component)this.helpBtnMsg, gridBagConstraints);
        helpBtnButtonGroup.add(this.helpBtnSolution);
        this.helpBtnSolution.setText(this.options.getMsg("edit_act_helpBtn_solution"));
        this.helpBtnSolution.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.buttonsPanel.getMainPanel().add((Component)this.helpBtnSolution, gridBagConstraints);
        this.helpBtnMsgScroll.setPreferredSize(new Dimension(300, 60));
        this.helpBtnMsgScroll.setMinimumSize(new Dimension(150, 60));
        this.helpBtnMsgText.setWrapStyleWord(true);
        this.helpBtnMsgText.setLineWrap(true);
        this.helpBtnMsgText.getDocument().addDocumentListener(this);
        this.helpBtnMsgScroll.setViewportView(this.helpBtnMsgText);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.buttonsPanel.getMainPanel().add((Component)this.helpBtnMsgScroll, gridBagConstraints);
        this.infoBtnChk.setToolTipText(this.options.getMsg("edit_act_infoBtn_tooltip"));
        this.infoBtnChk.setText(this.options.getMsg("edit_act_infoBtn"));
        this.infoBtnChk.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(9, 3, 3, 3);
        this.buttonsPanel.getMainPanel().add((Component)this.infoBtnChk, gridBagConstraints);
        infoBtnButtonGroup.add(this.infoBtnUrlChk);
        this.infoBtnUrlChk.setText(this.options.getMsg("edit_act_infoBtn_url"));
        this.infoBtnUrlChk.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.buttonsPanel.getMainPanel().add((Component)this.infoBtnUrlChk, gridBagConstraints);
        this.infoBtnUrlTxt.setToolTipText(this.options.getMsg("edit_act_infoBtn_url_tooltip"));
        this.infoBtnUrlTxt.setPreferredSize(new Dimension(300, 21));
        this.infoBtnUrlTxt.setMinimumSize(new Dimension(100, 21));
        this.infoBtnUrlTxt.getDocument().addDocumentListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.buttonsPanel.getMainPanel().add((Component)this.infoBtnUrlTxt, gridBagConstraints);
        infoBtnButtonGroup.add(this.infoBtnCmdChk);
        this.infoBtnCmdChk.setText(this.options.getMsg("edit_act_infoBtn_cmd"));
        this.infoBtnCmdChk.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.buttonsPanel.getMainPanel().add((Component)this.infoBtnCmdChk, gridBagConstraints);
        this.infoBtnCmdTxt.setToolTipText(this.options.getMsg("edit_act_infoBtn_cmd_tooltip"));
        this.infoBtnCmdTxt.setPreferredSize(new Dimension(300, 21));
        this.infoBtnCmdTxt.setMinimumSize(new Dimension(100, 21));
        this.infoBtnCmdTxt.getDocument().addDocumentListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.buttonsPanel.getMainPanel().add((Component)this.infoBtnCmdTxt, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        mainPanel.add((Component)this.buttonsPanel, gridBagConstraints);
        this.behaviorPanel.setTitle(this.options.getMsg("edit_act_behavior_block"));
        this.behaviorPanel.getMainPanel().setLayout(new GridBagLayout());
        scrambleTimesLb.setLabelFor(this.scrambleTimesInt);
        scrambleTimesLb.setText(this.options.getMsg("edit_act_behavior_scramble_times"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.behaviorPanel.getMainPanel().add((Component)scrambleTimesLb, gridBagConstraints);
        this.scrambleTimesInt.setToolTipText(this.options.getMsg("edit_act_behavior_scramble_times_tooltip"));
        this.scrambleTimesInt.setMax(999);
        this.scrambleTimesInt.setMin(1);
        this.scrambleTimesInt.setValue(30);
        this.scrambleTimesInt.addPropertyChangeListener("value", this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.behaviorPanel.getMainPanel().add((Component)this.scrambleTimesInt, gridBagConstraints);
        this.dragCellsChk.setText(this.options.getMsg("edit_act_behavior_drag"));
        this.dragCellsChk.setToolTipText(this.options.getMsg("edit_act_behavior_drag_tooltip"));
        this.dragCellsChk.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.behaviorPanel.getMainPanel().add((Component)this.dragCellsChk, gridBagConstraints);
        this.orderChk.setText(this.options.getMsg("edit_act_behavior_order"));
        this.orderChk.setToolTipText(this.options.getMsg("edit_act_behavior_order_tooltip"));
        this.orderChk.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.behaviorPanel.getMainPanel().add((Component)this.orderChk, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        mainPanel.add((Component)this.behaviorPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        gridBagConstraints.weighty = 1.0;
        mainPanel.add((Component)spacer, gridBagConstraints);
        this.scroll.setViewportView(mainPanel);
        this.add(this.scroll);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.chNameBtn.setEnabled(enabled);
        this.chClassBtn.setEnabled(enabled);
        this.descText.setEnabled(enabled);
        this.bIncludeInReportsChk.setEnabled(enabled);
        this.skinCombo.setEnabled(enabled);
        this.evSoundsBtn.setEnabled(enabled);
        this.autoCpCombo.setEnabled(enabled);
        this.timeCounterChk.setEnabled(enabled);
        this.actionsCounterChk.setEnabled(enabled);
        this.scoreCounterChk.setEnabled(enabled);
        this.helpBtnChk.setEnabled(enabled);
        this.infoBtnChk.setEnabled(enabled);
        this.scrambleTimesInt.setEnabled(enabled);
        this.dragCellsChk.setEnabled(enabled);
        this.orderChk.setEnabled(enabled);
        this.checkEnabled();
    }

    protected void checkEnabled() {
        boolean e = this.isEnabled();
        boolean b = e && this.bIncludeInReportsChk.isSelected();
        this.bRegisterActionsChk.setEnabled(b);
        this.codeText.setEnabled(b);
        this.autoCpEditBtn.setEnabled(e && this.autoCpCombo.getSelectedIndex() > 0);
        b = e && this.timeCounterChk.isSelected();
        this.maxTimeInt.setEnabled(b);
        this.countdownTimeChk.setEnabled(b && this.maxTimeInt.getValue() > 0);
        b = e && this.actionsCounterChk.isSelected();
        this.maxActionsInt.setEnabled(b);
        this.countdownActionsChk.setEnabled(b && this.maxActionsInt.getValue() > 0);
        b = e && this.helpBtnChk.isSelected();
        this.helpBtnSolution.setEnabled(b);
        this.helpBtnMsg.setEnabled(b);
        this.helpBtnMsgText.setEnabled(b && this.helpBtnMsg.isSelected());
        this.helpBtnMsgScroll.setEnabled(b && this.helpBtnMsg.isSelected());
        b = e && this.infoBtnChk.isSelected();
        this.infoBtnUrlChk.setEnabled(b);
        this.infoBtnUrlTxt.setEnabled(b && this.infoBtnUrlChk.isSelected());
        this.infoBtnCmdChk.setEnabled(b);
        this.infoBtnCmdTxt.setEnabled(b && this.infoBtnCmdChk.isSelected());
    }

    private void checkContentProviders() {
        Activity act = this.getActivity();
        if (this.contentProviders == null) {
            this.contentProviders = new ArrayList<TripleString>(this.allContentProviders.size());
        } else {
            this.contentProviders.clear();
        }
        this.autoCpCombo.removeAllItems();
        for (TripleString ts : this.allContentProviders) {
            boolean isOk;
            boolean bl = isOk = ts.getClassName() == null;
            if (!isOk && act != null) {
                isOk = AutoContentProvider.checkClient(ts.getClassName(), act.getClass());
            }
            if (!isOk) continue;
            this.contentProviders.add(ts);
            this.autoCpCombo.addItem(ts);
        }
    }

    @Override
    public void fillData() {
        String s;
        Activity act = this.getActivity();
        this.nameText.setText(act == null ? this.options.getMsg("UNNAMED") : act.name);
        this.descText.setText(act == null ? "" : (act.description == null ? "" : act.description));
        String string = s = act == null ? "" : act.getShortClassName();
        if (s.startsWith("@")) {
            s = s.substring(1);
        }
        this.className.setText(s);
        this.bIncludeInReportsChk.setSelected(act == null ? true : act.includeInReports);
        this.bRegisterActionsChk.setSelected(act == null ? false : act.reportActions);
        this.codeText.setText(act == null ? "" : act.code);
        this.skinCombo.setSelectedItem(act == null ? null : act.skinFileName);
        this.evSoundsBtn.setMediaBagEditor(act == null ? null : this.getActivityEditor().getProjectEditor().getMediaBagEditor());
        this.evSoundsBtn.setEventSounds(act == null ? null : act.eventSounds);
        this.evSoundsBtn.setModified(false);
        this.checkContentProviders();
        String acpClassName = act == null || act.acp == null ? null : act.acp.getShortClassName();
        int index = Math.max(0, TripleString.getFirstItemWithClass(this.contentProviders, acpClassName));
        this.autoCpCombo.setSelectedIndex(index);
        this.timeCounterChk.setSelected(act == null ? true : act.bTimeCounter);
        this.maxTimeInt.setValue(act == null ? 0 : act.maxTime);
        this.countdownTimeChk.setSelected(act == null ? false : act.countDownTime);
        this.actionsCounterChk.setSelected(act == null ? false : act.bActionsCounter);
        this.maxActionsInt.setValue(act == null ? 0 : act.maxActions);
        this.countdownActionsChk.setSelected(act == null ? false : act.countDownActions);
        this.scoreCounterChk.setSelected(act == null ? true : act.bScoreCounter);
        this.helpBtnChk.setSelected(act == null ? true : act.helpWindow);
        boolean helpSolution = act != null && (act.showSolution || act.helpMsg == null || act.helpMsg.length() == 0);
        this.helpBtnSolution.setSelected(helpSolution);
        this.helpBtnMsg.setSelected(!helpSolution);
        this.helpBtnMsgText.setText(act == null ? "" : act.helpMsg);
        int v = 0;
        if (act != null && act.infoUrl != null && act.infoUrl.length() > 0) {
            v = 1;
        } else if (act != null && act.infoCmd != null && act.infoCmd.length() > 0) {
            v = 2;
        }
        this.infoBtnChk.setSelected(v > 0);
        this.infoBtnUrlChk.setSelected(v != 2);
        this.infoBtnCmdChk.setSelected(v == 2);
        this.infoBtnUrlTxt.setText(act == null ? "" : act.infoUrl);
        this.infoBtnCmdTxt.setText(act == null ? "" : act.infoCmd);
        if (act != null && act.hasRandom()) {
            this.scrambleTimesInt.setValue(act.shuffles);
        }
        this.dragCellsChk.setSelected(act == null ? false : act.dragCells);
        this.orderChk.setSelected(act == null ? false : act.useOrder);
        this.checkEnabled();
    }

    @Override
    public void saveData() {
        Activity act = this.getActivity();
        if (act != null) {
            act.description = this.descText.getText();
            act.includeInReports = this.bIncludeInReportsChk.isSelected();
            act.reportActions = this.bRegisterActionsChk.isSelected();
            act.code = this.codeText.getText();
            act.skinFileName = (String)this.skinCombo.getSelectedItem();
            act.eventSounds = this.evSoundsBtn.getEventSounds();
            this.evSoundsBtn.setModified(false);
            act.bTimeCounter = this.timeCounterChk.isSelected();
            act.maxTime = this.maxTimeInt.getValue();
            act.countDownTime = this.countdownTimeChk.isSelected();
            act.bActionsCounter = this.actionsCounterChk.isSelected();
            act.maxActions = this.maxActionsInt.getValue();
            act.countDownActions = this.countdownActionsChk.isSelected();
            act.bScoreCounter = this.scoreCounterChk.isSelected();
            act.helpWindow = this.helpBtnChk.isSelected();
            act.showSolution = this.helpBtnSolution.isSelected();
            act.helpMsg = StrUtils.nullableString(this.helpBtnMsgText.getText());
            boolean v = false;
            if (this.infoBtnChk.isSelected()) {
                if (this.infoBtnUrlChk.isSelected()) {
                    act.infoUrl = StrUtils.nullableString(this.infoBtnUrlTxt.getText());
                    act.infoCmd = null;
                } else {
                    act.infoUrl = null;
                    act.infoCmd = StrUtils.nullableString(this.infoBtnCmdTxt.getText());
                }
            } else {
                act.infoUrl = null;
                act.infoCmd = null;
            }
            if (act.hasRandom()) {
                act.shuffles = this.scrambleTimesInt.getValue();
            }
            act.dragCells = this.dragCellsChk.isSelected();
            act.useOrder = this.orderChk.isSelected();
        }
    }

    @Override
    public boolean eventPerformed(EventObject ev) {
        AutoContentProviderEditor acped;
        Object cmp = ev == null ? null : ev.getSource();
        boolean result = cmp != null;
        final ActivityEditor aed = this.getActivityEditor();
        if (cmp == this.chClassBtn && aed != null) {
            if (sac == null) {
                sac = new SelectActivityClass(this.options);
                sac.setAlertMsg(this.options.getMsg("edit_act_changeType_warning"));
            }
            String oldClassName = this.getActivity().getShortClassName();
            sac.setCurrentClassName(oldClassName);
            sac.setListFilter(this.getActivity().getSimilarActivityClasses(), true);
            result = this.getOptions().getMessages().showInputDlg(this, sac, "edit_act_changeType") && sac.getCurrentClassName() != null && !oldClassName.equals(sac.getCurrentClassName());
            if (result) {
                ActivityBagElementEditor abed = aed.getActivityBagElementEditor();
                aed.collectData();
                aed.saveData();
                try {
                    abed.changeActivityClass(sac.getCurrentClassName());
                    abed.reselect();
                }
                catch (Exception ex) {
                    this.options.getMessages().showErrorWarning(this, "ERROR", ex);
                }
            }
        } else if (cmp == this.chNameBtn && aed != null) {
            String oldName = this.getActivity().name;
            final String newName = this.options.getMessages().showInputDlg((Component)this, "edit_media_rename", "edit_media_rename_prompt", oldName, "edit_media_rename_title", false);
            result = newName != null && !newName.equals(oldName);
            if (result) {
                final ProgressDialog progressDialog = new ProgressDialog(this, this.options);
                SwingWorker sw = new SwingWorker(){

                    @Override
                    public Object construct() {
                        aed.rename(newName, ActivityEditorOptionsPanel.this, ActivityEditorOptionsPanel.this.options.getMessages());
                        aed.getActivityBagElementEditor().reselect();
                        return null;
                    }

                    @Override
                    public void finished() {
                        progressDialog.setVisible(false);
                    }
                };
                progressDialog.start("edit_media_rename", "edit_media_renaming", sw, false, false, false);
            }
        } else if (cmp == this.autoCpCombo && aed != null) {
            String acpClassName;
            AutoContentProviderEditor acped2 = aed.getAutoContentProviderEditor();
            TripleString ts = (TripleString)this.autoCpCombo.getSelectedItem();
            String string = acpClassName = ts == null ? null : ts.getClassName();
            if (acped2 != null) {
                if (acped2.getAutoContentProvider().getShortClassName().equals(acpClassName)) {
                    return false;
                }
                acped2.removeFromParent();
                aed.getActivity().acp = null;
            }
            if (acpClassName != null) {
                try {
                    AutoContentProvider acp;
                    aed.getActivity().acp = acp = AutoContentProvider.getAutoContentProvider(acpClassName);
                    acp.getEditor(aed);
                }
                catch (Exception ex) {
                    this.options.getMessages().showErrorWarning(this, "edit_acp_err_creating", ex);
                    aed.getActivity().acp = null;
                }
            }
        } else if (cmp == this.autoCpEditBtn && aed != null && (acped = (AutoContentProviderEditor)aed.getFirstChild(AutoContentProviderEditor.class)) != null) {
            acped.editData(this, this.options);
        }
        if (result) {
            this.checkEnabled();
        }
        return result;
    }

    @Override
    protected Icon getIcon() {
        return ResourceManager.getImageIcon("icons/options.gif");
    }

    @Override
    protected String getTitle() {
        return this.options.getMsg("edit_act_panels_options");
    }

    @Override
    protected String getTooltip() {
        return this.options.getMsg("edit_act_panels_options_tooltip");
    }
}

