/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic;

import edu.xtec.jclic.Activity;
import edu.xtec.jclic.ActivityEditor;
import edu.xtec.jclic.activities.text.TextActivityBase;
import edu.xtec.jclic.activities.text.TextActivityDocument;
import edu.xtec.jclic.bags.ActivityBagEditor;
import edu.xtec.jclic.bags.ActivityBagElementEditor;
import edu.xtec.jclic.beans.CheckBoxTree;
import edu.xtec.jclic.beans.CheckBoxTreeObject;
import edu.xtec.util.Options;
import edu.xtec.util.ProgressDialog;
import edu.xtec.util.SwingWorker;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.text.StyleContext;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;

public class CopyActivityAttributesPanel
extends JPanel {
    Options options;
    ActivityBagElementEditor abed;
    ActivityBagEditor abe;
    private CheckBoxTreeObject bgColor;
    private CheckBoxTreeObject bgGradient;
    private CheckBoxTreeObject bgImage;
    private CheckBoxTreeObject activityBgColor;
    private CheckBoxTreeObject activityBgGradient;
    private CheckBoxTreeObject transparentBg;
    private CheckBoxTreeObject border;
    private CheckBoxTreeObject position;
    private CheckBoxTreeObject margin;
    private CheckBoxTreeObject msgPrev;
    private CheckBoxTreeObject msgIni;
    private CheckBoxTreeObject msgEnd;
    private CheckBoxTreeObject msgErr;
    private CheckBoxTreeObject repInclude;
    private CheckBoxTreeObject repActions;
    private CheckBoxTreeObject skin;
    private CheckBoxTreeObject evSounds;
    private CheckBoxTreeObject cTime;
    private CheckBoxTreeObject maxTime;
    private CheckBoxTreeObject cTries;
    private CheckBoxTreeObject maxTries;
    private CheckBoxTreeObject cScore;
    private CheckBoxTreeObject scramble;
    private CheckBoxTreeObject helpBtn;
    private CheckBoxTreeObject infoBtn;
    private CheckBoxTreeObject gridA;
    private CheckBoxTreeObject gridB;
    private CheckBoxTreeObject textGrid;
    private CheckBoxTreeObject textFontFace;
    private CheckBoxTreeObject textFontSize;
    private CheckBoxTreeObject textStyle;
    private CheckBoxTreeObject textColour;
    private CheckBoxTreeObject targetColour;
    private CheckBoxTreeObject errorColour;
    private CheckBoxTreeObject tabSpace;
    private JList<Object> actList;
    private CheckBoxTree checkBoxTree;
    private JButton selectAllBtn;
    private JButton selectNoneBtn;

    public CopyActivityAttributesPanel(Options options, ActivityBagElementEditor abed) {
        this.options = options;
        this.abed = abed;
        this.abe = (ActivityBagEditor)abed.getEditorParent();
        this.initComponents();
    }

    private void initComponents() {
        JScrollPane scroll = new JScrollPane();
        this.checkBoxTree = new CheckBoxTree();
        JPanel actPanel = new JPanel();
        JScrollPane actScroll = new JScrollPane();
        this.actList = new JList();
        this.selectAllBtn = new JButton();
        this.selectNoneBtn = new JButton();
        this.setLayout(new BorderLayout());
        scroll.setPreferredSize(new Dimension(300, 300));
        this.checkBoxTree.setModel(this.getTreeModel());
        int k = this.checkBoxTree.getRowCount();
        for (int i = k + 1; i >= 0; --i) {
            this.checkBoxTree.expandRow(i);
        }
        scroll.setViewportView(this.checkBoxTree);
        this.add((Component)scroll, "Center");
        actPanel.setBorder(BorderFactory.createTitledBorder(this.options.getMsg("edit_act_copy_dest")));
        actPanel.setLayout(new GridBagLayout());
        actScroll.setPreferredSize(new Dimension(200, 300));
        this.actList.setModel(this.abe.getListModel());
        actScroll.setViewportView(this.actList);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        actPanel.add((Component)actScroll, gridBagConstraints);
        this.selectAllBtn.setText(this.options.getMsg("SELECT_ALL"));
        this.selectAllBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CopyActivityAttributesPanel.this.selectAllBtnActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        actPanel.add((Component)this.selectAllBtn, gridBagConstraints);
        this.selectNoneBtn.setText(this.options.getMsg("SELECT_NONE"));
        this.selectNoneBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CopyActivityAttributesPanel.this.selectNoneBtnActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        actPanel.add((Component)this.selectNoneBtn, gridBagConstraints);
        this.add((Component)actPanel, "East");
    }

    private void selectNoneBtnActionPerformed(ActionEvent evt) {
        this.actList.clearSelection();
    }

    private void selectAllBtnActionPerformed(ActionEvent evt) {
        this.actList.setSelectionInterval(0, this.actList.getModel().getSize() - 1);
    }

    public boolean showDialog(Component parent) {
        boolean result = false;
        if (this.options.getMessages().showInputDlg(parent, this, "edit_act_copy_title")) {
            final Object[] selectedItems = this.actList.getSelectedValues();
            if (selectedItems == null || selectedItems.length == 0) {
                this.options.getMessages().showAlert((Component)this, "edit_act_copy_err_noSelection");
            } else {
                ActivityEditor srcActEd = this.abed.getActivityEditor();
                srcActEd.collectData();
                final Activity srcAct = srcActEd.getActivity();
                final ProgressDialog pd = new ProgressDialog(this, this.options);
                SwingWorker sw = new SwingWorker(){

                    @Override
                    public Object construct() {
                        int modifiedItems = 0;
                        for (int i = 0; i < selectedItems.length; ++i) {
                            ActivityBagElementEditor targetEd = (ActivityBagElementEditor)selectedItems[i];
                            if (targetEd != CopyActivityAttributesPanel.this.abed) {
                                ActivityEditor targetActEd = targetEd.getActivityEditor();
                                Activity targetAct = targetActEd.getActivity();
                                pd.setFileLabel(targetAct.name);
                                CopyActivityAttributesPanel.this.copyAttributes(srcAct, targetAct);
                                pd.setProgressValue(modifiedItems++);
                                targetActEd.setModified(true);
                                targetEd.forgetActivityEditor();
                            }
                            if (this.isCancelled() || Thread.currentThread().isInterrupted()) break;
                        }
                        return new Integer(modifiedItems);
                    }

                    @Override
                    public void finished() {
                        pd.setVisible(false);
                    }
                };
                pd.setProgressMax(selectedItems.length);
                pd.start("WORKING", "edit_act_copy_action_prefix", sw, true, true, false);
            }
        }
        return result;
    }

    private TreeModel getTreeModel() {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(this.options.getMsg("edit_act_copy_attributes"));
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(this.options.getMsg("edit_act_copy_style_main"));
        this.bgColor = new CheckBoxTreeObject(this.options.getMsg("edit_act_copy_bgColor"), true);
        node.add(this.bgColor);
        this.bgGradient = new CheckBoxTreeObject(this.options.getMsg("edit_act_copy_gradient"), true);
        node.add(this.bgGradient);
        this.bgImage = new CheckBoxTreeObject(this.options.getMsg("edit_act_copy_bgImage"), true);
        node.add(this.bgImage);
        root.add(node);
        node = new DefaultMutableTreeNode(this.options.getMsg("edit_act_copy_style_play"));
        this.activityBgColor = new CheckBoxTreeObject(this.options.getMsg("edit_act_copy_bgColor"), true);
        node.add(this.activityBgColor);
        this.activityBgGradient = new CheckBoxTreeObject(this.options.getMsg("edit_act_copy_gradient"), true);
        node.add(this.activityBgGradient);
        this.transparentBg = new CheckBoxTreeObject(this.options.getMsg("edit_act_copy_transparentBg"), true);
        node.add(this.transparentBg);
        this.border = new CheckBoxTreeObject(this.options.getMsg("edit_act_copy_border"), true);
        node.add(this.border);
        this.margin = new CheckBoxTreeObject(this.options.getMsg("edit_act_copy_margin"), true);
        node.add(this.margin);
        this.position = new CheckBoxTreeObject(this.options.getMsg("edit_act_copy_position"), false);
        node.add(this.position);
        root.add(node);
        node = new DefaultMutableTreeNode(this.options.getMsg("edit_act_copy_messages"));
        this.msgPrev = new CheckBoxTreeObject(this.options.getMsg("edit_act_copy_messages_prev"), true);
        node.add(this.msgPrev);
        this.msgIni = new CheckBoxTreeObject(this.options.getMsg("edit_act_copy_messages_ini"), true);
        node.add(this.msgIni);
        this.msgEnd = new CheckBoxTreeObject(this.options.getMsg("edit_act_copy_messages_end"), true);
        node.add(this.msgEnd);
        this.msgErr = new CheckBoxTreeObject(this.options.getMsg("edit_act_copy_messages_err"), true);
        node.add(this.msgErr);
        root.add(node);
        node = new DefaultMutableTreeNode(this.options.getMsg("edit_act_copy_reports"));
        this.repInclude = new CheckBoxTreeObject(this.options.getMsg("edit_act_copy_rep_include"), false);
        node.add(this.repInclude);
        this.repActions = new CheckBoxTreeObject(this.options.getMsg("edit_act_copy_rep_actions"), false);
        node.add(this.repActions);
        root.add(node);
        node = new DefaultMutableTreeNode(this.options.getMsg("edit_act_copy_interface"));
        this.skin = new CheckBoxTreeObject(this.options.getMsg("edit_act_copy_skin"), false);
        node.add(this.skin);
        this.evSounds = new CheckBoxTreeObject(this.options.getMsg("edit_act_copy_evSounds"), false);
        node.add(this.evSounds);
        root.add(node);
        node = new DefaultMutableTreeNode(this.options.getMsg("edit_act_copy_counters"));
        this.cTime = new CheckBoxTreeObject(this.options.getMsg("edit_act_copy_cTime"), true);
        node.add(this.cTime);
        this.maxTime = new CheckBoxTreeObject(this.options.getMsg("edit_act_copy_maxTime"), false);
        node.add(this.maxTime);
        this.cTries = new CheckBoxTreeObject(this.options.getMsg("edit_act_copy_cTries"), true);
        node.add(this.cTries);
        this.maxTries = new CheckBoxTreeObject(this.options.getMsg("edit_act_copy_maxTries"), false);
        node.add(this.maxTries);
        this.cScore = new CheckBoxTreeObject(this.options.getMsg("edit_act_copy_cScore"), true);
        node.add(this.cScore);
        this.scramble = new CheckBoxTreeObject(this.options.getMsg("edit_act_copy_scramble"), false);
        node.add(this.scramble);
        root.add(node);
        node = new DefaultMutableTreeNode(this.options.getMsg("edit_act_copy_buttons"));
        this.helpBtn = new CheckBoxTreeObject(this.options.getMsg("edit_act_copy_btnHelp"), false);
        node.add(this.helpBtn);
        this.infoBtn = new CheckBoxTreeObject(this.options.getMsg("edit_act_copy_btnInfo"), false);
        node.add(this.infoBtn);
        root.add(node);
        node = new DefaultMutableTreeNode(this.options.getMsg("edit_act_copy_grids"));
        this.gridA = new CheckBoxTreeObject(this.options.getMsg("edit_act_copy_gridA"), true);
        node.add(this.gridA);
        this.gridB = new CheckBoxTreeObject(this.options.getMsg("edit_act_copy_gridB"), true);
        node.add(this.gridB);
        this.textGrid = new CheckBoxTreeObject(this.options.getMsg("edit_act_copy_textGrid"), true);
        node.add(this.textGrid);
        root.add(node);
        node = new DefaultMutableTreeNode(this.options.getMsg("edit_act_copy_text"));
        this.textFontFace = new CheckBoxTreeObject(this.options.getMsg("edit_act_copy_fontFace"), true);
        node.add(this.textFontFace);
        this.textFontSize = new CheckBoxTreeObject(this.options.getMsg("edit_act_copy_fontSize"), true);
        node.add(this.textFontSize);
        this.textStyle = new CheckBoxTreeObject(this.options.getMsg("edit_act_copy_fontStyle"), true);
        node.add(this.textStyle);
        this.textColour = new CheckBoxTreeObject(this.options.getMsg("edit_act_copy_textColour"), true);
        node.add(this.textColour);
        this.targetColour = new CheckBoxTreeObject(this.options.getMsg("edit_act_copy_textTargetColour"), true);
        node.add(this.targetColour);
        this.errorColour = new CheckBoxTreeObject(this.options.getMsg("edit_act_copy_textErrorColour"), true);
        node.add(this.errorColour);
        this.tabSpace = new CheckBoxTreeObject(this.options.getMsg("edit_act_copy_tabSpace"), false);
        node.add(this.tabSpace);
        root.add(node);
        return new DefaultTreeModel(root);
    }

    private void copyAttributes(Activity srcAct, Activity targetAct) {
        if (this.bgColor.isSelected()) {
            targetAct.bgColor = srcAct.bgColor;
        }
        if (this.bgGradient.isSelected()) {
            targetAct.bgGradient = srcAct.bgGradient;
        }
        if (this.bgImage.isSelected()) {
            targetAct.bgImageFile = srcAct.bgImageFile;
            targetAct.tiledBgImg = srcAct.tiledBgImg;
        }
        if (this.margin.isSelected()) {
            targetAct.margin = srcAct.margin;
        }
        if (this.activityBgColor.isSelected()) {
            targetAct.activityBgColor = srcAct.activityBgColor;
        }
        if (this.activityBgGradient.isSelected()) {
            targetAct.activityBgGradient = srcAct.activityBgGradient;
        }
        if (this.transparentBg.isSelected()) {
            targetAct.transparentBg = srcAct.transparentBg;
        }
        if (this.border.isSelected()) {
            targetAct.border = srcAct.border;
        }
        if (this.position.isSelected()) {
            targetAct.absolutePositioned = srcAct.absolutePositioned;
            targetAct.absolutePosition = srcAct.absolutePosition;
        }
        if (this.msgPrev.isSelected() && srcAct.messages[0] != null && targetAct.messages[0] != null) {
            srcAct.messages[0].copyStyleTo(targetAct.messages[0]);
        }
        if (this.msgIni.isSelected() && srcAct.messages[1] != null && targetAct.messages[1] != null) {
            srcAct.messages[1].copyStyleTo(targetAct.messages[1]);
        }
        if (this.msgEnd.isSelected() && srcAct.messages[2] != null && targetAct.messages[2] != null) {
            srcAct.messages[2].copyStyleTo(targetAct.messages[2]);
        }
        if (this.msgErr.isSelected() && srcAct.messages[3] != null && targetAct.messages[3] != null) {
            srcAct.messages[3].copyStyleTo(targetAct.messages[3]);
        }
        if (this.repInclude.isSelected()) {
            targetAct.includeInReports = srcAct.includeInReports;
        }
        if (this.repActions.isSelected()) {
            targetAct.reportActions = srcAct.reportActions;
        }
        if (this.skin.isSelected()) {
            targetAct.skinFileName = srcAct.skinFileName;
        }
        if (this.evSounds.isSelected()) {
            targetAct.eventSounds = srcAct.eventSounds;
        }
        if (this.cTime.isSelected()) {
            targetAct.bTimeCounter = srcAct.bTimeCounter;
        }
        if (this.maxTime.isSelected()) {
            targetAct.maxTime = srcAct.maxTime;
            targetAct.countDownTime = srcAct.countDownTime;
        }
        if (this.cTries.isSelected()) {
            targetAct.bActionsCounter = srcAct.bActionsCounter;
        }
        if (this.maxTries.isSelected()) {
            targetAct.maxActions = srcAct.maxActions;
            targetAct.countDownActions = srcAct.countDownActions;
        }
        if (this.cScore.isSelected()) {
            targetAct.bScoreCounter = srcAct.bScoreCounter;
        }
        if (this.scramble.isSelected()) {
            targetAct.shuffles = srcAct.shuffles;
        }
        if (this.helpBtn.isSelected()) {
            targetAct.helpWindow = srcAct.helpWindow;
            targetAct.showSolution = srcAct.showSolution;
        }
        if (this.infoBtn.isSelected()) {
            targetAct.infoUrl = srcAct.infoUrl;
            targetAct.infoCmd = srcAct.infoCmd;
        }
        if (this.gridA.isSelected() && srcAct.abc != null && srcAct.abc.length > 0 && srcAct.abc[0] != null && targetAct.abc != null && targetAct.abc.length > 0 && targetAct.abc[0] != null) {
            srcAct.abc[0].copyStyleTo(targetAct.abc[0]);
        }
        if (this.gridB.isSelected() && srcAct.abc != null && srcAct.abc.length > 1 && srcAct.abc[1] != null && targetAct.abc != null && targetAct.abc.length > 1 && targetAct.abc[1] != null) {
            srcAct.abc[1].copyStyleTo(targetAct.abc[1]);
        }
        if (this.textGrid.isSelected() && srcAct.tgc != null && targetAct.tgc != null) {
            srcAct.tgc.copyStyleTo(targetAct.tgc);
        }
        if (srcAct instanceof TextActivityBase && targetAct instanceof TextActivityBase) {
            TextActivityBase txSrcAct = (TextActivityBase)srcAct;
            TextActivityBase txTargetAct = (TextActivityBase)targetAct;
            if (this.textFontFace.isSelected() || this.textFontSize.isSelected() || this.textStyle.isSelected() || this.textColour.isSelected() || this.targetColour.isSelected() || this.errorColour.isSelected() || this.tabSpace.isSelected()) {
                StyleContext sc = TextActivityDocument.copyStylesFrom(txSrcAct.getStyleContext(), txTargetAct.getStyleContext(), this.textFontFace.isSelected(), this.textFontSize.isSelected(), this.textStyle.isSelected(), this.textColour.isSelected(), this.targetColour.isSelected(), this.errorColour.isSelected());
                if (sc != null) {
                    txTargetAct.setStyleContext(sc);
                }
                if (this.tabSpace.isSelected()) {
                    txTargetAct.getDocument().setTabSpc(txSrcAct.getDocument().getTabSpc());
                }
            }
        }
    }
}

