/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.automation.arith;

import edu.xtec.jclic.automation.arith.Operator;
import edu.xtec.jclic.beans.TextListEditor;
import edu.xtec.util.CtrlPanel;
import edu.xtec.util.Options;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.EventObject;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class OperatorEditorPanel
extends CtrlPanel {
    protected static final Integer[] LIST_OF_VALUES = new Integer[Operator.LIMITS.length];
    Options options;
    private ButtonGroup decGrp;
    private JComboBox<Object> fromCombo;
    private JCheckBox fromListChk;
    private JTextField listTxt;
    private JRadioButton opDec0;
    private JRadioButton opDec1;
    private JRadioButton opDec2;
    private JPanel opPanel;
    private JPanel rangePanel;
    private JComboBox<Object> toCombo;
    private JCheckBox withMinusOneChk;
    private JCheckBox withOneChk;
    private JCheckBox withZeroChk;

    public OperatorEditorPanel(Options options) {
        this.options = options;
        this.initComponents();
    }

    private void initComponents() {
        this.decGrp = new ButtonGroup();
        this.rangePanel = new JPanel();
        JLabel fromLb = new JLabel();
        this.fromCombo = new JComboBox<Integer>(LIST_OF_VALUES);
        JLabel toLb = new JLabel();
        this.toCombo = new JComboBox<Integer>(LIST_OF_VALUES);
        JLabel withLb = new JLabel();
        this.opPanel = new JPanel();
        this.withZeroChk = new JCheckBox();
        this.withOneChk = new JCheckBox();
        this.withMinusOneChk = new JCheckBox();
        this.fromListChk = new JCheckBox();
        this.listTxt = new JTextField();
        JPanel decPanel = new JPanel();
        this.opDec0 = new JRadioButton();
        this.opDec1 = new JRadioButton();
        this.opDec2 = new JRadioButton();
        this.setLayout(new GridBagLayout());
        this.rangePanel.setLayout(new GridBagLayout());
        fromLb.setLabelFor(this.fromCombo);
        fromLb.setText(this.options.getMsg("edit_arith_op_from"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.rangePanel.add((Component)fromLb, gridBagConstraints);
        this.fromCombo.setToolTipText(this.options.getMsg("edit_arith_op_from_tooltip"));
        this.fromCombo.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.rangePanel.add(this.fromCombo, gridBagConstraints);
        toLb.setLabelFor(this.toCombo);
        toLb.setText(this.options.getMsg("edit_arith_op_to"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.rangePanel.add((Component)toLb, gridBagConstraints);
        this.toCombo.setToolTipText(this.options.getMsg("edit_arith_op_to_tooltip"));
        this.toCombo.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.rangePanel.add(this.toCombo, gridBagConstraints);
        withLb.setText(this.options.getMsg("edit_arith_op_with"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.rangePanel.add((Component)withLb, gridBagConstraints);
        this.withZeroChk.setText("0");
        this.withZeroChk.setToolTipText(this.options.getMsg("edit_arith_op_with_tooltip"));
        this.withZeroChk.addActionListener(this);
        this.opPanel.add(this.withZeroChk);
        this.withOneChk.setText("1");
        this.withOneChk.setToolTipText(this.options.getMsg("edit_arith_op_with_tooltip"));
        this.withOneChk.addActionListener(this);
        this.opPanel.add(this.withOneChk);
        this.withMinusOneChk.setText("-1");
        this.withMinusOneChk.setToolTipText(this.options.getMsg("edit_arith_op_with_tooltip"));
        this.withMinusOneChk.addActionListener(this);
        this.opPanel.add(this.withMinusOneChk);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        this.rangePanel.add((Component)this.opPanel, gridBagConstraints);
        this.fromListChk.setText(this.options.getMsg("edit_arith_op_fromList"));
        this.fromListChk.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.rangePanel.add((Component)this.fromListChk, gridBagConstraints);
        this.listTxt.getDocument().addDocumentListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.rangePanel.add((Component)this.listTxt, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.rangePanel, gridBagConstraints);
        decPanel.setBorder(BorderFactory.createTitledBorder(this.options.getMsg("edit_arith_op_decimals")));
        decPanel.setLayout(new GridBagLayout());
        this.decGrp.add(this.opDec0);
        this.opDec0.setText(this.options.getMsg("edit_arith_op_dec0"));
        this.opDec0.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        decPanel.add((Component)this.opDec0, gridBagConstraints);
        this.decGrp.add(this.opDec1);
        this.opDec1.setText(this.options.getMsg("edit_arith_op_dec1"));
        this.opDec1.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        decPanel.add((Component)this.opDec1, gridBagConstraints);
        this.decGrp.add(this.opDec2);
        this.opDec2.setText(this.options.getMsg("edit_arith_op_dec2"));
        this.opDec2.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        decPanel.add((Component)this.opDec2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        this.add((Component)decPanel, gridBagConstraints);
    }

    private TextListEditor buildNumList() {
        TextListEditor tle = new TextListEditor(){

            @Override
            protected Object editItem(Object currentValue, boolean newValue) {
                Object result = super.editItem(currentValue, newValue);
                if (result != null) {
                    boolean ok = false;
                    try {
                        int v = Integer.parseInt(result.toString());
                        ok = Math.abs(v) < 100000000;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    if (!ok) {
                        OperatorEditorPanel.this.options.getMessages().showAlert((Component)this, "BAD_NUMBER");
                        result = null;
                    }
                }
                return result;
            }
        };
        tle.setOptions(this.options);
        tle.setMaxItems(20);
        return tle;
    }

    public void setOperator(Operator op) {
        this.setInitializing(true);
        this.fromCombo.setSelectedIndex(op.limInf);
        this.toCombo.setSelectedIndex(op.limSup);
        this.withZeroChk.setSelected(op.wZero);
        this.withOneChk.setSelected(op.wOne);
        this.withMinusOneChk.setSelected(op.wMinusOne);
        if (op.numDec == 1) {
            this.opDec1.setSelected(true);
        } else if (op.numDec == 2) {
            this.opDec2.setSelected(true);
        } else {
            this.opDec0.setSelected(true);
        }
        this.fromListChk.setSelected(op.fromList > 0);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < op.fromList; ++i) {
            sb.append(op.lst[i]).append(" ");
        }
        this.listTxt.setText(sb.substring(0).trim());
        this.checkEnabled();
        this.setInitializing(false);
        this.setModified(false);
    }

    public Operator getOperator() {
        Operator op = new Operator();
        op.limInf = this.fromCombo.getSelectedIndex();
        op.limSup = this.toCombo.getSelectedIndex();
        op.wZero = this.withZeroChk.isSelected();
        op.wOne = this.withOneChk.isSelected();
        op.wMinusOne = this.withMinusOneChk.isSelected();
        op.numDec = this.opDec1.isSelected() ? 1 : (this.opDec2.isSelected() ? 2 : 0);
        op.fromList = 0;
        if (this.fromListChk.isSelected()) {
            StringTokenizer st = new StringTokenizer(this.listTxt.getText());
            String str = "";
            boolean alerted = false;
            while (st.hasMoreTokens() && op.fromList < 20) {
                try {
                    op.lst[op.fromList] = Integer.parseInt(st.nextToken());
                    ++op.fromList;
                }
                catch (NumberFormatException ex) {
                    if (alerted) continue;
                    this.options.getMessages().showAlert((Component)this, "BAD_NUMBER");
                    alerted = true;
                }
            }
        }
        return op;
    }

    protected void checkEnabled() {
        boolean fromList = this.fromListChk.isSelected();
        this.listTxt.setEnabled(fromList);
        this.fromCombo.setEnabled(!fromList);
        this.toCombo.setEnabled(!fromList);
        this.withZeroChk.setEnabled(!fromList);
        this.withOneChk.setEnabled(!fromList);
        this.withMinusOneChk.setEnabled(!fromList);
    }

    @Override
    public boolean eventPerformed(EventObject ev) {
        this.checkEnabled();
        return ev != null;
    }

    static {
        for (int i = 0; i < Operator.LIMITS.length; ++i) {
            OperatorEditorPanel.LIST_OF_VALUES[i] = new Integer(Operator.LIMITS[i]);
        }
    }
}

