/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.bags;

import edu.xtec.jclic.bags.ActivityBag;
import edu.xtec.jclic.bags.ActivityBagEditor;
import edu.xtec.jclic.bags.ActivityBagElementEditor;
import edu.xtec.jclic.edit.Editor;
import edu.xtec.jclic.edit.EditorPanel;
import edu.xtec.util.Options;
import edu.xtec.util.SmallButton;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.FocusEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ActivityBagEditorPanel
extends EditorPanel
implements ListSelectionListener {
    boolean modified;
    public ActivityBagElementEditor currentItem;
    protected Map<Class, EditorPanel> editPanels = new HashMap<Class, EditorPanel>();
    protected EditorPanel currentPanel;
    private JPanel edit;
    private JList<Object> list;

    public ActivityBagEditorPanel(Options options) {
        super(options);
        ActivityBagEditor.createActions(options);
        ActivityBagElementEditor.createActions(options);
        this.initComponents();
        this.postInit(250, false, true);
        this.list.getSelectionModel().addListSelectionListener(this);
        this.setEnabled(false);
    }

    private void initComponents() {
        JSplitPane split = new JSplitPane();
        JScrollPane scroll = new JScrollPane();
        scroll.getVerticalScrollBar().setUnitIncrement(16);
        this.list = new JList();
        this.edit = new JPanel();
        this.setLayout(new BorderLayout());
        this.list.setSelectionMode(0);
        scroll.setViewportView(this.list);
        split.setLeftComponent(scroll);
        this.edit.setPreferredSize(new Dimension(700, 600));
        this.edit.setLayout(new BorderLayout());
        split.setRightComponent(this.edit);
        this.add((Component)split, "Center");
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.list.setEnabled(enabled);
        if (this.currentPanel != null) {
            this.currentPanel.setEnabled(enabled);
        }
    }

    @Override
    public boolean checkIfEditorValid(Editor e) {
        return e instanceof ActivityBagEditor;
    }

    protected ActivityBag getActivityBag() {
        if (this.editor == null) {
            return null;
        }
        return ((ActivityBagEditor)this.editor).getActivityBag();
    }

    @Override
    public void fillData() {
        ActivityBagEditor abe = this.getActivityBagEditor();
        this.list.setModel(abe == null ? new DefaultListModel() : abe.getListModel());
        if (abe != null) {
            abe.setListSelectionModel(this.list.getSelectionModel());
        } else if (this.currentPanel != null) {
            this.currentPanel.removeEditor(true);
            this.edit.remove(this.currentPanel);
            this.currentPanel = null;
        }
    }

    @Override
    public void saveData() {
        ActivityBag ab = this.getActivityBag();
    }

    @Override
    protected Icon getIcon() {
        return ActivityBagEditor.getIcon();
    }

    @Override
    protected String getTitle() {
        return "Activity bag";
    }

    ActivityBagEditor getActivityBagEditor() {
        return (ActivityBagEditor)this.getEditor();
    }

    protected void currentItemChanged() {
        if (this.edit != null) {
            if (this.currentPanel != null) {
                this.currentPanel.removeEditor(true);
            }
            if (this.currentItem != null) {
                Class pc = this.currentItem.getEditorPanelClass();
                EditorPanel ep = this.editPanels.get(pc);
                if (ep == null) {
                    ep = this.currentItem.createEditorPanel(this.options);
                    this.editPanels.put(pc, ep);
                }
                ep.attachEditor(this.currentItem.getActivityEditor(), true);
                if (this.currentPanel != ep) {
                    if (this.currentPanel != null) {
                        this.edit.remove(this.currentPanel);
                    }
                    this.edit.add((Component)ep, "Center");
                    this.edit.revalidate();
                    this.edit.repaint();
                }
                this.currentPanel = ep;
            }
        }
    }

    public boolean editActivity(String activityName) {
        boolean result = false;
        if (activityName != null && activityName.length() > 0) {
            ListModel<Object> model = this.list.getModel();
            int size = model.getSize();
            for (int i = 0; i < model.getSize(); ++i) {
                Object o = model.getElementAt(i);
                if (o == null || !activityName.equals(o.toString())) continue;
                this.list.setSelectedIndex(i);
                this.list.ensureIndexIsVisible(i);
                result = true;
                break;
            }
        }
        return result;
    }

    @Override
    public void valueChanged(ListSelectionEvent ev) {
        if (ev != null && ev.getValueIsAdjusting()) {
            return;
        }
        ActivityBagEditor abe = this.getActivityBagEditor();
        if (abe != null && this.currentItem != null && this.currentItem.getActivityEditor() != null) {
            this.currentItem.getActivityEditor().collectData();
            this.currentItem.forgetActivityEditor();
        }
        this.currentItem = null;
        int row = this.list.getSelectedIndex();
        if (abe != null && row >= 0 && row < abe.getChildCount()) {
            this.currentItem = (ActivityBagElementEditor)abe.getChildAt(row);
        }
        this.currentItemChanged();
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (this.currentPanel != null) {
            this.currentPanel.focusGained(focusEvent);
        } else {
            Editor.clearBasicActionsOwner();
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        if (this.currentPanel != null) {
            this.currentPanel.focusLost(focusEvent);
        }
    }

    @Override
    protected void addActionsTo(Container cnt) {
        cnt.add(new SmallButton(ActivityBagEditor.newActivityBagElementAction));
        cnt.add(new SmallButton(ActivityBagElementEditor.testActivityAction));
        cnt.add(new SmallButton(Editor.moveUpAction));
        cnt.add(new SmallButton(Editor.moveDownAction));
        cnt.add(new SmallButton(Editor.copyAction));
        cnt.add(new SmallButton(Editor.cutAction));
        cnt.add(new SmallButton(Editor.pasteAction));
        cnt.add(new SmallButton(Editor.deleteAction));
        cnt.add(new SmallButton(ActivityBagEditor.copyActivityAttributesAction));
    }
}

