/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.bags;

import edu.xtec.jclic.Activity;
import edu.xtec.jclic.ActivityEditor;
import edu.xtec.jclic.TestPlayerContainer;
import edu.xtec.jclic.bags.ActivityBagEditor;
import edu.xtec.jclic.bags.ActivityBagElement;
import edu.xtec.jclic.bags.ActivitySequenceEditor;
import edu.xtec.jclic.bags.ActivitySequenceElementEditor;
import edu.xtec.jclic.edit.Editor;
import edu.xtec.jclic.edit.EditorAction;
import edu.xtec.jclic.edit.EditorPanel;
import edu.xtec.jclic.project.JClicProject;
import edu.xtec.jclic.project.JClicProjectEditor;
import edu.xtec.util.Options;
import edu.xtec.util.ResourceManager;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class ActivityBagElementEditor
extends Editor {
    public static ImageIcon icon;
    public static EditorAction testActivityAction;
    public static boolean actionsCreated;

    public ActivityBagElementEditor(ActivityBagElement abe) {
        super(abe);
    }

    @Override
    protected void createChildren() {
    }

    @Override
    public EditorPanel createEditorPanel(Options options) {
        ActivityEditor ae = this.getActivityEditor();
        return ae == null ? null : ae.createEditorPanel(options);
    }

    @Override
    public Class getEditorPanelClass() {
        ActivityEditor ae = this.getActivityEditor();
        return ae == null ? null : ae.getEditorPanelClass();
    }

    public ActivityBagElement getActivityBagElement() {
        return (ActivityBagElement)this.getUserObject();
    }

    public ActivityEditor getActivityEditor() {
        ActivityEditor ae;
        ActivityEditor activityEditor = ae = this.getChildCount() > 0 ? (ActivityEditor)this.getFirstChild() : null;
        if (ae == null) {
            try {
                ActivityBagElement abel = this.getActivityBagElement();
                JClicProject prj = ((ActivityBagEditor)this.getEditorParent()).getActivityBag().getProject();
                Activity act = Activity.getActivity(abel.getData(), prj);
                ae = (ActivityEditor)act.getEditor(this);
            }
            catch (Exception ex) {
                System.err.println("Error loading activity!\n");
                ex.printStackTrace(System.err);
            }
        }
        return ae;
    }

    public void changeActivityClass(String newClassName) throws Exception {
        ((ActivityBagEditor)this.getEditorParent()).changeActivityClass(this, newClassName);
    }

    public void forgetActivityEditor() {
        if (this.getChildCount() > 0) {
            ActivityEditor ae = (ActivityEditor)this.getFirstChild();
            if (ae.isModified()) {
                ae.saveData();
            }
            this.removeAllChildren();
        }
    }

    public static Icon getIcon() {
        if (icon == null) {
            icon = ResourceManager.getImageIcon("icons/miniclic.png");
        }
        return icon;
    }

    @Override
    public Icon getIcon(boolean leaf, boolean expanded) {
        return ActivityBagElementEditor.getIcon();
    }

    @Override
    public String toString() {
        return this.getActivityBagElement().getName();
    }

    @Override
    public boolean canBeParentOf(Editor e) {
        return e instanceof ActivityEditor;
    }

    @Override
    public boolean canBeSiblingOf(Editor e) {
        return e instanceof ActivityBagElementEditor;
    }

    @Override
    protected boolean canClone() {
        return true;
    }

    @Override
    protected Editor getClone() throws Exception {
        ActivityBagElement abe = (ActivityBagElement)this.getActivityBagElement().clone();
        return abe.getEditor(null);
    }

    protected void setActionsFlag() {
        this.allowDelete = true;
        this.allowCut = true;
        this.allowCopy = true;
        this.allowPaste = true;
    }

    @Override
    protected boolean delete(boolean changeSelection) {
        ActivityEditor aed = this.getActivityEditor();
        String activityName = aed.getActivity().name;
        JClicProjectEditor projectEditor = aed.getProjectEditor();
        boolean result = super.delete(changeSelection);
        if (result) {
            projectEditor.getActivitySequenceEditor().removeElementsWith(activityName);
        }
        return result;
    }

    @Override
    public void setActionsOwner() {
        this.setActionsFlag();
        super.setActionsOwner();
        if (actionsCreated) {
            testActivityAction.setActionOwner(this);
            ActivityBagEditor.newActivityBagElementAction.setActionOwner(this);
            ActivityBagEditor.copyActivityAttributesAction.setActionOwner(this);
        }
    }

    @Override
    public void clearActionsOwner() {
        super.clearActionsOwner();
        testActivityAction.setActionOwner(null);
        ActivityBagEditor.newActivityBagElementAction.setActionOwner(this.getEditorParent());
        ActivityBagEditor.copyActivityAttributesAction.setActionOwner(null);
    }

    public void testActivity() {
        TestPlayerContainer tpc;
        ActivityEditor ae = this.getActivityEditor();
        ae.collectData();
        JClicProjectEditor pe = ae.getProjectEditor();
        if (pe != null && (tpc = pe.getTestPlayerContainer()) != null && tpc.getTestPlayer() != null) {
            String activityName = ae.getActivity().name;
            ActivitySequenceEditor ased = pe.getActivitySequenceEditor();
            if (ased.getActivitySequence().getElementByActivityName(activityName) == null) {
                ased.createNewSequenceElement(activityName, null, -1);
            }
            pe.collectData();
            pe.getProject().skin = null;
            pe.getProject().realize(null, tpc.getTestPlayer());
            tpc.getTestPlayer().load(null, null, activityName, null);
            tpc.test();
        }
    }

    public static void createActions(Options options) {
        ActivityBagElementEditor.createBasicActions(options);
        if (!actionsCreated) {
            testActivityAction = new EditorAction("edit_act_testAction", "icons/play.gif", "edit_act_testAction_tooltip", options){

                @Override
                protected void doAction(Editor e) {
                    if (e instanceof ActivityBagElementEditor) {
                        ((ActivityBagElementEditor)e).testActivity();
                    } else if (e instanceof ActivitySequenceElementEditor) {
                        ((ActivitySequenceElementEditor)e).testActivity();
                    }
                }
            };
            actionsCreated = true;
        }
    }

    public boolean nameChanged(int type, String oldName, String newName) {
        boolean result = false;
        boolean hasChild = this.getChildCount() > 0;
        ActivityEditor ae = this.getActivityEditor();
        if (ae != null) {
            result = ae.nameChanged(type, oldName, newName);
        }
        if (!hasChild) {
            this.forgetActivityEditor();
        }
        return result;
    }
}

