/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.bags;

import edu.xtec.jclic.bags.ActivitySequence;
import edu.xtec.jclic.bags.ActivitySequenceEditorPanel;
import edu.xtec.jclic.bags.ActivitySequenceElement;
import edu.xtec.jclic.bags.ActivitySequenceElementEditor;
import edu.xtec.jclic.edit.Editor;
import edu.xtec.jclic.edit.EditorAction;
import edu.xtec.jclic.edit.EditorPanel;
import edu.xtec.jclic.fileSystem.FileSystem;
import edu.xtec.jclic.project.JClicProjectEditor;
import edu.xtec.util.ListComboModel;
import edu.xtec.util.Messages;
import edu.xtec.util.Options;
import edu.xtec.util.ResourceManager;
import edu.xtec.util.StrUtils;
import java.awt.Component;
import java.util.Enumeration;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

public class ActivitySequenceEditor
extends Editor {
    public static ImageIcon icon;
    protected DefaultListModel<Object> tagList;
    private boolean initializing;
    public static boolean actionsCreated;
    public static EditorAction newActivitySequenceElementAction;

    public ActivitySequenceEditor(ActivitySequence ac) {
        super(ac);
    }

    @Override
    protected void createChildren() {
        this.initializing = true;
        ActivitySequence as = this.getActivitySequence();
        int n = as.getSize();
        for (int i = 0; i < n; ++i) {
            as.getElement(i, false).getEditor(this);
        }
        this.initializing = false;
    }

    @Override
    public EditorPanel createEditorPanel(Options options) {
        return new ActivitySequenceEditorPanel(options);
    }

    @Override
    public Class getEditorPanelClass() {
        return ActivitySequenceEditorPanel.class;
    }

    @Override
    public String getTitleKey() {
        return "edit_sequences";
    }

    public ActivitySequence getActivitySequence() {
        return (ActivitySequence)this.getUserObject();
    }

    public static Icon getIcon() {
        if (icon == null) {
            icon = ResourceManager.getImageIcon("icons/sequence.gif");
        }
        return icon;
    }

    @Override
    public Icon getIcon(boolean leaf, boolean expanded) {
        return ActivitySequenceEditor.getIcon();
    }

    @Override
    public String toString() {
        return "Activity sequence";
    }

    public Options getOptions() {
        return this.getActivitySequence().getProject().getBridge().getOptions();
    }

    public JClicProjectEditor getProjectEditor() {
        return (JClicProjectEditor)this.getFirstParent(JClicProjectEditor.class);
    }

    public void removeElementsWith(String activityName) {
        String act = StrUtils.nullableString(activityName);
        if (act != null) {
            act = FileSystem.stdFn(act);
            int i = 0;
            int numElements = this.getChildCount();
            block0: while (i < numElements) {
                numElements = this.getChildCount();
                for (i = 0; i < numElements; ++i) {
                    ActivitySequenceElementEditor asee = (ActivitySequenceElementEditor)this.getChildAt(i);
                    if (!act.equals(asee.getActivitySequenceElement().getActivityName())) continue;
                    this.remove(i);
                    continue block0;
                }
            }
        }
    }

    public boolean createNewSequenceElement(int index, boolean prompt, Component dlgParent) {
        String act = null;
        String tag = null;
        Messages msg = this.getOptions().getMessages();
        if (prompt) {
            AbstractListModel<Object> lm = this.getProjectEditor().getActivityBagEditor().getListModel();
            if (lm.getSize() == 0) {
                msg.showAlert(dlgParent, "edit_seq_newElement_error_emptyList");
                return false;
            }
            JComboBox<Object> actCombo = new JComboBox<Object>(new ListComboModel(this.getProjectEditor().getActivityBagEditor().getListModel()));
            actCombo.setToolTipText(msg.get("edit_seq_activity_tooltip"));
            JTextField tagField = new JTextField();
            tagField.setToolTipText(msg.get("edit_seq_tag_tooltip"));
            JComponent[] prompt_objects = new JComponent[]{actCombo, tagField};
            String[] prompt_keys = new String[]{"edit_seq_activity", "edit_seq_tag"};
            String[] prompt_msg = new String[]{"edit_seq_newElement_msg"};
            if (!msg.showInputDlg(dlgParent, prompt_msg, prompt_keys, prompt_objects, "edit_seq_newElement")) {
                return false;
            }
            act = StrUtils.nullableString(actCombo.getSelectedItem());
            tag = StrUtils.nullableString(tagField.getText());
        }
        if (act == null) {
            msg.showAlert(dlgParent, "edit_seq_newElement_error_noAct");
            return false;
        }
        return this.createNewSequenceElement(act, tag, index);
    }

    public boolean createNewSequenceElement(String actName, String tag, int index) {
        ActivitySequenceElement ase = new ActivitySequenceElement(actName);
        if (tag != null) {
            ase.setTag(tag);
        }
        ActivitySequenceElementEditor aseed = (ActivitySequenceElementEditor)ase.getEditor(null);
        index = index < 0 ? this.getChildCount() : Math.min(index, this.getChildCount());
        return this.insertEditor(aseed, true, index, true);
    }

    public ListModel<Object> getTagList() {
        if (this.tagList == null) {
            this.tagList = new DefaultListModel();
            Enumeration<TreeNode> en = this.children();
            while (en.hasMoreElements()) {
                ActivitySequenceElementEditor asee = (ActivitySequenceElementEditor)en.nextElement();
                String tag = StrUtils.nullableString(asee.getActivitySequenceElement().getTag());
                if (tag == null) continue;
                this.tagList.addElement(tag);
            }
        }
        return this.tagList;
    }

    public String getTag(String tag) {
        String result = null;
        this.getTagList();
        Enumeration<Object> en = this.tagList.elements();
        while (en.hasMoreElements() && result == null) {
            String s = (String)en.nextElement();
            if (!s.equals(tag)) continue;
            result = s;
        }
        return result;
    }

    @Override
    public void insert(MutableTreeNode newChild, int childIndex) {
        super.insert(newChild, childIndex);
        if (!this.initializing) {
            String tag;
            ActivitySequenceElementEditor asee = (ActivitySequenceElementEditor)newChild;
            this.getActivitySequence().insertElementAt(asee.getActivitySequenceElement(), childIndex);
            if (this.tagList != null && (tag = asee.getTag()) != null && this.getTag(tag) == null) {
                this.tagList.addElement(tag);
            }
        }
    }

    @Override
    public void remove(int childIndex) {
        String s;
        ActivitySequenceElementEditor asee = (ActivitySequenceElementEditor)this.getChildAt(childIndex);
        super.remove(childIndex);
        this.getActivitySequence().remove(asee.getActivitySequenceElement());
        if (this.tagList != null && asee.getTag() != null && (s = this.getTag(asee.getTag())) != null) {
            this.tagList.removeElement(s);
        }
    }

    public boolean nameChanged(int type, String oldName, String newName) {
        boolean result = false;
        if ((type & 3) != 0) {
            Enumeration<TreeNode> en = this.children();
            while (en.hasMoreElements()) {
                result |= ((ActivitySequenceElementEditor)en.nextElement()).nameChanged(type, oldName, newName);
            }
        }
        return result;
    }

    @Override
    public void setActionsOwner() {
        this.allowPaste = false;
        this.allowCopy = false;
        this.allowCut = false;
        this.allowDelete = false;
        super.setActionsOwner();
        if (actionsCreated) {
            newActivitySequenceElementAction.setActionOwner(this);
        }
    }

    @Override
    public void clearActionsOwner() {
        super.clearActionsOwner();
        if (actionsCreated) {
            newActivitySequenceElementAction.setActionOwner(null);
        }
    }

    public static void createActions(Options options) {
        ActivitySequenceEditor.createBasicActions(options);
        if (!actionsCreated) {
            newActivitySequenceElementAction = new EditorAction("edit_seq_newElement", "icons/sequence_new.gif", "edit_seq_newElement_tooltip", options){

                @Override
                protected void doAction(Editor e) {
                    Editor ch = null;
                    if (e instanceof ActivitySequenceElementEditor) {
                        ch = e;
                        e = e.getEditorParent();
                    }
                    if (e instanceof ActivitySequenceEditor) {
                        ((ActivitySequenceEditor)e).createNewSequenceElement(e.getNearestIndex(ch, true), true, this.getComponentSrc());
                    }
                }
            };
            actionsCreated = true;
        }
    }
}

