/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.bags;

import edu.xtec.jclic.bags.MediaBag;
import edu.xtec.jclic.bags.MediaBagElement;
import edu.xtec.jclic.bags.MediaBagElementEditor;
import edu.xtec.jclic.bags.MediaBagMultiEditorPanel;
import edu.xtec.jclic.edit.Editor;
import edu.xtec.jclic.edit.EditorAction;
import edu.xtec.jclic.edit.EditorPanel;
import edu.xtec.jclic.fileSystem.FileSystem;
import edu.xtec.jclic.fileSystem.ZipFileSystem;
import edu.xtec.jclic.misc.Utils;
import edu.xtec.jclic.project.JClicProjectEditor;
import edu.xtec.util.Messages;
import edu.xtec.util.Options;
import edu.xtec.util.ProgressDialog;
import edu.xtec.util.ResourceManager;
import edu.xtec.util.StrUtils;
import edu.xtec.util.StreamIO;
import edu.xtec.util.SwingWorker;
import java.awt.Color;
import java.awt.Component;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.tree.TreeNode;

public class MediaBagEditor
extends Editor {
    public static final int DEFAULT_IMG_MAX_WIDTH = 800;
    public static final int DEFAULT_IMG_MAX_HEIGHT = 600;
    public static final int IMG_MIN_SIZE = 10;
    public static final String RESIZED = "resized";
    public static boolean actionsCreated;
    private boolean initializing;
    public static EditorAction newMediaBagElementAction;
    public static EditorAction updateAllMediaAction;
    public static EditorAction exportAllMediaAction;
    private static Icon icon;
    protected static int imgMaxWidth;
    protected static int imgMaxHeight;

    public MediaBagEditor(MediaBag mb) {
        super(mb);
    }

    public Options getOptions() {
        return this.getMediaBag().getProject().getBridge().getOptions();
    }

    @Override
    protected void createChildren() {
        this.initializing = true;
        Iterator<MediaBagElement> it = this.getMediaBag().getElementsByName().iterator();
        while (it.hasNext()) {
            it.next().getEditor(this);
        }
        this.initializing = false;
    }

    @Override
    public EditorPanel createEditorPanel(Options options) {
        return new MediaBagMultiEditorPanel(options);
    }

    @Override
    public Class getEditorPanelClass() {
        return MediaBagMultiEditorPanel.class;
    }

    @Override
    public String getTitleKey() {
        return "edit_media";
    }

    public MediaBag getMediaBag() {
        return (MediaBag)this.getUserObject();
    }

    public JClicProjectEditor getProjectEditor() {
        return (JClicProjectEditor)this.getFirstParent(JClicProjectEditor.class);
    }

    public static String[] selectMediaFiles(MediaBag mediaBag, Options options, Component dlgOwner, int fileFilters, String defaultFile) {
        FileSystem fs = mediaBag.getProject().getFileSystem();
        int[] filters = new int[]{11, 13, 14, 15, 16, 18, 17, 19};
        String[] result = fs.chooseFiles(defaultFile, false, filters, options, "edit_find_media", dlgOwner, true, true);
        if (result != null) {
            for (int i = 0; i < result.length; ++i) {
                if (result[i] == null) continue;
                result[i] = result[i].replace(File.separatorChar, '/');
            }
        }
        return result;
    }

    public String getValidMediaName(String suggestedName) {
        String name = suggestedName;
        int i = 1;
        while (this.getMediaBag().getElement(name) != null) {
            name = name + "_" + i++;
        }
        return name;
    }

    public MediaBagElementEditor addMediaBagElement(MediaBagElement mbe) {
        MediaBagElementEditor result = null;
        if (this.getMediaBag().addElement(mbe)) {
            result = (MediaBagElementEditor)mbe.getEditor(this);
            this.fireEditorDataChanged(null);
        }
        return result;
    }

    public MediaBagElementEditor[] createNewMediaBagElements(Options options, Component dlgOwner, int fileFilters) {
        MediaBagElementEditor[] result = null;
        Messages msg = options.getMessages();
        MediaBag mb = this.getMediaBag();
        FileSystem fs = mb.getProject().getFileSystem();
        String[] fNames = MediaBagEditor.selectMediaFiles(this.getMediaBag(), options, dlgOwner, fileFilters, null);
        if (fNames != null) {
            ArrayList<MediaBagElementEditor> v = new ArrayList<MediaBagElementEditor>();
            for (int i = 0; i < fNames.length; ++i) {
                if (mb.getElementByFileName(fNames[i]) != null) {
                    msg.showAlert(dlgOwner, new String[]{msg.get("edit_media_exists_1"), fNames[i], msg.get("edit_media_exists_2")});
                    continue;
                }
                MediaBagElement mbe = new MediaBagElement(fNames[i], null, this.getValidMediaName(fNames[i]));
                boolean cancel = false;
                if (mbe.isImage()) {
                    Image img = null;
                    try {
                        img = mbe.prepareAndGetImage(fs);
                        if (img == null) {
                            throw new Exception("invalid image!");
                        }
                    }
                    catch (Exception ex) {
                        msg.showErrorWarning(dlgOwner, "err_reading_data", fNames[i], ex, null);
                        cancel = true;
                    }
                    if (img != null) {
                        int imgWidth = img.getWidth(null);
                        int imgHeight = img.getHeight(null);
                        if (imgWidth > imgMaxWidth || imgHeight > imgMaxHeight) {
                            int answer = msg.showQuestionDlgObj(dlgOwner, new String[]{StrUtils.replace(msg.get("img_resize_prompt"), "%s", new String[]{fNames[i], "" + imgWidth + "x" + imgHeight, "" + imgMaxWidth + "x" + imgMaxHeight})}, "CONFIRM", "ync");
                            if (answer == 5) {
                                cancel = true;
                            } else if (answer == 1) {
                                String baseName = fNames[i];
                                int lastDot = baseName.lastIndexOf(".");
                                if (lastDot > 0) {
                                    baseName = baseName.substring(0, lastDot);
                                }
                                String newName = baseName + "-" + RESIZED + ".jpg";
                                File destFile = new File(fs.getFullFileNamePath(newName));
                                int counter = 0;
                                while (destFile.exists()) {
                                    newName = baseName + "-" + RESIZED + Integer.toString(++counter) + ".jpg";
                                    destFile = new File(fs.getFullFileNamePath(newName));
                                }
                                try {
                                    ImageIcon resizedImg = mbe.getThumbNail(imgMaxWidth, imgMaxHeight, fs);
                                    BufferedImage bimg = Utils.toBufferedImage(resizedImg.getImage(), Color.white, null);
                                    ImageIO.write((RenderedImage)bimg, "jpg", destFile);
                                    fNames[i] = newName;
                                    mbe = new MediaBagElement(fNames[i], null, this.getValidMediaName(fNames[i]));
                                }
                                catch (Exception ex) {
                                    cancel = true;
                                    msg.showErrorWarning(dlgOwner, "err_file_save", ex);
                                }
                            }
                        }
                    }
                }
                if (cancel || !mb.addElement(mbe)) continue;
                v.add((MediaBagElementEditor)mbe.getEditor(this));
            }
            if (v.size() > 0) {
                result = v.toArray(new MediaBagElementEditor[v.size()]);
                this.fireEditorDataChanged(null);
            }
        }
        return result;
    }

    public void updateAllElements(JComponent parent) {
        final ProgressDialog progressDialog = new ProgressDialog(parent, this.getOptions());
        SwingWorker sw = new SwingWorker(){

            @Override
            public Object construct() {
                FileSystem fs = MediaBagEditor.this.getMediaBag().getProject().getFileSystem();
                ZipFileSystem zfs = fs instanceof ZipFileSystem ? (ZipFileSystem)fs : null;
                int count = 0;
                int updated = 0;
                progressDialog.setProgressMax(MediaBagEditor.this.getChildCount());
                progressDialog.setProgressValue(count);
                Enumeration<TreeNode> en = MediaBagEditor.this.children();
                while (en.hasMoreElements() && !this.isCancelled()) {
                    MediaBagElementEditor mbeled = (MediaBagElementEditor)en.nextElement();
                    String fName = mbeled.getMediaBagElement().getFileName();
                    progressDialog.setFileLabel(fName);
                    if (fs.realFileExists(fName)) {
                        ZipFileSystem.ExtendedZipEntry ze;
                        if (zfs != null && (ze = zfs.getEntry(fName)) != null && zfs.fileExists(fName)) {
                            ze.ignore = true;
                        }
                        mbeled.updateContent(null);
                        ++updated;
                    }
                    progressDialog.setProgressValue(++count);
                }
                progressDialog.setFileLabel(null);
                if (updated > 0) {
                    MediaBagEditor.this.setModified(true);
                    MediaBagEditor.this.fireEditorDataChanged(null);
                }
                return null;
            }

            @Override
            public void finished() {
                progressDialog.setVisible(false);
            }
        };
        progressDialog.start("edit_media_refreshAll", "edit_media_refreshAll_working", sw, true, true, false);
    }

    public void exportAllElements(final JComponent parent) {
        final Options options = this.getOptions();
        final ProgressDialog progressDialog = new ProgressDialog(parent, options);
        SwingWorker sw = new SwingWorker(){

            @Override
            public Object construct() {
                FileSystem fs = MediaBagEditor.this.getMediaBag().getProject().getFileSystem();
                ZipFileSystem zfs = fs instanceof ZipFileSystem ? (ZipFileSystem)fs : null;
                String dlgMsg = options.getMessages().get("filesystem_copyFile");
                int count = 0;
                progressDialog.setProgressMax(MediaBagEditor.this.getChildCount());
                progressDialog.setProgressValue(count);
                Enumeration<TreeNode> en = MediaBagEditor.this.children();
                boolean overwriteAll = false;
                boolean overwriteNone = false;
                while (en.hasMoreElements() && !this.isCancelled()) {
                    MediaBagElementEditor mbeled = (MediaBagElementEditor)en.nextElement();
                    String fName = mbeled.getMediaBagElement().getFileName();
                    if (zfs == null) continue;
                    ZipFileSystem.ExtendedZipEntry ze = zfs.getEntry(fName);
                    if (ze != null && !ze.ignore) {
                        progressDialog.setFileLabel(fName);
                        String fNameDest = zfs.getFullFileNamePath(fName);
                        File fileDest = new File(fNameDest);
                        boolean prompt = true;
                        if (fileDest.exists()) {
                            if (overwriteNone) continue;
                            if (!overwriteAll) {
                                boolean next = false;
                                boolean cancel = false;
                                switch (options.getMessages().confirmOverwriteFile(parent, fileDest, "yYnNc")) {
                                    case 7: {
                                        overwriteNone = true;
                                    }
                                    case 3: {
                                        next = true;
                                        break;
                                    }
                                    case 6: {
                                        overwriteAll = true;
                                    }
                                    case 1: {
                                        break;
                                    }
                                    default: {
                                        cancel = true;
                                    }
                                }
                                if (next) continue;
                                if (cancel) break;
                            }
                        }
                        try {
                            FileOutputStream os = zfs.createSecureFileOutputStream(fNameDest, false);
                            InputStream is = zfs.getInputStream(fName);
                            StreamIO.writeStreamTo(is, os);
                        }
                        catch (Exception ex) {
                            options.getMessages().showErrorWarning(progressDialog, "FILE_ERR_SAVING", ex);
                            break;
                        }
                    }
                    progressDialog.setProgressValue(++count);
                }
                progressDialog.setFileLabel(null);
                return null;
            }

            @Override
            public void finished() {
                progressDialog.setVisible(false);
            }
        };
        progressDialog.start("edit_media_refreshAll", "edit_media_refreshAll_working", sw, true, true, false);
    }

    @Override
    public void setActionsOwner() {
        this.allowPaste = false;
        this.allowCopy = false;
        this.allowCut = false;
        this.allowDelete = false;
        super.setActionsOwner();
        if (actionsCreated) {
            newMediaBagElementAction.setActionOwner(this);
            FileSystem fs = this.getMediaBag().getProject().getFileSystem();
            boolean isZipFileSystem = fs instanceof ZipFileSystem;
            updateAllMediaAction.setActionOwner(isZipFileSystem ? this : null);
            exportAllMediaAction.setActionOwner(isZipFileSystem ? this : null);
        }
    }

    @Override
    public void clearActionsOwner() {
        super.clearActionsOwner();
        if (actionsCreated) {
            newMediaBagElementAction.setActionOwner(null);
            updateAllMediaAction.setActionOwner(null);
            exportAllMediaAction.setActionOwner(null);
        }
    }

    public static void createActions(Options opt) {
        MediaBagEditor.createBasicActions(opt);
        if (!actionsCreated) {
            newMediaBagElementAction = new EditorAction("edit_media_new", "icons/media_new.gif", "edit_media_new_tooltip", opt){

                @Override
                protected void doAction(Editor e) {
                    Editor ch = null;
                    if (e instanceof MediaBagElementEditor) {
                        ch = e;
                        e = e.getEditorParent();
                    }
                    if (e instanceof MediaBagEditor) {
                        EditorPanel ep = this.getEditorPanelSrc();
                        MediaBagMultiEditorPanel mbep = null;
                        if (ep instanceof MediaBagMultiEditorPanel) {
                            mbep = (MediaBagMultiEditorPanel)ep;
                        }
                        int filters = mbep == null ? -1 : mbep.getFilters();
                        MediaBagElementEditor[] mbed = ((MediaBagEditor)e).createNewMediaBagElements(this.options, this.getComponentSrc(), filters);
                        if (mbed != null && mbed.length > 0 && mbep != null) {
                            mbep.setSelected(mbed[0]);
                        }
                    }
                }
            };
            updateAllMediaAction = new EditorAction("edit_media_refreshAll", "icons/reset_all.gif", "edit_media_refreshAll_tooltip", opt){

                @Override
                protected void doAction(Editor e) {
                    if (e instanceof MediaBagEditor) {
                        ((MediaBagEditor)e).updateAllElements(this.getJComponentSrc());
                    }
                }
            };
            exportAllMediaAction = new EditorAction("edit_media_exportAll", "icons/file_save_all.gif", "edit_media_exportAll_tooltip", opt){

                @Override
                protected void doAction(Editor e) {
                    if (e instanceof MediaBagEditor) {
                        ((MediaBagEditor)e).exportAllElements(this.getJComponentSrc());
                    }
                }
            };
            actionsCreated = true;
        }
    }

    public MediaBagElementEditor getChildFor(MediaBagElement mbe) {
        MediaBagElementEditor result = null;
        if (mbe != null) {
            Enumeration<TreeNode> en = this.children();
            while (en.hasMoreElements()) {
                Editor e = (Editor)en.nextElement();
                if (e.getUserObject() != mbe) continue;
                result = (MediaBagElementEditor)e;
                break;
            }
        }
        return result;
    }

    public List<MediaBagElementEditor> getChildrenList(int filters) {
        ArrayList<MediaBagElementEditor> v = new ArrayList<MediaBagElementEditor>();
        Iterator<MediaBagElement> it = this.getMediaBag().getElementsByName().iterator();
        String[] extFilters = Utils.getFileFilterExtensions(filters);
        while (it.hasNext()) {
            MediaBagElementEditor mbed;
            int i;
            MediaBagElement mbe = it.next();
            String s = mbe.getFileName().toLowerCase();
            if (extFilters != null) {
                for (i = 0; i < extFilters.length && !s.endsWith(extFilters[i]); ++i) {
                }
            }
            if (extFilters != null && i >= extFilters.length || (mbed = this.getChildFor(mbe)) == null) continue;
            v.add(mbed);
        }
        return v;
    }

    public boolean nameChanged(int type, String oldName, String newName) {
        boolean result = false;
        if ((type & 0x47F0) != 0) {
            Enumeration<TreeNode> e = this.children();
            while (e.hasMoreElements()) {
                result |= ((MediaBagElementEditor)e.nextElement()).nameChanged(type, oldName, newName);
            }
        }
        return result;
    }

    public static Icon getIcon() {
        if (icon == null) {
            icon = ResourceManager.getImageIcon("icons/media_bag.gif");
        }
        return icon;
    }

    public int checkOrphanElements(Options options, Component parent, boolean prompt) {
        int result = 1;
        ArrayList<MediaBagElementEditor> v = new ArrayList<MediaBagElementEditor>();
        Enumeration<TreeNode> en = this.children();
        while (en.hasMoreElements()) {
            MediaBagElementEditor mbed = (MediaBagElementEditor)en.nextElement();
            if (!mbed.listReferences().isEmpty()) continue;
            v.add(mbed);
        }
        if (!v.isEmpty()) {
            boolean doIt;
            boolean bl = doIt = !prompt;
            if (!doIt) {
                Object[] object = new Object[]{options.getMsg("edit_project_orphanMedia"), v.size() > 10 ? new JScrollPane(new JList<Object>(v.toArray())) : v, options.getMsg("edit_project_orphanMedia_prompt")};
                result = options.getMessages().showQuestionDlgObj(parent, object, "edit_project_orphanMedia_title", "ync");
                boolean bl2 = doIt = result == 1;
            }
            if (doIt) {
                Iterator it = v.iterator();
                while (it.hasNext()) {
                    ((MediaBagElementEditor)it.next()).delete(true);
                }
            }
        }
        return result;
    }

    public static int getImgMaxWidth() {
        return imgMaxWidth;
    }

    public static void setImgMaxWidth(int width) {
        imgMaxWidth = Math.max(10, width);
    }

    public static int getImgMaxHeight() {
        return imgMaxHeight;
    }

    public static void setImgMaxHeight(int height) {
        imgMaxHeight = Math.max(10, height);
    }

    static {
        imgMaxWidth = 800;
        imgMaxHeight = 600;
    }
}

