/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.bags;

import edu.xtec.jclic.bags.MediaBag;
import edu.xtec.jclic.bags.MediaBagEditor;
import edu.xtec.jclic.bags.MediaBagElement;
import edu.xtec.jclic.bags.MediaBagElementEditorPanel;
import edu.xtec.jclic.bags.MediaPreviewPanel;
import edu.xtec.jclic.edit.Editor;
import edu.xtec.jclic.edit.EditorAction;
import edu.xtec.jclic.edit.EditorPanel;
import edu.xtec.jclic.fileSystem.FileSystem;
import edu.xtec.jclic.misc.Utils;
import edu.xtec.jclic.project.JClicProjectEditor;
import edu.xtec.util.Messages;
import edu.xtec.util.Options;
import edu.xtec.util.ResourceManager;
import java.awt.Component;
import java.awt.Image;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.Icon;

public class MediaBagElementEditor
extends Editor {
    private static boolean actionsCreated;
    private static Icon icon;
    public static EditorAction testMediaBagElementAction;
    private static MediaPreviewPanel previewPanel;

    public MediaBagElementEditor(MediaBagElement el) {
        super(el);
    }

    @Override
    protected void createChildren() {
    }

    @Override
    public Class getEditorPanelClass() {
        return MediaBagElementEditorPanel.class;
    }

    @Override
    public EditorPanel createEditorPanel(Options options) {
        return new MediaBagElementEditorPanel(options);
    }

    public MediaBagElement getMediaBagElement() {
        return (MediaBagElement)this.getFirstObject(MediaBagElement.class);
    }

    public MediaBag getMediaBag() {
        MediaBag result = null;
        if (this.getEditorParent() instanceof MediaBagEditor) {
            result = ((MediaBagEditor)this.getParent()).getMediaBag();
        }
        return result;
    }

    public String getName() {
        return this.getMediaBagElement().getName();
    }

    public void testMedia(Component parent, Options options) {
        if (previewPanel == null) {
            previewPanel = new MediaPreviewPanel(this, options);
            options.getMessages().showInputDlg(parent, previewPanel, "edit_media_preview_tooltip", null);
            previewPanel.end();
            previewPanel = null;
        }
    }

    public boolean rename(String newName, Editor.EditorListener agent, Messages msg) {
        String oldName = this.getName();
        String errMsg = null;
        newName = newName.trim();
        Component parentComponent = agent instanceof Component ? (Component)((Object)agent) : null;
        boolean result = false;
        if (!oldName.equals(newName)) {
            if (newName.length() < 1) {
                errMsg = "edit_media_rename_invalid";
            } else if (this.getMediaBag().getElement(newName) != null) {
                errMsg = "edit_media_rename_exists";
            } else {
                result = this.getProjectEditor().nameChanged(Utils.T_CODES[Utils.getFileType(this.getMediaBagElement().getFileName())], oldName, newName);
            }
        }
        if (errMsg != null && msg != null && parentComponent != null) {
            msg.showAlert(parentComponent, errMsg);
        }
        return result;
    }

    public void updateContent(Editor.EditorListener agent) {
        MediaBagElement mbe = this.getMediaBagElement();
        FileSystem fs = this.getMediaBag().getProject().getFileSystem();
        if (fs.realFileExists(mbe.getFileName())) {
            mbe.setData(null);
            this.fireEditorDataChanged(null);
        }
    }

    public boolean changeFileName(String newFileName, Editor.EditorListener agent, Messages msg) {
        Component parentComponent;
        boolean result = false;
        String errMsg = null;
        String oldFileName = this.getMediaBagElement().getFileName();
        FileSystem fs = this.getMediaBag().getProject().getFileSystem();
        newFileName = FileSystem.stdFn(newFileName.trim());
        Component component = parentComponent = agent instanceof Component ? (Component)((Object)agent) : null;
        if (!oldFileName.equals(newFileName)) {
            if (Utils.getFileType(oldFileName) != Utils.getFileType(newFileName)) {
                errMsg = "edit_media_chfile_different";
            } else if (newFileName.length() < 1) {
                errMsg = "edit_media_chfile_invalid";
            } else if (this.getMediaBag().getElementByFileName(newFileName) != null) {
                if (msg != null && parentComponent != null) {
                    msg.showAlert(parentComponent, new String[]{msg.get("edit_media_exists_1"), newFileName, msg.get("edit_media_exists_2")});
                }
            } else {
                this.getMediaBagElement().setFileName(newFileName);
                result = true;
                this.fireEditorDataChanged(agent);
            }
        }
        if (errMsg != null && msg != null && parentComponent != null) {
            msg.showAlert(parentComponent, errMsg);
        }
        return result;
    }

    @Override
    public String toString() {
        return this.getName();
    }

    protected void saveData() {
    }

    @Override
    protected boolean delete(boolean changeSelection) {
        MediaBagEditor mbe = (MediaBagEditor)this.getEditorParent();
        boolean result = super.delete(changeSelection);
        if (result && mbe != null) {
            result = mbe.getMediaBag().removeElement(this.getMediaBagElement());
            mbe.fireEditorDataChanged(null);
        }
        return result;
    }

    @Override
    protected boolean canClone() {
        return false;
    }

    protected void setActionsFlag() {
        this.allowDelete = true;
        this.allowCut = false;
        this.allowCopy = false;
        this.allowPaste = false;
    }

    @Override
    public void setActionsOwner() {
        this.setActionsFlag();
        super.setActionsOwner();
        if (actionsCreated) {
            testMediaBagElementAction.setActionOwner(this);
        }
    }

    @Override
    public void clearActionsOwner() {
        super.clearActionsOwner();
        if (actionsCreated) {
            testMediaBagElementAction.setActionOwner(null);
        }
    }

    public static Icon getIcon() {
        if (icon == null) {
            icon = ResourceManager.getImageIcon("icons/movie.gif");
        }
        return icon;
    }

    @Override
    public Icon getIcon(boolean leaf, boolean expanded) {
        return MediaBagElementEditor.getIcon();
    }

    @Override
    public boolean canBeParentOf(Editor e) {
        return false;
    }

    @Override
    public boolean canBeSiblingOf(Editor e) {
        return e instanceof MediaBagElementEditor;
    }

    public JClicProjectEditor getProjectEditor() {
        return (JClicProjectEditor)this.getFirstParent(JClicProjectEditor.class);
    }

    public static void createActions(Options opt) {
        MediaBagElementEditor.createBasicActions(opt);
        if (!actionsCreated) {
            testMediaBagElementAction = new EditorAction("edit_media_preview", "icons/media_view.gif", "edit_media_preview_tooltip", opt){

                @Override
                protected void doAction(Editor e) {
                    EditorPanel ep = this.getEditorPanelSrc();
                    if (ep != null && e instanceof MediaBagElementEditor) {
                        ((MediaBagElementEditor)e).testMedia(ep, ep.getOptions());
                    }
                }
            };
            actionsCreated = true;
        }
    }

    public String getDescription(Options options) {
        MediaBagElement mbe = this.getMediaBagElement();
        StringBuilder sb = new StringBuilder();
        String fileName = mbe.getFileName();
        if (fileName != null) {
            int type = Utils.getFileType(fileName);
            sb.append(options.getMsg(Utils.TYPE_CODES[type]));
            if (type == 0) {
                if (mbe.animated) {
                    sb.append(" ").append(options.getMsg("ftype_animated"));
                }
                try {
                    Image img = mbe.getImage();
                    if (img != null) {
                        sb.append(" (").append(img.getWidth(null)).append("x").append(img.getHeight(null)).append(")");
                    }
                }
                catch (Exception ex) {
                    sb.append(" - ").append(options.getMsg("ERROR"));
                    System.err.println("Error reading image " + fileName);
                }
            }
        }
        return sb.substring(0);
    }

    public long getFileSize() {
        String fileName;
        MediaBagElement mbe = this.getMediaBagElement();
        long result = -1L;
        if (mbe != null && (fileName = mbe.getFileName()) != null && this.getMediaBag() != null) {
            try {
                result = this.getMediaBag().getProject().getFileSystem().getFileLength(fileName);
            }
            catch (Exception ex) {
                System.err.println("ERROR getting the size of " + fileName);
            }
        }
        return result;
    }

    public boolean nameChanged(int type, String oldName, String newName) {
        boolean result = false;
        if ((type & 0x47F0) != 0 && oldName.equals(this.getMediaBagElement().getName())) {
            this.getMediaBagElement().setName(newName);
            this.setModified(true);
            result = true;
        }
        return result;
    }

    public List<String> listReferences() {
        ArrayList result = null;
        MediaBag mb = this.getMediaBag();
        if (mb != null) {
            HashMap<String, String> hm = new HashMap<String, String>();
            mb.listReferencesTo(this.getName(), "media", hm);
            result = new ArrayList(hm.keySet());
        }
        this.allowDelete = result == null || result.isEmpty();
        deleteAction.setEnabled(this.allowDelete);
        return result;
    }

    static {
        previewPanel = null;
    }
}

