/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.bags;

import edu.xtec.jclic.bags.MediaBag;
import edu.xtec.jclic.bags.MediaBagEditor;
import edu.xtec.jclic.bags.MediaBagElementEditor;
import edu.xtec.jclic.bags.MediaBagElementEditorPanel;
import edu.xtec.jclic.boxes.ThumbsExplorerPanel;
import edu.xtec.jclic.edit.Editor;
import edu.xtec.jclic.edit.EditorPanel;
import edu.xtec.jclic.fileSystem.FileSystem;
import edu.xtec.util.Messages;
import edu.xtec.util.Options;
import edu.xtec.util.SmallButton;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class MediaBagMultiEditorPanel
extends EditorPanel {
    public static final int ICON_MAX_WIDTH = 100;
    public static final int BUTTON_WIDTH = 130;
    public static final int ICON_MAX_HEIGHT = 70;
    public static final int BUTTON_HEIGHT = 110;
    public static final String[] COMBO_ITEMS = new String[]{"filefilter_all_media", "filefilter_all_images", "filefilter_all_sounds", "filefilter_midi", "filefilter_all_video", "filefilter_all_anim", "filefilter_skins", "filefilter_fonts"};
    public static final int[] COMBO_FILTERS = new int[]{12, 11, 13, 14, 15, 16, 17, 18};
    private ThumbsExplorerPanel selectPanel;
    private MediaBagElementEditor current;
    int filters = -1;
    private ListSelectionListener btSelListener = new ListSelectionListener(){

        @Override
        public void valueChanged(ListSelectionEvent evt) {
            MediaBagMultiEditorPanel.this.current = (MediaBagElementEditor)MediaBagMultiEditorPanel.this.selectPanel.getCurrentObject();
            ((MediaBagElementEditorPanel)MediaBagMultiEditorPanel.this.elementEditPanel).attachEditor(MediaBagMultiEditorPanel.this.current, true);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MediaBagMultiEditorPanel.this.selectPanel.checkCurrentVisibility();
                }
            });
        }
    };
    private ActionListener btActListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent evt) {
            MediaBagElementEditor.testMediaBagElementAction.actionPerformed(new ActionEvent(MediaBagMultiEditorPanel.this.elementEditPanel, 1001, ""));
        }
    };
    private static Map<Options, MediaBagMultiEditorPanel> dlgPanels = new HashMap<Options, MediaBagMultiEditorPanel>(1);
    private ButtonGroup bGroup;
    private JPanel elementEditPanel;
    private JComboBox<Object> filterCombo;
    private JLabel filterLb;
    private JPanel filterPanel;
    private JPanel mainPanel;
    private JPanel sPanel;
    private JScrollPane scrollPanel;
    private JLabel statusLb;

    public MediaBagMultiEditorPanel(Options options) {
        super(options);
        MediaBagEditor.createActions(options);
        MediaBagElementEditor.createActions(options);
        this.initComponents();
        this.selectPanel = (ThumbsExplorerPanel)this.sPanel;
        this.scrollPanel.getVerticalScrollBar().setUnitIncrement(this.selectPanel.boxSize.height);
        this.selectPanel.addListSelectionListener(this.btSelListener);
        this.selectPanel.addActionListener(this.btActListener);
        this.filterCombo.setSelectedIndex(0);
        this.postInit(250, false, true);
        this.setEnabled(false);
    }

    @Override
    protected String getTitle() {
        return this.options.getMsg("edit_media_title");
    }

    protected List<String> getComboItems() {
        ArrayList<String> result = new ArrayList<String>();
        for (String item : COMBO_ITEMS) {
            result.add(this.options.getMsg(item));
        }
        return result;
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        ((MediaBagElementEditorPanel)this.elementEditPanel).focusGained(focusEvent);
    }

    private void initComponents() {
        this.bGroup = new ButtonGroup();
        this.mainPanel = new JPanel();
        this.filterPanel = new JPanel();
        this.filterLb = new JLabel();
        this.filterCombo = new JComboBox<Object>(this.getComboItems().toArray());
        this.scrollPanel = new JScrollPane();
        this.sPanel = new ThumbsExplorerPanel();
        this.statusLb = new JLabel();
        this.elementEditPanel = new MediaBagElementEditorPanel(this.options);
        this.setLayout(new BorderLayout());
        this.mainPanel.setLayout(new GridBagLayout());
        this.filterPanel.setLayout(new FlowLayout(0));
        this.filterLb.setText(this.options.getMsg("edit_media_show_type"));
        this.filterPanel.add(this.filterLb);
        this.filterCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MediaBagMultiEditorPanel.this.filterComboActionPerformed(evt);
            }
        });
        this.filterPanel.add(this.filterCombo);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        this.mainPanel.add((Component)this.filterPanel, gridBagConstraints);
        this.scrollPanel.setHorizontalScrollBarPolicy(31);
        this.scrollPanel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                MediaBagMultiEditorPanel.this.scrollPanelComponentResized(evt);
            }
        });
        this.scrollPanel.setViewportView(this.sPanel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.mainPanel.add((Component)this.scrollPanel, gridBagConstraints);
        this.statusLb.setText("0 " + this.options.getMsg("edit_media_objects"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.mainPanel.add((Component)this.statusLb, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 18;
        this.mainPanel.add((Component)this.elementEditPanel, gridBagConstraints);
        this.add((Component)this.mainPanel, "Center");
    }

    private void filterComboActionPerformed(ActionEvent evt) {
        this.setFilters(COMBO_FILTERS[this.filterCombo.getSelectedIndex()]);
    }

    private void scrollPanelComponentResized(ComponentEvent evt) {
        this.selectPanel.resizeTo(this.scrollPanel.getViewport().getSize().width);
    }

    @Override
    public void editorDataChanged(Editor e) {
        if (e != null) {
            if (e.equals(this.getEditor())) {
                this.fillData();
            } else {
                ThumbsExplorerPanel.ThumbElement th = this.selectPanel.getElementFor(e);
                if (th != null) {
                    MediaBagElementEditor mbed = (MediaBagElementEditor)e;
                    Dimension d = this.selectPanel.maxThumbSize;
                    th.setImage(mbed.getMediaBagElement().getThumbNail(d.width, d.height, this.getMediaBag().getProject().getFileSystem()));
                    th.setText(mbed.getName());
                    mbed.getMediaBagElement().clearData();
                    this.btSelListener.valueChanged(null);
                    this.repaint();
                }
            }
        }
    }

    @Override
    public boolean checkIfEditorValid(Editor e) {
        return e instanceof MediaBagEditor;
    }

    protected MediaBagEditor getMediaBagEditor() {
        return (MediaBagEditor)this.editor;
    }

    protected MediaBag getMediaBag() {
        if (this.editor == null) {
            return null;
        }
        return this.getMediaBagEditor().getMediaBag();
    }

    public void setFilters(int filters) {
        this.filters = filters;
        for (int i = 0; i < COMBO_FILTERS.length; ++i) {
            if (COMBO_FILTERS[i] != filters) continue;
            this.filterCombo.setSelectedIndex(i);
            break;
        }
        this.fillData();
    }

    public int getFilters() {
        return this.filters;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.selectPanel.setEnabled(enabled);
        this.filterCombo.setEnabled(enabled);
        this.elementEditPanel.setEnabled(enabled);
    }

    @Override
    protected void fillData() {
        this.current = null;
        this.selectPanel.removeAllThumbElements();
        ((MediaBagElementEditorPanel)this.elementEditPanel).attachEditor(null, true);
        MediaBagEditor mbe = this.getMediaBagEditor();
        int n = 0;
        if (mbe != null) {
            Dimension d = this.selectPanel.maxThumbSize;
            List<MediaBagElementEditor> v = mbe.getChildrenList(this.filters);
            n = v.size();
            FileSystem fs = this.getMediaBag().getProject().getFileSystem();
            for (MediaBagElementEditor mbed : v) {
                this.selectPanel.addThumbElement(mbed, mbed.getMediaBagElement().getThumbNail(d.width, d.height, fs), mbed.getName());
                mbed.getMediaBagElement().clearData();
            }
        }
        this.btSelListener.valueChanged(null);
        this.statusLb.setText(Integer.toString(n) + " " + this.options.getMsg(n == 1 ? "edit_media_object" : "edit_media_objects"));
        this.scrollPanelComponentResized(null);
    }

    @Override
    protected void saveData() {
    }

    public MediaBagElementEditor getSelected() {
        return this.current;
    }

    public void setSelected(MediaBagElementEditor value) {
        this.selectPanel.setCurrentObject(value);
        this.btSelListener.valueChanged(null);
    }

    public static String getMediaName(String initialValue, Options options, Component parent, MediaBagEditor mbe, int filters) {
        MediaBagElementEditor mbele;
        String result = null;
        Messages msg = options.getMessages();
        MediaBagMultiEditorPanel mbep = dlgPanels.get(options);
        if (mbep == null) {
            mbep = new MediaBagMultiEditorPanel(options);
            mbep.setPreferredSize(new Dimension(500, 500));
            dlgPanels.put(options, mbep);
        }
        mbep.attachEditor(mbe, true);
        mbep.setFilters(filters);
        if (filters >= 0) {
            mbep.filterCombo.setEnabled(false);
        }
        mbep.setSelected(initialValue == null ? null : (MediaBagElementEditor)mbe.getChildByName(initialValue));
        boolean b = msg.showInputDlg(parent, mbep, "edit_media_dlg_title");
        if (b && (mbele = mbep.getSelected()) != null) {
            result = mbele.getName();
        }
        mbep.filterCombo.setEnabled(true);
        mbep.removeEditor(true);
        return result;
    }

    @Override
    protected void addActionsTo(Container cnt) {
        cnt.add(new SmallButton(MediaBagEditor.newMediaBagElementAction));
        cnt.add(new SmallButton(MediaBagElementEditor.testMediaBagElementAction));
        cnt.add(new SmallButton(Editor.deleteAction));
        cnt.add(new SmallButton(MediaBagEditor.updateAllMediaAction));
        cnt.add(new SmallButton(MediaBagEditor.exportAllMediaAction));
    }
}

