/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.bags;

import edu.xtec.jclic.bags.MediaBagEditor;
import edu.xtec.jclic.bags.MediaBagElementEditor;
import edu.xtec.util.Messages;
import edu.xtec.util.Options;
import edu.xtec.util.ResourceManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class MediaBagSelector
extends JPanel {
    Options options;
    MediaBagEditor mbe;
    MediaBagElementEditor current;
    int filters;
    private ListSelectionListener selListener = new ListSelectionListener(){

        @Override
        public void valueChanged(ListSelectionEvent evt) {
            if (evt != null && !evt.getValueIsAdjusting()) {
                MediaBagSelector.this.setSelected((MediaBagElementEditor)MediaBagSelector.this.mediaList.getSelectedValue());
            }
        }
    };
    private static Map<Options, MediaBagSelector> dlgPanels = new HashMap<Options, MediaBagSelector>(1);
    private JButton addMediaBtn;
    private JPanel elementPanel;
    private JLabel fileLb;
    private JLabel fileText;
    private JPanel listPanel;
    private JList<Object> mediaList;
    private JLabel nameLb;
    private JLabel nameText;
    private JLabel previewLabel;
    private JScrollPane scrollList;
    private JLabel sizeTx;
    private JLabel typeTx;

    public MediaBagSelector(Options options) {
        this.options = options;
        this.initComponents();
        this.mediaList.addListSelectionListener(this.selListener);
    }

    private void initComponents() {
        this.listPanel = new JPanel();
        this.scrollList = new JScrollPane();
        this.mediaList = new JList();
        this.addMediaBtn = new JButton();
        this.elementPanel = new JPanel();
        this.previewLabel = new JLabel();
        this.nameLb = new JLabel();
        this.nameText = new JLabel();
        this.fileLb = new JLabel();
        this.fileText = new JLabel();
        JLabel typeLb = new JLabel();
        this.typeTx = new JLabel();
        JLabel sizeLb = new JLabel();
        this.sizeTx = new JLabel();
        this.setLayout(new GridBagLayout());
        this.listPanel.setLayout(new BorderLayout());
        this.scrollList.setMinimumSize(new Dimension(200, 400));
        this.scrollList.setPreferredSize(new Dimension(200, 400));
        this.scrollList.setViewportView(this.mediaList);
        this.listPanel.add((Component)this.scrollList, "Center");
        this.addMediaBtn.setIcon(ResourceManager.getImageIcon("icons/media_new.gif"));
        this.addMediaBtn.setText(this.options.getMsg("edit_media_new"));
        this.addMediaBtn.setToolTipText(this.options.getMsg("edit_media_new_tooltip"));
        this.addMediaBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MediaBagSelector.this.addMediaBtnActionPerformed(evt);
            }
        });
        this.listPanel.add((Component)this.addMediaBtn, "Last");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        this.add((Component)this.listPanel, gridBagConstraints);
        this.elementPanel.setLayout(new GridBagLayout());
        this.previewLabel.setHorizontalAlignment(0);
        this.previewLabel.setBorder(BorderFactory.createEtchedBorder());
        this.previewLabel.setMinimumSize(new Dimension(100, 100));
        this.previewLabel.setPreferredSize(new Dimension(100, 100));
        this.previewLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                MediaBagSelector.this.previewLabelMousePressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 7, 3);
        this.elementPanel.add((Component)this.previewLabel, gridBagConstraints);
        this.nameLb.setText(this.options.getMsg("edit_name"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.elementPanel.add((Component)this.nameLb, gridBagConstraints);
        this.nameText.setMinimumSize(new Dimension(200, 16));
        this.nameText.setPreferredSize(new Dimension(200, 17));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.elementPanel.add((Component)this.nameText, gridBagConstraints);
        this.fileLb.setText(this.options.getMsg("edit_file"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.elementPanel.add((Component)this.fileLb, gridBagConstraints);
        this.fileText.setMinimumSize(new Dimension(200, 16));
        this.fileText.setPreferredSize(new Dimension(200, 17));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.elementPanel.add((Component)this.fileText, gridBagConstraints);
        typeLb.setText(this.options.getMsg("edit_media_type"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.elementPanel.add((Component)typeLb, gridBagConstraints);
        this.typeTx.setText("-");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.elementPanel.add((Component)this.typeTx, gridBagConstraints);
        sizeLb.setText(this.options.getMsg("edit_media_size"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.elementPanel.add((Component)sizeLb, gridBagConstraints);
        this.sizeTx.setText("0 Kb");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.elementPanel.add((Component)this.sizeTx, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.elementPanel, gridBagConstraints);
    }

    private void previewLabelMousePressed(MouseEvent evt) {
        if (this.current != null) {
            this.current.testMedia(this, this.options);
        }
    }

    private void addMediaBtnActionPerformed(ActionEvent evt) {
        MediaBagElementEditor[] mbele;
        if (this.mbe != null && (mbele = this.mbe.createNewMediaBagElements(this.options, this, this.filters)) != null && mbele.length > 0) {
            this.mediaList.setListData((Object[])this.mbe.getChildrenList(this.filters).toArray());
            this.setSelected(mbele[0]);
            this.mediaList.setSelectedValue(mbele[0], true);
        }
    }

    protected void setMediaBagEditor(MediaBagEditor mbe, int filters) {
        this.mbe = mbe;
        this.filters = filters;
        this.setSelected(null);
        this.mediaList.setListData((Object[])(mbe == null ? new String[]{} : mbe.getChildrenList(filters).toArray()));
    }

    protected void setSelected(MediaBagElementEditor mbed) {
        this.current = mbed;
        this.nameText.setText(this.current == null ? "" : this.current.getName());
        this.fileText.setText(this.current == null ? "" : this.current.getMediaBagElement().getFileName());
        this.typeTx.setText(mbed == null ? "" : mbed.getDescription(this.options));
        long fSize = -1L;
        if (mbed != null) {
            fSize = mbed.getFileSize();
        }
        this.sizeTx.setText(fSize < 0L ? "" : this.options.getMessages().fileSize(fSize));
        this.previewLabel.setIcon(mbed == null ? null : mbed.getMediaBagElement().getThumbNail(90, 90, mbed.getMediaBag().getProject().getFileSystem()));
        if (mbed != null) {
            mbed.getMediaBagElement().clearData();
        }
    }

    protected MediaBagElementEditor getSelected() {
        return this.current;
    }

    public static String getMediaName(String initialValue, Options options, Component parent, MediaBagEditor mbe, int filters) {
        MediaBagElementEditor mbele;
        String result = null;
        Messages msg = options.getMessages();
        MediaBagSelector mbs = dlgPanels.get(options);
        if (mbs == null) {
            mbs = new MediaBagSelector(options);
            dlgPanels.put(options, mbs);
        }
        mbs.setMediaBagEditor(mbe, filters);
        MediaBagElementEditor mbed = initialValue == null ? null : (MediaBagElementEditor)mbe.getChildByName(initialValue);
        mbs.setSelected(mbed);
        mbs.mediaList.setSelectedValue(mbed, true);
        boolean b = msg.showInputDlg(parent, mbs, "edit_media_dlg_title");
        if (b && (mbele = mbs.getSelected()) != null) {
            result = mbele.getName();
        }
        mbs.setMediaBagEditor(null, -1);
        return result;
    }
}

