/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.beans;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import java.text.ParseException;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class SmallIntEditor
extends JPanel
implements ActionListener {
    public static final String PROP_VALUE = "value";
    private JButton plusButton;
    private JButton minusButton;
    private NumberField textFld;
    private int max;
    private int min;
    private int lastValue;
    private Toolkit toolkit;
    private NumberFormat integerFormatter;
    private int[] values;
    boolean editable;

    public SmallIntEditor() {
        this.setLayout(new BoxLayout(this, 0));
        this.setOpaque(false);
        this.editable = true;
        this.toolkit = Toolkit.getDefaultToolkit();
        this.integerFormatter = NumberFormat.getNumberInstance();
        this.integerFormatter.setParseIntegerOnly(true);
        this.max = 10;
        this.min = 0;
        this.plusButton = new JButton(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/plus.gif")));
        this.plusButton.setMnemonic('+');
        this.plusButton.addActionListener(this);
        this.plusButton.setPreferredSize(new Dimension(16, 16));
        this.minusButton = new JButton(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/minus.gif")));
        this.minusButton.setMnemonic('-');
        this.minusButton.addActionListener(this);
        this.minusButton.setPreferredSize(new Dimension(16, 16));
        this.textFld = new NumberField(4);
        this.textFld.setColumns(4);
        this.textFld.setHorizontalAlignment(0);
        this.textFld.setText("0");
        this.textFld.addActionListener(this);
        this.add((Component)this.minusButton, "West");
        this.add((Component)this.textFld, "Center");
        this.add((Component)this.plusButton, "East");
    }

    @Override
    public void setToolTipText(String text) {
        super.setToolTipText(text);
        this.textFld.setToolTipText(text);
        this.plusButton.setToolTipText(text);
        this.minusButton.setToolTipText(text);
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        int delta;
        boolean btMinus;
        int oldValue = this.lastValue;
        boolean btPlus = this.plusButton == ev.getSource();
        boolean bl = btMinus = this.minusButton == ev.getSource();
        int n = btPlus ? 1 : (delta = btMinus ? -1 : 0);
        if (delta != 0 && this.values != null && this.values.length > 0) {
            int p;
            for (p = 0; p < this.values.length && oldValue > this.values[p]; ++p) {
            }
            if (delta < 0 || p < this.values.length && this.values[p] == oldValue) {
                p += delta;
            }
            delta = p >= 0 && p < this.values.length ? this.values[p] - oldValue : 0;
        }
        if (delta != 0) {
            this.setValue(this.getValue() + delta);
        }
        this.checkValueRanges();
        this.checkEnabled();
        this.lastValue = this.getValue();
        this.firePropertyChange(PROP_VALUE, oldValue, this.lastValue);
    }

    private void checkEnabled() {
        int value = this.getValue();
        this.minusButton.setEnabled(this.isEnabled() && value > this.min);
        this.plusButton.setEnabled(this.isEnabled() && value < this.max);
        this.textFld.setEnabled(this.isEnabled() && this.editable);
    }

    @Override
    public void setEnabled(boolean b) {
        super.setEnabled(b);
        this.checkEnabled();
    }

    public int getValue() {
        int retVal = 0;
        String s = this.textFld.getText();
        if (s != null && s.length() > 0) {
            try {
                retVal = this.integerFormatter.parse(s).intValue();
            }
            catch (ParseException e) {
                this.toolkit.beep();
                System.err.println("Bad integer value " + s + ": " + e.getMessage());
            }
        }
        return this.correctValue(retVal);
    }

    public void setValue(int value) {
        this.lastValue = this.correctValue(value);
        this.textFld.setText(this.integerFormatter.format(this.lastValue));
    }

    public int correctValue(int value) {
        return Math.min(this.max, Math.max(this.min, value));
    }

    private void checkValueRanges() {
        int v = 0;
        try {
            v = this.integerFormatter.parse(this.textFld.getText()).intValue();
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        if (v < this.min || v > this.max) {
            this.setValue(this.correctValue(v));
        }
    }

    public void setEditColumns(int columns) {
        this.textFld.setColumns(columns);
    }

    public int getEditColumns() {
        return this.textFld.getColumns();
    }

    public int getMax() {
        return this.max;
    }

    public void setMax(int max) {
        this.max = max;
    }

    public int getMin() {
        return this.min;
    }

    public void setMin(int min) {
        this.min = min;
    }

    public int[] getValues() {
        return this.values;
    }

    public void setValues(int[] values) {
        this.values = values;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
        this.checkEnabled();
    }

    class NumberField
    extends JTextField {
        public NumberField(int columns) {
            super(columns);
        }

        @Override
        protected Document createDefaultModel() {
            return new WholeNumberDocument();
        }

        protected class WholeNumberDocument
        extends PlainDocument {
            protected WholeNumberDocument() {
            }

            @Override
            public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
                char[] source = str.toCharArray();
                char[] result = new char[source.length];
                int j = 0;
                for (int i = 0; i < result.length; ++i) {
                    if (Character.isDigit(source[i]) || source[i] == '-') {
                        result[j++] = source[i];
                        continue;
                    }
                    SmallIntEditor.this.toolkit.beep();
                }
                super.insertString(offs, new String(result, 0, j), a);
                SmallIntEditor.this.checkEnabled();
            }

            @Override
            public void remove(int offs, int len) throws BadLocationException {
                super.remove(offs, len);
                SmallIntEditor.this.checkEnabled();
            }
        }
    }
}

