/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.media;

import edu.xtec.jclic.bags.MediaBagEditor;
import edu.xtec.jclic.beans.SoundButton;
import edu.xtec.jclic.media.EventSounds;
import edu.xtec.jclic.media.EventSoundsElement;
import edu.xtec.util.Messages;
import edu.xtec.util.Options;
import edu.xtec.util.StrUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public class EventSoundsEditorPanel
extends JPanel
implements PropertyChangeListener,
ActionListener {
    Options options;
    JLabel[] txFields;
    JCheckBox[] chkBoxes;
    SoundButton[] buttons;
    EventSounds evs;
    private static Map<Options, EventSoundsEditorPanel> dlgPanels = new HashMap<Options, EventSoundsEditorPanel>(1);
    private JLabel evActionError;
    private SoundButton evActionErrorBtn;
    private JCheckBox evActionErrorChk;
    private JLabel evActionErrorLb;
    private JLabel evActionOk;
    private SoundButton evActionOkBtn;
    private JCheckBox evActionOkChk;
    private JLabel evActionOkLb;
    private JLabel evClick;
    private SoundButton evClickBtn;
    private JCheckBox evClickChk;
    private JLabel evClickLb;
    private JLabel evFinishedError;
    private SoundButton evFinishedErrorBtn;
    private JCheckBox evFinishedErrorChk;
    private JLabel evFinishedErrorLb;
    private JLabel evFinishedOk;
    private SoundButton evFinishedOkBtn;
    private JCheckBox evFinishedOkChk;
    private JLabel evFinishedOkLb;
    private JLabel evStart;
    private SoundButton evStartBtn;
    private JCheckBox evStartChk;
    private JLabel evStartLb;

    public EventSoundsEditorPanel(Options options, MediaBagEditor mbe) {
        this.options = options;
        this.evs = new EventSounds(null);
        this.initComponents();
        this.txFields = new JLabel[]{this.evStart, this.evClick, this.evActionError, this.evActionOk, this.evFinishedError, this.evFinishedOk};
        this.buttons = new SoundButton[]{this.evStartBtn, this.evClickBtn, this.evActionErrorBtn, this.evActionOkBtn, this.evFinishedErrorBtn, this.evFinishedOkBtn};
        this.chkBoxes = new JCheckBox[]{this.evStartChk, this.evClickChk, this.evActionErrorChk, this.evActionOkChk, this.evFinishedErrorChk, this.evFinishedOkChk};
        for (int i = 0; i < this.buttons.length; ++i) {
            this.buttons[i].setOptions(options);
            this.buttons[i].setMediaBagEditor(mbe);
            this.buttons[i].addPropertyChangeListener("soundName", this);
            this.chkBoxes[i].addActionListener(this);
            this.chkBoxes[i].setSelected(true);
        }
    }

    private void initComponents() {
        this.evStartLb = new JLabel();
        this.evStartChk = new JCheckBox();
        this.evStart = new JLabel();
        this.evStartBtn = new SoundButton();
        this.evClickLb = new JLabel();
        this.evClickChk = new JCheckBox();
        this.evClick = new JLabel();
        this.evClickBtn = new SoundButton();
        this.evActionOkLb = new JLabel();
        this.evActionOkChk = new JCheckBox();
        this.evActionOk = new JLabel();
        this.evActionOkBtn = new SoundButton();
        this.evActionErrorLb = new JLabel();
        this.evActionErrorChk = new JCheckBox();
        this.evActionError = new JLabel();
        this.evActionErrorBtn = new SoundButton();
        this.evFinishedOkLb = new JLabel();
        this.evFinishedOkChk = new JCheckBox();
        this.evFinishedOk = new JLabel();
        this.evFinishedOkBtn = new SoundButton();
        this.evFinishedErrorLb = new JLabel();
        this.evFinishedErrorChk = new JCheckBox();
        this.evFinishedError = new JLabel();
        this.evFinishedErrorBtn = new SoundButton();
        this.setLayout(new GridBagLayout());
        this.evStartLb.setLabelFor(this.evStartBtn);
        this.evStartLb.setText(this.options.getMsg("edit_evsounds_start"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.evStartLb, gridBagConstraints);
        this.evStartChk.setToolTipText(this.options.getMsg("edit_evsounds_chk_tooltip"));
        this.evStartChk.setHorizontalAlignment(4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.evStartChk, gridBagConstraints);
        this.evStart.setText(this.options.getMsg("edit_evsounds_default"));
        this.evStart.setPreferredSize(new Dimension(140, 27));
        this.evStart.setBorder(new TitledBorder(""));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.evStart, gridBagConstraints);
        this.evStartBtn.setToolTipText(this.options.getMsg("edit_evsounds_select_tooltip"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.evStartBtn, gridBagConstraints);
        this.evClickLb.setLabelFor(this.evClickBtn);
        this.evClickLb.setText(this.options.getMsg("edit_evsounds_click"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.evClickLb, gridBagConstraints);
        this.evClickChk.setToolTipText(this.options.getMsg("edit_evsounds_chk_tooltip"));
        this.evClickChk.setHorizontalAlignment(4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.evClickChk, gridBagConstraints);
        this.evClick.setText(this.options.getMsg("edit_evsounds_default"));
        this.evClick.setPreferredSize(new Dimension(140, 27));
        this.evClick.setBorder(new TitledBorder(""));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.evClick, gridBagConstraints);
        this.evClickBtn.setToolTipText(this.options.getMsg("edit_evsounds_select_tooltip"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.evClickBtn, gridBagConstraints);
        this.evActionOkLb.setLabelFor(this.evActionOkBtn);
        this.evActionOkLb.setText(this.options.getMsg("edit_evsounds_actionOk"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.evActionOkLb, gridBagConstraints);
        this.evActionOkChk.setToolTipText(this.options.getMsg("edit_evsounds_chk_tooltip"));
        this.evActionOkChk.setHorizontalAlignment(4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.evActionOkChk, gridBagConstraints);
        this.evActionOk.setText(this.options.getMsg("edit_evsounds_default"));
        this.evActionOk.setPreferredSize(new Dimension(140, 27));
        this.evActionOk.setBorder(new TitledBorder(""));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.evActionOk, gridBagConstraints);
        this.evActionOkBtn.setToolTipText(this.options.getMsg("edit_evsounds_select_tooltip"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.evActionOkBtn, gridBagConstraints);
        this.evActionErrorLb.setLabelFor(this.evActionErrorBtn);
        this.evActionErrorLb.setText(this.options.getMsg("edit_evsounds_actionError"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.evActionErrorLb, gridBagConstraints);
        this.evActionErrorChk.setToolTipText(this.options.getMsg("edit_evsounds_chk_tooltip"));
        this.evActionErrorChk.setHorizontalAlignment(4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.evActionErrorChk, gridBagConstraints);
        this.evActionError.setText(this.options.getMsg("edit_evsounds_default"));
        this.evActionError.setPreferredSize(new Dimension(140, 27));
        this.evActionError.setBorder(new TitledBorder(""));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.evActionError, gridBagConstraints);
        this.evActionErrorBtn.setToolTipText(this.options.getMsg("edit_evsounds_select_tooltip"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.evActionErrorBtn, gridBagConstraints);
        this.evFinishedOkLb.setLabelFor(this.evFinishedOkBtn);
        this.evFinishedOkLb.setText(this.options.getMsg("edit_evsounds_finishedOk"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.evFinishedOkLb, gridBagConstraints);
        this.evFinishedOkChk.setToolTipText(this.options.getMsg("edit_evsounds_chk_tooltip"));
        this.evFinishedOkChk.setHorizontalAlignment(4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.evFinishedOkChk, gridBagConstraints);
        this.evFinishedOk.setText(this.options.getMsg("edit_evsounds_default"));
        this.evFinishedOk.setPreferredSize(new Dimension(140, 27));
        this.evFinishedOk.setBorder(new TitledBorder(""));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.evFinishedOk, gridBagConstraints);
        this.evFinishedOkBtn.setToolTipText(this.options.getMsg("edit_evsounds_select_tooltip"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.evFinishedOkBtn, gridBagConstraints);
        this.evFinishedErrorLb.setLabelFor(this.evFinishedErrorBtn);
        this.evFinishedErrorLb.setText(this.options.getMsg("edit_evsounds_finishedError"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.evFinishedErrorLb, gridBagConstraints);
        this.evFinishedErrorChk.setToolTipText(this.options.getMsg("edit_evsounds_chk_tooltip"));
        this.evFinishedErrorChk.setHorizontalAlignment(4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.evFinishedErrorChk, gridBagConstraints);
        this.evFinishedError.setText(this.options.getMsg("edit_evsounds_default"));
        this.evFinishedError.setPreferredSize(new Dimension(140, 27));
        this.evFinishedError.setBorder(new TitledBorder(""));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.evFinishedError, gridBagConstraints);
        this.evFinishedErrorBtn.setToolTipText(this.options.getMsg("edit_evsounds_select_tooltip"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.evFinishedErrorBtn, gridBagConstraints);
    }

    public static boolean nameChanged(EventSounds ev, int type, String oldName, String newName) {
        boolean result = false;
        if ((type & 0x60) != 0) {
            if (ev.parent != null) {
                result |= EventSoundsEditorPanel.nameChanged(ev.parent, type, oldName, newName);
            }
            for (int i = 0; i < ev.elements.length; ++i) {
                if (ev.elements[i] == null || !oldName.equals(ev.elements[i].fileName)) continue;
                ev.elements[i].fileName = newName;
                result = true;
            }
        }
        return result;
    }

    @Override
    public void propertyChange(PropertyChangeEvent ev) {
        if (ev != null && ev.getSource() instanceof SoundButton) {
            SoundButton src = (SoundButton)ev.getSource();
            Object destLb = null;
            for (int i = 0; i < this.buttons.length; ++i) {
                if (src != this.buttons[i]) continue;
                EventSoundsElement evse = this.evs.createElement(i);
                evse.setFileName(src.getSoundName());
                this.updateDisplayFor(i);
                break;
            }
        }
    }

    protected void updateDisplayFor(int event) {
        EventSoundsElement evse = this.evs.getElement(event);
        boolean enabled = true;
        String msgKey = null;
        String msg = null;
        String fName = null;
        if (evse == null) {
            msgKey = "edit_evsounds_default";
        } else {
            boolean bl = enabled = evse.getEnabled() != 0;
            if (!enabled) {
                msgKey = "edit_evsounds_disabled";
            } else {
                fName = StrUtils.nullableString(evse.getFileName());
                if (fName == null) {
                    msgKey = "edit_evsounds_default";
                } else {
                    msg = fName;
                }
            }
        }
        if (msgKey != null) {
            msg = this.options.getMsg(msgKey);
        }
        this.txFields[event].setText(msg);
        this.buttons[event].setEnabled(enabled);
        this.buttons[event].setSoundName(fName);
        this.chkBoxes[event].setSelected(enabled);
    }

    public void setEventSounds(EventSounds evs) {
        this.evs = evs;
        if (this.evs == null) {
            this.evs = new EventSounds(null);
        }
        for (int i = 0; i < this.buttons.length; ++i) {
            this.updateDisplayFor(i);
        }
    }

    public EventSounds getEventSounds() {
        return this.evs;
    }

    public static EventSounds getEventSounds(EventSounds initialValue, Options options, Component parent, MediaBagEditor mbe) {
        EventSounds result = null;
        Messages msg = options.getMessages();
        EventSoundsEditorPanel evsed = dlgPanels.get(options);
        if (evsed == null) {
            evsed = new EventSoundsEditorPanel(options, mbe);
            dlgPanels.put(options, evsed);
        }
        evsed.setEventSounds((EventSounds)initialValue.clone());
        boolean b = msg.showInputDlg(parent, evsed, "edit_evsounds_dlg_title");
        if (b) {
            result = evsed.getEventSounds();
        }
        return result;
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        if (ev != null && ev.getSource() instanceof JCheckBox) {
            for (int i = 0; i < this.chkBoxes.length; ++i) {
                if (this.chkBoxes[i] != ev.getSource()) continue;
                EventSoundsElement evse = this.evs.createElement(i);
                evse.setEnabled(this.chkBoxes[i].isSelected() ? 2 : 0);
                this.updateDisplayFor(i);
                break;
            }
        }
    }
}

