/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.project;

import edu.xtec.jclic.bags.ActivityBagElement;
import edu.xtec.jclic.bags.ActivitySequenceElement;
import edu.xtec.jclic.bags.JumpInfo;
import edu.xtec.jclic.bags.MediaBagElement;
import edu.xtec.jclic.edit.Editable;
import edu.xtec.jclic.fileSystem.FileSystem;
import edu.xtec.jclic.fileSystem.FileZip;
import edu.xtec.jclic.project.JClicProject;
import edu.xtec.util.JDomUtility;
import edu.xtec.util.Options;
import edu.xtec.util.ResourceBridge;
import edu.xtec.util.StreamIO;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.JComponent;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.XMLOutputter;
import org.json.JSONObject;

public class ProjectFileUtils
implements ResourceBridge {
    FileSystem fileSystem;
    String fullFilePath;
    String projectName;
    String jclicFileName;
    String plainProjectName;
    String basePath;
    String relativePath;
    JClicProject project;
    public boolean isScorm;
    public static boolean interrupt = false;
    public static int NUM_ACTS = 0;
    public static int NUM_MEDIA = 1;
    public static int TOTAL_FILESIZE = 2;

    public ProjectFileUtils(String fileName, String basePath) throws Exception {
        boolean isZip;
        this.fullFilePath = new File(fileName).getCanonicalPath();
        this.isScorm = this.fullFilePath.endsWith(".scorm.zip");
        boolean bl = isZip = this.isScorm || this.fullFilePath.endsWith(".jclic.zip");
        if (!isZip && !this.fullFilePath.endsWith(".jclic")) {
            throw new Exception("File " + fileName + " is not a JClic project file!");
        }
        File fullFilePathFile = new File(this.fullFilePath);
        String fileBase = fullFilePathFile.getParent();
        this.basePath = basePath == null ? fileBase : basePath;
        this.relativePath = this.basePath.equals(fileBase) ? "" : fileBase.substring(this.basePath.length() + 1);
        this.fileSystem = FileSystem.createFileSystem(this.fullFilePath, this);
        String file = fullFilePathFile.getName();
        JSONObject json = null;
        if (isZip && !this.isScorm) {
            file = ((FileZip)this.fileSystem).getZipName();
            this.jclicFileName = file.substring(0, file.lastIndexOf("."));
            String[] projects = ((FileZip)this.fileSystem).getEntries(".jclic");
            if (projects == null) {
                throw new Exception("File " + this.fullFilePath + " does not contain any jclic project");
            }
            this.projectName = projects[0];
        } else if (this.isScorm) {
            if (this.fileSystem.fileExists("project.json")) {
                json = new JSONObject(new String(this.fileSystem.getBytes("project.json")));
                this.jclicFileName = this.projectName = json.optString("mainFile", null);
            }
            if (this.projectName == null) {
                throw new Exception("Invalid JClic SCORM file: " + this.fullFilePath);
            }
        } else {
            this.jclicFileName = this.projectName = file;
        }
        this.plainProjectName = FileSystem.getValidFileName(this.projectName.substring(0, this.projectName.lastIndexOf(".")));
        Document doc = this.fileSystem.getXMLDocument(this.projectName);
        this.project = JClicProject.getJClicProject(doc.getRootElement(), this, this.fileSystem, file);
        if (json != null) {
            this.project.readJSON(json, false);
        }
    }

    public void normalizeFileNames(PrintStream ps, Collection<String> fileList) throws InterruptedException {
        HashSet<String> currentNames = new HashSet<String>();
        Iterator<MediaBagElement> it = this.project.mediaBag.getElements().iterator();
        while (it.hasNext()) {
            boolean renamed = false;
            if (interrupt) {
                interrupt = false;
                throw new InterruptedException();
            }
            MediaBagElement mbe = it.next();
            String fn = mbe.getFileName();
            mbe.setMetaData(fn);
            String fnv = FileSystem.getValidFileName(fn);
            if (fnv.charAt(0) == '.') {
                fnv = "_" + fnv;
            }
            if (!fnv.equals(fn)) {
                String fn0 = fnv;
                int n = 0;
                while (currentNames.contains(fnv)) {
                    fnv = Integer.toString(n++) + fn0;
                }
                renamed = true;
            }
            if (fileList != null && fileList.contains(this.getRelativeFn(fnv))) {
                int p = fnv.lastIndexOf(".");
                fnv = fnv.substring(0, p) + "-" + this.plainProjectName + fnv.substring(p);
                renamed = true;
            }
            if (renamed && ps != null) {
                mbe.justSetFileName(fnv);
                ps.println("Renaming \"" + fn + "\" as \"" + fnv + "\"");
            }
            currentNames.add(fnv);
        }
    }

    public void avoidZipLinks(PrintStream ps) throws InterruptedException {
        for (ActivityBagElement activityBagElement : this.project.activityBag.getElements()) {
            if (interrupt) {
                interrupt = false;
                throw new InterruptedException();
            }
            this.avoidZipLinksInElement(activityBagElement.getData(), ps);
        }
        for (Editable editable : this.project.activitySequence.getElements()) {
            if (interrupt) {
                interrupt = false;
                throw new InterruptedException();
            }
            if (((ActivitySequenceElement)editable).fwdJump != null) {
                this.avoidZipLinksInJumpInfo(((ActivitySequenceElement)editable).fwdJump, ps);
                this.avoidZipLinksInJumpInfo(((ActivitySequenceElement)editable).fwdJump.upperJump, ps);
                this.avoidZipLinksInJumpInfo(((ActivitySequenceElement)editable).fwdJump.lowerJump, ps);
            }
            if (((ActivitySequenceElement)editable).backJump == null) continue;
            this.avoidZipLinksInJumpInfo(((ActivitySequenceElement)editable).backJump, ps);
            this.avoidZipLinksInJumpInfo(((ActivitySequenceElement)editable).backJump.upperJump, ps);
            this.avoidZipLinksInJumpInfo(((ActivitySequenceElement)editable).backJump.lowerJump, ps);
        }
    }

    public void avoidZipLinksInJumpInfo(JumpInfo ji, PrintStream ps) throws InterruptedException {
        if (ji != null && ji.projectPath != null && ji.projectPath.endsWith(".jclic.zip")) {
            String pv;
            String p = ji.projectPath;
            ji.projectPath = pv = p.substring(0, p.length() - 4);
            if (ps != null) {
                ps.println("Changing sequence link from \"" + p + "\" to \"" + pv + "\"");
            }
        }
    }

    public void avoidZipLinksInElement(Element el, PrintStream ps) throws InterruptedException {
        String attr;
        String p;
        if ((el.getAttribute("params") != null || el.getName().equals("menuElement") && el.getAttribute("path") != null) && (p = el.getAttributeValue(attr = el.getName().equals("menuElement") ? "path" : "params")) != null && p.endsWith(".jclic.zip")) {
            String pv = p.substring(0, p.length() - 4);
            if (ps != null) {
                ps.println("Changing media link from \"" + p + "\" to \"" + pv + "\"");
            }
            el.setAttribute(attr, pv);
        }
        Iterator it = el.getChildren().iterator();
        while (it.hasNext()) {
            if (interrupt) {
                interrupt = false;
                throw new InterruptedException();
            }
            this.avoidZipLinksInElement((Element)it.next(), ps);
        }
    }

    public String getRelativeFn(String fName) {
        return this.relativePath.length() > 0 ? this.relativePath + '/' + fName : fName;
    }

    public void saveTo(String path, Collection<String> fileList, PrintStream ps, long[] counters) throws Exception, InterruptedException {
        int n = NUM_ACTS;
        counters[n] = counters[n] + (long)this.project.activityBag.size();
        int n2 = NUM_MEDIA;
        counters[n2] = counters[n2] + (long)this.project.mediaBag.getElements().size();
        File outPath = new File(path);
        path = outPath.getCanonicalPath();
        if (!outPath.exists()) {
            outPath.mkdirs();
        }
        if (!outPath.isDirectory() || !outPath.canWrite()) {
            throw new Exception("Unable to write to: \"" + path + "\"");
        }
        Iterator<MediaBagElement> it = this.project.mediaBag.getElements().iterator();
        while (it.hasNext()) {
            if (interrupt) {
                interrupt = false;
                throw new InterruptedException();
            }
            MediaBagElement mbe = it.next();
            String fn = mbe.getMetaData();
            if (fn == null) {
                fn = mbe.getFileName();
            }
            InputStream is = this.fileSystem.getInputStream(fn);
            File outFile = new File(outPath, mbe.getFileName());
            FileOutputStream fos = new FileOutputStream(outFile);
            if (ps != null) {
                ps.println("Extracting " + fn + " to " + outFile.getCanonicalPath());
            }
            int n3 = TOTAL_FILESIZE;
            counters[n3] = counters[n3] + StreamIO.writeStreamTo(is, fos);
            if (fileList == null) continue;
            fileList.add(this.getRelativeFn(outFile.getName()));
        }
        Document doc = this.project.getDocument();
        File outFile = new File(outPath, this.jclicFileName);
        FileOutputStream fos = new FileOutputStream(outFile);
        if (ps != null) {
            ps.println("Saving project to: " + outFile.getCanonicalPath());
        }
        JDomUtility.saveDocument((OutputStream)fos, doc);
        int n4 = TOTAL_FILESIZE;
        counters[n4] = counters[n4] + fos.getChannel().size();
        fos.close();
        String jsFileName = this.jclicFileName + ".js";
        outFile = new File(outPath, jsFileName);
        fos = new FileOutputStream(outFile);
        PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)fos, "UTF-8"));
        if (ps != null) {
            ps.println("Saving project to: " + outFile.getCanonicalPath());
        }
        XMLOutputter xmlOutputter = new XMLOutputter();
        ByteArrayOutputStream bas = new ByteArrayOutputStream();
        xmlOutputter.output(doc, (OutputStream)bas);
        JSONObject json = new JSONObject();
        json.put("xml", bas.toString("UTF-8"));
        String sequence = json.toString();
        sequence = sequence.substring(8, sequence.length() - 2);
        pw.println("if(JClicObject){JClicObject.projectFiles[\"" + this.getRelativeFn(this.jclicFileName) + "\"]=\"" + sequence + "\";}");
        pw.flush();
        int n5 = TOTAL_FILESIZE;
        counters[n5] = counters[n5] + fos.getChannel().size();
        pw.close();
        if (fileList != null) {
            fileList.add(this.getRelativeFn(this.jclicFileName));
            fileList.add(this.getRelativeFn(jsFileName));
        }
        if (ps != null) {
            ps.println("Done processing: " + this.fullFilePath);
        }
    }

    public static void processSingleFile(String sourceFile, String destPath, Collection<String> fileList, PrintStream ps, long[] counters) throws Exception, InterruptedException {
        ProjectFileUtils.processSingleFile(sourceFile, destPath, null, fileList, ps, counters);
    }

    public static void processSingleFile(String sourceFile, String destPath, String basePath, Collection<String> fileList, PrintStream ps, long[] counters) throws Exception, InterruptedException {
        ProjectFileUtils prjFU = new ProjectFileUtils(sourceFile, basePath);
        prjFU.normalizeFileNames(ps, fileList);
        prjFU.avoidZipLinks(ps);
        prjFU.saveTo(destPath, fileList, ps, counters);
    }

    public static void processRootFolder(String sourcePath, String destPath, Collection<String> fileList, PrintStream ps, long[] counters) throws Exception, InterruptedException {
        String basePath = new File(sourcePath).getCanonicalPath();
        ProjectFileUtils.processFolder(sourcePath, destPath, basePath, fileList, ps, counters);
    }

    public static void processFolder(String sourcePath, String destPath, String basePath, Collection<String> fileList, PrintStream ps, long[] counters) throws Exception, InterruptedException {
        File[] subDirs;
        File[] jclicFiles;
        ArrayList<String> thisFolderList;
        File src = new File(sourcePath);
        ArrayList<String> arrayList = thisFolderList = fileList == null ? new ArrayList<String>() : fileList;
        if (!src.isDirectory() || !src.canRead()) {
            throw new Exception("Source directory \"" + sourcePath + "\" does not exist, not a directory or not readable");
        }
        if (ps != null) {
            ps.println("Writting all jclic.zip files in \"" + src.getCanonicalPath() + "\" to \"" + destPath + "\"");
        }
        File dest = new File(destPath);
        for (File f : jclicFiles = src.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                String lowerName = name.toLowerCase();
                return lowerName.endsWith(".jclic.zip") || lowerName.endsWith(".scorm.zip") || lowerName.endsWith(".jclic");
            }
        })) {
            if (interrupt) {
                interrupt = false;
                throw new InterruptedException();
            }
            if (ps != null) {
                ps.println("\nProcessing file: " + f.getAbsolutePath());
            }
            ProjectFileUtils.processSingleFile(f.getAbsolutePath(), dest.getAbsolutePath(), basePath, thisFolderList, ps, counters);
        }
        jclicFiles = null;
        System.gc();
        for (File f : subDirs = src.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return new File(dir, name).isDirectory();
            }
        })) {
            if (interrupt) {
                interrupt = false;
                throw new InterruptedException();
            }
            ProjectFileUtils.processFolder(new File(src, f.getName()).getCanonicalPath(), new File(dest, f.getName()).getCanonicalPath(), basePath, fileList, ps, counters);
        }
        subDirs = null;
        System.gc();
    }

    @Override
    public InputStream getProgressInputStream(InputStream is, int expectedLength, String name) {
        return is;
    }

    @Override
    public Options getOptions() {
        return null;
    }

    @Override
    public String getMsg(String key) {
        return key;
    }

    @Override
    public JComponent getComponent() {
        return null;
    }

    @Override
    public void displayUrl(String url, boolean inFrame) {
        throw new UnsupportedOperationException("Not supported");
    }
}

