/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.project;

import edu.xtec.jclic.fileSystem.FileSystem;
import edu.xtec.jclic.misc.Utils;
import edu.xtec.jclic.project.JClicProject;
import edu.xtec.jclic.project.ProjectInstaller;
import edu.xtec.util.JDomUtility;
import edu.xtec.util.Messages;
import edu.xtec.util.Options;
import edu.xtec.util.StrUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jdom.Document;

public class ProjectInstallerEditPanel
extends JPanel
implements ListSelectionListener,
ActionListener {
    Options options;
    DefaultListModel<Object> availModel;
    DefaultListModel<Object> filesModel;
    private String suggestedFileName;
    private JButton addBtn;
    private JTextField authFld;
    private JList<Object> availFiles;
    private JScrollPane availFilesSP;
    private JTextField descFld;
    private JTextField folderFld;
    private JTextField iconFld;
    private JList<Object> includedFiles;
    private JScrollPane includedFilesSP;
    private JTextField projectFld;
    private JButton removeBtn;
    private JTextField textFld;
    private JTextField titleFld;

    public ProjectInstallerEditPanel(Options options) {
        this.options = options;
        this.availModel = new DefaultListModel();
        this.filesModel = new DefaultListModel();
        this.initComponents();
        this.availFiles.addListSelectionListener(this);
        this.includedFiles.addListSelectionListener(this);
        this.addBtn.addActionListener(this);
        this.removeBtn.addActionListener(this);
        this.checkButtons();
    }

    private void initComponents() {
        JLabel titleLb = new JLabel();
        this.titleFld = new JTextField();
        JLabel authLb = new JLabel();
        this.authFld = new JTextField();
        JLabel folderLb = new JLabel();
        this.folderFld = new JTextField();
        JPanel filesPanel = new JPanel();
        this.availFilesSP = new JScrollPane();
        this.availFiles = new JList();
        this.addBtn = new JButton();
        this.removeBtn = new JButton();
        this.includedFilesSP = new JScrollPane();
        this.includedFiles = new JList();
        JPanel buttonPanel = new JPanel();
        JLabel projectLb = new JLabel();
        this.projectFld = new JTextField();
        JLabel txtLb = new JLabel();
        this.textFld = new JTextField();
        JLabel iconLb = new JLabel();
        this.iconFld = new JTextField();
        JLabel descLb = new JLabel();
        this.descFld = new JTextField();
        this.setLayout(new GridBagLayout());
        titleLb.setLabelFor(this.titleFld);
        titleLb.setText(this.options.getMsg("installer_title"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)titleLb, gridBagConstraints);
        this.titleFld.setToolTipText(this.options.getMsg("installer_title_tooltip"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.titleFld, gridBagConstraints);
        authLb.setLabelFor(this.authFld);
        authLb.setText(this.options.getMsg("installer_authors"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)authLb, gridBagConstraints);
        this.authFld.setToolTipText(this.options.getMsg("installer_authors_tooltip"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.authFld, gridBagConstraints);
        folderLb.setLabelFor(this.folderFld);
        folderLb.setText(this.options.getMsg("installer_folder"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)folderLb, gridBagConstraints);
        this.folderFld.setToolTipText(this.options.getMsg("installer_folder_tooltip"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.folderFld, gridBagConstraints);
        filesPanel.setBorder(BorderFactory.createTitledBorder(this.options.getMsg("installer_files")));
        filesPanel.setToolTipText(this.options.getMsg("installer_files_tooltip"));
        filesPanel.setLayout(new GridBagLayout());
        this.availFilesSP.setPreferredSize(new Dimension(120, 100));
        this.availFiles.setModel(this.availModel);
        this.availFiles.setToolTipText(this.options.getMsg("installer_files_available"));
        this.availFilesSP.setViewportView(this.availFiles);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        filesPanel.add((Component)this.availFilesSP, gridBagConstraints);
        this.addBtn.setToolTipText(this.options.getMsg("installer_files_add_tooltip"));
        this.addBtn.setText(this.options.getMsg("installer_files_add"));
        this.addBtn.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        filesPanel.add((Component)this.addBtn, gridBagConstraints);
        this.removeBtn.setToolTipText(this.options.getMsg("installer_files_tooltip"));
        this.removeBtn.setText(this.options.getMsg("installer_files_remove"));
        this.removeBtn.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        filesPanel.add((Component)this.removeBtn, gridBagConstraints);
        this.includedFilesSP.setPreferredSize(new Dimension(120, 100));
        this.includedFiles.setModel(this.filesModel);
        this.includedFiles.setToolTipText(this.options.getMsg("installer_files_selected"));
        this.includedFilesSP.setViewportView(this.includedFiles);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        filesPanel.add((Component)this.includedFilesSP, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)filesPanel, gridBagConstraints);
        buttonPanel.setBorder(BorderFactory.createTitledBorder(this.options.getMsg("installer_button")));
        buttonPanel.setToolTipText(this.options.getMsg("installer_button_tooltip"));
        buttonPanel.setLayout(new GridBagLayout());
        projectLb.setLabelFor(this.projectFld);
        projectLb.setText(this.options.getMsg("installer_button_project"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        buttonPanel.add((Component)projectLb, gridBagConstraints);
        this.projectFld.setToolTipText(this.options.getMsg("installer_button_project_tooltip"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        buttonPanel.add((Component)this.projectFld, gridBagConstraints);
        txtLb.setLabelFor(this.textFld);
        txtLb.setText(this.options.getMsg("installer_button_text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        buttonPanel.add((Component)txtLb, gridBagConstraints);
        this.textFld.setToolTipText(this.options.getMsg("installer_button_text_tooltip"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        buttonPanel.add((Component)this.textFld, gridBagConstraints);
        iconLb.setLabelFor(this.iconFld);
        iconLb.setText(this.options.getMsg("installer_button_icon"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        buttonPanel.add((Component)iconLb, gridBagConstraints);
        this.iconFld.setToolTipText(this.options.getMsg("installer_button_icon_tooltip"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        buttonPanel.add((Component)this.iconFld, gridBagConstraints);
        descLb.setLabelFor(this.descFld);
        descLb.setText(this.options.getMsg("installer_button_description"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        buttonPanel.add((Component)descLb, gridBagConstraints);
        this.descFld.setToolTipText(this.options.getMsg("installer_button_description_tooltip"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        buttonPanel.add((Component)this.descFld, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)buttonPanel, gridBagConstraints);
    }

    public void setValues(JClicProject prj) {
        ProjectInstaller.IconItem ii;
        int i;
        File base;
        ProjectInstaller pi;
        block12: {
            this.suggestedFileName = null;
            pi = null;
            FileSystem fs = prj.getFileSystem();
            base = new File(FileSystem.sysFn(fs.getFullFileNamePath(null)));
            try {
                File[] files = base.listFiles(Utils.getFileFilter(7, this.options.getMessages()));
                if (files == null) break block12;
                for (i = 0; i < files.length; ++i) {
                    if (!files[i].isFile()) continue;
                    this.suggestedFileName = files[i].getName();
                    pi = ProjectInstaller.getProjectInstaller(fs.getFullFileNamePath(this.suggestedFileName));
                    break;
                }
            }
            catch (Exception ex) {
                System.err.println("Error reading installer: " + ex);
            }
        }
        if (this.suggestedFileName == null) {
            this.suggestedFileName = FileSystem.getValidFileName(prj.getName().trim()) + ".jclic.inst";
        }
        if (pi == null) {
            pi = new ProjectInstaller();
            pi.projectTitle = prj.settings.title;
            pi.baseFolder = base.getName();
            StringBuilder sb = new StringBuilder();
            if (prj.settings.authors != null) {
                for (i = 0; i < prj.settings.authors.length; ++i) {
                    if (i > 0) {
                        sb.append(", ");
                    }
                    sb.append(prj.settings.authors[i].name);
                }
            }
            pi.authors = sb.substring(0);
            String projectFileName = prj.getFullPath();
            projectFileName = projectFileName != null ? FileSystem.getFileNameOf(projectFileName) : prj.getName() + ".jclic.zip";
            pi.addFile(projectFileName);
            ii = pi.createIconItem();
            ii.project = projectFileName;
            ii.text = prj.settings.title;
            ii.icon = prj.settings.iconFileName;
        }
        this.titleFld.setText(StrUtils.secureString(pi.projectTitle));
        this.authFld.setText(StrUtils.secureString(pi.authors));
        this.folderFld.setText(StrUtils.secureString(pi.baseFolder));
        this.availModel.removeAllElements();
        ArrayList<String> v = new ArrayList<String>();
        FileSystem.exploreFiles(null, base, v, '/', null, 3, 300);
        for (String v1 : v) {
            this.availModel.addElement(v1);
        }
        this.filesModel.removeAllElements();
        for (int i2 = 0; i2 < pi.files.size(); ++i2) {
            String s = pi.getFile(i2);
            if (this.availModel.contains(s)) {
                this.availModel.removeElement(s);
            }
            this.filesModel.addElement(s);
        }
        ii = pi.getIconItem(0);
        if (ii != null) {
            this.projectFld.setText(StrUtils.secureString(ii.project));
            this.textFld.setText(StrUtils.secureString(ii.text));
            this.iconFld.setText(StrUtils.secureString(ii.icon));
            this.descFld.setText(StrUtils.secureString(ii.description));
        }
        this.checkButtons();
    }

    private void checkButtons() {
        this.addBtn.setEnabled(!this.availFiles.isSelectionEmpty());
        this.removeBtn.setEnabled(!this.includedFiles.isSelectionEmpty());
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (!e.getValueIsAdjusting()) {
            this.checkButtons();
        }
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        if (ev != null && ev.getSource() != null) {
            DefaultListModel<Object> src = null;
            DefaultListModel<Object> dest = null;
            JList<Object> list = null;
            if (ev.getSource() == this.addBtn) {
                src = this.availModel;
                dest = this.filesModel;
                list = this.availFiles;
            } else if (ev.getSource() == this.removeBtn) {
                dest = this.availModel;
                src = this.filesModel;
                list = this.includedFiles;
            }
            if (dest != null && src != null & list != null) {
                Object[] values = list.getSelectedValuesList().toArray();
                if (values != null) {
                    for (int i = 0; i < values.length; ++i) {
                        src.removeElement(values[i]);
                        dest.addElement(values[i]);
                    }
                }
                this.checkButtons();
            }
        }
    }

    public ProjectInstaller getProjectInstaller(Component parent) {
        ProjectInstaller result = new ProjectInstaller();
        String errorKey = null;
        result.projectTitle = StrUtils.nullableString(this.titleFld.getText());
        result.authors = StrUtils.nullableString(this.authFld.getText());
        result.baseFolder = StrUtils.nullableString(this.folderFld.getText());
        int numFiles = this.filesModel.getSize();
        for (int i = 0; i < numFiles; ++i) {
            result.addFile((String)this.filesModel.get(i));
        }
        ProjectInstaller.IconItem ii = result.createIconItem();
        ii.project = StrUtils.nullableString(this.projectFld.getText());
        ii.text = StrUtils.nullableString(this.textFld.getText());
        ii.icon = StrUtils.nullableString(this.iconFld.getText());
        ii.description = StrUtils.nullableString(this.descFld.getText());
        if (result.projectTitle == null) {
            errorKey = "noTitle";
        } else if (result.baseFolder == null) {
            errorKey = "noBaseFolder";
        } else if (numFiles == 0) {
            errorKey = "noFilesSelected";
        } else if (ii.project == null) {
            errorKey = "noProjectSelected";
        } else if (ii.text == null) {
            errorKey = "noButtonText";
        } else if (!result.files.contains(ii.project)) {
            errorKey = "projectNotInFiles";
        }
        if (errorKey != null) {
            this.options.getMessages().showErrorWarning(parent, "installer_error_" + errorKey, null);
        }
        return errorKey != null ? null : result;
    }

    public static void createInstaller(JClicProject prj, Component parent) {
        Options options = prj.getBridge().getOptions();
        Messages msg = options.getMessages();
        ProjectInstallerEditPanel panel = new ProjectInstallerEditPanel(options);
        panel.setValues(prj);
        boolean exit = false;
        while (!exit) {
            if (msg.showInputDlg(parent, panel, "installer_caption")) {
                ProjectInstaller result = panel.getProjectInstaller(parent);
                if (result == null) continue;
                int[] filters = new int[]{7};
                FileSystem fs = prj.getFileSystem();
                String fileName = fs.chooseFile(panel.suggestedFileName, true, filters, options, null, parent, false);
                if (fileName != null) {
                    try {
                        FileOutputStream fos = fs.createSecureFileOutputStream(fileName, false);
                        JDomUtility.saveDocument((OutputStream)fos, new Document(result.getJDomElement(false)));
                        fos.close();
                        exit = true;
                    }
                    catch (Exception ex) {
                        options.getMessages().showErrorWarning(parent, null, ex);
                    }
                    continue;
                }
                exit = true;
                continue;
            }
            exit = true;
        }
    }
}

