/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.project;

import edu.xtec.jclic.bags.MediaBagEditor;
import edu.xtec.jclic.beans.EventSoundsButton;
import edu.xtec.jclic.beans.ImgButton;
import edu.xtec.jclic.beans.RollPanel;
import edu.xtec.jclic.beans.TextListEditor;
import edu.xtec.jclic.edit.Editor;
import edu.xtec.jclic.edit.EditorPanel;
import edu.xtec.jclic.media.EventSounds;
import edu.xtec.jclic.project.Author;
import edu.xtec.jclic.project.AuthorEditPanel;
import edu.xtec.jclic.project.JClicProjectEditor;
import edu.xtec.jclic.project.Organization;
import edu.xtec.jclic.project.OrganizationEditPanel;
import edu.xtec.jclic.project.ProjectSettings;
import edu.xtec.jclic.project.ProjectSettingsEditor;
import edu.xtec.jclic.project.Revision;
import edu.xtec.jclic.project.RevisionEditPanel;
import edu.xtec.jclic.skins.Skin;
import edu.xtec.util.Messages;
import edu.xtec.util.Options;
import edu.xtec.util.StrUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;

public class ProjectSettingsEditorPanel
extends EditorPanel {
    private JTextPane[] descPanels;
    private Locale[] meta_langs = new Locale[0];
    private JCheckBox[] levelChkBoxes;
    private JCheckBox[] areaChkBoxes;
    private static JScrollPane langListPanel;
    private static JList<String> langList;
    private AuthorEditPanel authorEditPanel;
    private OrganizationEditPanel organizationEditPanel;
    private RevisionEditPanel revisionEditPanel;
    private JButton addBtn;
    private JTextField areaText;
    private JCheckBox areas_div;
    private JCheckBox areas_ef;
    private JCheckBox areas_exp;
    private JCheckBox areas_lleng;
    private JCheckBox areas_mat;
    private JCheckBox areas_mus;
    private JCheckBox areas_soc;
    private JCheckBox areas_tec;
    private JCheckBox areas_vip;
    private RollPanel authPanel;
    private TextListEditor authorListEditor;
    private ImgButton coverButton;
    private RollPanel coverPanel;
    private RollPanel descPanel;
    private RollPanel descrPanel;
    private JTextField descriptorsText;
    private EventSoundsButton evSoundsBtn;
    private ImgButton icon16Button;
    private ImgButton icon192Button;
    private ImgButton icon72Button;
    private JPanel imgPanel1;
    private JPanel imgPanel2;
    private TextListEditor langListEditor;
    private JTextField levelText;
    private JCheckBox levels_BTX;
    private JCheckBox levels_INF;
    private JCheckBox levels_PRI;
    private JCheckBox levels_SEC;
    private JComboBox licenseCombo;
    private JPanel mainPanel;
    private TextListEditor orgListEditor;
    private JButton removeBtn;
    private TextListEditor revListEditor;
    private JScrollPane scroll;
    private JComboBox skinCombo;
    private JTabbedPane tabDesc;
    private ImgButton thumbButton;
    private JTextField titleText;
    private RollPanel uiPanel;

    public ProjectSettingsEditorPanel(Options options) {
        super(options);
        this.initComponents();
        this.levelChkBoxes = new JCheckBox[]{this.levels_INF, this.levels_PRI, this.levels_SEC, this.levels_BTX};
        this.areaChkBoxes = new JCheckBox[]{this.areas_lleng, this.areas_mat, this.areas_soc, this.areas_exp, this.areas_mus, this.areas_vip, this.areas_ef, this.areas_tec, this.areas_div};
        this.listenButtonActions(this.levelChkBoxes);
        this.listenButtonActions(this.areaChkBoxes);
        this.evSoundsBtn.setOptions(options);
        this.postInit(250, false, false);
        this.setEnabled(false);
    }

    private void initComponents() {
        this.scroll = new JScrollPane();
        this.scroll.getVerticalScrollBar().setUnitIncrement(16);
        this.mainPanel = new JPanel();
        this.descrPanel = new RollPanel();
        JLabel titleLb = new JLabel();
        this.titleText = new JTextField();
        JLabel descLb = new JLabel();
        this.tabDesc = new JTabbedPane();
        this.addBtn = new JButton();
        this.removeBtn = new JButton();
        this.coverPanel = new RollPanel();
        this.imgPanel1 = new JPanel();
        JLabel coverLb = new JLabel();
        this.coverButton = new ImgButton();
        this.coverButton.setOptions(this.options);
        JLabel thumbLb = new JLabel();
        this.thumbButton = new ImgButton();
        this.thumbButton.setOptions(this.options);
        this.imgPanel2 = new JPanel();
        JLabel icon16Lb = new JLabel();
        this.icon16Button = new ImgButton();
        this.icon16Button.setOptions(this.options);
        JLabel icon72Lb = new JLabel();
        this.icon72Button = new ImgButton();
        this.icon72Button.setOptions(this.options);
        JLabel icon192Lb = new JLabel();
        this.icon192Button = new ImgButton();
        this.icon192Button.setOptions(this.options);
        this.authPanel = new RollPanel();
        JLabel authorLb = new JLabel();
        this.authorListEditor = new TextListEditor(this.options){

            @Override
            protected Object editItem(Object currentValue, boolean newValue) {
                return ProjectSettingsEditorPanel.this.editAuthor(currentValue, newValue);
            }
        };
        JLabel orgLb = new JLabel();
        this.orgListEditor = new TextListEditor(this.options){

            @Override
            protected Object editItem(Object currentValue, boolean newValue) {
                return ProjectSettingsEditorPanel.this.editOrg(currentValue, newValue);
            }
        };
        JLabel revLb = new JLabel();
        this.revListEditor = new TextListEditor(this.options){

            @Override
            protected Object editItem(Object currentValue, boolean newValue) {
                return ProjectSettingsEditorPanel.this.editRevision(currentValue, newValue);
            }
        };
        JLabel licenseLb = new JLabel();
        this.licenseCombo = new JComboBox<String>(ProjectSettings.getLicensesList(this.options.getMsg("settings_license_other")));
        this.licenseCombo.setSelectedIndex(ProjectSettings.CC_BY_NC_SA);
        this.descPanel = new RollPanel();
        JLabel langLb = new JLabel();
        this.langListEditor = new TextListEditor(this.options){

            @Override
            protected Object editItem(Object currentValue, boolean newValue) {
                return ProjectSettingsEditorPanel.this.editLanguage(currentValue, newValue);
            }
        };
        JLabel levelLb = new JLabel();
        this.levels_INF = new JCheckBox();
        this.levels_PRI = new JCheckBox();
        this.levels_SEC = new JCheckBox();
        this.levels_BTX = new JCheckBox();
        JLabel levelOtherLb = new JLabel();
        this.levelText = new JTextField();
        JLabel areaLb = new JLabel();
        this.areas_lleng = new JCheckBox();
        this.areas_mat = new JCheckBox();
        this.areas_soc = new JCheckBox();
        this.areas_exp = new JCheckBox();
        this.areas_mus = new JCheckBox();
        this.areas_vip = new JCheckBox();
        this.areas_ef = new JCheckBox();
        this.areas_tec = new JCheckBox();
        this.areas_div = new JCheckBox();
        JLabel areaOtherLb = new JLabel();
        this.areaText = new JTextField();
        JLabel descriptorslLb = new JLabel();
        this.descriptorsText = new JTextField();
        this.uiPanel = new RollPanel();
        JLabel skinLb = new JLabel();
        this.skinCombo = new JComboBox<String>(Skin.getSystemSkinList(false));
        this.skinCombo.setSelectedItem(null);
        JLabel evSoundsLb = new JLabel();
        this.evSoundsBtn = new EventSoundsButton();
        JLabel spacer = new JLabel();
        this.setLayout(new BorderLayout());
        this.mainPanel.setLayout(new GridBagLayout());
        this.descrPanel.setTitle(this.options.getMsg("edit_project_description_block"));
        this.descrPanel.getMainPanel().setLayout(new GridBagLayout());
        titleLb.setLabelFor(this.titleText);
        titleLb.setText(this.options.getMsg("edit_project_title"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.descrPanel.getMainPanel().add((Component)titleLb, gridBagConstraints);
        this.titleText.setToolTipText(this.options.getMsg("edit_project_title_tooltip"));
        this.titleText.setPreferredSize(new Dimension(500, 21));
        this.titleText.getDocument().addDocumentListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.descrPanel.getMainPanel().add((Component)this.titleText, gridBagConstraints);
        descLb.setText(this.options.getMsg("edit_project_description"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.descrPanel.getMainPanel().add((Component)descLb, gridBagConstraints);
        this.tabDesc.setToolTipText(this.options.getMsg("edit_project_description_tooltip"));
        this.tabDesc.setPreferredSize(new Dimension(500, 200));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.descrPanel.getMainPanel().add((Component)this.tabDesc, gridBagConstraints);
        this.addBtn.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/plus16.gif")));
        this.addBtn.setToolTipText(this.options == null ? "" : this.options.getMsg("edit_list_newElement_tooltip"));
        this.addBtn.setMargin(new Insets(0, 0, 0, 0));
        this.addBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectSettingsEditorPanel.this.addBtnActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.insets = new Insets(3, 3, 3, 0);
        this.descrPanel.getMainPanel().add((Component)this.addBtn, gridBagConstraints);
        this.removeBtn.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/minus16.gif")));
        this.removeBtn.setToolTipText(this.options == null ? "" : this.options.getMsg("edit_list_deleteElement_tooltip"));
        this.removeBtn.setEnabled(false);
        this.removeBtn.setMargin(new Insets(0, 0, 0, 0));
        this.removeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectSettingsEditorPanel.this.removeBtnActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.descrPanel.getMainPanel().add((Component)this.removeBtn, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.mainPanel.add((Component)this.descrPanel, gridBagConstraints);
        this.coverPanel.setTitle(this.options.getMsg("edit_project_images_block"));
        this.coverPanel.getMainPanel().setLayout(new FlowLayout(3, 0, 0));
        this.imgPanel1.setFocusable(false);
        this.imgPanel1.setLayout(new GridBagLayout());
        coverLb.setLabelFor(this.coverButton);
        coverLb.setText(this.options.getMsg("edit_project_cover"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.imgPanel1.add((Component)coverLb, gridBagConstraints);
        this.coverButton.setToolTipText(this.options.getMsg("edit_project_cover_tooltip"));
        this.coverButton.addPropertyChangeListener("imageName", this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 30);
        this.imgPanel1.add((Component)this.coverButton, gridBagConstraints);
        thumbLb.setLabelFor(this.thumbButton);
        thumbLb.setText(this.options.getMsg("edit_project_thumb"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.imgPanel1.add((Component)thumbLb, gridBagConstraints);
        this.thumbButton.setToolTipText(this.options.getMsg("edit_project_thumb_tooltip"));
        this.thumbButton.addPropertyChangeListener("imageName", this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 30, 3);
        this.imgPanel1.add((Component)this.thumbButton, gridBagConstraints);
        this.coverPanel.getMainPanel().add(this.imgPanel1);
        this.imgPanel2.setLayout(new GridBagLayout());
        icon16Lb.setLabelFor(this.icon16Button);
        icon16Lb.setText(this.options.getMsg("edit_project_icon16"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.imgPanel2.add((Component)icon16Lb, gridBagConstraints);
        this.icon16Button.setToolTipText(this.options.getMsg("edit_project_icons_tooltip"));
        this.icon16Button.addPropertyChangeListener("imageName", this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.imgPanel2.add((Component)this.icon16Button, gridBagConstraints);
        icon72Lb.setLabelFor(this.icon72Button);
        icon72Lb.setText(this.options.getMsg("edit_project_icon72"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.imgPanel2.add((Component)icon72Lb, gridBagConstraints);
        this.icon72Button.setToolTipText(this.options.getMsg("edit_project_icons_tooltip"));
        this.icon72Button.addPropertyChangeListener("imageName", this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.imgPanel2.add((Component)this.icon72Button, gridBagConstraints);
        icon192Lb.setLabelFor(this.icon192Button);
        icon192Lb.setText(this.options.getMsg("edit_project_icon192"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.imgPanel2.add((Component)icon192Lb, gridBagConstraints);
        this.icon192Button.setToolTipText(this.options.getMsg("edit_project_icons_tooltip"));
        this.icon192Button.addPropertyChangeListener("imageName", this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.imgPanel2.add((Component)this.icon192Button, gridBagConstraints);
        this.coverPanel.getMainPanel().add(this.imgPanel2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.mainPanel.add((Component)this.coverPanel, gridBagConstraints);
        this.authPanel.setTitle(this.options.getMsg("edit_project_author_group"));
        this.authPanel.getMainPanel().setLayout(new GridBagLayout());
        authorLb.setLabelFor(this.authorListEditor);
        authorLb.setText(this.options.getMsg("edit_project_authors"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.authPanel.getMainPanel().add((Component)authorLb, gridBagConstraints);
        this.authorListEditor.setToolTipText(this.options.getMsg("edit_project_authors_tooltip"));
        this.authorListEditor.setPreferredSize(new Dimension(500, 80));
        this.authorListEditor.addPropertyChangeListener("list", this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.authPanel.getMainPanel().add((Component)this.authorListEditor, gridBagConstraints);
        orgLb.setLabelFor(this.orgListEditor);
        orgLb.setText(this.options.getMsg("edit_project_org"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.authPanel.getMainPanel().add((Component)orgLb, gridBagConstraints);
        this.orgListEditor.setToolTipText(this.options.getMsg("edit_project_org_tooltip"));
        this.orgListEditor.setPreferredSize(new Dimension(500, 80));
        this.orgListEditor.addPropertyChangeListener("list", this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        this.authPanel.getMainPanel().add((Component)this.orgListEditor, gridBagConstraints);
        revLb.setLabelFor(this.revListEditor);
        revLb.setText(this.options.getMsg("edit_project_rev"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.authPanel.getMainPanel().add((Component)revLb, gridBagConstraints);
        this.revListEditor.setToolTipText(this.options.getMsg("edit_project_rev_tooltip"));
        this.revListEditor.setPreferredSize(new Dimension(500, 80));
        this.revListEditor.addPropertyChangeListener("list", this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        this.authPanel.getMainPanel().add((Component)this.revListEditor, gridBagConstraints);
        licenseLb.setLabelFor(this.licenseCombo);
        licenseLb.setText(this.options.getMsg("settings_license"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.authPanel.getMainPanel().add((Component)licenseLb, gridBagConstraints);
        this.licenseCombo.setToolTipText(this.options.getMsg("settings_license_tooltip"));
        this.licenseCombo.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.authPanel.getMainPanel().add((Component)this.licenseCombo, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.mainPanel.add((Component)this.authPanel, gridBagConstraints);
        this.descPanel.setTitle(this.options.getMsg("edit_project_descriptors_block"));
        this.descPanel.getMainPanel().setLayout(new GridBagLayout());
        langLb.setLabelFor(this.langListEditor);
        langLb.setText(this.options.getMsg("edit_project_languages"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.descPanel.getMainPanel().add((Component)langLb, gridBagConstraints);
        this.langListEditor.setToolTipText(this.options.getMsg("edit_project_languages_tooltip"));
        this.langListEditor.setPreferredSize(new Dimension(200, 80));
        this.langListEditor.addPropertyChangeListener("list", this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        this.descPanel.getMainPanel().add((Component)this.langListEditor, gridBagConstraints);
        levelLb.setText(this.options.getMsg("edit_project_level"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.descPanel.getMainPanel().add((Component)levelLb, gridBagConstraints);
        this.levels_INF.setText(this.options.getMsg("levels_INF"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        this.descPanel.getMainPanel().add((Component)this.levels_INF, gridBagConstraints);
        this.levels_PRI.setText(this.options.getMsg("levels_PRI"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        this.descPanel.getMainPanel().add((Component)this.levels_PRI, gridBagConstraints);
        this.levels_SEC.setText(this.options.getMsg("levels_SEC"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        this.descPanel.getMainPanel().add((Component)this.levels_SEC, gridBagConstraints);
        this.levels_BTX.setText(this.options.getMsg("levels_BTX"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        this.descPanel.getMainPanel().add((Component)this.levels_BTX, gridBagConstraints);
        levelOtherLb.setLabelFor(this.levelText);
        levelOtherLb.setText(this.options.getMsg("levels_other"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 10, 3);
        this.descPanel.getMainPanel().add((Component)levelOtherLb, gridBagConstraints);
        this.levelText.setToolTipText(this.options.getMsg("edit_project_level_tooltip"));
        this.levelText.setPreferredSize(new Dimension(300, 21));
        this.levelText.getDocument().addDocumentListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 10, 3);
        this.descPanel.getMainPanel().add((Component)this.levelText, gridBagConstraints);
        areaLb.setText(this.options.getMsg("edit_project_area"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.descPanel.getMainPanel().add((Component)areaLb, gridBagConstraints);
        this.areas_lleng.setText(this.options.getMsg("areas_lleng"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.anchor = 17;
        this.descPanel.getMainPanel().add((Component)this.areas_lleng, gridBagConstraints);
        this.areas_mat.setText(this.options.getMsg("areas_mat"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        this.descPanel.getMainPanel().add((Component)this.areas_mat, gridBagConstraints);
        this.areas_soc.setText(this.options.getMsg("areas_soc"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.anchor = 17;
        this.descPanel.getMainPanel().add((Component)this.areas_soc, gridBagConstraints);
        this.areas_exp.setText(this.options.getMsg("areas_exp"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        this.descPanel.getMainPanel().add((Component)this.areas_exp, gridBagConstraints);
        this.areas_mus.setText(this.options.getMsg("areas_mus"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.anchor = 17;
        this.descPanel.getMainPanel().add((Component)this.areas_mus, gridBagConstraints);
        this.areas_vip.setText(this.options.getMsg("areas_vip"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        this.descPanel.getMainPanel().add((Component)this.areas_vip, gridBagConstraints);
        this.areas_ef.setText(this.options.getMsg("areas_ef"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.anchor = 17;
        this.descPanel.getMainPanel().add((Component)this.areas_ef, gridBagConstraints);
        this.areas_tec.setText(this.options.getMsg("areas_tec"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        this.descPanel.getMainPanel().add((Component)this.areas_tec, gridBagConstraints);
        this.areas_div.setText(this.options.getMsg("areas_div"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        this.descPanel.getMainPanel().add((Component)this.areas_div, gridBagConstraints);
        areaOtherLb.setLabelFor(this.areaText);
        areaOtherLb.setText(this.options.getMsg("areas_other"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 10, 3);
        this.descPanel.getMainPanel().add((Component)areaOtherLb, gridBagConstraints);
        this.areaText.setToolTipText(this.options.getMsg("edit_project_area_tooltip"));
        this.areaText.setPreferredSize(new Dimension(300, 21));
        this.areaText.getDocument().addDocumentListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 10, 3);
        this.descPanel.getMainPanel().add((Component)this.areaText, gridBagConstraints);
        descriptorslLb.setLabelFor(this.descriptorsText);
        descriptorslLb.setText(this.options.getMsg("edit_project_descriptors"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 10, 3);
        this.descPanel.getMainPanel().add((Component)descriptorslLb, gridBagConstraints);
        this.descriptorsText.setToolTipText(this.options.getMsg("edit_project_descriptors_tooltip"));
        this.descriptorsText.setPreferredSize(new Dimension(500, 21));
        this.descriptorsText.getDocument().addDocumentListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 10, 3);
        this.descPanel.getMainPanel().add((Component)this.descriptorsText, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.mainPanel.add((Component)this.descPanel, gridBagConstraints);
        this.uiPanel.setTitle(this.options.getMsg("edit_project_ui_block"));
        this.uiPanel.getMainPanel().setLayout(new GridBagLayout());
        skinLb.setLabelFor(this.skinCombo);
        skinLb.setText(this.options.getMsg("settings_skin"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.uiPanel.getMainPanel().add((Component)skinLb, gridBagConstraints);
        this.skinCombo.setEditable(true);
        this.skinCombo.setToolTipText(this.options.getMsg("settings_skin_tooltip"));
        this.skinCombo.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.uiPanel.getMainPanel().add((Component)this.skinCombo, gridBagConstraints);
        evSoundsLb.setLabelFor(this.revListEditor);
        evSoundsLb.setText(this.options.getMsg("edit_project_evsounds"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.uiPanel.getMainPanel().add((Component)evSoundsLb, gridBagConstraints);
        this.evSoundsBtn.setToolTipText(this.options.getMsg("edit_project_evsounds_tooltip"));
        this.evSoundsBtn.addPropertyChangeListener("eventSounds", this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.uiPanel.getMainPanel().add((Component)this.evSoundsBtn, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.mainPanel.add((Component)this.uiPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.weighty = 1.0;
        this.mainPanel.add((Component)spacer, gridBagConstraints);
        this.scroll.setViewportView(this.mainPanel);
        this.add((Component)this.scroll, "Center");
    }

    private void addBtnActionPerformed(ActionEvent evt) {
        String lang = (String)this.editLanguage(null, true);
        if (lang != null) {
            lang = Messages.getLanguageFromDescriptive(lang);
            Locale loc = Locale.forLanguageTag(lang);
            Locale[] ml = Arrays.copyOf(this.meta_langs, this.meta_langs.length + 1);
            for (Locale meta_lang : this.meta_langs) {
                if (!meta_lang.equals(loc)) continue;
                this.options.getMessages().showAlert((Component)this, "edit_project_languages_already_selected");
                return;
            }
            ml[this.meta_langs.length] = loc;
            this.meta_langs = ml;
            this.addDescTab("");
        }
    }

    private void removeBtnActionPerformed(ActionEvent evt) {
        if (this.meta_langs.length > 1) {
            int p = this.tabDesc.getSelectedIndex();
            if (this.options.getMessages().showQuestionDlg(this, "edit_project_languages_confirm_delete", this.meta_langs[p].getDisplayName(), "yn") == 1) {
                this.tabDesc.remove(p);
                Locale[] ml = new Locale[this.meta_langs.length - 1];
                int c = 0;
                for (int i = 0; i < this.meta_langs.length; ++i) {
                    if (i == p) continue;
                    ml[c++] = this.meta_langs[i];
                }
                this.checkEnabled();
            }
        }
    }

    @Override
    public boolean checkIfEditorValid(Editor e) {
        return e instanceof ProjectSettingsEditor;
    }

    protected ProjectSettingsEditor getProjectSettingsEditor() {
        return (ProjectSettingsEditor)this.getEditor();
    }

    protected ProjectSettings getProjectSettings() {
        ProjectSettings result = null;
        ProjectSettingsEditor pse = this.getProjectSettingsEditor();
        if (pse != null) {
            result = pse.getProjectSettings();
        }
        return result;
    }

    @Override
    protected void fillData() {
        int i;
        MediaBagEditor mbe;
        ProjectSettings ps = this.getProjectSettings();
        JClicProjectEditor prjed = ps == null ? null : this.getProjectSettingsEditor().getProjectEditor();
        MediaBagEditor mediaBagEditor = mbe = prjed == null ? null : prjed.getMediaBagEditor();
        if (prjed != null) {
            this.evSoundsBtn.setMediaBagEditor(mbe);
        }
        this.evSoundsBtn.setEventSounds(ps == null ? null : ps.eventSounds);
        this.coverButton.setMediaBagEditor(mbe);
        this.coverButton.setImgName(ps == null ? null : ps.coverFileName);
        this.thumbButton.setMediaBagEditor(mbe);
        this.thumbButton.setImgName(ps == null ? null : ps.thumbnailFileName);
        this.icon16Button.setMediaBagEditor(mbe);
        this.icon16Button.setImgName(ps == null ? null : ps.icon16);
        this.icon72Button.setMediaBagEditor(mbe);
        this.icon72Button.setImgName(ps == null ? null : ps.icon72);
        this.icon192Button.setMediaBagEditor(mbe);
        this.icon192Button.setImgName(ps == null ? null : ps.icon192);
        this.titleText.setText(ps == null || ps.title == null ? this.options.getMsg("UNNAMED") : ps.title);
        this.tabDesc.removeAll();
        this.descPanels = null;
        this.meta_langs = new Locale[0];
        if (ps != null) {
            this.meta_langs = new Locale[ps.meta_langs.length];
            this.descPanels = new JTextPane[ps.meta_langs.length];
            for (i = 0; i < this.meta_langs.length; ++i) {
                this.meta_langs[i] = ps.meta_langs[i];
                this.addDescTab(ps.descriptions[i]);
            }
        }
        for (i = 0; i < this.levelChkBoxes.length; ++i) {
            this.levelChkBoxes[i].setSelected(ps != null && ps.level_codes != null && ps.level_codes.contains(ProjectSettings.KNOWN_LEVEL_CODES[i]));
        }
        for (i = 0; i < this.areaChkBoxes.length; ++i) {
            this.areaChkBoxes[i].setSelected(ps != null && ps.area_codes != null && ps.area_codes.contains(ProjectSettings.KNOWN_AREA_CODES[i]));
        }
        this.areaText.setText(ps == null ? "" : StrUtils.secureString(ps.area));
        this.levelText.setText(ps == null ? "" : StrUtils.secureString(ps.level));
        this.descriptorsText.setText(ps == null ? "" : StrUtils.secureString(ps.descriptors));
        this.skinCombo.setSelectedItem(ps == null ? null : ps.skinFileName);
        this.licenseCombo.setSelectedIndex(ps == null ? ProjectSettings.CC_BY_NC_SA : ps.license);
        ArrayList<Object> v = new ArrayList<Object>();
        if (ps != null && ps.languages != null) {
            for (String language : ps.languages) {
                String code = (String)Messages.getNamesToCodes().get(language.toLowerCase());
                if (code != null) {
                    v.add(Messages.getDescriptiveLanguageCode(code));
                    continue;
                }
                v.add(language);
            }
        }
        this.langListEditor.setListData(v);
        v.clear();
        if (ps != null && ps.authors != null) {
            v.addAll(Arrays.asList(ps.authors));
        }
        this.authorListEditor.setListData(v);
        v.clear();
        if (ps != null && ps.organizations != null) {
            v.addAll(Arrays.asList(ps.organizations));
        }
        this.orgListEditor.setListData(v);
        v.clear();
        if (ps != null && ps.revisions != null) {
            v.addAll(Arrays.asList(ps.revisions));
        }
        this.revListEditor.setListData(v);
    }

    private void addDescTab(String text) {
        int i = this.tabDesc.getTabCount();
        if (i >= this.descPanels.length) {
            JTextPane[] dp = new JTextPane[this.descPanels.length + 1];
            for (int p = 0; p < this.descPanels.length; ++p) {
                dp[p] = this.descPanels[p];
            }
            this.descPanels = dp;
        }
        JScrollPane scr = new JScrollPane();
        this.descPanels[i] = new JTextPane();
        this.descPanels[i].setText(StrUtils.secureString(text));
        this.descPanels[i].getDocument().addDocumentListener(this);
        scr.setViewportView(this.descPanels[i]);
        scr.setHorizontalScrollBarPolicy(31);
        this.tabDesc.addTab(this.meta_langs[i].toLanguageTag(), scr);
        this.checkEnabled();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.evSoundsBtn.setEnabled(enabled);
        this.titleText.setEnabled(enabled);
        this.tabDesc.setEnabled(enabled);
        this.addBtn.setEnabled(enabled);
        this.removeBtn.setEnabled(enabled && this.meta_langs != null && this.meta_langs.length > 1);
        this.descriptorsText.setEnabled(enabled);
        this.skinCombo.setEnabled(enabled);
        this.licenseCombo.setEnabled(enabled);
        this.langListEditor.setEnabled(enabled);
        this.authorListEditor.setEnabled(enabled);
        this.orgListEditor.setEnabled(enabled);
        this.revListEditor.setEnabled(enabled);
        this.coverButton.setEnabled(enabled);
        this.thumbButton.setEnabled(enabled);
        this.icon16Button.setEnabled(enabled);
        this.icon72Button.setEnabled(enabled);
        this.icon192Button.setEnabled(enabled);
        for (JCheckBox check : this.levelChkBoxes) {
            check.setEnabled(enabled);
        }
        this.levelText.setEnabled(enabled);
        for (JCheckBox check : this.areaChkBoxes) {
            check.setEnabled(enabled);
        }
        this.areaText.setEnabled(enabled);
    }

    protected void checkEnabled() {
        this.removeBtn.setEnabled(this.meta_langs != null && this.meta_langs.length > 1);
    }

    @Override
    protected void saveData() {
        ProjectSettings ps = this.getProjectSettings();
        if (ps != null) {
            int i;
            ps.title = StrUtils.secureString(this.titleText.getText(), this.options.getMsg("UNNAMED"));
            ps.meta_langs = this.meta_langs;
            ps.descriptions = new String[this.meta_langs.length];
            for (int i2 = 0; i2 < this.meta_langs.length; ++i2) {
                ps.descriptions[i2] = this.descPanels[i2].getText();
            }
            ps.description = ps.descriptions[0];
            ps.coverFileName = this.coverButton.getImgName();
            ps.thumbnailFileName = this.thumbButton.getImgName();
            ps.icon16 = this.icon16Button.getImgName();
            ps.icon72 = this.icon72Button.getImgName();
            ps.icon192 = this.icon192Button.getImgName();
            List<Object> v = this.authorListEditor.getListData();
            ps.authors = v.toArray(new Author[v.size()]);
            v = this.orgListEditor.getListData();
            ps.organizations = v.toArray(new Organization[v.size()]);
            v = this.revListEditor.getListData();
            ps.revisions = v.toArray(new Revision[v.size()]);
            ps.level_codes = new ArrayList<String>();
            for (i = 0; i < this.levelChkBoxes.length; ++i) {
                if (!this.levelChkBoxes[i].isSelected()) continue;
                ps.level_codes.add(ProjectSettings.KNOWN_LEVEL_CODES[i]);
            }
            ps.level = StrUtils.nullableString(this.levelText.getText());
            ps.area_codes = new ArrayList<String>();
            for (i = 0; i < this.areaChkBoxes.length; ++i) {
                if (!this.areaChkBoxes[i].isSelected()) continue;
                ps.area_codes.add(ProjectSettings.KNOWN_AREA_CODES[i]);
            }
            ps.area = StrUtils.nullableString(this.areaText.getText());
            ps.descriptors = StrUtils.nullableString(this.descriptorsText.getText());
            String[] langs = this.langListEditor.getTextList();
            ps.languages = new String[langs.length];
            for (int i3 = 0; i3 < langs.length; ++i3) {
                String ln = langs[i3];
                int p = ln.length();
                if (p > 5) {
                    String code = ln.substring(p - 3, p - 1);
                    ln = (String)Messages.getNamesToCodes().get(code);
                }
                ps.languages[i3] = ln == null ? langs[i3] : ln;
            }
            ps.skinFileName = StrUtils.nullableString(this.skinCombo.getSelectedItem());
            ps.license = this.licenseCombo.getSelectedIndex();
            EventSounds evs = this.evSoundsBtn.getEventSounds();
            ps.eventSounds = evs == null ? new EventSounds(null) : evs;
        }
    }

    private Object editLanguage(final Object currentValue, boolean newValue) {
        if (langList == null || langListPanel == null) {
            langList = new JList<String>(this.options.getMessages().getDescriptiveLanguageCodes());
            langListPanel = new JScrollPane(langList);
        }
        String result = null;
        if (!newValue && currentValue != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    langList.setSelectedValue(currentValue, true);
                }
            });
        } else {
            langList.setSelectedIndex(-1);
        }
        if (this.options.getMessages().showInputDlg((Component)this, new String[]{"edit_project_languages_select"}, null, new JComponent[]{langListPanel}, newValue ? "edit_project_languages_add" : "edit_project_languages_modify")) {
            result = langList.getSelectedValue();
        }
        return result;
    }

    private Object editAuthor(Object currentValue, boolean newValue) {
        Author result = null;
        if (this.authorEditPanel == null) {
            this.authorEditPanel = new AuthorEditPanel(this.options);
        }
        if (newValue) {
            currentValue = null;
        }
        this.authorEditPanel.setAuthor((Author)currentValue);
        if (this.options.getMessages().showInputDlg((Component)this, new String[]{"edit_project_author_info"}, null, new JComponent[]{this.authorEditPanel}, newValue ? "edit_project_author_add" : "edit_project_author_edit")) {
            result = this.authorEditPanel.getAuthor();
            if (result.name.length() < 1) {
                result = null;
            }
        }
        return result;
    }

    private Object editOrg(Object currentValue, boolean newValue) {
        Organization result = null;
        if (this.organizationEditPanel == null) {
            this.organizationEditPanel = new OrganizationEditPanel(this.options);
        }
        if (newValue) {
            currentValue = null;
        }
        this.organizationEditPanel.setOrganization((Organization)currentValue);
        if (this.options.getMessages().showInputDlg((Component)this, new String[]{"edit_project_org_info"}, null, new JComponent[]{this.organizationEditPanel}, newValue ? "edit_project_org_add" : "edit_project_org_edit")) {
            result = this.organizationEditPanel.getOrganization();
            if (result.name.length() < 1) {
                result = null;
            }
        }
        return result;
    }

    private Object editRevision(Object currentValue, boolean newValue) {
        Revision result = null;
        if (this.revisionEditPanel == null) {
            this.revisionEditPanel = new RevisionEditPanel(this.options);
        }
        if (newValue) {
            currentValue = null;
        }
        this.revisionEditPanel.setRevision((Revision)currentValue);
        if (this.options.getMessages().showInputDlg((Component)this, new String[]{"edit_project_rev_info"}, null, new JComponent[]{this.revisionEditPanel}, newValue ? "edit_project_rev_add" : "edit_project_rev_edit") && (result = this.revisionEditPanel.getRevision()) != null && result.description.length() < 1) {
            result = null;
        }
        return result;
    }
}

