/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.shapers;

import edu.xtec.jclic.shapers.EditableShape;
import edu.xtec.jclic.shapers.EditableShapeConstants;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class EditableLine2D
extends Line2D.Double
implements EditableShape {
    private boolean selected = false;
    private int border = 0;
    private int selectedBorder = -1;

    public EditableLine2D(double x1, double y1, double x2, double y2) {
        super(x1, y1, x2, y2);
    }

    public EditableLine2D(Point2D p1, Point2D p2) {
        super(p1, p2);
    }

    @Override
    public boolean isSelected() {
        return this.selected;
    }

    @Override
    public void drawBorders(Graphics g) {
        g.drawRect((int)this.x1 - EditableShapeConstants.selectLength / 2, (int)this.y1 - EditableShapeConstants.selectLength / 2, EditableShapeConstants.selectLength, EditableShapeConstants.selectLength);
        g.drawRect((int)this.x2 - EditableShapeConstants.selectLength / 2, (int)this.y2 - EditableShapeConstants.selectLength / 2, EditableShapeConstants.selectLength, EditableShapeConstants.selectLength);
        g.setColor(EditableShapeConstants.SELECTED_BORDER_COLOR);
        if (this.selectedBorder == 1) {
            g.fillRect((int)this.x1 - EditableShapeConstants.selectLength / 2, (int)this.y1 - EditableShapeConstants.selectLength / 2, EditableShapeConstants.selectLength, EditableShapeConstants.selectLength);
        } else if (this.selectedBorder == 2) {
            g.fillRect((int)this.x2 - EditableShapeConstants.selectLength / 2, (int)this.y2 - EditableShapeConstants.selectLength / 2, EditableShapeConstants.selectLength, EditableShapeConstants.selectLength);
        }
    }

    @Override
    public boolean hasClickedBorder(double x, double y, boolean needSelected) {
        boolean hasClicked = false;
        if (!needSelected || this.selected) {
            Rectangle r1 = new Rectangle((int)this.x1 - EditableShapeConstants.selectLength / 2, (int)this.y1 - EditableShapeConstants.selectLength / 2, EditableShapeConstants.selectLength, EditableShapeConstants.selectLength);
            Rectangle r2 = new Rectangle((int)this.x2 - EditableShapeConstants.selectLength / 2, (int)this.y2 - EditableShapeConstants.selectLength / 2, EditableShapeConstants.selectLength, EditableShapeConstants.selectLength);
            if (r1.contains(x, y)) {
                this.border = 1;
                hasClicked = true;
            } else if (r2.contains(x, y)) {
                this.border = 2;
                hasClicked = true;
            }
        }
        return hasClicked;
    }

    @Override
    public void aproximateNearestBorder(double x, double y) {
        if (this.getP1().distance(x, y) < this.getP2().distance(x, y)) {
            this.x1 = x;
            this.y1 = y;
        } else {
            this.x2 = x;
            this.y2 = y;
        }
    }

    @Override
    public Point2D getNearestBorder(double x, double y) {
        return this.getP1().distance(x, y) < this.getP2().distance(x, y) ? this.getP1() : this.getP2();
    }

    @Override
    public void setSelected(boolean b) {
        this.selected = b;
    }

    @Override
    public void paintWithColor(Graphics g, int drawingMode, Color c) {
        g.setColor(EditableShapeConstants.BORDER_COLOR);
        this.drawBorders(g);
        if (this.selected && drawingMode != 2) {
            this.paintSelection(g);
        } else if (drawingMode == 4) {
            g.setColor(Color.red);
            this.drawBorders(g);
            g.setColor(c);
        } else {
            g.setColor(c);
        }
        g.drawLine((int)this.getX1(), (int)this.getY1(), (int)this.getX2(), (int)this.getY2());
    }

    @Override
    public void paint(Graphics g, int drawingMode) {
        this.paintWithColor(g, drawingMode, EditableShapeConstants.defaultColor);
    }

    @Override
    public void paintSelection(Graphics g) {
        g.setColor(Color.black);
        this.drawBorders(g);
        g.setColor(EditableShapeConstants.selectedColor);
    }

    @Override
    public void changeBorder(double x, double y) {
        if (this.border == 1) {
            this.x1 = x;
            this.y1 = y;
        } else {
            this.x2 = x;
            this.y2 = y;
        }
    }

    @Override
    public double distanceTo(double x, double y) {
        return this.ptSegDist(x, y);
    }

    @Override
    public boolean isInto(Rectangle2D r) {
        return r.intersectsLine(this);
    }

    public void move(double incX, double incY) {
        this.x1 += incX;
        this.x2 += incX;
        this.y1 += incY;
        this.y2 += incY;
    }

    @Override
    public void transform(AffineTransform aTransf) {
        Point2D p1 = this.getP1();
        Point2D p2 = this.getP2();
        aTransf.transform(p1, p1);
        aTransf.transform(p2, p2);
        this.setLine(p1, p2);
    }

    @Override
    public EditableShape[] divide(double x, double y) {
        EditableShape[] newShapes = new EditableShape[2];
        Point2D.Double p = new Point2D.Double(x, y);
        newShapes[0] = new EditableLine2D(p, this.getP2());
        newShapes[1] = new EditableLine2D(this.getP1(), p);
        return newShapes;
    }

    @Override
    public boolean isAdjacentTo(Point2D p) {
        if (this.getP1().equals(p)) {
            return true;
        }
        if (this.getP2().equals(p)) {
            this.setLine(this.getP2(), this.getP1());
            return true;
        }
        return false;
    }

    @Override
    public Point2D getEndPoint() {
        return this.getP2();
    }

    @Override
    public Point2D getInitialPoint() {
        return this.getP1();
    }

    @Override
    public Object clone() {
        EditableLine2D el = new EditableLine2D(this.getInitialPoint(), this.getEndPoint());
        el.setSelected(this.isSelected());
        return el;
    }

    @Override
    public Point2D[] getBorders() {
        return new Point2D[]{this.getP1(), this.getP2()};
    }

    @Override
    public void selectBorder(double x, double y) {
        Point2D.Double p = new Point2D.Double(x, y);
        this.selectedBorder = this.getP1().equals(p) ? 1 : (this.getP2().equals(p) ? 2 : -1);
    }

    @Override
    public void deselectBorder() {
        this.selectedBorder = -1;
    }

    @Override
    public boolean hasSelectedBorder() {
        return this.selectedBorder != -1;
    }

    @Override
    public Point2D getNotSelectedBorder() {
        if (this.selectedBorder == 1) {
            return this.getP2();
        }
        return this.getP1();
    }
}

