/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.util;

import edu.xtec.jclic.fileSystem.FileSystem;
import edu.xtec.util.JDomTreeObject;
import edu.xtec.util.JDomUtility;
import edu.xtec.util.ResourceBridge;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.text.JTextComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Text;

public class JDomTreePanel
extends JPanel {
    ResourceBridge rb;
    TreeSelectionListener treeSelectionListener;
    ListSelectionListener listSelectionListener;
    JDomTreeObject current;
    DefaultMutableTreeNode currentNode;
    FileSystem fs;
    String fileName;
    Element element;
    private DefaultMutableTreeNode clip;
    private boolean cut;
    private JButton copyBtn;
    private JButton cutBtn;
    private JButton delAttributeBtn;
    private JButton delElementBtn;
    private JButton newAttributeBtn;
    private JButton newElementBtn;
    private JButton pasteBtn;
    private JButton saveBtn;
    private JTable table;
    private JTree tree;

    public JDomTreePanel(Element element, ResourceBridge rb, FileSystem fs, String fileName) {
        this.rb = rb;
        this.fs = fs;
        this.fileName = fileName;
        this.element = element;
        this.initComponents();
        this.initMembers();
        this.tree.setModel(new DefaultTreeModel(JDomTreeObject.processNode(null, element, rb.getOptions())));
        this.tree.addTreeSelectionListener(this.treeSelectionListener);
        this.table.getSelectionModel().addListSelectionListener(this.listSelectionListener);
    }

    private void initMembers() {
        this.treeSelectionListener = new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                JDomTreePanel.this.checkEnabled();
            }
        };
        this.listSelectionListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    JDomTreePanel.this.delAttributeBtn.setEnabled(e.getFirstIndex() >= 0);
                }
            }
        };
    }

    private void checkEnabled() {
        this.current = null;
        this.currentNode = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        if (this.currentNode == null) {
            this.newElementBtn.setEnabled(false);
            this.delElementBtn.setEnabled(false);
            this.copyBtn.setEnabled(false);
            this.cutBtn.setEnabled(false);
            this.pasteBtn.setEnabled(false);
        } else {
            this.current = (JDomTreeObject)this.currentNode.getUserObject();
            this.setTableModel();
            String s = this.current.getElement().getText();
            boolean empty = s == null || s.length() == 0;
            boolean root = this.current.getElement().isRootElement();
            this.newElementBtn.setEnabled(empty);
            this.delElementBtn.setEnabled(!root);
            this.copyBtn.setEnabled(!root);
            this.cutBtn.setEnabled(!root);
            this.pasteBtn.setEnabled(this.clip != null && empty && this.clip != this.currentNode && !this.clip.isNodeChild(this.currentNode));
        }
    }

    private void setTableModel() {
        AbstractTableModel model = this.current;
        if (model == null) {
            model = new DefaultTableModel();
        }
        this.table.setModel(model);
        model.fireTableStructureChanged();
        this.newAttributeBtn.setEnabled(this.current != null);
        this.delAttributeBtn.setEnabled(false);
    }

    private void initComponents() {
        JSplitPane split = new JSplitPane();
        JPanel treePanel = new JPanel();
        JScrollPane treeScroll = new JScrollPane();
        this.tree = new JTree();
        JPanel treeButtonsPanel = new JPanel();
        this.newElementBtn = new JButton();
        this.delElementBtn = new JButton();
        this.copyBtn = new JButton();
        this.pasteBtn = new JButton();
        this.cutBtn = new JButton();
        this.saveBtn = new JButton();
        JPanel tablePanel = new JPanel();
        JScrollPane tableScroll = new JScrollPane();
        this.table = new JTable();
        JPanel buttonsPanel = new JPanel();
        this.newAttributeBtn = new JButton();
        this.delAttributeBtn = new JButton();
        this.setLayout(new BorderLayout());
        treePanel.setLayout(new BorderLayout());
        treeScroll.setMinimumSize(new Dimension(150, 22));
        treeScroll.setViewportView(this.tree);
        treePanel.add((Component)treeScroll, "Center");
        this.newElementBtn.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/new_element.gif")));
        this.newElementBtn.setToolTipText(this.rb.getMsg("XML_NEW_ELEMENT"));
        this.newElementBtn.setEnabled(false);
        this.newElementBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JDomTreePanel.this.newElementBtnActionPerformed(evt);
            }
        });
        treeButtonsPanel.add(this.newElementBtn);
        this.delElementBtn.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/delete.gif")));
        this.delElementBtn.setToolTipText(this.rb.getMsg("XML_DEL_ELEMENT"));
        this.delElementBtn.setEnabled(false);
        this.delElementBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JDomTreePanel.this.delElementBtnActionPerformed(evt);
            }
        });
        treeButtonsPanel.add(this.delElementBtn);
        this.copyBtn.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/copy.gif")));
        this.copyBtn.setToolTipText(this.rb.getMsg("COPY"));
        this.copyBtn.setEnabled(false);
        this.copyBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JDomTreePanel.this.copyBtnActionPerformed(evt);
            }
        });
        treeButtonsPanel.add(this.copyBtn);
        this.pasteBtn.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/paste.gif")));
        this.pasteBtn.setToolTipText(this.rb.getMsg("PASTE"));
        this.pasteBtn.setEnabled(false);
        this.pasteBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JDomTreePanel.this.pasteBtnActionPerformed(evt);
            }
        });
        treeButtonsPanel.add(this.pasteBtn);
        this.cutBtn.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/cut.gif")));
        this.cutBtn.setToolTipText(this.rb.getMsg("CUT"));
        this.cutBtn.setEnabled(false);
        this.cutBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JDomTreePanel.this.cutBtnActionPerformed(evt);
            }
        });
        treeButtonsPanel.add(this.cutBtn);
        this.saveBtn.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/file_save.gif")));
        this.saveBtn.setToolTipText(this.rb.getMsg("FILE_SAVE"));
        this.saveBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JDomTreePanel.this.saveBtnActionPerformed(evt);
            }
        });
        treeButtonsPanel.add(this.saveBtn);
        treePanel.add((Component)treeButtonsPanel, "South");
        split.setLeftComponent(treePanel);
        tablePanel.setLayout(new BorderLayout());
        this.table.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        tableScroll.setViewportView(this.table);
        tablePanel.add((Component)tableScroll, "Center");
        this.newAttributeBtn.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/new_attribute.gif")));
        this.newAttributeBtn.setToolTipText(this.rb.getMsg("XML_NEW_ATTRIBUTE"));
        this.newAttributeBtn.setEnabled(false);
        this.newAttributeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JDomTreePanel.this.newAttributeBtnActionPerformed(evt);
            }
        });
        buttonsPanel.add(this.newAttributeBtn);
        this.delAttributeBtn.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/delete.gif")));
        this.delAttributeBtn.setToolTipText(this.rb.getMsg("XML_DEL_ATTRIBUTE"));
        this.delAttributeBtn.setEnabled(false);
        this.delAttributeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JDomTreePanel.this.delAttributeBtnActionPerformed(evt);
            }
        });
        buttonsPanel.add(this.delAttributeBtn);
        tablePanel.add((Component)buttonsPanel, "South");
        split.setRightComponent(tablePanel);
        this.add((Component)split, "Center");
    }

    private void cutBtnActionPerformed(ActionEvent evt) {
        if (this.currentNode != null && this.current != null && !this.current.getElement().isRootElement()) {
            this.clip = this.currentNode;
            this.cut = true;
            this.checkEnabled();
        }
    }

    private void pasteBtnActionPerformed(ActionEvent evt) {
        if (this.currentNode != null && this.current != null && this.clip != null && this.clip != this.currentNode && !this.clip.isNodeChild(this.currentNode)) {
            Element clipElement = ((JDomTreeObject)this.clip.getUserObject()).getElement();
            Element el = (Element)clipElement.clone();
            this.current.getElement().addContent(el);
            DefaultMutableTreeNode node = JDomTreeObject.processNode(this.currentNode, el, this.rb.getOptions());
            ((DefaultTreeModel)this.tree.getModel()).nodeStructureChanged(this.currentNode);
            if (this.cut) {
                clipElement.detach();
                ((DefaultTreeModel)this.tree.getModel()).removeNodeFromParent(this.clip);
                this.clip = null;
            }
            this.setTableModel();
            this.checkEnabled();
        }
    }

    private void copyBtnActionPerformed(ActionEvent evt) {
        if (this.currentNode != null && this.current != null && !this.current.getElement().isRootElement()) {
            this.clip = this.currentNode;
            this.cut = false;
            this.checkEnabled();
        }
    }

    private void saveBtnActionPerformed(ActionEvent evt) {
        if (this.fs == null) {
            this.fs = new FileSystem(this.rb);
        }
        int[] filters = new int[]{0};
        String result = this.fs.chooseFile(this.fileName + ".jclic", true, filters, this.rb.getOptions(), null, this, false);
        if (result != null) {
            String fullFileName = this.fs.getFullFileNamePath(result);
            try {
                FileOutputStream fos = this.fs.createSecureFileOutputStream(fullFileName, false);
                JDomUtility.saveDocument((OutputStream)fos, new Document(this.element));
                fos.close();
            }
            catch (Exception ex) {
                this.rb.getOptions().getMessages().showErrorWarning((Component)this, "FILE_ERR_SAVING", fullFileName, ex, null);
            }
        }
    }

    private void delElementBtnActionPerformed(ActionEvent evt) {
        if (this.currentNode != null && this.current != null && !this.current.getElement().isRootElement()) {
            if (this.clip == this.currentNode) {
                this.clip = null;
            }
            this.current.getElement().detach();
            ((DefaultTreeModel)this.tree.getModel()).removeNodeFromParent(this.currentNode);
            this.setTableModel();
        }
    }

    private void newElementBtnActionPerformed(ActionEvent evt) {
        String s;
        if (this.currentNode != null && this.current != null && ((s = this.current.getElement().getText()) == null || s.length() == 0)) {
            String elementName;
            JComponent[] fields = new JTextField[]{new JTextField()};
            Dimension dim = new Dimension(100, 20);
            for (int i = 0; i < fields.length; ++i) {
                fields[i].setPreferredSize(dim);
            }
            String[] promptKeys = new String[]{"XML_NAME"};
            if (this.rb.getOptions().getMessages().showInputDlg((Component)this, null, promptKeys, fields, "XML_NEW_ELEMENT") && (elementName = ((JTextComponent)fields[0]).getText()) != null && elementName.length() > 0) {
                Element el = new Element(elementName);
                this.current.getElement().addContent(el);
                JDomTreeObject te = new JDomTreeObject(el, this.rb.getOptions());
                DefaultMutableTreeNode node = new DefaultMutableTreeNode(te);
                ((DefaultTreeModel)this.tree.getModel()).insertNodeInto(node, this.currentNode, this.currentNode.getChildCount());
                this.setTableModel();
            }
        }
    }

    private void delAttributeBtnActionPerformed(ActionEvent evt) {
        int r;
        if (this.current != null && (r = this.table.getSelectedRow()) >= 0) {
            if (r == 0) {
                ArrayList<Text> toRemove = new ArrayList<Text>();
                List ls = this.current.getElement().getContent();
                for (Object o : ls) {
                    if (!(o instanceof Text)) continue;
                    toRemove.add((Text)o);
                }
                ls.removeAll(toRemove);
            } else {
                String s = (String)this.current.getValueAt(r, 0);
                if (s != null) {
                    this.current.getElement().removeAttribute(s);
                }
            }
            this.setTableModel();
        }
    }

    private void newAttributeBtnActionPerformed(ActionEvent evt) {
        if (this.current != null) {
            JComponent[] fields = new JTextField[]{new JTextField(), new JTextField()};
            Dimension dim = new Dimension(100, 20);
            for (int i = 0; i < fields.length; ++i) {
                fields[i].setPreferredSize(dim);
            }
            String[] promptKeys = new String[]{"XML_ATTRIBUTE", "XML_VALUE"};
            if (this.rb.getOptions().getMessages().showInputDlg((Component)this, null, promptKeys, fields, "XML_NEW_ATTRIBUTE")) {
                String atrName = ((JTextComponent)fields[0]).getText();
                String atrValue = ((JTextComponent)fields[1]).getText();
                if (atrName != null && atrValue != null && atrName.length() > 0) {
                    this.current.getElement().setAttribute(atrName, atrValue);
                    this.setTableModel();
                }
            }
        }
    }

    public static Element editElement(Component parent, Element element, ResourceBridge rb, FileSystem fs, String fileName, String titleKey) {
        Element clon = (Element)element.clone();
        boolean b = rb.getOptions().getMessages().showInputDlg(parent, new JDomTreePanel(clon, rb, fs, fileName), titleKey);
        return b ? clon : null;
    }
}

