/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.util;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JComponent;

public class Resizer
implements MouseListener,
MouseMotionListener {
    JComponent jc;
    Rectangle r;
    Cursor defaultCursor;
    boolean doGetBounds;
    boolean dragging;
    boolean dragCursorX;
    boolean dragCursorY;
    ResizerListener rl;
    Dimension minSize;
    Dimension maxSize;
    boolean editable;
    boolean enabled;
    public static final int MARGIN = 5;

    public Resizer(JComponent jc, Rectangle r, boolean editable, ResizerListener rl) {
        this.jc = jc;
        this.setRect(r);
        this.editable = editable;
        if (editable) {
            this.defaultCursor = Cursor.getPredefinedCursor(12);
        }
        this.rl = rl;
        jc.addMouseListener(this);
        jc.addMouseMotionListener(this);
        this.minSize = new Dimension(10, 10);
        this.maxSize = new Dimension(jc.getPreferredSize());
        this.setEnabled(true);
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        this.jc.setCursor(this.defaultCursor);
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public void setMinSize(Dimension d) {
        this.minSize = d;
    }

    public void setMaxSize(Dimension d) {
        this.maxSize = d;
    }

    public void setRect(Rectangle r) {
        this.r = r;
        boolean bl = this.doGetBounds = r == null;
        if (this.doGetBounds) {
            this.r = this.jc.getBounds();
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.enabled && this.editable && this.rl != null && this.r.contains(mouseEvent.getPoint())) {
            this.rl.editObject(this.r, this.jc, mouseEvent.getPoint());
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.enabled && this.dragging) {
            this.resizeByDrag(mouseEvent.getPoint());
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        if (!this.dragging && this.enabled) {
            Point p = mouseEvent.getPoint();
            Cursor newCursor = this.defaultCursor;
            if (this.doGetBounds) {
                this.r = this.jc.getBounds();
            }
            this.dragCursorX = Math.abs(p.x - this.r.x - this.r.width) < 5 && p.y >= this.r.y && p.y < this.r.y + this.r.height + 5;
            boolean bl = this.dragCursorY = Math.abs(p.y - this.r.y - this.r.height) < 5 && p.x >= this.r.x && p.x < this.r.x + this.r.width + 5;
            if (this.dragCursorX && this.dragCursorY) {
                newCursor = Cursor.getPredefinedCursor(6);
            } else if (this.dragCursorY) {
                newCursor = Cursor.getPredefinedCursor(8);
            } else if (this.dragCursorX) {
                newCursor = Cursor.getPredefinedCursor(11);
            }
            this.jc.setCursor(newCursor);
        } else if (this.dragging) {
            this.mouseDragged(mouseEvent);
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (this.enabled && (this.dragCursorX || this.dragCursorY)) {
            this.dragging = true;
            this.resizeByDrag(mouseEvent.getPoint());
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.enabled && this.dragging) {
            this.resizeByDrag(mouseEvent.getPoint());
            this.dragging = false;
        }
    }

    private void resizeByDrag(Point p) {
        int w = this.r.width;
        int h = this.r.height;
        if (this.dragCursorX) {
            w = Math.min(this.maxSize.width, Math.max(this.minSize.width, p.x - this.r.x));
        }
        if (this.dragCursorY) {
            h = Math.min(this.maxSize.height, Math.max(this.minSize.height, p.y - this.r.y));
        }
        this.r = new Rectangle(this.r.x, this.r.y, w, h);
        if (this.rl != null) {
            this.rl.resizeObjectTo(this.r, this.jc);
        }
    }

    public JComponent getComponent() {
        return this.jc;
    }

    public static interface ResizerListener {
        public void resizeObjectTo(Rectangle var1, JComponent var2);

        public void editObject(Rectangle var1, JComponent var2, Point var3);
    }
}

