#! /bin/sh
# Generated by niminst

set -e

if [ $# -eq 1 ] ; then
  if test -f bin/nimrod
  then 
    echo "Nimrod build detected"
  else
    echo "Please build Nimrod before installing it"
    exit 1
  fi
  case $1 in
    "--help"|"-h"|"help"|"h")
      echo "Nimrod installation script"
      echo "Usage: [sudo] sh install.sh DIR"
      echo "Where DIR may be:"
      echo "  /usr/bin"
      echo "  /usr/local/bin"
      echo "  /opt"
      echo "  <some other dir> (treated like '/opt')"
      echo "To deinstall, use the command:"
      echo "sh deinstall.sh DIR"
      exit 1
      ;;
    "/usr/bin")
      bindir=/usr/bin
      configdir=/etc
      libdir=/usr/lib/nimrod
      docdir=/usr/share/nimrod/doc
      datadir=/usr/share/nimrod/data
      ;;
    "/usr/local/bin")
      bindir=/usr/local/bin
      configdir=/etc
      libdir=/usr/local/lib/nimrod
      docdir=/usr/local/share/nimrod/doc
      datadir=/usr/local/share/nimrod/data
      ;;
    *)
      bindir="$1/nimrod/bin"
      configdir="$1/nimrod/config"
      libdir="$1/nimrod/lib"
      docdir="$1/nimrod/doc"
      datadir="$1/nimrod/data"
      
      mkdir -p $1/nimrod
      mkdir -p $bindir
      mkdir -p $configdir
      ;;
  esac
  mkdir -p $libdir
  mkdir -p $docdir
  echo "copying files..."
  mkdir -p $libdir/system
  mkdir -p $libdir/core
  mkdir -p $libdir/pure
  mkdir -p $libdir/pure/collections
  mkdir -p $libdir/impure
  mkdir -p $libdir/wrappers
  mkdir -p $libdir/wrappers/cairo
  mkdir -p $libdir/wrappers/gtk
  mkdir -p $libdir/wrappers/lua
  mkdir -p $libdir/wrappers/opengl
  mkdir -p $libdir/wrappers/readline
  mkdir -p $libdir/wrappers/sdl
  mkdir -p $libdir/wrappers/x11
  mkdir -p $libdir/wrappers/zip
  mkdir -p $libdir/windows
  mkdir -p $libdir/posix
  mkdir -p $libdir/ecmas

  cp bin/nimrod $bindir/nimrod
  chmod 755 $bindir/nimrod
  cp config/nimrod.cfg $configdir/nimrod.cfg
  chmod 644 $configdir/nimrod.cfg
  cp config/nimdoc.cfg $configdir/nimdoc.cfg
  chmod 644 $configdir/nimdoc.cfg
  cp config/nimdoc.tex.cfg $configdir/nimdoc.tex.cfg
  chmod 644 $configdir/nimdoc.tex.cfg
  if [ -f doc/abstypes.txt ]; then
    cp doc/abstypes.txt $docdir/abstypes.txt
    chmod 644 $docdir/abstypes.txt
  fi
  if [ -f doc/advopt.txt ]; then
    cp doc/advopt.txt $docdir/advopt.txt
    chmod 644 $docdir/advopt.txt
  fi
  if [ -f doc/apis.txt ]; then
    cp doc/apis.txt $docdir/apis.txt
    chmod 644 $docdir/apis.txt
  fi
  if [ -f doc/astspec.txt ]; then
    cp doc/astspec.txt $docdir/astspec.txt
    chmod 644 $docdir/astspec.txt
  fi
  if [ -f doc/basicopt.txt ]; then
    cp doc/basicopt.txt $docdir/basicopt.txt
    chmod 644 $docdir/basicopt.txt
  fi
  if [ -f doc/c2nim.txt ]; then
    cp doc/c2nim.txt $docdir/c2nim.txt
    chmod 644 $docdir/c2nim.txt
  fi
  if [ -f doc/docs.txt ]; then
    cp doc/docs.txt $docdir/docs.txt
    chmod 644 $docdir/docs.txt
  fi
  if [ -f doc/effects.txt ]; then
    cp doc/effects.txt $docdir/effects.txt
    chmod 644 $docdir/effects.txt
  fi
  if [ -f doc/endb.txt ]; then
    cp doc/endb.txt $docdir/endb.txt
    chmod 644 $docdir/endb.txt
  fi
  if [ -f doc/estp.txt ]; then
    cp doc/estp.txt $docdir/estp.txt
    chmod 644 $docdir/estp.txt
  fi
  if [ -f doc/filelist.txt ]; then
    cp doc/filelist.txt $docdir/filelist.txt
    chmod 644 $docdir/filelist.txt
  fi
  if [ -f doc/filters.txt ]; then
    cp doc/filters.txt $docdir/filters.txt
    chmod 644 $docdir/filters.txt
  fi
  if [ -f doc/gc.txt ]; then
    cp doc/gc.txt $docdir/gc.txt
    chmod 644 $docdir/gc.txt
  fi
  if [ -f doc/grammar.txt ]; then
    cp doc/grammar.txt $docdir/grammar.txt
    chmod 644 $docdir/grammar.txt
  fi
  if [ -f doc/intern.txt ]; then
    cp doc/intern.txt $docdir/intern.txt
    chmod 644 $docdir/intern.txt
  fi
  if [ -f doc/keywords.txt ]; then
    cp doc/keywords.txt $docdir/keywords.txt
    chmod 644 $docdir/keywords.txt
  fi
  if [ -f doc/lib.txt ]; then
    cp doc/lib.txt $docdir/lib.txt
    chmod 644 $docdir/lib.txt
  fi
  if [ -f doc/manual.txt ]; then
    cp doc/manual.txt $docdir/manual.txt
    chmod 644 $docdir/manual.txt
  fi
  if [ -f doc/nimgrep.txt ]; then
    cp doc/nimgrep.txt $docdir/nimgrep.txt
    chmod 644 $docdir/nimgrep.txt
  fi
  if [ -f doc/niminst.txt ]; then
    cp doc/niminst.txt $docdir/niminst.txt
    chmod 644 $docdir/niminst.txt
  fi
  if [ -f doc/nimrodc.txt ]; then
    cp doc/nimrodc.txt $docdir/nimrodc.txt
    chmod 644 $docdir/nimrodc.txt
  fi
  if [ -f doc/overview.txt ]; then
    cp doc/overview.txt $docdir/overview.txt
    chmod 644 $docdir/overview.txt
  fi
  if [ -f doc/pegdocs.txt ]; then
    cp doc/pegdocs.txt $docdir/pegdocs.txt
    chmod 644 $docdir/pegdocs.txt
  fi
  if [ -f doc/readme.txt ]; then
    cp doc/readme.txt $docdir/readme.txt
    chmod 644 $docdir/readme.txt
  fi
  if [ -f doc/regexprs.txt ]; then
    cp doc/regexprs.txt $docdir/regexprs.txt
    chmod 644 $docdir/regexprs.txt
  fi
  if [ -f doc/rst.txt ]; then
    cp doc/rst.txt $docdir/rst.txt
    chmod 644 $docdir/rst.txt
  fi
  if [ -f doc/subexes.txt ]; then
    cp doc/subexes.txt $docdir/subexes.txt
    chmod 644 $docdir/subexes.txt
  fi
  if [ -f doc/tools.txt ]; then
    cp doc/tools.txt $docdir/tools.txt
    chmod 644 $docdir/tools.txt
  fi
  if [ -f doc/trmacros.txt ]; then
    cp doc/trmacros.txt $docdir/trmacros.txt
    chmod 644 $docdir/trmacros.txt
  fi
  if [ -f doc/tut1.txt ]; then
    cp doc/tut1.txt $docdir/tut1.txt
    chmod 644 $docdir/tut1.txt
  fi
  if [ -f doc/tut2.txt ]; then
    cp doc/tut2.txt $docdir/tut2.txt
    chmod 644 $docdir/tut2.txt
  fi
  if [ -f doc/actors.html ]; then
    cp doc/actors.html $docdir/actors.html
    chmod 644 $docdir/actors.html
  fi
  if [ -f doc/algorithm.html ]; then
    cp doc/algorithm.html $docdir/algorithm.html
    chmod 644 $docdir/algorithm.html
  fi
  if [ -f doc/apis.html ]; then
    cp doc/apis.html $docdir/apis.html
    chmod 644 $docdir/apis.html
  fi
  if [ -f doc/asyncio.html ]; then
    cp doc/asyncio.html $docdir/asyncio.html
    chmod 644 $docdir/asyncio.html
  fi
  if [ -f doc/base64.html ]; then
    cp doc/base64.html $docdir/base64.html
    chmod 644 $docdir/base64.html
  fi
  if [ -f doc/browsers.html ]; then
    cp doc/browsers.html $docdir/browsers.html
    chmod 644 $docdir/browsers.html
  fi
  if [ -f doc/c2nim.html ]; then
    cp doc/c2nim.html $docdir/c2nim.html
    chmod 644 $docdir/c2nim.html
  fi
  if [ -f doc/cgi.html ]; then
    cp doc/cgi.html $docdir/cgi.html
    chmod 644 $docdir/cgi.html
  fi
  if [ -f doc/channels.html ]; then
    cp doc/channels.html $docdir/channels.html
    chmod 644 $docdir/channels.html
  fi
  if [ -f doc/colors.html ]; then
    cp doc/colors.html $docdir/colors.html
    chmod 644 $docdir/colors.html
  fi
  if [ -f doc/complex.html ]; then
    cp doc/complex.html $docdir/complex.html
    chmod 644 $docdir/complex.html
  fi
  if [ -f doc/cookies.html ]; then
    cp doc/cookies.html $docdir/cookies.html
    chmod 644 $docdir/cookies.html
  fi
  if [ -f doc/critbits.html ]; then
    cp doc/critbits.html $docdir/critbits.html
    chmod 644 $docdir/critbits.html
  fi
  if [ -f doc/db_mongo.html ]; then
    cp doc/db_mongo.html $docdir/db_mongo.html
    chmod 644 $docdir/db_mongo.html
  fi
  if [ -f doc/db_mysql.html ]; then
    cp doc/db_mysql.html $docdir/db_mysql.html
    chmod 644 $docdir/db_mysql.html
  fi
  if [ -f doc/db_postgres.html ]; then
    cp doc/db_postgres.html $docdir/db_postgres.html
    chmod 644 $docdir/db_postgres.html
  fi
  if [ -f doc/db_sqlite.html ]; then
    cp doc/db_sqlite.html $docdir/db_sqlite.html
    chmod 644 $docdir/db_sqlite.html
  fi
  if [ -f doc/dom.html ]; then
    cp doc/dom.html $docdir/dom.html
    chmod 644 $docdir/dom.html
  fi
  if [ -f doc/dynlib.html ]; then
    cp doc/dynlib.html $docdir/dynlib.html
    chmod 644 $docdir/dynlib.html
  fi
  if [ -f doc/encodings.html ]; then
    cp doc/encodings.html $docdir/encodings.html
    chmod 644 $docdir/encodings.html
  fi
  if [ -f doc/endb.html ]; then
    cp doc/endb.html $docdir/endb.html
    chmod 644 $docdir/endb.html
  fi
  if [ -f doc/endians.html ]; then
    cp doc/endians.html $docdir/endians.html
    chmod 644 $docdir/endians.html
  fi
  if [ -f doc/estp.html ]; then
    cp doc/estp.html $docdir/estp.html
    chmod 644 $docdir/estp.html
  fi
  if [ -f doc/events.html ]; then
    cp doc/events.html $docdir/events.html
    chmod 644 $docdir/events.html
  fi
  if [ -f doc/filters.html ]; then
    cp doc/filters.html $docdir/filters.html
    chmod 644 $docdir/filters.html
  fi
  if [ -f doc/fsmonitor.html ]; then
    cp doc/fsmonitor.html $docdir/fsmonitor.html
    chmod 644 $docdir/fsmonitor.html
  fi
  if [ -f doc/ftpclient.html ]; then
    cp doc/ftpclient.html $docdir/ftpclient.html
    chmod 644 $docdir/ftpclient.html
  fi
  if [ -f doc/gc.html ]; then
    cp doc/gc.html $docdir/gc.html
    chmod 644 $docdir/gc.html
  fi
  if [ -f doc/graphics.html ]; then
    cp doc/graphics.html $docdir/graphics.html
    chmod 644 $docdir/graphics.html
  fi
  if [ -f doc/hashes.html ]; then
    cp doc/hashes.html $docdir/hashes.html
    chmod 644 $docdir/hashes.html
  fi
  if [ -f doc/htmlgen.html ]; then
    cp doc/htmlgen.html $docdir/htmlgen.html
    chmod 644 $docdir/htmlgen.html
  fi
  if [ -f doc/htmlparser.html ]; then
    cp doc/htmlparser.html $docdir/htmlparser.html
    chmod 644 $docdir/htmlparser.html
  fi
  if [ -f doc/httpclient.html ]; then
    cp doc/httpclient.html $docdir/httpclient.html
    chmod 644 $docdir/httpclient.html
  fi
  if [ -f doc/httpserver.html ]; then
    cp doc/httpserver.html $docdir/httpserver.html
    chmod 644 $docdir/httpserver.html
  fi
  if [ -f doc/intern.html ]; then
    cp doc/intern.html $docdir/intern.html
    chmod 644 $docdir/intern.html
  fi
  if [ -f doc/intsets.html ]; then
    cp doc/intsets.html $docdir/intsets.html
    chmod 644 $docdir/intsets.html
  fi
  if [ -f doc/irc.html ]; then
    cp doc/irc.html $docdir/irc.html
    chmod 644 $docdir/irc.html
  fi
  if [ -f doc/json.html ]; then
    cp doc/json.html $docdir/json.html
    chmod 644 $docdir/json.html
  fi
  if [ -f doc/lexbase.html ]; then
    cp doc/lexbase.html $docdir/lexbase.html
    chmod 644 $docdir/lexbase.html
  fi
  if [ -f doc/lib.html ]; then
    cp doc/lib.html $docdir/lib.html
    chmod 644 $docdir/lib.html
  fi
  if [ -f doc/lists.html ]; then
    cp doc/lists.html $docdir/lists.html
    chmod 644 $docdir/lists.html
  fi
  if [ -f doc/locks.html ]; then
    cp doc/locks.html $docdir/locks.html
    chmod 644 $docdir/locks.html
  fi
  if [ -f doc/macros.html ]; then
    cp doc/macros.html $docdir/macros.html
    chmod 644 $docdir/macros.html
  fi
  if [ -f doc/manual.html ]; then
    cp doc/manual.html $docdir/manual.html
    chmod 644 $docdir/manual.html
  fi
  if [ -f doc/marshal.html ]; then
    cp doc/marshal.html $docdir/marshal.html
    chmod 644 $docdir/marshal.html
  fi
  if [ -f doc/matchers.html ]; then
    cp doc/matchers.html $docdir/matchers.html
    chmod 644 $docdir/matchers.html
  fi
  if [ -f doc/math.html ]; then
    cp doc/math.html $docdir/math.html
    chmod 644 $docdir/math.html
  fi
  if [ -f doc/memfiles.html ]; then
    cp doc/memfiles.html $docdir/memfiles.html
    chmod 644 $docdir/memfiles.html
  fi
  if [ -f doc/mimetypes.html ]; then
    cp doc/mimetypes.html $docdir/mimetypes.html
    chmod 644 $docdir/mimetypes.html
  fi
  if [ -f doc/nimgrep.html ]; then
    cp doc/nimgrep.html $docdir/nimgrep.html
    chmod 644 $docdir/nimgrep.html
  fi
  if [ -f doc/niminst.html ]; then
    cp doc/niminst.html $docdir/niminst.html
    chmod 644 $docdir/niminst.html
  fi
  if [ -f doc/nimprof.html ]; then
    cp doc/nimprof.html $docdir/nimprof.html
    chmod 644 $docdir/nimprof.html
  fi
  if [ -f doc/nimrodc.html ]; then
    cp doc/nimrodc.html $docdir/nimrodc.html
    chmod 644 $docdir/nimrodc.html
  fi
  if [ -f doc/oids.html ]; then
    cp doc/oids.html $docdir/oids.html
    chmod 644 $docdir/oids.html
  fi
  if [ -f doc/os.html ]; then
    cp doc/os.html $docdir/os.html
    chmod 644 $docdir/os.html
  fi
  if [ -f doc/osproc.html ]; then
    cp doc/osproc.html $docdir/osproc.html
    chmod 644 $docdir/osproc.html
  fi
  if [ -f doc/overview.html ]; then
    cp doc/overview.html $docdir/overview.html
    chmod 644 $docdir/overview.html
  fi
  if [ -f doc/parsecfg.html ]; then
    cp doc/parsecfg.html $docdir/parsecfg.html
    chmod 644 $docdir/parsecfg.html
  fi
  if [ -f doc/parsecsv.html ]; then
    cp doc/parsecsv.html $docdir/parsecsv.html
    chmod 644 $docdir/parsecsv.html
  fi
  if [ -f doc/parseopt.html ]; then
    cp doc/parseopt.html $docdir/parseopt.html
    chmod 644 $docdir/parseopt.html
  fi
  if [ -f doc/parsesql.html ]; then
    cp doc/parsesql.html $docdir/parsesql.html
    chmod 644 $docdir/parsesql.html
  fi
  if [ -f doc/parseutils.html ]; then
    cp doc/parseutils.html $docdir/parseutils.html
    chmod 644 $docdir/parseutils.html
  fi
  if [ -f doc/parsexml.html ]; then
    cp doc/parsexml.html $docdir/parsexml.html
    chmod 644 $docdir/parsexml.html
  fi
  if [ -f doc/pegs.html ]; then
    cp doc/pegs.html $docdir/pegs.html
    chmod 644 $docdir/pegs.html
  fi
  if [ -f doc/queues.html ]; then
    cp doc/queues.html $docdir/queues.html
    chmod 644 $docdir/queues.html
  fi
  if [ -f doc/rdstdin.html ]; then
    cp doc/rdstdin.html $docdir/rdstdin.html
    chmod 644 $docdir/rdstdin.html
  fi
  if [ -f doc/re.html ]; then
    cp doc/re.html $docdir/re.html
    chmod 644 $docdir/re.html
  fi
  if [ -f doc/redis.html ]; then
    cp doc/redis.html $docdir/redis.html
    chmod 644 $docdir/redis.html
  fi
  if [ -f doc/ropes.html ]; then
    cp doc/ropes.html $docdir/ropes.html
    chmod 644 $docdir/ropes.html
  fi
  if [ -f doc/scgi.html ]; then
    cp doc/scgi.html $docdir/scgi.html
    chmod 644 $docdir/scgi.html
  fi
  if [ -f doc/sequtils.html ]; then
    cp doc/sequtils.html $docdir/sequtils.html
    chmod 644 $docdir/sequtils.html
  fi
  if [ -f doc/sets.html ]; then
    cp doc/sets.html $docdir/sets.html
    chmod 644 $docdir/sets.html
  fi
  if [ -f doc/smtp.html ]; then
    cp doc/smtp.html $docdir/smtp.html
    chmod 644 $docdir/smtp.html
  fi
  if [ -f doc/sockets.html ]; then
    cp doc/sockets.html $docdir/sockets.html
    chmod 644 $docdir/sockets.html
  fi
  if [ -f doc/sphinx.html ]; then
    cp doc/sphinx.html $docdir/sphinx.html
    chmod 644 $docdir/sphinx.html
  fi
  if [ -f doc/ssl.html ]; then
    cp doc/ssl.html $docdir/ssl.html
    chmod 644 $docdir/ssl.html
  fi
  if [ -f doc/streams.html ]; then
    cp doc/streams.html $docdir/streams.html
    chmod 644 $docdir/streams.html
  fi
  if [ -f doc/strtabs.html ]; then
    cp doc/strtabs.html $docdir/strtabs.html
    chmod 644 $docdir/strtabs.html
  fi
  if [ -f doc/strutils.html ]; then
    cp doc/strutils.html $docdir/strutils.html
    chmod 644 $docdir/strutils.html
  fi
  if [ -f doc/subexes.html ]; then
    cp doc/subexes.html $docdir/subexes.html
    chmod 644 $docdir/subexes.html
  fi
  if [ -f doc/system.html ]; then
    cp doc/system.html $docdir/system.html
    chmod 644 $docdir/system.html
  fi
  if [ -f doc/tables.html ]; then
    cp doc/tables.html $docdir/tables.html
    chmod 644 $docdir/tables.html
  fi
  if [ -f doc/terminal.html ]; then
    cp doc/terminal.html $docdir/terminal.html
    chmod 644 $docdir/terminal.html
  fi
  if [ -f doc/theindex.html ]; then
    cp doc/theindex.html $docdir/theindex.html
    chmod 644 $docdir/theindex.html
  fi
  if [ -f doc/threads.html ]; then
    cp doc/threads.html $docdir/threads.html
    chmod 644 $docdir/threads.html
  fi
  if [ -f doc/times.html ]; then
    cp doc/times.html $docdir/times.html
    chmod 644 $docdir/times.html
  fi
  if [ -f doc/tools.html ]; then
    cp doc/tools.html $docdir/tools.html
    chmod 644 $docdir/tools.html
  fi
  if [ -f doc/trmacros.html ]; then
    cp doc/trmacros.html $docdir/trmacros.html
    chmod 644 $docdir/trmacros.html
  fi
  if [ -f doc/tut1.html ]; then
    cp doc/tut1.html $docdir/tut1.html
    chmod 644 $docdir/tut1.html
  fi
  if [ -f doc/tut2.html ]; then
    cp doc/tut2.html $docdir/tut2.html
    chmod 644 $docdir/tut2.html
  fi
  if [ -f doc/typeinfo.html ]; then
    cp doc/typeinfo.html $docdir/typeinfo.html
    chmod 644 $docdir/typeinfo.html
  fi
  if [ -f doc/unicode.html ]; then
    cp doc/unicode.html $docdir/unicode.html
    chmod 644 $docdir/unicode.html
  fi
  if [ -f doc/unidecode.html ]; then
    cp doc/unidecode.html $docdir/unidecode.html
    chmod 644 $docdir/unidecode.html
  fi
  if [ -f doc/unsigned.html ]; then
    cp doc/unsigned.html $docdir/unsigned.html
    chmod 644 $docdir/unsigned.html
  fi
  if [ -f doc/uri.html ]; then
    cp doc/uri.html $docdir/uri.html
    chmod 644 $docdir/uri.html
  fi
  if [ -f doc/web.html ]; then
    cp doc/web.html $docdir/web.html
    chmod 644 $docdir/web.html
  fi
  if [ -f doc/xmldom.html ]; then
    cp doc/xmldom.html $docdir/xmldom.html
    chmod 644 $docdir/xmldom.html
  fi
  if [ -f doc/xmldomparser.html ]; then
    cp doc/xmldomparser.html $docdir/xmldomparser.html
    chmod 644 $docdir/xmldomparser.html
  fi
  if [ -f doc/xmlparser.html ]; then
    cp doc/xmlparser.html $docdir/xmlparser.html
    chmod 644 $docdir/xmlparser.html
  fi
  if [ -f doc/xmltree.html ]; then
    cp doc/xmltree.html $docdir/xmltree.html
    chmod 644 $docdir/xmltree.html
  fi
  if [ -f doc/zipfiles.html ]; then
    cp doc/zipfiles.html $docdir/zipfiles.html
    chmod 644 $docdir/zipfiles.html
  fi
  if [ -f doc/zmq.html ]; then
    cp doc/zmq.html $docdir/zmq.html
    chmod 644 $docdir/zmq.html
  fi
  if [ -f doc/mytest.cfg ]; then
    cp doc/mytest.cfg $docdir/mytest.cfg
    chmod 644 $docdir/mytest.cfg
  fi
  if [ -f doc/c2nim.pdf ]; then
    cp doc/c2nim.pdf $docdir/c2nim.pdf
    chmod 644 $docdir/c2nim.pdf
  fi
  if [ -f doc/gc.pdf ]; then
    cp doc/gc.pdf $docdir/gc.pdf
    chmod 644 $docdir/gc.pdf
  fi
  if [ -f doc/lib.pdf ]; then
    cp doc/lib.pdf $docdir/lib.pdf
    chmod 644 $docdir/lib.pdf
  fi
  if [ -f doc/manual.pdf ]; then
    cp doc/manual.pdf $docdir/manual.pdf
    chmod 644 $docdir/manual.pdf
  fi
  if [ -f doc/niminst.pdf ]; then
    cp doc/niminst.pdf $docdir/niminst.pdf
    chmod 644 $docdir/niminst.pdf
  fi
  if [ -f doc/nimrodc.pdf ]; then
    cp doc/nimrodc.pdf $docdir/nimrodc.pdf
    chmod 644 $docdir/nimrodc.pdf
  fi
  if [ -f doc/tut1.pdf ]; then
    cp doc/tut1.pdf $docdir/tut1.pdf
    chmod 644 $docdir/tut1.pdf
  fi
  if [ -f doc/tut2.pdf ]; then
    cp doc/tut2.pdf $docdir/tut2.pdf
    chmod 644 $docdir/tut2.pdf
  fi
  cp lib/nimbase.h $libdir/nimbase.h
  chmod 644 $libdir/nimbase.h
  cp lib/nimrtl.nim $libdir/nimrtl.nim
  chmod 644 $libdir/nimrtl.nim
  cp lib/prelude.nim $libdir/prelude.nim
  chmod 644 $libdir/prelude.nim
  cp lib/system.nim $libdir/system.nim
  chmod 644 $libdir/system.nim
  cp lib/nimrtl.nimrod.cfg $libdir/nimrtl.nimrod.cfg
  chmod 644 $libdir/nimrtl.nimrod.cfg
  cp lib/system/alloc.nim $libdir/system/alloc.nim
  chmod 644 $libdir/system/alloc.nim
  cp lib/system/ansi_c.nim $libdir/system/ansi_c.nim
  chmod 644 $libdir/system/ansi_c.nim
  cp lib/system/arithm.nim $libdir/system/arithm.nim
  chmod 644 $libdir/system/arithm.nim
  cp lib/system/assign.nim $libdir/system/assign.nim
  chmod 644 $libdir/system/assign.nim
  cp lib/system/atomics.nim $libdir/system/atomics.nim
  chmod 644 $libdir/system/atomics.nim
  cp lib/system/avltree.nim $libdir/system/avltree.nim
  chmod 644 $libdir/system/avltree.nim
  cp lib/system/cellsets.nim $libdir/system/cellsets.nim
  chmod 644 $libdir/system/cellsets.nim
  cp lib/system/cgprocs.nim $libdir/system/cgprocs.nim
  chmod 644 $libdir/system/cgprocs.nim
  cp lib/system/channels.nim $libdir/system/channels.nim
  chmod 644 $libdir/system/channels.nim
  cp lib/system/debugger.nim $libdir/system/debugger.nim
  chmod 644 $libdir/system/debugger.nim
  cp lib/system/dyncalls.nim $libdir/system/dyncalls.nim
  chmod 644 $libdir/system/dyncalls.nim
  cp lib/system/ecmasys.nim $libdir/system/ecmasys.nim
  chmod 644 $libdir/system/ecmasys.nim
  cp lib/system/embedded.nim $libdir/system/embedded.nim
  chmod 644 $libdir/system/embedded.nim
  cp lib/system/excpt.nim $libdir/system/excpt.nim
  chmod 644 $libdir/system/excpt.nim
  cp lib/system/gc.nim $libdir/system/gc.nim
  chmod 644 $libdir/system/gc.nim
  cp lib/system/hti.nim $libdir/system/hti.nim
  chmod 644 $libdir/system/hti.nim
  cp lib/system/inclrtl.nim $libdir/system/inclrtl.nim
  chmod 644 $libdir/system/inclrtl.nim
  cp lib/system/mmdisp.nim $libdir/system/mmdisp.nim
  chmod 644 $libdir/system/mmdisp.nim
  cp lib/system/profiler.nim $libdir/system/profiler.nim
  chmod 644 $libdir/system/profiler.nim
  cp lib/system/repr.nim $libdir/system/repr.nim
  chmod 644 $libdir/system/repr.nim
  cp lib/system/reprjs.nim $libdir/system/reprjs.nim
  chmod 644 $libdir/system/reprjs.nim
  cp lib/system/sets.nim $libdir/system/sets.nim
  chmod 644 $libdir/system/sets.nim
  cp lib/system/sysio.nim $libdir/system/sysio.nim
  chmod 644 $libdir/system/sysio.nim
  cp lib/system/syslocks.nim $libdir/system/syslocks.nim
  chmod 644 $libdir/system/syslocks.nim
  cp lib/system/sysstr.nim $libdir/system/sysstr.nim
  chmod 644 $libdir/system/sysstr.nim
  cp lib/system/threads.nim $libdir/system/threads.nim
  chmod 644 $libdir/system/threads.nim
  cp lib/system/timers.nim $libdir/system/timers.nim
  chmod 644 $libdir/system/timers.nim
  cp lib/system/widestrs.nim $libdir/system/widestrs.nim
  chmod 644 $libdir/system/widestrs.nim
  cp lib/core/locks.nim $libdir/core/locks.nim
  chmod 644 $libdir/core/locks.nim
  cp lib/core/macros.nim $libdir/core/macros.nim
  chmod 644 $libdir/core/macros.nim
  cp lib/core/typeinfo.nim $libdir/core/typeinfo.nim
  chmod 644 $libdir/core/typeinfo.nim
  cp lib/core/unsigned.nim $libdir/core/unsigned.nim
  chmod 644 $libdir/core/unsigned.nim
  cp lib/pure/actors.nim $libdir/pure/actors.nim
  chmod 644 $libdir/pure/actors.nim
  cp lib/pure/algorithm.nim $libdir/pure/algorithm.nim
  chmod 644 $libdir/pure/algorithm.nim
  cp lib/pure/asyncio.nim $libdir/pure/asyncio.nim
  chmod 644 $libdir/pure/asyncio.nim
  cp lib/pure/base64.nim $libdir/pure/base64.nim
  chmod 644 $libdir/pure/base64.nim
  cp lib/pure/browsers.nim $libdir/pure/browsers.nim
  chmod 644 $libdir/pure/browsers.nim
  cp lib/pure/cgi.nim $libdir/pure/cgi.nim
  chmod 644 $libdir/pure/cgi.nim
  cp lib/pure/colors.nim $libdir/pure/colors.nim
  chmod 644 $libdir/pure/colors.nim
  cp lib/pure/complex.nim $libdir/pure/complex.nim
  chmod 644 $libdir/pure/complex.nim
  cp lib/pure/cookies.nim $libdir/pure/cookies.nim
  chmod 644 $libdir/pure/cookies.nim
  cp lib/pure/dynlib.nim $libdir/pure/dynlib.nim
  chmod 644 $libdir/pure/dynlib.nim
  cp lib/pure/encodings.nim $libdir/pure/encodings.nim
  chmod 644 $libdir/pure/encodings.nim
  cp lib/pure/endians.nim $libdir/pure/endians.nim
  chmod 644 $libdir/pure/endians.nim
  cp lib/pure/events.nim $libdir/pure/events.nim
  chmod 644 $libdir/pure/events.nim
  cp lib/pure/fsmonitor.nim $libdir/pure/fsmonitor.nim
  chmod 644 $libdir/pure/fsmonitor.nim
  cp lib/pure/ftpclient.nim $libdir/pure/ftpclient.nim
  chmod 644 $libdir/pure/ftpclient.nim
  cp lib/pure/gentabs.nim $libdir/pure/gentabs.nim
  chmod 644 $libdir/pure/gentabs.nim
  cp lib/pure/hashes.nim $libdir/pure/hashes.nim
  chmod 644 $libdir/pure/hashes.nim
  cp lib/pure/htmlgen.nim $libdir/pure/htmlgen.nim
  chmod 644 $libdir/pure/htmlgen.nim
  cp lib/pure/htmlparser.nim $libdir/pure/htmlparser.nim
  chmod 644 $libdir/pure/htmlparser.nim
  cp lib/pure/httpclient.nim $libdir/pure/httpclient.nim
  chmod 644 $libdir/pure/httpclient.nim
  cp lib/pure/httpserver.nim $libdir/pure/httpserver.nim
  chmod 644 $libdir/pure/httpserver.nim
  cp lib/pure/irc.nim $libdir/pure/irc.nim
  chmod 644 $libdir/pure/irc.nim
  cp lib/pure/json.nim $libdir/pure/json.nim
  chmod 644 $libdir/pure/json.nim
  cp lib/pure/lexbase.nim $libdir/pure/lexbase.nim
  chmod 644 $libdir/pure/lexbase.nim
  cp lib/pure/marshal.nim $libdir/pure/marshal.nim
  chmod 644 $libdir/pure/marshal.nim
  cp lib/pure/matchers.nim $libdir/pure/matchers.nim
  chmod 644 $libdir/pure/matchers.nim
  cp lib/pure/math.nim $libdir/pure/math.nim
  chmod 644 $libdir/pure/math.nim
  cp lib/pure/md5.nim $libdir/pure/md5.nim
  chmod 644 $libdir/pure/md5.nim
  cp lib/pure/memfiles.nim $libdir/pure/memfiles.nim
  chmod 644 $libdir/pure/memfiles.nim
  cp lib/pure/mimetypes.nim $libdir/pure/mimetypes.nim
  chmod 644 $libdir/pure/mimetypes.nim
  cp lib/pure/nimprof.nim $libdir/pure/nimprof.nim
  chmod 644 $libdir/pure/nimprof.nim
  cp lib/pure/oids.nim $libdir/pure/oids.nim
  chmod 644 $libdir/pure/oids.nim
  cp lib/pure/os.nim $libdir/pure/os.nim
  chmod 644 $libdir/pure/os.nim
  cp lib/pure/osproc.nim $libdir/pure/osproc.nim
  chmod 644 $libdir/pure/osproc.nim
  cp lib/pure/parsecfg.nim $libdir/pure/parsecfg.nim
  chmod 644 $libdir/pure/parsecfg.nim
  cp lib/pure/parsecsv.nim $libdir/pure/parsecsv.nim
  chmod 644 $libdir/pure/parsecsv.nim
  cp lib/pure/parseopt.nim $libdir/pure/parseopt.nim
  chmod 644 $libdir/pure/parseopt.nim
  cp lib/pure/parsesql.nim $libdir/pure/parsesql.nim
  chmod 644 $libdir/pure/parsesql.nim
  cp lib/pure/parseurl.nim $libdir/pure/parseurl.nim
  chmod 644 $libdir/pure/parseurl.nim
  cp lib/pure/parseutils.nim $libdir/pure/parseutils.nim
  chmod 644 $libdir/pure/parseutils.nim
  cp lib/pure/parsexml.nim $libdir/pure/parsexml.nim
  chmod 644 $libdir/pure/parsexml.nim
  cp lib/pure/pegs.nim $libdir/pure/pegs.nim
  chmod 644 $libdir/pure/pegs.nim
  cp lib/pure/redis.nim $libdir/pure/redis.nim
  chmod 644 $libdir/pure/redis.nim
  cp lib/pure/romans.nim $libdir/pure/romans.nim
  chmod 644 $libdir/pure/romans.nim
  cp lib/pure/ropes.nim $libdir/pure/ropes.nim
  chmod 644 $libdir/pure/ropes.nim
  cp lib/pure/scgi.nim $libdir/pure/scgi.nim
  chmod 644 $libdir/pure/scgi.nim
  cp lib/pure/smtp.nim $libdir/pure/smtp.nim
  chmod 644 $libdir/pure/smtp.nim
  cp lib/pure/sockets.nim $libdir/pure/sockets.nim
  chmod 644 $libdir/pure/sockets.nim
  cp lib/pure/streams.nim $libdir/pure/streams.nim
  chmod 644 $libdir/pure/streams.nim
  cp lib/pure/strtabs.nim $libdir/pure/strtabs.nim
  chmod 644 $libdir/pure/strtabs.nim
  cp lib/pure/strutils.nim $libdir/pure/strutils.nim
  chmod 644 $libdir/pure/strutils.nim
  cp lib/pure/subexes.nim $libdir/pure/subexes.nim
  chmod 644 $libdir/pure/subexes.nim
  cp lib/pure/terminal.nim $libdir/pure/terminal.nim
  chmod 644 $libdir/pure/terminal.nim
  cp lib/pure/times.nim $libdir/pure/times.nim
  chmod 644 $libdir/pure/times.nim
  cp lib/pure/typetraits.nim $libdir/pure/typetraits.nim
  chmod 644 $libdir/pure/typetraits.nim
  cp lib/pure/unicode.nim $libdir/pure/unicode.nim
  chmod 644 $libdir/pure/unicode.nim
  cp lib/pure/unittest.nim $libdir/pure/unittest.nim
  chmod 644 $libdir/pure/unittest.nim
  cp lib/pure/uri.nim $libdir/pure/uri.nim
  chmod 644 $libdir/pure/uri.nim
  cp lib/pure/xmldom.nim $libdir/pure/xmldom.nim
  chmod 644 $libdir/pure/xmldom.nim
  cp lib/pure/xmldomparser.nim $libdir/pure/xmldomparser.nim
  chmod 644 $libdir/pure/xmldomparser.nim
  cp lib/pure/xmlparser.nim $libdir/pure/xmlparser.nim
  chmod 644 $libdir/pure/xmlparser.nim
  cp lib/pure/xmltree.nim $libdir/pure/xmltree.nim
  chmod 644 $libdir/pure/xmltree.nim
  cp lib/pure/collections/critbits.nim $libdir/pure/collections/critbits.nim
  chmod 644 $libdir/pure/collections/critbits.nim
  cp lib/pure/collections/intsets.nim $libdir/pure/collections/intsets.nim
  chmod 644 $libdir/pure/collections/intsets.nim
  cp lib/pure/collections/lists.nim $libdir/pure/collections/lists.nim
  chmod 644 $libdir/pure/collections/lists.nim
  cp lib/pure/collections/queues.nim $libdir/pure/collections/queues.nim
  chmod 644 $libdir/pure/collections/queues.nim
  cp lib/pure/collections/sequtils.nim $libdir/pure/collections/sequtils.nim
  chmod 644 $libdir/pure/collections/sequtils.nim
  cp lib/pure/collections/sets.nim $libdir/pure/collections/sets.nim
  chmod 644 $libdir/pure/collections/sets.nim
  cp lib/pure/collections/tables.nim $libdir/pure/collections/tables.nim
  chmod 644 $libdir/pure/collections/tables.nim
  cp lib/impure/db_mongo.nim $libdir/impure/db_mongo.nim
  chmod 644 $libdir/impure/db_mongo.nim
  cp lib/impure/db_mysql.nim $libdir/impure/db_mysql.nim
  chmod 644 $libdir/impure/db_mysql.nim
  cp lib/impure/db_postgres.nim $libdir/impure/db_postgres.nim
  chmod 644 $libdir/impure/db_postgres.nim
  cp lib/impure/db_sqlite.nim $libdir/impure/db_sqlite.nim
  chmod 644 $libdir/impure/db_sqlite.nim
  cp lib/impure/dialogs.nim $libdir/impure/dialogs.nim
  chmod 644 $libdir/impure/dialogs.nim
  cp lib/impure/graphics.nim $libdir/impure/graphics.nim
  chmod 644 $libdir/impure/graphics.nim
  cp lib/impure/osinfo_posix.nim $libdir/impure/osinfo_posix.nim
  chmod 644 $libdir/impure/osinfo_posix.nim
  cp lib/impure/osinfo_win.nim $libdir/impure/osinfo_win.nim
  chmod 644 $libdir/impure/osinfo_win.nim
  cp lib/impure/rdstdin.nim $libdir/impure/rdstdin.nim
  chmod 644 $libdir/impure/rdstdin.nim
  cp lib/impure/re.nim $libdir/impure/re.nim
  chmod 644 $libdir/impure/re.nim
  cp lib/impure/ssl.nim $libdir/impure/ssl.nim
  chmod 644 $libdir/impure/ssl.nim
  cp lib/impure/web.nim $libdir/impure/web.nim
  chmod 644 $libdir/impure/web.nim
  cp lib/impure/zipfiles.nim $libdir/impure/zipfiles.nim
  chmod 644 $libdir/impure/zipfiles.nim
  cp lib/wrappers/claro.nim $libdir/wrappers/claro.nim
  chmod 644 $libdir/wrappers/claro.nim
  cp lib/wrappers/expat.nim $libdir/wrappers/expat.nim
  chmod 644 $libdir/wrappers/expat.nim
  cp lib/wrappers/iup.nim $libdir/wrappers/iup.nim
  chmod 644 $libdir/wrappers/iup.nim
  cp lib/wrappers/joyent_http_parser.nim $libdir/wrappers/joyent_http_parser.nim
  chmod 644 $libdir/wrappers/joyent_http_parser.nim
  cp lib/wrappers/libcurl.nim $libdir/wrappers/libcurl.nim
  chmod 644 $libdir/wrappers/libcurl.nim
  cp lib/wrappers/libsvm.nim $libdir/wrappers/libsvm.nim
  chmod 644 $libdir/wrappers/libsvm.nim
  cp lib/wrappers/libuv.nim $libdir/wrappers/libuv.nim
  chmod 644 $libdir/wrappers/libuv.nim
  cp lib/wrappers/mongo.nim $libdir/wrappers/mongo.nim
  chmod 644 $libdir/wrappers/mongo.nim
  cp lib/wrappers/mysql.nim $libdir/wrappers/mysql.nim
  chmod 644 $libdir/wrappers/mysql.nim
  cp lib/wrappers/odbcsql.nim $libdir/wrappers/odbcsql.nim
  chmod 644 $libdir/wrappers/odbcsql.nim
  cp lib/wrappers/openssl.nim $libdir/wrappers/openssl.nim
  chmod 644 $libdir/wrappers/openssl.nim
  cp lib/wrappers/pcre.nim $libdir/wrappers/pcre.nim
  chmod 644 $libdir/wrappers/pcre.nim
  cp lib/wrappers/pdcurses.nim $libdir/wrappers/pdcurses.nim
  chmod 644 $libdir/wrappers/pdcurses.nim
  cp lib/wrappers/postgres.nim $libdir/wrappers/postgres.nim
  chmod 644 $libdir/wrappers/postgres.nim
  cp lib/wrappers/python.nim $libdir/wrappers/python.nim
  chmod 644 $libdir/wrappers/python.nim
  cp lib/wrappers/sphinx.nim $libdir/wrappers/sphinx.nim
  chmod 644 $libdir/wrappers/sphinx.nim
  cp lib/wrappers/sqlite3.nim $libdir/wrappers/sqlite3.nim
  chmod 644 $libdir/wrappers/sqlite3.nim
  cp lib/wrappers/tcl.nim $libdir/wrappers/tcl.nim
  chmod 644 $libdir/wrappers/tcl.nim
  cp lib/wrappers/tinyc.nim $libdir/wrappers/tinyc.nim
  chmod 644 $libdir/wrappers/tinyc.nim
  cp lib/wrappers/tre.nim $libdir/wrappers/tre.nim
  chmod 644 $libdir/wrappers/tre.nim
  cp lib/wrappers/zmq.nim $libdir/wrappers/zmq.nim
  chmod 644 $libdir/wrappers/zmq.nim
  cp lib/wrappers/cairo/cairo.nim $libdir/wrappers/cairo/cairo.nim
  chmod 644 $libdir/wrappers/cairo/cairo.nim
  cp lib/wrappers/cairo/cairoft.nim $libdir/wrappers/cairo/cairoft.nim
  chmod 644 $libdir/wrappers/cairo/cairoft.nim
  cp lib/wrappers/cairo/cairowin32.nim $libdir/wrappers/cairo/cairowin32.nim
  chmod 644 $libdir/wrappers/cairo/cairowin32.nim
  cp lib/wrappers/cairo/cairoxlib.nim $libdir/wrappers/cairo/cairoxlib.nim
  chmod 644 $libdir/wrappers/cairo/cairoxlib.nim
  cp lib/wrappers/gtk/atk.nim $libdir/wrappers/gtk/atk.nim
  chmod 644 $libdir/wrappers/gtk/atk.nim
  cp lib/wrappers/gtk/gdk2.nim $libdir/wrappers/gtk/gdk2.nim
  chmod 644 $libdir/wrappers/gtk/gdk2.nim
  cp lib/wrappers/gtk/gdk2pixbuf.nim $libdir/wrappers/gtk/gdk2pixbuf.nim
  chmod 644 $libdir/wrappers/gtk/gdk2pixbuf.nim
  cp lib/wrappers/gtk/gdkglext.nim $libdir/wrappers/gtk/gdkglext.nim
  chmod 644 $libdir/wrappers/gtk/gdkglext.nim
  cp lib/wrappers/gtk/glib2.nim $libdir/wrappers/gtk/glib2.nim
  chmod 644 $libdir/wrappers/gtk/glib2.nim
  cp lib/wrappers/gtk/gtk2.nim $libdir/wrappers/gtk/gtk2.nim
  chmod 644 $libdir/wrappers/gtk/gtk2.nim
  cp lib/wrappers/gtk/gtkglext.nim $libdir/wrappers/gtk/gtkglext.nim
  chmod 644 $libdir/wrappers/gtk/gtkglext.nim
  cp lib/wrappers/gtk/gtkhtml.nim $libdir/wrappers/gtk/gtkhtml.nim
  chmod 644 $libdir/wrappers/gtk/gtkhtml.nim
  cp lib/wrappers/gtk/libglade2.nim $libdir/wrappers/gtk/libglade2.nim
  chmod 644 $libdir/wrappers/gtk/libglade2.nim
  cp lib/wrappers/gtk/pango.nim $libdir/wrappers/gtk/pango.nim
  chmod 644 $libdir/wrappers/gtk/pango.nim
  cp lib/wrappers/gtk/pangoutils.nim $libdir/wrappers/gtk/pangoutils.nim
  chmod 644 $libdir/wrappers/gtk/pangoutils.nim
  cp lib/wrappers/lua/lauxlib.nim $libdir/wrappers/lua/lauxlib.nim
  chmod 644 $libdir/wrappers/lua/lauxlib.nim
  cp lib/wrappers/lua/lua.nim $libdir/wrappers/lua/lua.nim
  chmod 644 $libdir/wrappers/lua/lua.nim
  cp lib/wrappers/lua/lualib.nim $libdir/wrappers/lua/lualib.nim
  chmod 644 $libdir/wrappers/lua/lualib.nim
  cp lib/wrappers/opengl/gl.nim $libdir/wrappers/opengl/gl.nim
  chmod 644 $libdir/wrappers/opengl/gl.nim
  cp lib/wrappers/opengl/glext.nim $libdir/wrappers/opengl/glext.nim
  chmod 644 $libdir/wrappers/opengl/glext.nim
  cp lib/wrappers/opengl/glu.nim $libdir/wrappers/opengl/glu.nim
  chmod 644 $libdir/wrappers/opengl/glu.nim
  cp lib/wrappers/opengl/glut.nim $libdir/wrappers/opengl/glut.nim
  chmod 644 $libdir/wrappers/opengl/glut.nim
  cp lib/wrappers/opengl/glx.nim $libdir/wrappers/opengl/glx.nim
  chmod 644 $libdir/wrappers/opengl/glx.nim
  cp lib/wrappers/opengl/opengl.nim $libdir/wrappers/opengl/opengl.nim
  chmod 644 $libdir/wrappers/opengl/opengl.nim
  cp lib/wrappers/opengl/wingl.nim $libdir/wrappers/opengl/wingl.nim
  chmod 644 $libdir/wrappers/opengl/wingl.nim
  cp lib/wrappers/readline/history.nim $libdir/wrappers/readline/history.nim
  chmod 644 $libdir/wrappers/readline/history.nim
  cp lib/wrappers/readline/readline.nim $libdir/wrappers/readline/readline.nim
  chmod 644 $libdir/wrappers/readline/readline.nim
  cp lib/wrappers/readline/rltypedefs.nim $libdir/wrappers/readline/rltypedefs.nim
  chmod 644 $libdir/wrappers/readline/rltypedefs.nim
  cp lib/wrappers/sdl/sdl.nim $libdir/wrappers/sdl/sdl.nim
  chmod 644 $libdir/wrappers/sdl/sdl.nim
  cp lib/wrappers/sdl/sdl_gfx.nim $libdir/wrappers/sdl/sdl_gfx.nim
  chmod 644 $libdir/wrappers/sdl/sdl_gfx.nim
  cp lib/wrappers/sdl/sdl_image.nim $libdir/wrappers/sdl/sdl_image.nim
  chmod 644 $libdir/wrappers/sdl/sdl_image.nim
  cp lib/wrappers/sdl/sdl_mixer.nim $libdir/wrappers/sdl/sdl_mixer.nim
  chmod 644 $libdir/wrappers/sdl/sdl_mixer.nim
  cp lib/wrappers/sdl/sdl_mixer_nosmpeg.nim $libdir/wrappers/sdl/sdl_mixer_nosmpeg.nim
  chmod 644 $libdir/wrappers/sdl/sdl_mixer_nosmpeg.nim
  cp lib/wrappers/sdl/sdl_net.nim $libdir/wrappers/sdl/sdl_net.nim
  chmod 644 $libdir/wrappers/sdl/sdl_net.nim
  cp lib/wrappers/sdl/sdl_ttf.nim $libdir/wrappers/sdl/sdl_ttf.nim
  chmod 644 $libdir/wrappers/sdl/sdl_ttf.nim
  cp lib/wrappers/sdl/smpeg.nim $libdir/wrappers/sdl/smpeg.nim
  chmod 644 $libdir/wrappers/sdl/smpeg.nim
  cp lib/wrappers/x11/cursorfont.nim $libdir/wrappers/x11/cursorfont.nim
  chmod 644 $libdir/wrappers/x11/cursorfont.nim
  cp lib/wrappers/x11/keysym.nim $libdir/wrappers/x11/keysym.nim
  chmod 644 $libdir/wrappers/x11/keysym.nim
  cp lib/wrappers/x11/x.nim $libdir/wrappers/x11/x.nim
  chmod 644 $libdir/wrappers/x11/x.nim
  cp lib/wrappers/x11/xatom.nim $libdir/wrappers/x11/xatom.nim
  chmod 644 $libdir/wrappers/x11/xatom.nim
  cp lib/wrappers/x11/xcms.nim $libdir/wrappers/x11/xcms.nim
  chmod 644 $libdir/wrappers/x11/xcms.nim
  cp lib/wrappers/x11/xf86dga.nim $libdir/wrappers/x11/xf86dga.nim
  chmod 644 $libdir/wrappers/x11/xf86dga.nim
  cp lib/wrappers/x11/xf86vmode.nim $libdir/wrappers/x11/xf86vmode.nim
  chmod 644 $libdir/wrappers/x11/xf86vmode.nim
  cp lib/wrappers/x11/xi.nim $libdir/wrappers/x11/xi.nim
  chmod 644 $libdir/wrappers/x11/xi.nim
  cp lib/wrappers/x11/xinerama.nim $libdir/wrappers/x11/xinerama.nim
  chmod 644 $libdir/wrappers/x11/xinerama.nim
  cp lib/wrappers/x11/xkb.nim $libdir/wrappers/x11/xkb.nim
  chmod 644 $libdir/wrappers/x11/xkb.nim
  cp lib/wrappers/x11/xkblib.nim $libdir/wrappers/x11/xkblib.nim
  chmod 644 $libdir/wrappers/x11/xkblib.nim
  cp lib/wrappers/x11/xlib.nim $libdir/wrappers/x11/xlib.nim
  chmod 644 $libdir/wrappers/x11/xlib.nim
  cp lib/wrappers/x11/xrandr.nim $libdir/wrappers/x11/xrandr.nim
  chmod 644 $libdir/wrappers/x11/xrandr.nim
  cp lib/wrappers/x11/xrender.nim $libdir/wrappers/x11/xrender.nim
  chmod 644 $libdir/wrappers/x11/xrender.nim
  cp lib/wrappers/x11/xresource.nim $libdir/wrappers/x11/xresource.nim
  chmod 644 $libdir/wrappers/x11/xresource.nim
  cp lib/wrappers/x11/xshm.nim $libdir/wrappers/x11/xshm.nim
  chmod 644 $libdir/wrappers/x11/xshm.nim
  cp lib/wrappers/x11/xutil.nim $libdir/wrappers/x11/xutil.nim
  chmod 644 $libdir/wrappers/x11/xutil.nim
  cp lib/wrappers/x11/xv.nim $libdir/wrappers/x11/xv.nim
  chmod 644 $libdir/wrappers/x11/xv.nim
  cp lib/wrappers/x11/xvlib.nim $libdir/wrappers/x11/xvlib.nim
  chmod 644 $libdir/wrappers/x11/xvlib.nim
  cp lib/wrappers/zip/libzip.nim $libdir/wrappers/zip/libzip.nim
  chmod 644 $libdir/wrappers/zip/libzip.nim
  cp lib/wrappers/zip/zlib.nim $libdir/wrappers/zip/zlib.nim
  chmod 644 $libdir/wrappers/zip/zlib.nim
  cp lib/wrappers/zip/zzip.nim $libdir/wrappers/zip/zzip.nim
  chmod 644 $libdir/wrappers/zip/zzip.nim
  cp lib/wrappers/zip/libzip_all.c $libdir/wrappers/zip/libzip_all.c
  chmod 644 $libdir/wrappers/zip/libzip_all.c
  cp lib/windows/mmsystem.nim $libdir/windows/mmsystem.nim
  chmod 644 $libdir/windows/mmsystem.nim
  cp lib/windows/nb30.nim $libdir/windows/nb30.nim
  chmod 644 $libdir/windows/nb30.nim
  cp lib/windows/ole2.nim $libdir/windows/ole2.nim
  chmod 644 $libdir/windows/ole2.nim
  cp lib/windows/psapi.nim $libdir/windows/psapi.nim
  chmod 644 $libdir/windows/psapi.nim
  cp lib/windows/shellapi.nim $libdir/windows/shellapi.nim
  chmod 644 $libdir/windows/shellapi.nim
  cp lib/windows/shfolder.nim $libdir/windows/shfolder.nim
  chmod 644 $libdir/windows/shfolder.nim
  cp lib/windows/windows.nim $libdir/windows/windows.nim
  chmod 644 $libdir/windows/windows.nim
  cp lib/windows/winlean.nim $libdir/windows/winlean.nim
  chmod 644 $libdir/windows/winlean.nim
  cp lib/posix/inotify.nim $libdir/posix/inotify.nim
  chmod 644 $libdir/posix/inotify.nim
  cp lib/posix/posix.nim $libdir/posix/posix.nim
  chmod 644 $libdir/posix/posix.nim
  cp lib/ecmas/dom.nim $libdir/ecmas/dom.nim
  chmod 644 $libdir/ecmas/dom.nim
  
  echo "installation successful"
else
  echo "Nimrod installation script"
  echo "Usage: [sudo] sh install.sh DIR"
  echo "Where DIR may be:"
  echo "  /usr/bin"
  echo "  /usr/local/bin"
  echo "  /opt"
  echo "  <some other dir> (treated like '/opt')"
  echo "To deinstall, use the command:"
  echo "sh deinstall.sh DIR"
  exit 1
fi

