/*
 * Decompiled with CFR 0.152.
 */
package net.sf.phpeasyvcs;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;

public class JSON {
    public static void write(Writer w, Object object) throws IOException {
        new JSONWriter(w).write(object);
    }

    public static Object read(Reader r) throws IOException {
        return new JSONReader(r).read();
    }

    public static String encode(Object object) {
        StringWriter w = new StringWriter();
        try {
            JSON.write(w, object);
            return w.toString();
        }
        catch (IOException e) {
            return null;
        }
    }

    public static Object decode(String s) {
        try {
            return JSON.read(new StringReader(s));
        }
        catch (IOException e) {
            return null;
        }
    }

    private static class JSONReader {
        private Reader r;
        private char c;
        private Object token;
        private int pos = 0;

        public JSONReader(Reader r) throws IOException {
            this.r = r;
            this.next();
            this.readToken();
        }

        private Object read() throws IOException {
            if (this.token == null) {
                return null;
            }
            if (this.token instanceof String) {
                return this.token;
            }
            if (this.token instanceof Number) {
                return this.token;
            }
            if (this.token instanceof Boolean) {
                return this.token;
            }
            if (this.token == Token.OPEN_OBJ) {
                LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
                this.readToken();
                boolean first = true;
                if (this.token != Token.CLOSE_OBJ) {
                    do {
                        if (!first) {
                            this.readToken();
                        } else {
                            first = false;
                        }
                        this.expect(String.class);
                        String key = (String)this.token;
                        this.readToken();
                        this.expect((Object)Token.COLON);
                        this.readToken();
                        Object value = this.read();
                        m.put(key, value);
                        this.readToken();
                    } while (this.token == Token.COMMA);
                }
                this.expect((Object)Token.CLOSE_OBJ);
                return m;
            }
            if (this.token == Token.OPEN_ARR) {
                ArrayList<Object> l = new ArrayList<Object>();
                this.readToken();
                boolean first = true;
                if (this.token != Token.CLOSE_ARR) {
                    do {
                        if (!first) {
                            this.readToken();
                        } else {
                            first = false;
                        }
                        Object value = this.read();
                        l.add(value);
                        this.readToken();
                    } while (this.token == Token.COMMA);
                }
                this.expect((Object)Token.CLOSE_ARR);
                return l;
            }
            throw new RuntimeException("Unexpected " + (this.token != null ? "'" + this.token + "'" : "null") + "!");
        }

        private void readToken() throws IOException {
            while (Character.isWhitespace(this.c)) {
                this.next();
            }
            if (this.c == '\"') {
                StringBuffer sb = new StringBuffer();
                this.next();
                while (this.c != '\"') {
                    if (this.c == '\\') {
                        this.next();
                        switch (this.c) {
                            case 'b': {
                                sb.append('\b');
                                break;
                            }
                            case 'f': {
                                sb.append('\f');
                                break;
                            }
                            case 'n': {
                                sb.append('\n');
                                break;
                            }
                            case 'r': {
                                sb.append('\r');
                                break;
                            }
                            case 't': {
                                sb.append('\t');
                                break;
                            }
                            case '\"': 
                            case '/': 
                            case '\\': {
                                sb.append(this.c);
                                break;
                            }
                            case 'u': {
                                StringBuffer hex = new StringBuffer();
                                for (int i = 0; i < 4; ++i) {
                                    this.next();
                                    hex.append(this.c);
                                }
                                sb.append((char)Integer.parseInt(hex.toString(), 16));
                                break;
                            }
                            default: {
                                throw new RuntimeException("Unknown escape sequence \\" + this.c + "!");
                            }
                        }
                    } else {
                        sb.append(this.c);
                    }
                    this.next();
                }
                this.next();
                this.token = sb.toString();
            } else if (this.c == 't') {
                this.expect('r');
                this.expect('u');
                this.expect('e');
                this.next();
                this.token = Boolean.TRUE;
            } else if (this.c == 'f') {
                this.expect('a');
                this.expect('l');
                this.expect('s');
                this.expect('e');
                this.next();
                this.token = Boolean.FALSE;
            } else if (this.c == 'n') {
                this.expect('u');
                this.expect('l');
                this.expect('l');
                this.next();
                this.token = null;
            } else if (this.c >= '0' && this.c <= '9' || this.c == '-') {
                Double value;
                StringBuffer sb = new StringBuffer();
                do {
                    sb.append(this.c);
                    this.next();
                } while (this.c >= '0' && this.c <= '9' || this.c == '-' || this.c == '+' || this.c == '.' || this.c == 'e' || this.c == 'E');
                this.token = sb.indexOf(".") >= 0 ? (Number)((value = Double.valueOf(Double.parseDouble(sb.toString()))) >= (double)1.4E-45f && value <= 3.4028234663852886E38 ? (Number)Float.valueOf(value.floatValue()) : (Number)value) : (Number)((value = Long.valueOf(Long.parseLong(sb.toString()))) >= Integer.MIN_VALUE && value <= Integer.MAX_VALUE ? (Number)value.intValue() : (Number)value);
            } else {
                this.token = Token.get(this.c);
                if (this.token == null) {
                    this.token = Token.END;
                }
                this.next();
            }
        }

        private void next() throws IOException {
            this.c = (char)this.r.read();
            ++this.pos;
        }

        private void expect(char c) throws IOException {
            this.next();
            if (c != this.c) {
                throw new RuntimeException("Expected '" + c + "', got '" + this.c + "' at position " + this.pos + "!");
            }
        }

        private void expect(Object o) throws IOException {
            if (o == null) {
                if (this.token != null) {
                    throw new RuntimeException("Expected null, got '" + this.token + "' at position " + this.pos + "!");
                }
            } else if (o instanceof Token) {
                if (!(this.token instanceof Token) || o != this.token) {
                    throw new RuntimeException("Expected '" + this.c + "', got '" + this.token + "' at position " + this.pos + "!");
                }
            } else if (o instanceof Class) {
                if (!((Class)o).isInstance(this.token)) {
                    String got;
                    String exp = ((Class)o).getSimpleName();
                    String string = got = this.token != null ? this.token.getClass().getSimpleName() : "null";
                    if (this.token instanceof Token) {
                        got = got + " '" + this.token + "'";
                    }
                    throw new RuntimeException("Expected " + exp + ", got " + got + " at position " + this.pos + "!");
                }
            } else if (!o.equals(this.token)) {
                String got = this.token == null ? "null" : "'" + this.token + "'";
                throw new RuntimeException("Expected '" + o + "', got " + got + " at position " + this.pos + "!");
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static enum Token {
            OPEN_OBJ('{'),
            CLOSE_OBJ('}'),
            OPEN_ARR('['),
            CLOSE_ARR(']'),
            COMMA(','),
            COLON(':'),
            END('\u0000');

            private char c;

            private Token(char c) {
                this.c = c;
            }

            public String toString() {
                return "" + this.c;
            }

            private static Token get(char c) {
                for (Token t : Token.values()) {
                    if (t.c != c) continue;
                    return t;
                }
                return null;
            }
        }
    }

    private static class JSONWriter {
        private Writer w;
        private DateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

        public JSONWriter(Writer w) {
            this.w = w;
        }

        public void write(Object object) throws IOException {
            if (object == null) {
                this.w.append("null");
            } else if (object instanceof String) {
                this.writeString((String)object);
            } else if (object instanceof Number) {
                this.w.append(object.toString());
            } else if (object instanceof Boolean) {
                this.w.append((Boolean)object != false ? "true" : "false");
            } else if (object instanceof Date) {
                this.writeString(this.df.format((Date)object));
            } else if (object instanceof Enum) {
                this.writeString(object.toString());
            } else if (object.getClass().isArray()) {
                this.w.append("[");
                int length = Array.getLength(object);
                for (int i = 0; i < length; ++i) {
                    this.write(Array.get(object, i));
                    if (i >= length - 1) continue;
                    this.w.append(", ");
                }
                this.w.append("]");
            } else if (object instanceof Map) {
                this.w.append("{");
                boolean first = true;
                Map m = (Map)object;
                for (Map.Entry e : m.entrySet()) {
                    if (!first) {
                        this.w.append(", ");
                    } else {
                        first = false;
                    }
                    this.writeString(String.valueOf(e.getKey()));
                    this.w.append(":");
                    this.write(e.getValue());
                }
                this.w.append("}");
            } else if (object instanceof Collection) {
                this.w.append("[");
                boolean first = true;
                for (Object e : (Collection)object) {
                    if (!first) {
                        this.w.append(", ");
                    } else {
                        first = false;
                    }
                    this.write(e);
                }
                this.w.append("]");
            } else {
                Method[] methods;
                this.w.append("{");
                boolean first = true;
                for (Method m : methods = object.getClass().getMethods()) {
                    String name = m.getName();
                    name = name.startsWith("get") && name.length() > 3 && !name.equals("getClass") ? name.substring(3, 4).toLowerCase() + name.substring(4) : (name.startsWith("is") && name.length() > 2 ? name.substring(2, 3).toLowerCase() + name.substring(3) : null);
                    if (name == null) continue;
                    try {
                        Object value = m.invoke(object, new Object[0]);
                        if (!first) {
                            this.w.append(", ");
                        } else {
                            first = false;
                        }
                        this.writeString(name);
                        this.w.append(":");
                        this.write(value);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                this.w.append("}");
            }
        }

        private void writeString(String s) throws IOException {
            this.w.append('\"');
            block10: for (int i = 0; i < s.length(); ++i) {
                char c = s.charAt(i);
                switch (c) {
                    case '\"': {
                        this.w.append("\\\"");
                        continue block10;
                    }
                    case '\\': {
                        this.w.append("\\\\");
                        continue block10;
                    }
                    case '\b': {
                        this.w.append("\\b");
                        continue block10;
                    }
                    case '\f': {
                        this.w.append("\\f");
                        continue block10;
                    }
                    case '\n': {
                        this.w.append("\\n");
                        continue block10;
                    }
                    case '\r': {
                        this.w.append("\\r");
                        continue block10;
                    }
                    case '\t': {
                        this.w.append("\\t");
                        continue block10;
                    }
                    case '/': {
                        this.w.append("\\/");
                        continue block10;
                    }
                    default: {
                        if (c >= '\u0000' && c <= '\u001f' || c >= '\u007f' && c <= '\u009f' || c >= '\u2000' && c <= '\u20ff') {
                            String h = Integer.toHexString(c);
                            this.w.append("\\u");
                            for (int k = 0; k < 4 - h.length(); ++k) {
                                this.w.append('0');
                            }
                            this.w.append(h.toUpperCase());
                            continue block10;
                        }
                        this.w.append(c);
                    }
                }
            }
            this.w.append('\"');
        }
    }
}

