
/* This file is created by the "tcl2c" utility, which is included in
 * most "plus"-patches (e.g. for Tcl7.6 and Tcl8.0). Standalone
 * executables can be made by providing alternative initialization
 * functions which don't read files any more. Sometimes, small
 * adaptations to the original libraries are needed to get the
 * application truly standalone. The "plus"-patches contain these
 * adaptations for Tcl and Tk. If you just create your own
 * Xxx_InitStandAlone() function for your package, you can
 * easyly extend the "tcl2c" utility to your own requirements.
 *
 *	Jan Nijtmans
 *	CMG (Computer Management Group) Arnhem B.V.
 *	email: Jan.Nijtmans@wxs.nl (private)
 *	       Jan.Nijtmans@cmg.nl (work)
 *	url:   http://home.wxs.nl/~nijtmans/
 *
 *new options for gcc by:  Cyril Barbato (cyril.barbato@gmx.com)
 *          -D__MALLOC__ : for using malloc()
 *          -D_CYGWIN_ : for using GygWin under Win32
 *          -D__LIBPATH__="your lib" : change tcl lib path
 *			-D_APPLICATION_IS_ROOT_PATH_ : for application is root path
 *	    url:   http://tcl2c.sourceforge.net/
 *
 * usage:	tcl2c -o file source1 source2 ... ?options?
 *	tcl2c -help
 */
#include "tcl.h"
#ifdef __WIN32__
#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#undef WIN32_LEAN_AND_MEAN
#ifndef __MALLOC_H__
#include <malloc.h>
#endif
#include <locale.h>
#ifndef __LIBPATH__
#define __LIBPATH__ "lib"
#endif
#include <unistd.h>
#ifdef _APPLICATION_IS_ROOT_PATH_
#include <string.h>
#include <limits.h>
#include <unistd.h>
#endif

static int setargv _ANSI_ARGS_((char ***argvPtr));
static void TclshPanic _ANSI_ARGS_(TCL_VARARGS(char *,format));
extern void TclWinInit(HINSTANCE instance);
extern int  Registry_Init _ANSI_ARGS_((Tcl_Interp *interp));

#endif

/*
 * Defines to replace the standard Xxx_Init calls to Xxx_InitStandAlone.
 * If you don't have this function, just delete the corresponding
 * define such that the normal initialization function is used.
 * If no Xxx_SafeInit function exists, use NULL pointers instead
 * by commenting out the appropriate lines below.
 */

#if defined(TCL_ACTIVE) && !defined(SHARED)
#define Tcl_Init Tcl_InitStandAlone
#define Tk_Init Tk_InitStandAlone
#endif

/*#define Tk_SafeInit ((Tcl_PackageInitProc *) NULL)*/

/*
 * Prototypes of all initialization functions and the free() function.
 * So, only "tcl.h" needs to be included now.
 */

#ifdef __cplusplus
extern "C" {
#endif

#ifndef USE_TCLALLOC
#   define USE_TCLALLOC 0
#endif
#if USE_TCLALLOC == 0
extern void free _ANSI_ARGS_((void *));
extern VOID *malloc _ANSI_ARGS_((int));
#endif
extern int  Tcl_Init _ANSI_ARGS_((Tcl_Interp *interp));


extern void Tk_MainLoop _ANSI_ARGS_((void));
#define HAS_TK
#ifdef __WIN32__
extern void TkWinXInit _ANSI_ARGS_((HINSTANCE hinstance));
extern void TkWinXCleanup _ANSI_ARGS_((HINSTANCE hinstance));
#endif

extern int  Tk_Init _ANSI_ARGS_((Tcl_Interp *interp));
#ifndef Tk_SafeInit
extern int  Tk_SafeInit _ANSI_ARGS_((Tcl_Interp *interp));
#endif

#ifdef __cplusplus
}
#endif

/*
 * The array "script" contains the script that is compiled in.
 * It will be executed in tclAppInit() after the other initializations.
 */

static char *lineformat = "%.0s%d";
static int line = (__LINE__ + 1);
static char *script[] = {
"tk_messageBox -message Test:[pwd] ; exit",
(char *) NULL
};

#ifdef _APPLICATION_IS_ROOT_PATH_
#define PATH_MAX 1024
char abs_exe_path[PATH_MAX];
char *
#ifdef _USING_PROTOTYPES_
app_GetPath(
	int argc,
	char *argv[])
#else
app_GetPath(argc, argv)
	int argc;
	char *argv[];
#endif
{
  char path_save[PATH_MAX];
  char *p;
  if(!(p = strrchr(argv[0], '/')))
    getcwd(abs_exe_path, sizeof(abs_exe_path));
  else
  {
    *p = '\0';
    getcwd(path_save, sizeof(path_save));
    chdir(argv[0]);
    getcwd(abs_exe_path, sizeof(abs_exe_path));
    chdir(path_save);
  }
  //printf("Absolute path to executable is: script\n", abs_exe_path);
  return abs_exe_path;
};
#endif
/*
 *----------------------------------------------------------------------
 *
 * main --
 *
 *	This is the main program for the application.
 *
 * Results:
 *	None.
 *
 * Side effects:
 *	Whatever the application does.
 *
 *----------------------------------------------------------------------
 */

#if defined(__WIN32__) && defined(HAS_TK)
int APIENTRY
WinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance,
    LPSTR lpszCmdLine, int nCmdShow)
{
    char **argv;
    int argc;
#else
int
#ifdef _USING_PROTOTYPES_
main (int    argc,		/* Number of command-line arguments. */
      char **argv)		/* Values of command-line arguments. */
#else
main(argc, argv)
    int argc;			/* Number of command-line arguments. */
    char **argv;		/* Values of command-line arguments. */
#endif
{
#endif
    Tcl_Interp *interp;
    char **p = script;
    char *q, buffer[16];
    Tcl_DString data;
    Tcl_Channel inChannel, outChannel, errChannel;

#ifdef __LIBPATH__
	////char _cwd[1024];
	char _libpath[2048];
#endif
#ifdef __WIN32__
    char argv0[128];
#endif
#ifdef _APPLICATION_IS_ROOT_PATH_
	/* GOTO APPLICATION PATH FOR MAC OS*/
	chdir(app_GetPath(argc, argv));
#endif
#ifdef __WIN32__
#if defined(TCL_ACTIVE) && !defined(SHARED) && defined(HAS_TK)
    TclWinInit(hInstance);
    TkWinXInit(hInstance);
    Tcl_CreateExitHandler((Tcl_ExitProc *) TkWinXCleanup, (ClientData) hInstance);
#endif

    Tcl_SetPanicProc(TclshPanic);


    /*
     * Set up the default locale to be standard "C" locale so parsing
     * is performed correctly.
     */

    setlocale(LC_ALL, "C");

    /*
     * Increase the application queue size from default value of 8.
     * At the default value, cross application SendMessage of WM_KILLFOCUS
     * will fail because the handler will not be able to do a PostMessage!
     * This is only needed for Windows 3.x, since NT dynamically expands
     * the queue.
     */
    SetMessageQueue(64);

    argc = setargv(&argv);

    /*
     * Replace argv[0] with full pathname of executable, and forward
     * slashes substituted for backslashes.
     */

    GetModuleFileName(NULL, argv0, sizeof(argv0));
    argv[0] = argv0;
    for (q = argv0; *q != '\0'; q++) {
	if (*q == '\\') {
	    *q = '/';
	}
    }

#endif
    Tcl_FindExecutable(argv[0]);
    interp = Tcl_CreateInterp();

    q = Tcl_Merge(argc-1, argv+1);
    Tcl_SetVar(interp, "argv", q, TCL_GLOBAL_ONLY);
    ckfree(q);
    sprintf(buffer, "%d", argc-1);
    Tcl_SetVar(interp, "argc", buffer, TCL_GLOBAL_ONLY);
    Tcl_SetVar(interp, "argv0", argv[0],TCL_GLOBAL_ONLY);
    Tcl_SetVar(interp, "tcl_interactive","0", TCL_GLOBAL_ONLY);

#ifdef __LIBPATH__
	////chdir(__LIBPATH__);
	////getcwd(_cwd,sizeof(_cwd));
	////printf("libpath:%s\n", _cwd);
	sprintf(_libpath, "set env(PWD) [pwd]");
	Tcl_Eval(interp, _libpath);
	sprintf(_libpath, "%s/%s/tcl%s", Tcl_GetVar2(interp, "env", "PWD", TCL_GLOBAL_ONLY),__LIBPATH__, Tcl_GetVar(interp,"tcl_version", TCL_GLOBAL_ONLY));
	Tcl_SetVar2(interp, "env", "TCL_LIBRARY", _libpath, TCL_GLOBAL_ONLY);
	Tcl_SetVar2(interp, "env", "TK_LIBRARY", _libpath, TCL_GLOBAL_ONLY);
	Tcl_SetVar(interp, "auto_path", _libpath, TCL_GLOBAL_ONLY);
	Tcl_SetVar(interp, "tcl_libPath", _libpath, TCL_GLOBAL_ONLY);
#endif

if (Tcl_Init(interp) != TCL_OK) {
        goto error;
    }

#ifdef __WIN32__
	Tcl_StaticPackage((Tcl_Interp *) NULL, "registry", Registry_Init,
	    (Tcl_PackageInitProc *) NULL);
#endif

    if (Tk_Init(interp) != TCL_OK) {
        goto error;
    }
    Tcl_StaticPackage(interp, "Tk", Tk_Init, Tk_SafeInit);

    /*
     * Execute the script that is compiled in.
     */

    inChannel = Tcl_GetStdChannel(TCL_STDIN);
    outChannel = Tcl_GetStdChannel(TCL_STDOUT);
    Tcl_DStringInit(&data);
    while(*p) {
	Tcl_DStringSetLength(&data,0);
	Tcl_DStringAppend(&data,*p++,-1);
	if (Tcl_Eval(interp,Tcl_DStringValue(&data)) != TCL_OK) {
	    Tcl_DStringFree(&data);
	    while (p-- != script) {
		for (q = *p;*q; q++) {
		    if (*q=='\n') line++;
		}
		line++;
	    }
	    sprintf(buffer,lineformat,"script",line);
	    Tcl_AddErrorInfo(interp,"\n	( Error in file: \"");
	    Tcl_AddErrorInfo(interp,__FILE__);
	    Tcl_AddErrorInfo(interp,"\", line: ");
	    Tcl_AddErrorInfo(interp,buffer);
	    Tcl_AddErrorInfo(interp,")");
	    errChannel = Tcl_GetStdChannel(TCL_STDERR);
	    if (errChannel) {
		Tcl_Write(errChannel,
			Tcl_GetVar(interp, "errorInfo", TCL_GLOBAL_ONLY), -1);
		Tcl_Write(errChannel, "\n", 1);
	    }
#ifdef __WIN32__
	    TclshPanic(Tcl_GetVar(interp, "errorInfo", TCL_GLOBAL_ONLY));
#endif
	    sprintf(buffer, "exit %d", 1);
	    Tcl_Eval(interp, buffer);
	}
    }
    Tcl_DStringFree(&data);
    Tk_MainLoop();
    sprintf(buffer, "exit %d", 0);
    Tcl_Eval(interp, buffer);

error:
    errChannel = Tcl_GetStdChannel(TCL_STDERR);
    if (errChannel) {
	Tcl_Write(errChannel,
		"application-specific initialization failed: ", -1);
	Tcl_Write(errChannel, Tcl_GetStringResult(interp), -1);
	Tcl_Write(errChannel, "\n", 1);
    }
#ifdef __WIN32__
    TclshPanic(Tcl_GetStringResult(interp));
#endif
    sprintf(buffer, "exit %d", 1);
    Tcl_Eval(interp, buffer);
    return 0;
}

#ifdef __WIN32__
/*
 *----------------------------------------------------------------------
 *
 * TclshPanic --
 *
 *	Display a message and exit.
 *
 * Results:
 *	None.
 *
 * Side effects:
 *	Exits the program.
 *
 *----------------------------------------------------------------------
 */

void
TclshPanic TCL_VARARGS_DEF(char *,arg1)
{
    va_list argList;
    char buf[1024];
    char *format;

    format = TCL_VARARGS_START(char *,arg1,argList);
    vsprintf(buf, format, argList);

    MessageBeep(MB_ICONEXCLAMATION);
    MessageBox(NULL, buf, "Fatal Error in Tclsh",
	    MB_ICONSTOP | MB_OK | MB_TASKMODAL | MB_SETFOREGROUND);
#ifdef _MSC_VER
    DebugBreak();
#endif
    ExitProcess(1);
}

/*
 *-------------------------------------------------------------------------
 *
 * setargv --
 *
 *	Parse the Windows command line string into argc/argv.  Done here
 *	because we don't trust the builtin argument parser in crt0.  
 *	Windows applications are responsible for breaking their command
 *	line into arguments.
 *
 *	2N backslashes + quote -> N backslashes + begin quoted string
 *	2N + 1 backslashes + quote -> literal
 *	N backslashes + non-quote -> literal
 *	quote + quote in a quoted string -> single quote
 *	quote + quote not in quoted string -> empty string
 *	quote -> begin quoted string
 *
 * Results:
 *	returns the number of arguments and fill argvPtr with the
 *	array of arguments.
 *
 * Side effects:
 *	Memory allocated.
 *
 *--------------------------------------------------------------------------
 */

static int
setargv(argvPtr)
    char ***argvPtr;		/* Filled with argument strings (malloc'd). */
{
    char *cmdLine, *p, *arg, *argSpace;
    char **argv;
    int argc, size, inquote, copy, slashes;

    cmdLine = GetCommandLine();

    /*
     * Precompute an overly pessimistic guess at the number of arguments
     * in the command line by counting non-space spans.
     */

    size = 2;
    for (p = cmdLine; *p != '\0'; p++) {
	if (isspace(*p)) {
	    size++;
	    while (isspace(*p)) {
		p++;
	    }
	    if (*p == '\0') {
		break;
	    }
	}
    }
    argSpace = (char *) ckalloc((unsigned) (size * sizeof(char *)
	    + strlen(cmdLine) + 1));
    argv = (char **) argSpace;
    argSpace += size * sizeof(char *);
    size--;

    p = cmdLine;
    for (argc = 0; argc < size; argc++) {
	argv[argc] = arg = argSpace;
	while (isspace(*p)) {
	    p++;
	}
	if (*p == '\0') {
	    break;
	}

	inquote = 0;
	slashes = 0;
	while (1) {
	    copy = 1;
	    while (*p == '\\') {
		slashes++;
		p++;
	    }
	    if (*p == '"') {
		if ((slashes & 1) == 0) {
		    copy = 0;
		    if ((inquote) && (p[1] == '"')) {
			p++;
			copy = 1;
		    } else {
			inquote = !inquote;
		    }
                }
                slashes >>= 1;
            }

            while (slashes) {
		*arg = '\\';
		arg++;
		slashes--;
	    }

	    if ((*p == '\0') || (!inquote && isspace(*p))) {
		break;
	    }
	    if (copy != 0) {
		*arg = *p;
		arg++;
	    }
	    p++;
        }
	*arg = '\0';
	argSpace = arg + 1;
    }
    argv[argc] = NULL;

    *argvPtr = argv;
    return argc;
}
#endif /* __WIN32__ */
