/*
 *  Print Dialog for Canon LIPS/PS/LIPSLX/UFR2/CAPT Printer.
 *  Copyright (C) 2004-2008 CANON INC.
 *  All Rights Reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#include <gtk/gtk.h>

#include "callbacks.h"
#include "interface.h"
#include "support.h"

#include "widgets.h"
#include "dialog.h"
#include "uimain.h"
#include "propdlg.h"
#include "bookletdlg.h"
#include "gutterdlg.h"
#include "boxiddlg.h"
#include "passwddlg.h"
#include "findetailsdlg.h"
#include "profiledlg.h"
#include "frontbackcvr.h"
#include "holdqueuedlg.h"
#include "mltlang.h"

static gboolean g_PrinterName_mapped = FALSE;
static gboolean g_Nup_mapped = FALSE;
static gboolean g_BannerStart_mapped = FALSE;
static gboolean g_BannerEnd_mapped = FALSE;
static gboolean g_Filter_mapped = FALSE;
static gboolean g_PaperSize_mapped = FALSE;
static gboolean g_BindingLocation_mapped = FALSE;
static gboolean g_PaperDisti_mapped = FALSE;
static gboolean g_PaperSource_mapped = FALSE;
static gboolean g_PaperType_mapped = FALSE;
static gboolean g_ColorMode_mapped = FALSE;
static gboolean g_QualityHalftone_mapped = FALSE;
static gboolean g_QualityTonerSave_mapped = FALSE;
static gboolean g_OutputMethod_mapped = FALSE;
static gboolean g_OutputOption_mapped = FALSE;
static gboolean g_QualityReso_mapped = FALSE;
static gboolean g_QualityGrayComp_mapped = FALSE;
static gboolean g_FinCollate_mapped = FALSE;
static gboolean g_StaplePosition_mapped = FALSE;
static gboolean g_CaptPaperSource_mapped = FALSE;
static gboolean g_CaptPaperType_mapped = FALSE;
static gboolean g_BookletDlgOpening_mapped = FALSE;
static gboolean	g_OutputSide_mapped = FALSE;
static gboolean g_FinDetail_Img_mapped = FALSE;
static gboolean g_FinDetail_Fix_mapped = FALSE;
static gboolean g_ImgSpecialProc_mapped = FALSE;
static gboolean g_QualityDraftMode_mapped = FALSE;
static gboolean g_InterleafMediaType_mapped = FALSE;
static gboolean g_SourceOption_mapped = FALSE;
static gboolean g_ColorHalftone_mapped = FALSE;
static gboolean g_KeepGray_mapped = FALSE;
static gboolean g_PureBlackText_mapped = FALSE;
static gboolean g_BlackOverprint_mapped = FALSE;
static gboolean g_RGBSourceProfile_mapped = FALSE;
static gboolean g_RGBMatchingMethod_mapped = FALSE;
static gboolean g_CMYKSimulationProfile_mapped = FALSE;
static gboolean g_OutputProfile_mapped = FALSE;
static gboolean g_QualityGradeMethod_mapped = FALSE;
static gboolean g_QualityImgRefine_mapped = FALSE;
static gboolean g_QualityLineRefine_mapped = FALSE;
static gboolean g_SpotColorMatching_mapped = FALSE;
static gboolean g_OHPPrintMode_mapped = FALSE;
static gboolean g_AdvancedSmoothing_mapped = FALSE;
static gboolean g_SpecialPrintMode_mapped = FALSE;
static gboolean g_FrontCvrPrintSide_mapped = FALSE;
static gboolean g_FrontCvrPaperSrc_mapped = FALSE;
static gboolean g_BackCvrPrintSide_mapped = FALSE;
static gboolean g_BackCvrPaperSrc_mapped = FALSE;
static gboolean g_SmallSizeCurl_mapped = FALSE;
static gboolean g_CaptCurlCorrection_mapped = FALSE;
static gboolean g_ImageCompression_mapped = FALSE;
static gboolean g_CfoldSetting_mapped = FALSE;
static gboolean g_TonerVolumeAdjustment_mapped = FALSE;
static gboolean g_LineControl_mapped = FALSE;
static gboolean g_SpecialPrintAdjustmentA_mapped = FALSE;
static gboolean g_SpecialPrintAdjustmentB_mapped = FALSE;
static gboolean g_FinDetail_RevicePostcard_mapped = FALSE;
static gboolean g_CaptFinDetail_WrinklesCorrectionOutput_mapped = FALSE;
#define CHECK_BOXID		0
#define CHECK_HOLDQUEUE 	1
#define CHECK_PASSWD 		0
#define CHECK_FINDETAILS 	1





gboolean
on_MainDlg_delete_event                (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
	DisposeMainDlg(g_main_window);
	gtk_main_quit();
	return FALSE;
}


void
on_MainDlg_destroy                     (GtkObject       *object,
                                        gpointer         user_data)
{
	gtk_main_quit();
}

void
on_PrinterName_combo_entry_changed     (GtkEditable     *editable,
                                        gpointer         user_data)
{
	if(SigDisable()){
		if(!g_PrinterName_mapped){
			gchar *text;
			text = GetCurrComboText(UI_DIALOG(g_main_window)->window, "PrinterName_combo_entry");
			UpdateData(ID_PRINTERNAME, text);

		}
	}
	SigEnable();
}

gboolean
on_PrinterName_combo_popwin_event	(GtkWidget	*widget, GdkEvent	*event,
					gpointer		user_data)
{
	if(event->type == GDK_MAP){
		g_PrinterName_mapped = TRUE;
	}else if(event->type == GDK_UNMAP){
		g_PrinterName_mapped = FALSE;
		if(SigDisable()){
			gchar *text;
			text = GetCurrComboText(UI_DIALOG(g_main_window)->window, "PrinterName_combo_entry");
			UpdateData(ID_PRINTERNAME, text);
		}
		SigEnable();
	}
	return FALSE;
}

void
on_Property_button_clicked             (GtkButton       *button,
                                        gpointer         user_data)
{
	cngplpSetData(g_main_window->data, ID_SHOWDLG, "Prop");
	ShowPropDlg(g_main_window->prop);
}


void
on_SetDefault_button_clicked           (GtkButton       *button,
                                        gpointer         user_data)
{
	cngplpSetData(g_main_window->data, ID_SETDEFAULT, NULL);
}

void
on_AllPage_radiobutton_toggled         (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	if(SigDisable()){
		if(togglebutton->active){
			UpdateData(ID_PAGE_SET, "all");
		}
	}
	SigEnable();
}


void
on_OddPages_radiobutton_toggled        (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	if(SigDisable()){
		if(togglebutton->active){
			UpdateData(ID_PAGE_SET, "odd");
		}
	}
	SigEnable();
}


void
on_EvenPages_radiobutton_toggled       (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	if(SigDisable()){
		if(togglebutton->active){
			UpdateData(ID_PAGE_SET, "even");
		}
	}
	SigEnable();
}


void
on_SelPages_radiobutton_toggled        (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	if(SigDisable()){
		if(togglebutton->active){
			UpdateData(ID_PAGE_SET, "range");
		}
	}
	SigEnable();
}

void
on_PageSelection_entry_changed         (GtkEditable     *editable,
                                        gpointer         user_data)
{
}

gboolean
on_PageSelection_entry_focus_out_event (GtkWidget       *widget,
                                        GdkEventFocus   *event,
                                        gpointer         user_data)
{
	if(SigDisable()){
		gchar *text;
		text = GetTextEntry(UI_DIALOG(g_main_window)->window, "PageSelection_entry");
		UpdateData(ID_PAGE_RANGES, text);
	}
	SigEnable();
	return FALSE;
}

void
on_Copies_spinbutton_changed           (GtkEditable     *editable,
                                        gpointer         user_data)
{
	if(SigDisable()){
		int value;
		value = GetSpinButtonValue(UI_DIALOG(g_main_window)->window, "Copies_spinbutton", 1);
		UpdateDataInt(ID_CNCOPIES, value);
	}
	SigEnable();
}

void
on_ReverseOrder_checkbutton_toggled    (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	if(SigDisable()){
		if(togglebutton->active)
			UpdateData(ID_OUTPUTORDER, "reverse");
		else
			UpdateData(ID_OUTPUTORDER, "normal");
	}
	SigEnable();
}

int ExecJobMode(UIMainDlg *main, int type)
{
	char *job;
	int print = 1;

	job = GetCurrOpt(ID_CNJOBEXECMODE, NULL);
	if(job != NULL){
		if(strcmp(job, "print") == 0)
			print = 1;
		else if(strcmp(job, "store") == 0)
			print = 1;
		else if(strcmp(job, "secured") == 0){
			gboolean doc;
			doc = (main->file_name == NULL) ? FALSE : TRUE;
			cngplpSetData(main->data, ID_SHOWDLG, "Secured");
			ShowPassWdDlg(main->prop->secured, TRUE, 0, doc, 1, 1);
			if(!main->print_ok){
				memFree(job);
				return 0;
			}
		}else if(strcmp(job, "hold") == 0)
			print = 1;
		memFree(job);
	}

	if(type == TRUE && main->prop->special_func){
		int job_account;
		int active_job;
		int is_color=0;
		char *active_color;
		job_account = GetCurrOptInt(ID_JOBACCOUNT, 0);
		if(job_account){
			active_job = GetCurrOptInt(ID_DISABLE_JOBACCOUNT_BW, 0);
			active_color = GetCurrOpt(ID_CNCOLORMODE, NULL);
			if(active_color !=NULL){
				if(strcmp(active_color, "mono") != 0){
					is_color = 1;
				}
				memFree(active_color);
			}
			if(!(active_job == 1 && is_color == 0)){
				cngplpSetData(main->data, ID_SHOWDLG, "JobAccount");
				ShowPassWdDlg(main->prop->jobaccount, TRUE, 1, 0, 1, 1);
				return main->print_ok;
			}

		}
	}

	return print;
}

void
on_MainOK_button_clicked               (GtkButton       *button,
                                        gpointer         user_data)
{
	if(ExecJobMode(g_main_window, TRUE)){
		cngplpSetData(g_main_window->data, ID_EXECLPR, "Print");
	}
	DisposeMainDlg(g_main_window);
	gtk_main_quit();
}

void
on_MainSave_button_clicked             (GtkButton       *button,
                                        gpointer         user_data)
{
	if(ExecJobMode(g_main_window, TRUE)){
		cngplpSetData(g_main_window->data, ID_EXECLPR, "Save");
		if(g_main_window->data->file_name != NULL)
			cngplpSetData(g_main_window->data, ID_EXECLPR, "Print");
	}
	DisposeMainDlg(g_main_window);
	gtk_main_quit();
}

void
on_MainCancel_button_clicked           (GtkButton       *button,
                                        gpointer         user_data)
{
	DisposeMainDlg(g_main_window);
	gtk_main_quit();
}

gboolean
on_PropertiesDlg_delete_event          (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
	if(SigDisable()){
		HidePropDlg(g_main_window->prop, FALSE);
	}
	SigEnable();
	return TRUE;
}


void
on_PropertiesDlg_destroy               (GtkObject       *object,
                                        gpointer         user_data)
{
}


void
on_PaperSize_combo_entry_changed       (GtkEditable     *editable,
                                        gpointer         user_data)
{
	if(SigDisable()){
		if(!g_PaperSize_mapped){
			UpdateDataCombo(ID_PAGESIZE, "PaperSize_combo_entry");
		}
	}
	SigEnable();
}

gboolean
on_PaperSize_combo_popwin_event	(GtkWidget	*widget, GdkEvent	*event,
					gpointer		user_data)
{
	if(event->type == GDK_MAP){
		g_PaperSize_mapped = TRUE;
	}else if(event->type == GDK_UNMAP){
		g_PaperSize_mapped = FALSE;
		if(SigDisable()){
			UpdateDataCombo(ID_PAGESIZE, "PaperSize_combo_entry");
		}
		SigEnable();
	}
	return FALSE;
}


void
on_Landscape_radiobutton_toggled       (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	if(SigDisable()){
		if(togglebutton->active){
			UpdateData(ID_ORIENTATION_REQUESTED, "4");
		}
	}
	SigEnable();
}


void
on_Portrait_radiobutton_toggled        (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	if(SigDisable()){
		if(togglebutton->active){
			UpdateData(ID_ORIENTATION_REQUESTED, "3");
		}
	}
	SigEnable();
}


void
on_ReversePortrait_radiobutton_toggled (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	if(SigDisable()){
		if(togglebutton->active){
			UpdateData(ID_ORIENTATION_REQUESTED, "6");
		}
	}
	SigEnable();
}


void
on_ReverseLandscape_radiobutton_toggled
                                        (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	if(SigDisable()){
		if(togglebutton->active){
			UpdateData(ID_ORIENTATION_REQUESTED, "5");
		}
	}
	SigEnable();
}

void
on_Nup_combo_entry_changed             (GtkEditable     *editable,
                                        gpointer         user_data)
{
	if(SigDisable()){
		if(!g_Nup_mapped){
			gchar *text, *tmp;
			tmp = GetCurrComboText(UI_DIALOG(g_main_window->prop)->window, "Nup_combo_entry");
			text = TextToName(ID_NUMBER_UP, tmp);
			UpdateData(ID_NUMBER_UP, text);
		}
	}
	SigEnable();
}

gboolean
on_Nup_combo_popwin_event	(GtkWidget	*widget, GdkEvent	*event,
					gpointer		user_data)
{
	if(event->type == GDK_MAP){
		g_Nup_mapped = TRUE;
	}else if(event->type == GDK_UNMAP){
		g_Nup_mapped = FALSE;
		if(SigDisable()){
			gchar *text, *tmp;
			tmp = GetCurrComboText(UI_DIALOG(g_main_window->prop)->window, "Nup_combo_entry");
			text = TextToName(ID_NUMBER_UP, tmp);
			UpdateData(ID_NUMBER_UP, text);
		}
		SigEnable();
	}
	return FALSE;
}

void
on_BrightnessValue_hscale_value_changed	(GtkWidget 	*widget,
					GtkAdjustment	*adjustment)
{
	if(SigDisable()){
		int value = (int)adjustment->value;
		int bright;
		if(value < 105 && value > 95){
			bright = 100;
		}else{
			bright = value;
		}

		UpdateDataInt(ID_BRIGHTNESS, bright);
	}
	SigEnable();
}

void
on_GammaValue_hscale_value_changed	(GtkWidget 	*widget,
					GtkAdjustment	*adjustment)
{
	if(SigDisable()){
		int value = (int)adjustment->value;
		int gamma;
		if(value < 1050 && value > 950){
			gamma = 1000;
		}else{
			int tmp;
			tmp = value % 5;
			gamma = value - tmp;
			if(gamma == 0)
				gamma = 1;
		}

		UpdateDataInt(ID_GAMMA, gamma);
	}
	SigEnable();
}

void
on_BannerEnd_combo_entry_changed       (GtkEditable     *editable,
                                        gpointer         user_data)
{
	if(SigDisable()){
		if(!g_BannerEnd_mapped){
			gchar *text;
			text = GetCurrComboText(UI_DIALOG(g_main_window->prop)->window, "BannerEnd_combo_entry");
			UpdateData(ID_JOB_SHEETS_END, text);
		}
	}
	SigEnable();
}

gboolean
on_BannerEnd_combo_popwin_event	(GtkWidget	*widget, GdkEvent	*event,
					gpointer		user_data)
{
	if(event->type == GDK_MAP){
		g_BannerEnd_mapped = TRUE;
	}else if(event->type == GDK_UNMAP){
		g_BannerEnd_mapped = FALSE;
		if(SigDisable()){
			gchar *text;
			text = GetCurrComboText(UI_DIALOG(g_main_window->prop)->window, "BannerEnd_combo_entry");
			UpdateData(ID_JOB_SHEETS_END, text);
		}
		SigEnable();
	}
	return FALSE;
}

void
on_BannerStart_combo_entry_changed     (GtkEditable     *editable,
                                        gpointer         user_data)
{
	if(SigDisable()){
		if(!g_BannerStart_mapped){
			gchar *text;
			text = GetCurrComboText(UI_DIALOG(g_main_window->prop)->window, "BannerStart_combo_entry");
			UpdateData(ID_JOB_SHEETS_START, text);
		}
	}
	SigEnable();
}

gboolean
on_BannerStart_combo_popwin_event	(GtkWidget	*widget, GdkEvent	*event,
					gpointer		user_data)
{
	if(event->type == GDK_MAP){
		g_BannerStart_mapped = TRUE;
	}else if(event->type == GDK_UNMAP){
		g_BannerStart_mapped = FALSE;
		if(SigDisable()){
			gchar *text;
			text = GetCurrComboText(UI_DIALOG(g_main_window->prop)->window, "BannerStart_combo_entry");
			UpdateData(ID_JOB_SHEETS_START, text);
		}
		SigEnable();
	}
	return FALSE;
}

void
on_BookletSetting_button_clicked       (GtkButton       *button,
                                        gpointer         user_data)
{
	ShowBookletDlg(g_main_window->prop->booklet);
}

void
on_Sided1Print_radiobutton_toggled     (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	if(SigDisable()){
		UpdateDataCheck(ID_SIDED1PRINT, (int)togglebutton->active);
	}
	SigEnable();
}


void
on_Sided2Print_radiobutton_toggled     (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	if(SigDisable()){
		UpdateDataCheck(ID_DUPLEX, (int)togglebutton->active);
	}
	SigEnable();
}


void
on_BookletPrint_radiobutton_toggled    (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	if(SigDisable()){
		UpdateDataCheck(ID_BOOKLET, (int)togglebutton->active);
	}
	SigEnable();
}

void
on_BindingLocation_combo_entry_changed (GtkEditable     *editable,
                                        gpointer         user_data)
{
	if(SigDisable()){
		if(!g_BindingLocation_mapped){
			UpdateDataCombo(ID_BINDEDGE, "BindingLocation_combo_entry");
		}
	}
	SigEnable();
}

gboolean
on_BindingLocation_combo_popwin_event	(GtkWidget	*widget, GdkEvent	*event,
					gpointer		user_data)
{
	if(event->type == GDK_MAP){
		g_BindingLocation_mapped = TRUE;
	}else if(event->type == GDK_UNMAP){
		g_BindingLocation_mapped = FALSE;
		if(SigDisable()){
			UpdateDataCombo(ID_BINDEDGE, "BindingLocation_combo_entry");
		}
		SigEnable();
	}
	return FALSE;
}

void
on_Gutter_button_clicked               (GtkButton       *button,
                                        gpointer         user_data)
{
	cngplpSetData(g_main_window->data, ID_SHOWDLG, "Gutter");
	ShowGutterDlg(g_main_window->prop->gutter);
}

void
on_FinCollate_combo_entry_changed      (GtkEditable     *editable,
                                        gpointer         user_data)
{
	if(SigDisable()){
		if(!g_FinCollate_mapped){
			UpdateDataCombo(ID_COLLATE, "FinCollate_combo_entry");
		}
	}
	SigEnable();
}

gboolean
on_FinCollate_combo_popwin_event	(GtkWidget	*widget,
					GdkEvent	*event,
					gpointer	user_date)
{
	if(event->type == GDK_MAP){
		g_FinCollate_mapped = TRUE;
	}else if(event->type == GDK_UNMAP){
		g_FinCollate_mapped = FALSE;
		if(SigDisable()){
			UpdateDataCombo(ID_COLLATE, "FinCollate_combo_entry");
		}
		SigEnable();
	}
	return FALSE;
}

void
on_FinHolePanch_checkbutton_toggled    (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	if(SigDisable()){
		UpdateDataCheck(ID_CNPUNCH, (int)togglebutton->active);
	}
	SigEnable();
}

void
on_FinZfold_checkbutton_toggled        (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	if(SigDisable()){
		UpdateDataCheck(ID_CNZFOLDING, (int)togglebutton->active);
	}
	SigEnable();
}

void
on_FinOffset_checkbutton_toggled       (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	if(SigDisable()){
		if(togglebutton->active)
			UpdateData(ID_CNOUTPUTPARTITION, "offset");
		else
			UpdateData(ID_CNOUTPUTPARTITION, "None");
	}
	SigEnable();
}


void
on_FinRotate_checkbutton_toggled       (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	if(SigDisable()){
		if(togglebutton->active)
			UpdateData(ID_CNOUTPUTPARTITION, "rotation");
		else
			UpdateData(ID_CNOUTPUTPARTITION, "None");
	}
	SigEnable();
}


void
on_SaddleStich_checkbutton_toggled     (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	if(SigDisable()){
		UpdateDataCheck(ID_CNSADDLESTITCH, (int)togglebutton->active);
	}
	SigEnable();
}


void
on_UseTrimmer_checkbutton_toggled      (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	if(SigDisable()){
		UpdateDataCheck(ID_CNTRIMMING, (int)togglebutton->active);
	}
	SigEnable();
}


void
on_PaperDisti_combo_entry_changed      (GtkEditable     *editable,
                                        gpointer         user_data)
{
	if(SigDisable()){
		if(!g_PaperDisti_mapped){
			UpdateDataCombo(ID_OUTPUTBIN, "PaperDisti_combo_entry");
		}
	}
	SigEnable();
}

gboolean
on_PaperDisti_combo_popwin_event	(GtkWidget	*widget, GdkEvent	*event,
					gpointer		user_data)
{
	if(event->type == GDK_MAP){
		g_PaperDisti_mapped = TRUE;
	}else if(event->type == GDK_UNMAP){
		g_PaperDisti_mapped = FALSE;
		if(SigDisable()){
			UpdateDataCombo(ID_OUTPUTBIN, "PaperDisti_combo_entry");
		}
		SigEnable();
	}
	return FALSE;
}

void
on_OutputSide_combo_entry_changed      (GtkEditable     *editable,
                                        gpointer         user_data)
{
	if(SigDisable()){
		if(!g_OutputSide_mapped){
			UpdateDataCombo(ID_CNOUTPUTFACE, "OutputSide_combo_entry");
		}
	}
	SigEnable();
}

gboolean
on_OutputSide_combo_popwin_event	(GtkWidget	*widget, GdkEvent	*event,
					gpointer		user_data)
{
	if(event->type == GDK_MAP){
		g_OutputSide_mapped = TRUE;
	}else if(event->type == GDK_UNMAP){
		g_OutputSide_mapped = FALSE;
		if(SigDisable()){
			UpdateDataCombo(ID_CNOUTPUTFACE, "OutputSide_combo_entry");
		}
		SigEnable();
	}
	return FALSE;
}

void
on_PaperSource_radiobutton_toggled     (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	if(SigDisable()){
		if(togglebutton->active)
			UpdateData(ID_SELECTBY, "1");
	}
	SigEnable();
}


void
on_PaperType_radiobutton_toggled       (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	if(SigDisable()){
		if(togglebutton->active)
			UpdateData(ID_SELECTBY, "2");
	}
	SigEnable();
}

void
on_PaperSource_combo_entry_changed     (GtkEditable     *editable,
                                        gpointer         user_data)
{
	if(SigDisable()){
		if(!g_PaperSource_mapped){
			UpdateDataCombo(ID_INPUTSLOT, "PaperSource_combo_entry");
		}
	}
	SigEnable();

}

gboolean
on_PaperSource_combo_popwin_event	(GtkWidget	*widget, GdkEvent	*event,
					gpointer		user_data)
{
	if(event->type == GDK_MAP){
		g_PaperSource_mapped = TRUE;
	}else if(event->type == GDK_UNMAP){
		g_PaperSource_mapped = FALSE;
		if(SigDisable()){
			UpdateDataCombo(ID_INPUTSLOT, "PaperSource_combo_entry");
		}
		SigEnable();
	}
	return FALSE;
}


void
on_PaperType_combo_entry_changed       (GtkEditable     *editable,
                                        gpointer         user_data)
{
	if(SigDisable()){
		if(!g_PaperType_mapped){
			UpdateDataCombo(ID_MEDIATYPE, "PaperType_combo_entry");
		}
	}
	SigEnable();

}

gboolean
on_PaperType_combo_popwin_event	(GtkWidget	*widget, GdkEvent	*event,
					gpointer		user_data)
{
	if(event->type == GDK_MAP){
		g_PaperType_mapped = TRUE;
	}else if(event->type == GDK_UNMAP){
		g_PaperType_mapped = FALSE;
		if(SigDisable()){
			UpdateDataCombo(ID_MEDIATYPE, "PaperType_combo_entry");
		}
		SigEnable();
	}
	return FALSE;
}

void
on_Inserter_checkbutton_toggled        (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	if(SigDisable()){
		UpdateDataCheck(ID_CNINSERTER, (int)togglebutton->active);
	}
	SigEnable();
}


void
on_ColorMode_Combo_entry_changed       (GtkEditable     *editable,
                                        gpointer         user_data)
{
	if(SigDisable()){
		if(!g_ColorMode_mapped){
			UpdateDataCombo(ID_CNCOLORMODE, "ColorMode_Combo_entry");
		}
	}
	SigEnable();
}

gboolean
on_ColorMode_combo_popwin_event	(GtkWidget	*widget, GdkEvent	*event,
					gpointer		user_data)
{
	if(event->type == GDK_MAP){
		g_ColorMode_mapped = TRUE;
	}else if(event->type == GDK_UNMAP){
		g_ColorMode_mapped = FALSE;
		if(SigDisable()){
			UpdateDataCombo(ID_CNCOLORMODE, "ColorMode_Combo_entry");
		}
		SigEnable();
	}
	return FALSE;
}


void
on_QualityHalftone_combo_entry_changed (GtkEditable     *editable,
                                        gpointer         user_data)
{
	if(SigDisable()){
		if(!g_QualityHalftone_mapped){
			UpdateDataCombo(ID_CNHALFTONE, "QualityHalftone_combo_entry");
		}
	}
	SigEnable();
}

gboolean
on_QualityHalftone_combo_popwin_event	(GtkWidget	*widget, GdkEvent	*event,
					gpointer		user_data)
{
	if(event->type == GDK_MAP){
		g_QualityHalftone_mapped = TRUE;
	}else if(event->type == GDK_UNMAP){
		g_QualityHalftone_mapped = FALSE;
		if(SigDisable()){
			UpdateDataCombo(ID_CNHALFTONE, "QualityHalftone_combo_entry");
		}
		SigEnable();
	}
	return FALSE;
}


void
on_QualityTonerSave_combo_entry_changed
                                        (GtkEditable     *editable,
                                        gpointer         user_data)
{
	if(SigDisable()){
		if(!g_QualityTonerSave_mapped){
			UpdateDataCombo(ID_CNTONERSAVING, "QualityTonerSave_combo_entry");
		}
	}
	SigEnable();
}

gboolean
on_QualityTonerSave_combo_popwin_event	(GtkWidget	*widget, GdkEvent	*event,
					gpointer		user_data)
{
	if(event->type == GDK_MAP){
		g_QualityTonerSave_mapped = TRUE;
	}else if(event->type == GDK_UNMAP){
		g_QualityTonerSave_mapped = FALSE;
		if(SigDisable()){
			UpdateDataCombo(ID_CNTONERSAVING, "QualityTonerSave_combo_entry");
		}
		SigEnable();
	}
	return FALSE;
}


void
on_QualityGrayComp_combo_entry_changed (GtkEditable     *editable,
                                        gpointer         user_data)
{
	if(SigDisable()){
		if(!g_QualityGrayComp_mapped){
			UpdateDataCombo(ID_CNBLACKSUBSTITUTE, "QualityGrayComp_combo_entry");
		}
	}
	SigEnable();
}

gboolean
on_QualityGrayComp_combo_popwin_event (GtkWidget	*widget,
					GdkEvent	*event,
					gpointer	user_data)
{
	if(event->type == GDK_MAP){
		g_QualityGrayComp_mapped = TRUE;
	}else if(event->type == GDK_UNMAP){
		g_QualityGrayComp_mapped = FALSE;
		if(SigDisable()){
			UpdateDataCombo(ID_CNBLACKSUBSTITUTE, "QualityGrayComp_combo_entry");
		}
		SigEnable();
	}
	return FALSE;
}

void
on_OutputMethod_combo_entry_changed    (GtkEditable     *editable,
                                        gpointer         user_data)
{
	if(SigDisable()){
		if(!g_OutputMethod_mapped){
			UpdateDataCombo(ID_CNJOBEXECMODE, "OutputMethod_combo_entry");
		}
	}
	SigEnable();
}

gboolean
on_OutputMethod_combo_popwin_event	(GtkWidget	*widget, GdkEvent	*event,
					gpointer		user_data)
{
	if(event->type == GDK_MAP){
		g_OutputMethod_mapped = TRUE;
	}else if(event->type == GDK_UNMAP){
		g_OutputMethod_mapped = FALSE;
		if(SigDisable()){
			UpdateDataCombo(ID_CNJOBEXECMODE, "OutputMethod_combo_entry");
		}
		SigEnable();
	}
	return FALSE;
}

void
on_OutputMethod_button_clicked         (GtkButton       *button,
                                        gpointer         user_data)
{
	char *method;
	method = GetCurrOpt(ID_CNJOBEXECMODE, NULL);
	if(method != NULL){
		if(strcmp(method, "secured") == 0){
			cngplpSetData(g_main_window->data, ID_SHOWDLG, "Secured");
			ShowPassWdDlg(g_main_window->prop->secured, FALSE, 0, 0, 1, 1);
		}else if(strcmp(method, "store") == 0){
			cngplpSetData(g_main_window->data, ID_SHOWDLG, "Boxid");
			ShowBoxIDDlg(g_main_window->prop->boxid);
		}
		else if(strcmp(method, "hold") == 0){
			cngplpSetData(g_main_window->data, ID_SHOWDLG, "HoldQueue");
			ShowHoldQueueDlg(g_main_window->prop->holdqueue);
		}
		memFree(method);
	}
}

void
on_OutputOption_combo_entry_changed    (GtkEditable     *editable,
                                        gpointer         user_data)
{
	if(SigDisable()){
		if(!g_OutputOption_mapped){
			UpdateDataCombo(ID_CNFINISHER, "OutputOption_combo_entry");
		}
	}
	SigEnable();
}

gboolean
on_OutputOption_combo_popwin_event	(GtkWidget	*widget, GdkEvent	*event,
					gpointer		user_data)
{
	if(event->type == GDK_MAP){
		g_OutputOption_mapped = TRUE;
	}else if(event->type == GDK_UNMAP){
		g_OutputOption_mapped = FALSE;
		if(SigDisable()){
			UpdateDataCombo(ID_CNFINISHER, "OutputOption_combo_entry");
		}
		SigEnable();
	}
	return FALSE;
}

void
on_SaddleFinisherG1_checkbutton_toggled
                                        (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
}


void
on_PaperFolding_checkbutton_toggled    (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	if(SigDisable()){
		UpdateDataCheck(ID_CNFOLDER, (int)togglebutton->active);
	}
	SigEnable();
}


void
on_PuncherUnit_checkbutton_toggled     (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	if(SigDisable()){
		UpdateDataCheck(ID_CNPUNCHER, (int)togglebutton->active);
	}
	SigEnable();

}


void
on_TrimmerUnit_checkbutton_toggled     (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	if(SigDisable()){
		UpdateDataCheck(ID_CNTRIMMER, (int)togglebutton->active);
	}
	SigEnable();

}


void
on_DocInsertUnit_checkbutton_toggled   (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	if(SigDisable()){
		UpdateDataCheck(ID_CNINSERTUNIT, (int)togglebutton->active);
	}
	SigEnable();

}


void
on_DuplexUnit_checkbutton_toggled      (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	if(SigDisable()){
		UpdateDataCheck(ID_CNDUPLEXUNIT, (int)togglebutton->active);
	}
	SigEnable();
}

void
on_JobAccouting_checkbutton_toggled    (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	if(SigDisable()){
		UpdateDataCheck(ID_JOBACCOUNT, (int)togglebutton->active);
	}
	SigEnable();
}

void
on_AllowPasswd_checkbutton_toggled     (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{

}

void
on_JobAccount_button_clicked           (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *window;
	gboolean active1, active2;
	window = UI_DIALOG(g_main_window->prop)->window;
	active1 = GetToggleButtonActive(window, "JobAccouting_checkbutton");
	active2 = GetToggleButtonActive(window, "AllowPasswd_checkbutton");
	cngplpSetData(g_main_window->data, ID_SHOWDLG, "JobAccount");
	ShowPassWdDlg(g_main_window->prop->jobaccount, FALSE, 1, 0, active1, active2);

}

void
on_DisableJobAccountingBW_checkbutton_toggled
                                        (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	if(SigDisable()){
		UpdateDataCheck(ID_DISABLE_JOBACCOUNT_BW, (int)togglebutton->active);
	}
	SigEnable();

}

void
on_CaptPaperSource_combo_entry_changed (GtkEditable     *editable,
                                        gpointer         user_data)
{
	if(SigDisable()){
		if(!g_CaptPaperSource_mapped){
			UpdateDataCombo(ID_INPUTSLOT, "CaptPaperSource_combo_entry");
		}
	}
	SigEnable();
}

gboolean
on_CaptPaperSource_combo_popwin_event	(GtkWidget	*widget, GdkEvent	*event,
					gpointer		user_data)
{
	if(event->type == GDK_MAP){
		g_CaptPaperSource_mapped = TRUE;
	}else if(event->type == GDK_UNMAP){
		g_CaptPaperSource_mapped = FALSE;
		if(SigDisable()){
			UpdateDataCombo(ID_INPUTSLOT, "CaptPaperSource_combo_entry");
		}
		SigEnable();
	}
	return FALSE;
}


void
on_CaptPaperType_combo_entry_changed   (GtkEditable     *editable,
                                        gpointer         user_data)
{
	if(SigDisable()){
		if(!g_CaptPaperType_mapped){
			UpdateDataCombo(ID_MEDIATYPE, "CaptPaperType_combo_entry");
		}
	}
	SigEnable();
}

gboolean
on_CaptPaperType_combo_popwin_event	(GtkWidget	*widget, GdkEvent	*event,
					gpointer		user_data)
{
	if(event->type == GDK_MAP){
		g_CaptPaperType_mapped = TRUE;
	}else if(event->type == GDK_UNMAP){
		g_CaptPaperType_mapped = FALSE;
		if(SigDisable()){
			UpdateDataCombo(ID_MEDIATYPE, "CaptPaperType_combo_entry");
		}
		SigEnable();
	}
	return FALSE;
}

void
on_CaptCollate_checkbutton_toggled     (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	if(SigDisable()){
		UpdateDataCheck(ID_COLLATE, (int)togglebutton->active);
	}
	SigEnable();
}

void
on_CaptHalftoneP1_radiobutton_toggled  (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	if(SigDisable()){
		if(togglebutton->active)
			UpdateData(ID_CNHALFTONE, "pattern1");
	}
	SigEnable();
}


void
on_CaptHalftoneP2_radiobutton_toggled  (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	if(SigDisable()){
		if(togglebutton->active)
			UpdateData(ID_CNHALFTONE, "pattern2");
	}
	SigEnable();
}


void
on_CaptHalftoneSmooth_radiobutton_toggled
                                        (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	if(SigDisable()){
		if(togglebutton->active)
			UpdateData(ID_CNHALFTONE, "pattern3");
	}
	SigEnable();
}


void
on_CaptTonerDensity1_radiobutton_toggled
                                        (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	if(SigDisable()){
		if(togglebutton->active)
			UpdateData(ID_CNTONERDENSITY, "1");
	}
	SigEnable();
}


void
on_CaptTonerDensity2_radiobutton_toggled
                                        (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	if(SigDisable()){
		if(togglebutton->active)
			UpdateData(ID_CNTONERDENSITY, "2");
	}
	SigEnable();
}


void
on_CaptTonerDensity3_radiobutton_toggled
                                        (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	if(SigDisable()){
		if(togglebutton->active)
			UpdateData(ID_CNTONERDENSITY, "3");
	}
	SigEnable();
}

void
on_CaptTonerDensity4_radiobutton_toggled
                                        (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	if(SigDisable()){
		if(togglebutton->active)
			UpdateData(ID_CNTONERDENSITY, "4");
	}
	SigEnable();
}


void
on_CaptTonerDensity5_radiobutton_toggled
                                        (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	if(SigDisable()){
		if(togglebutton->active)
			UpdateData(ID_CNTONERDENSITY, "5");
	}
	SigEnable();
}


void
on_CaptTonerSave_checkbutton_toggled   (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	if(SigDisable()){
		UpdateDataCheck(ID_CNTONERSAVING, (int)togglebutton->active);
	}
	SigEnable();
}

void
on_ImgRefinement_checkbutton_toggled   (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	if(SigDisable()){
		UpdateDataCheck(ID_CNSUPERSMOOTH, (int)togglebutton->active);
	}
	SigEnable();
}


void
on_Filter_combo_entry_changed          (GtkEditable     *editable,
                                        gpointer         user_data)
{
	if(SigDisable()){
		if(!g_Filter_mapped){
			gchar *text;
			text = GetCurrComboText(UI_DIALOG(g_main_window->prop)->window, "Filter_combo_entry");
			UpdateData(ID_FILTER, text);
		}
	}
	SigEnable();
}

gboolean
on_Filter_combo_popwin_event	(GtkWidget	*widget, GdkEvent	*event,
					gpointer		user_data)
{
	if(event->type == GDK_MAP){
		g_Filter_mapped = TRUE;
	}else if(event->type == GDK_UNMAP){
		g_Filter_mapped = FALSE;
		if(SigDisable()){
			gchar *text;
			text = GetCurrComboText(UI_DIALOG(g_main_window->prop)->window, "Filter_combo_entry");
			UpdateData(ID_FILTER, text);
		}
		SigEnable();
	}
	return FALSE;
}

void
on_ColorDefault_button_clicked         (GtkButton       *button,
                                        gpointer         user_data)
{
}

void
on_Resolution_radiobutton_toggled      (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	if(SigDisable()){
		if(togglebutton->active){
			UpdateData(ID_RESO_SCALE, "0");
		}
	}
	SigEnable();
}


void
on_Scale_radiobutton_toggled           (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	if(SigDisable()){
		if(togglebutton->active){
			UpdateData(ID_RESO_SCALE, "1");
		}
	}
	SigEnable();
}

void
on_PageScale_radiobutton_toggled       (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	if(SigDisable()){
		if(togglebutton->active){
			UpdateData(ID_RESO_SCALE, "2");
		}
	}
	SigEnable();
}

void
on_ImgPositionTL_radiobutton_toggled   (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	if(SigDisable()){
		if(togglebutton->active){
			UpdateData(ID_POSITION, "top-left");
		}
	}
	SigEnable();
}


void
on_ImgPositionTC_radiobutton_toggled   (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	if(SigDisable()){
		if(togglebutton->active){
			UpdateData(ID_POSITION, "top");
		}
	}
	SigEnable();

}


void
on_ImgPositionTR_radiobutton_toggled   (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	if(SigDisable()){
		if(togglebutton->active){
			UpdateData(ID_POSITION, "top-right");
		}
	}
	SigEnable();

}


void
on_ImgPositionCL_radiobutton_toggled   (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	if(SigDisable()){
		if(togglebutton->active){
			UpdateData(ID_POSITION, "left");
		}
	}
	SigEnable();

}


void
on_ImgPositionCC_radiobutton_toggled   (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	if(SigDisable()){
		if(togglebutton->active){
			UpdateData(ID_POSITION, "center");
		}
	}
	SigEnable();

}


void
on_ImgPositionCR_radiobutton_toggled   (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	if(SigDisable()){
		if(togglebutton->active){
			UpdateData(ID_POSITION, "right");
		}
	}
	SigEnable();

}


void
on_ImgPositionBL_radiobutton_toggled   (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	if(SigDisable()){
		if(togglebutton->active){
			UpdateData(ID_POSITION, "bottom-left");
		}
	}
	SigEnable();

}


void
on_ImgPositionBC_radiobutton_toggled   (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	if(SigDisable()){
		if(togglebutton->active){
			UpdateData(ID_POSITION, "bottom");
		}
	}
	SigEnable();

}


void
on_ImgPositionBR_radiobutton_toggled   (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	if(SigDisable()){
		if(togglebutton->active){
			UpdateData(ID_POSITION, "bottom-right");
		}
	}
	SigEnable();

}

void
on_Hue_hscale_value_changed	(GtkWidget 	*widget,
					GtkAdjustment	*adjustment)
{
	if(SigDisable()){
		int value = (int)adjustment->value;
		int hue;
		if(value < 5 && value > -5){
			hue = 0;
		}else{
			int tmp;
			tmp = value % 5;
			hue = value - tmp;
		}

		UpdateDataInt(ID_HUE, hue);
	}
	SigEnable();
}

void
on_Saturation_hscale_value_changed	(GtkWidget 	*widget,
					GtkAdjustment	*adjustment)
{
	if(SigDisable()){
		int value = (int)adjustment->value;
		int satu;
		if(value < 105 && value > 95){
			satu = 100;
		}else{
			int tmp;
			tmp = value % 5;
			satu = value - tmp;
		}
		UpdateDataInt(ID_SATURATION, satu);
	}
	SigEnable();
}

void
on_ImgReso_hscale_value_changed	(GtkWidget 	*widget,
					GtkAdjustment	*adjustment)
{
	if(SigDisable()){
		int value = (int)adjustment->value;
		int scale;
		if(value < 133 && value > 123){
			scale = 128;
		}else{
			scale = value;
		}
		UpdateDataInt(ID_PPI, scale);
	}
	SigEnable();
}

void
on_ImgPercent_hscale_value_changed	(GtkWidget 	*widget,
					GtkAdjustment	*adjustment)
{
	if(SigDisable()){
		int value = (int)adjustment->value;
		int scale;
		if(value < 5){
			scale = 1;
		}else{
			int tmp;
			tmp = value % 5;
			scale = value - tmp;
		}
		UpdateDataInt(ID_SCALING, scale);
	}
	SigEnable();
}

void
on_ImgPagePercent_hscale_value_changed	(GtkWidget 	*widget,
					GtkAdjustment	*adjustment)
{
	if(SigDisable()){
		int value = (int)adjustment->value;
		int scale;
		if(value < 5){
			scale = 1;
		}else{
			int tmp;
			tmp = value % 5;
			scale = value - tmp;
		}
		UpdateDataInt(ID_NATURAL_SCALING, scale);
	}
	SigEnable();
}
void
on_TextColumns_spinbutton_changed      (GtkEditable     *editable,
                                        gpointer         user_data)
{
	if(SigDisable()){
		int value;
		value = GetSpinButtonValue(UI_DIALOG(g_main_window->prop)->window, "TextColumns_spinbutton", 1);
		UpdateDataInt(ID_COLUMNS, value);
	}
	SigEnable();
}

void
on_TextCPI_spinbutton_changed          (GtkEditable     *editable,
                                        gpointer         user_data)
{
	if(SigDisable()){
		int value;
		value = GetSpinButtonValue(UI_DIALOG(g_main_window->prop)->window, "TextCPI_spinbutton", 1);
		UpdateDataInt(ID_CPI, value);
	}
	SigEnable();
}

void
on_TextLPI_spinbutton_changed          (GtkEditable     *editable,
                                        gpointer         user_data)
{
	if(SigDisable()){
		int value;
		value = GetSpinButtonValue(UI_DIALOG(g_main_window->prop)->window, "TextLPI_spinbutton", 1);
		UpdateDataInt(ID_LPI, value);
	}
	SigEnable();
}

void
on_CustomMargin_checkbutton_toggled    (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	if(SigDisable()){
		UpdateDataInt(ID_MARGIN, togglebutton->active);
	}
	SigEnable();
}

void
on_MarginBottom_spinbutton_changed     (GtkEditable     *editable,
                                        gpointer         user_data)
{
	if(SigDisable()){
		int value;
		value = GetSpinButtonValue(UI_DIALOG(g_main_window->prop)->window, "MarginBottom_spinbutton", 1);
		UpdateDataInt(ID_PAGE_BOTTOM, value);
	}
	SigEnable();
}

void
on_MarginLeft_spinbutton_changed       (GtkEditable     *editable,
                                        gpointer         user_data)
{
	if(SigDisable()){
		int value;
		value = GetSpinButtonValue(UI_DIALOG(g_main_window->prop)->window, "MarginLeft_spinbutton", 1);
		UpdateDataInt(ID_PAGE_LEFT, value);
	}
	SigEnable();
}

void
on_MarginRight_spinbutton_changed      (GtkEditable     *editable,
                                        gpointer         user_data)
{
	if(SigDisable()){
		int value;
		value = GetSpinButtonValue(UI_DIALOG(g_main_window->prop)->window, "MarginRight_spinbutton", 1);
		UpdateDataInt(ID_PAGE_RIGHT, value);
	}
	SigEnable();
}

void
on_MarginTop_spinbutton_changed        (GtkEditable     *editable,
                                        gpointer         user_data)
{
	if(SigDisable()){
		int value;
		value = GetSpinButtonValue(UI_DIALOG(g_main_window->prop)->window, "MarginTop_spinbutton", 1);
		UpdateDataInt(ID_PAGE_TOP, value);
	}
	SigEnable();
}

void
on_PrettyPrint_checkbutton_toggled     (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	if(SigDisable()){
		UpdateDataCheck(ID_PRETTYPRINT, (int)togglebutton->active);
	}
	SigEnable();
}
void
on_HPGL2BlackPen_checkbutton_toggled   (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	if(SigDisable()){
		UpdateDataCheck(ID_BLACKPLOT, (int)togglebutton->active);
	}
	SigEnable();
}

void
on_HPGL2FitPlot_checkbutton_toggled    (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	if(SigDisable()){
		UpdateDataCheck(ID_FITPLOT, (int)togglebutton->active);
	}
	SigEnable();
}


void
on_HPGL2PenWidth_spinbutton_changed
                                        (GtkEditable     *editable,
                                        gpointer         user_data)
{
	if(SigDisable()){
		float value;
		if(IsUS()){
			value = GetSpinButtonValueFloat(UI_DIALOG(g_main_window->prop)->window, "HPGL2PenWidth_spinbutton");
			value = value * 25.4 * 1000.0;
			if(value > 10000.0)
				value = 10000.0;
		}else
			value = GetSpinButtonValue(UI_DIALOG(g_main_window->prop)->window, "HPGL2PenWidth_spinbutton", 0);
		UpdateDataInt(ID_PENWIDTH, (int)value);
	}
	SigEnable();
}

void
on_PropOK_button_clicked               (GtkButton       *button,
                                        gpointer         user_data)
{
	if(SigDisable()){
		HidePropDlg(g_main_window->prop, TRUE);
	}
	SigEnable();
}


void
on_PropSave_button_clicked             (GtkButton       *button,
                                        gpointer         user_data)
{
	if(ExecJobMode(g_main_window, TRUE)){
		cngplpSetData(g_main_window->data, ID_EXECLPR, "Save");
	}
}


void
on_PropCancel_button_clicked           (GtkButton       *button,
                                        gpointer         user_data)
{
	if(SigDisable()){
		HidePropDlg(g_main_window->prop, FALSE);
	}
	SigEnable();
}


gboolean
on_BookletDlg_delete_event             (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
	if(SigDisable()){
		HideBookletDlg(g_main_window->prop->booklet, ID_CANCEL);
	}
	SigEnable();
	return TRUE;
}


void
on_BookletDlg_destroy                  (GtkObject       *object,
                                        gpointer         user_data)
{

}

void
on_BookletDlgOpening_combo_entry_changed
                                        (GtkEditable     *editable,
                                        gpointer         user_data)
{
	if(SigDisable()){
		if(!g_BookletDlgOpening_mapped){
			char *text, *tmp;
			tmp = GetCurrComboText(UI_DIALOG(g_main_window->prop->booklet)->window, "BookletDlgOpening_combo_entry");
			text = TextToName(ID_BOOKLET, tmp);
			UpdateData(ID_BOOKLET_DLG, text);
		}
	}
	SigEnable();
}

gboolean
on_BookletDlgOpening_combo_popwin_event	(GtkWidget	*widget, GdkEvent	*event,
					gpointer		user_data)
{
	if(event->type == GDK_MAP){
		g_BookletDlgOpening_mapped = TRUE;
	}else if(event->type == GDK_UNMAP){
		g_BookletDlgOpening_mapped = FALSE;
		if(SigDisable()){
			char *text, *tmp;
			tmp = GetCurrComboText(UI_DIALOG(g_main_window->prop->booklet)->window, "BookletDlgOpening_combo_entry");
			text = TextToName(ID_BOOKLET, tmp);
			UpdateData(ID_BOOKLET_DLG, text);
		}
		SigEnable();
	}
	return FALSE;
}

void
on_BookletDlgOK_button_clicked         (GtkButton       *button,
                                        gpointer         user_data)
{
	if(SigDisable()){
		HideBookletDlg(g_main_window->prop->booklet, ID_OK);
	}
	SigEnable();
}


void
on_BookletDlgCancel_button_clicked     (GtkButton       *button,
                                        gpointer         user_data)
{
	if(SigDisable()){
		HideBookletDlg(g_main_window->prop->booklet, ID_CANCEL);
	}
	SigEnable();
}

gboolean
on_GutterSettingDlg_delete_event       (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
	if(SigDisable()){
		HideGutterDlg(g_main_window->prop->gutter, ID_CANCEL);
	}
	SigEnable();
	return TRUE;
}


void
on_GutterSettingDlg_destroy            (GtkObject       *object,
                                        gpointer         user_data)
{

}

void
on_GutterSettingDlg_spinbutton_changed (GtkEditable     *editable,
                                        gpointer         user_data)
{
	if(SigDisable()){
		if(IsUS()){
			double value;
			value = GetSpinButtonValueFloat(UI_DIALOG(g_main_window->prop->gutter)->window, "GutterSettingDlg_spinbutton");
			UpdateDataDouble(ID_GUTTER, value);
		}else{
			int value;
			value = GetSpinButtonValue(UI_DIALOG(g_main_window->prop->gutter)->window, "GutterSettingDlg_spinbutton", 1);
			UpdateDataInt(ID_GUTTER, value);
		}
	}
	SigEnable();
}


void
on_GutterSettingOK_button_clicked      (GtkButton       *button,
                                        gpointer         user_data)
{
	if(SigDisable()){
		HideGutterDlg(g_main_window->prop->gutter, ID_OK);
	}
	SigEnable();
}


void
on_GutterSettingCancel_button_clicked  (GtkButton       *button,
                                        gpointer         user_data)
{
	if(SigDisable()){
		HideGutterDlg(g_main_window->prop->gutter, ID_CANCEL);
	}
	SigEnable();
}


void
on_QualityReso_combo_entry_changed     (GtkEditable     *editable,
                                        gpointer         user_data)
{
	if(SigDisable()){
		if(!g_QualityReso_mapped){
			UpdateDataCombo(ID_RESOLUTION, "QualityReso_combo_entry");
		}
	}
	SigEnable();
}

gboolean
on_QualityReso_combo_popwin_event	(GtkWidget	*widget, GdkEvent	*event,
					gpointer		user_data)
{
	if(event->type == GDK_MAP){
		g_QualityReso_mapped = TRUE;
	}else if(event->type == GDK_UNMAP){
		g_QualityReso_mapped = FALSE;
		if(SigDisable()){
			UpdateDataCombo(ID_RESOLUTION, "QualityReso_combo_entry");
		}
		SigEnable();
	}
	return FALSE;
}






void
on_StaplePosition_combo_entry_changed  (GtkEditable     *editable,
                                        gpointer         user_data)
{
	if(SigDisable()){
		if(!g_StaplePosition_mapped){
			UpdateDataCombo(ID_STAPLELOCATION, "StaplePosition_combo_entry");
		}
	}
	SigEnable();
}


gboolean
on_StaplePosition_combo_popwin_event	(GtkWidget	*widget,
					GdkEvent	*event,
					gpointer	user_data)
{
	if(event->type == GDK_MAP){
		g_StaplePosition_mapped = TRUE;
	}else if(event->type == GDK_UNMAP){
		g_StaplePosition_mapped = FALSE;
		if(SigDisable()){
			UpdateDataCombo(ID_STAPLELOCATION, "StaplePosition_combo_entry");
		}
		SigEnable();
	}
	return FALSE;
}

gboolean
on_DocName_entry_focus_out_event       (GtkWidget       *widget,
                                        GdkEventFocus   *event,
                                        gpointer         user_data)
{
	if(SigDisable()){
		char *text = NULL;
		text = GetTextEntry(UI_DIALOG(g_main_window->prop->secured)->window, "DocName_entry");
		if(text != NULL)
			UpdateData(ID_SECURED_DOCNAME, text);
	}
	SigEnable();
	return FALSE;
}

void UpdateIDEntry(UIPassWdDlg *dialog)
{
	gchar *id;
	id = GetTextEntry(UI_DIALOG(dialog)->window, "ID_entry");
	if(id != NULL){
		if(dialog->type == PASSWDDLG_SECURED)
			UpdateData(ID_SECURED_USRNAME, id);
		else
			UpdateData(ID_JOBACCOUNT_ID, id);
	}
}

void CheckIDEntry(UIPropDlg *prop, int dlg_type, gchar *entry_name)
{
	gchar id[128], *tmp;
	int num = 0, cnt = 0, i;
	GtkWidget *window = NULL;
	int code = 0;

	if(dlg_type == CHECK_PASSWD){
		code = prop->secured->code;
		window = UI_DIALOG(prop->secured)->window;
	}else if(dlg_type == CHECK_FINDETAILS){
		code = prop->captfin->code;
		window = UI_DIALOG(prop->captfin)->window;
	}
	if(code == 0)
		return;

	tmp = GetTextEntry(window, entry_name);
	num = strlen(tmp);

	for(i = 0; i < num; i++, cnt++){
		guchar ch = tmp[i];
		if(cnt >= 32)
			break;
		if(ch & 0x80){
			cnt++;
			if(cnt >= 32)
				break;
			switch(code){
			case 1:
				if(ch == 0x8F)
					i += 2;
				else
					i++;
				break;
			case 2:
				if(ch & 0x40){
					if(ch & 0x20){
						if(ch & 0x10)
							i += 3;
						else
							i += 2;
					}else{
						i++;
					}
				}
				break;
			}
		}
	}
	memset(id, 0, 128);
	strncpy(id, tmp, i);

	if(cnt >= 32){
		SetTextEntry(window, entry_name, id);
		SetCursolPosition(window, entry_name, -1);
	}
}

void
on_ID_entry_changed                    (GtkEditable     *editable,
                                        gpointer         user_data)
{
	if(SigDisable()){
		if(!g_main_window->prop->show_passwd)
			CheckIDEntry(g_main_window->prop, CHECK_PASSWD, "ID_entry");
	}
	SigEnable();
}

void
on_DocName_entry_changed               (GtkEditable     *editable,
                                        gpointer         user_data)
{
	if(SigDisable()){
		if(!g_main_window->prop->show_passwd)
			CheckIDEntry(g_main_window->prop, CHECK_PASSWD, "DocName_entry");
	}
	SigEnable();
}

gboolean
on_ID_entry_focus_out_event            (GtkWidget       *widget,
                                        GdkEventFocus   *event,
                                        gpointer         user_data)
{
	if(SigDisable()){
		if(g_main_window->prop->show_passwd)
			UpdateIDEntry(g_main_window->prop->jobaccount);
		else
			UpdateIDEntry(g_main_window->prop->secured);
	}
	SigEnable();
	return FALSE;
}

void UpdatePassWdEntry(UIPassWdDlg *dialog)
{
	gchar *text;
	int len = 0;
	text = GetTextEntry(UI_DIALOG(dialog)->window, "PassWd_entry");

	len = strlen(text);

	if(len < 8){
		text += len - 1;
		if(!(isdigit(*text)))
			len = len == 0 ? 0 : len - 1;
	}

	SetCursolPosition(UI_DIALOG(dialog)->window, "PassWd_entry", len);
}

void
on_PassWd_entry_changed                (GtkEditable     *editable,
                                        gpointer         user_data)
{
	if(SigDisable()){
		if(g_main_window->prop->show_passwd)
			UpdatePassWdEntry(g_main_window->prop->jobaccount);
		else
			UpdatePassWdEntry(g_main_window->prop->secured);
	}
	SigEnable();
}

void FocusOutPassWdEntry(UIPassWdDlg *dialog)
{
	gchar *ps;
	ps = GetTextEntry(UI_DIALOG(dialog)->window, "PassWd_entry");
	if(ps != NULL){
		if(dialog->type == PASSWDDLG_SECURED)
			UpdateData(ID_SECURED_PASSWD, ps);
		else
			UpdateData(ID_JOBACCOUNT_PASSWD, ps);
	}
}

gboolean
on_PassWd_entry_focus_out_event        (GtkWidget       *widget,
                                        GdkEventFocus   *event,
                                        gpointer         user_data)
{
	if(SigDisable()){
		if(g_main_window->prop->show_passwd)
			FocusOutPassWdEntry(g_main_window->prop->jobaccount);
		else
			FocusOutPassWdEntry(g_main_window->prop->secured);
	}
	SigEnable();
	return FALSE;
}

void
on_IdPassWdOK_button_clicked           (GtkButton       *button,
                                        gpointer         user_data)
{
	if(SigDisable()){
	if(g_main_window->prop->show_passwd)
		HidePassWdDlg(g_main_window->prop->jobaccount, TRUE);
	else
		HidePassWdDlg(g_main_window->prop->secured, TRUE);
	}
	SigEnable();
}


void
on_IdPassWdCancel_button_clicked       (GtkButton       *button,
                                        gpointer         user_data)
{
	if(SigDisable()){
	if(g_main_window->prop->show_passwd)
		HidePassWdDlg(g_main_window->prop->jobaccount, FALSE);
	else
		HidePassWdDlg(g_main_window->prop->secured, FALSE);
	}
	SigEnable();
}


void
on_IdPassWdDlg_destroy                 (GtkObject       *object,
                                        gpointer         user_data)
{
}

gboolean
on_IdPassWdDlg_delete_event            (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
	if(SigDisable()){
	if(g_main_window->prop->show_passwd)
		HidePassWdDlg(g_main_window->prop->jobaccount, FALSE);
	else
		HidePassWdDlg(g_main_window->prop->secured, FALSE);
	}
	SigEnable();
	return TRUE;
}

void
on_BoxIdDlg_destroy                    (GtkObject       *object,
                                        gpointer         user_data)
{
}

void CheckEnter(UIPropDlg  *prop, int dialog_type)
{
	gchar enter[128], *tmp = NULL;
	int num = 0, cnt = 0, i = 0, code = 0;

	if(dialog_type == CHECK_BOXID){
		code = prop->boxid->code;
		if(code == 0)
			return;
		tmp = GetTextEntry(UI_DIALOG(prop->boxid)->window, "EnterName_entry");
		num = strlen(tmp);
	}else if(dialog_type == CHECK_HOLDQUEUE){
		code = prop->holdqueue->code;
		if(code == 0)
			return;
		tmp = GetTextEntry(UI_DIALOG(prop->holdqueue)->window, "HoldQueue_EnterName_Entry");
		num = strlen(tmp);
	}

	for(i = 0; i < num; i++, cnt++){
		guchar ch = tmp[i];
		if(cnt >= 24)
			break;
		if(ch & 0x80){
			cnt++;
			if(cnt >= 24)
				break;
			switch(code){
			case 1:
				if(ch == 0x8F)
					i += 2;
				else
					i++;
				break;
			case 2:
				if(ch & 0x40){
					if(ch & 0x20){
						if(ch & 0x10)
							i += 3;
						else
							i += 2;
					}else{
						i++;
					}
				}
				break;
			}
		}
	}
	memset(enter, 0, 128);
	strncpy(enter, tmp, i);
	if(cnt >= 24){
		if(dialog_type == CHECK_BOXID){
			SetTextEntry(UI_DIALOG(prop->boxid)->window, "EnterName_entry", enter);
			SetCursolPosition(UI_DIALOG(prop->boxid)->window, "EnterName_entry", -1);
		}else if(dialog_type == CHECK_HOLDQUEUE){
			SetTextEntry(UI_DIALOG(prop->holdqueue)->window, "HoldQueue_EnterName_Entry", enter);
			SetCursolPosition(UI_DIALOG(prop->holdqueue)->window, "HoldQueue_EnterName_Entry", -1);
		}
	}
}

gboolean
on_BoxIdDlg_delete_event               (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
	if(SigDisable()){
		HideBoxIDDlg(g_main_window->prop->boxid, ID_CANCEL);
	}
	SigEnable();
	return TRUE;
}

void
on_EnterName_radiobutton_toggled       (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	if(SigDisable()){
		if(togglebutton->active){
			UpdateDataInt(ID_DATANAME, 0);
		}
	}
	SigEnable();
}

gboolean
on_EnterName_entry_focus_out_event     (GtkWidget       *widget,
                                        GdkEventFocus   *event,
                                        gpointer         user_data)
{
	if(SigDisable()){
		gchar *text;
		text = GetTextEntry(UI_DIALOG(g_main_window->prop->boxid)->window, "EnterName_entry");
		if(text != NULL)
			UpdateData(ID_ENTERNAME, text);
	}
	SigEnable();
	return FALSE;
}

void
on_EnterName_entry_changed             (GtkEditable     *editable,
                                        gpointer         user_data)
{
	if(SigDisable()){
		CheckEnter(g_main_window->prop, CHECK_BOXID);
	}
	SigEnable();
}


void
on_UseFileName_radiobutton_toggled     (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	if(SigDisable()){
		if(togglebutton->active){
			UpdateDataInt(ID_DATANAME, 1);
		}
	}
	SigEnable();
}

void
on_BoxID_spinbutton_changed            (GtkEditable     *editable,
                                        gpointer         user_data)
{
	if(SigDisable()){
		int value;
		value = GetSpinButtonValue(UI_DIALOG(g_main_window->prop->boxid)->window, "BoxID_spinbutton", 1);
		UpdateDataInt(ID_BOXIDNUM, value);
	}
	SigEnable();
}

void
on_BoxIDOK_button_clicked              (GtkButton       *button,
                                        gpointer         user_data)
{
	if(SigDisable()){
		HideBoxIDDlg(g_main_window->prop->boxid, ID_OK);
	}
	SigEnable();
}


void
on_BoxIDCancel_button_clicked          (GtkButton       *button,
                                        gpointer         user_data)
{
	if(SigDisable()){
		HideBoxIDDlg(g_main_window->prop->boxid, ID_CANCEL);
	}
	SigEnable();
}



void
on_Capt21TonerDensity1_radiobutton_toggled
                                        (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	if(SigDisable()){
		if(togglebutton->active)
			UpdateData(ID_CNTONERDENSITY, "1");
	}
	SigEnable();
}


void
on_Capt21TonerDensity2_radiobutton_toggled
                                        (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	if(SigDisable()){
		if(togglebutton->active)
			UpdateData(ID_CNTONERDENSITY, "2");
	}
	SigEnable();
}


void
on_Capt21TonerDensity3_radiobutton_toggled
                                        (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	if(SigDisable()){
		if(togglebutton->active)
			UpdateData(ID_CNTONERDENSITY, "3");
	}
	SigEnable();
}


void
on_Capt21TonerDensity4_radiobutton_toggled
                                        (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	if(SigDisable()){
		if(togglebutton->active)
			UpdateData(ID_CNTONERDENSITY, "4");
	}
	SigEnable();
}


void
on_Capt21TonerDensity5_radiobutton_toggled
                                        (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	if(SigDisable()){
		if(togglebutton->active)
			UpdateData(ID_CNTONERDENSITY, "5");
	}
	SigEnable();
}


void
on_Capt21TonerSave_checkbutton_toggled (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	if(SigDisable()){
		UpdateDataCheck(ID_CNTONERSAVING, (int)togglebutton->active);
	}
	SigEnable();
}


void
on_FinDetail_button_clicked            (GtkButton       *button,
                                        gpointer         user_data)
{
	cngplpSetData(g_main_window->data, ID_SHOWDLG, "FinDetail");
	ShowFinDetailsDlg(g_main_window->prop->captfin);
}

void
on_FinDetail_RotatePrint_checkbutton_toggled
                                        (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	if(SigDisable()){
		UpdateDataCheck(ID_CNROTATEPRINT, (int)togglebutton->active);
	}
	SigEnable();
}

gboolean
on_FinDetail_Img_combo_popwin_event(GtkWidget *widget, GdkEvent *event, gpointer user_data)
{
	if(event->type == GDK_MAP){
		g_FinDetail_Img_mapped = TRUE;
	}else if(event->type == GDK_UNMAP){
		g_FinDetail_Img_mapped = FALSE;
		if(SigDisable()){
			char *text, *tmp;
			tmp = GetCurrComboText(UI_DIALOG(g_main_window->prop->captfin)->window, "FinDetail_Img_combo_entry");
			text = TextToName(ID_CNSUPERSMOOTH, tmp);
			UpdateData(ID_CNSUPERSMOOTH, text);
		}
		SigEnable();
	}
	return FALSE;
}

void
on_FinDetail_Img_combo_entry_changed   (GtkEditable     *editable,
                                        gpointer         user_data)
{
	if(SigDisable()){
		if(!g_FinDetail_Img_mapped){
			char *text, *tmp;
			tmp = GetCurrComboText(UI_DIALOG(g_main_window->prop->captfin)->window, "FinDetail_Img_combo_entry");
			text = TextToName(ID_CNSUPERSMOOTH, tmp);
			UpdateData(ID_CNSUPERSMOOTH, text);
		}
	}
	SigEnable();
}

gboolean
on_FinDetail_Fix_combo_popwin_event(GtkWidget *widget, GdkEvent *event, gpointer user_data)
{
	if(event->type == GDK_MAP){
		g_FinDetail_Fix_mapped = TRUE;
	}else if(event->type == GDK_UNMAP){
		g_FinDetail_Fix_mapped = FALSE;
		if(SigDisable()){
			char *text, *tmp;
			tmp = GetCurrComboText(UI_DIALOG(g_main_window->prop->captfin)->window, "FinDetail_Fix_combo_entry");
			text = TextToName(ID_CNFIXINGMODE, tmp);
			UpdateData(ID_CNFIXINGMODE, text);
		}
		SigEnable();
	}
	return FALSE;
}

void
on_FinDetail_Fix_combo_entry_changed   (GtkEditable     *editable,
                                        gpointer         user_data)
{
	if(SigDisable()){
		if(!g_FinDetail_Fix_mapped){
			char *text, *tmp;
			tmp = GetCurrComboText(UI_DIALOG(g_main_window->prop->captfin)->window, "FinDetail_Fix_combo_entry");
			text = TextToName(ID_CNFIXINGMODE, tmp);
			UpdateData(ID_CNFIXINGMODE, text);
		}
	}
	SigEnable();
}


void
on_FinDetail_BackPrint_checkbutton_toggled
                                        (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	if(SigDisable()){
		UpdateDataCheck(ID_CNBACKPAPERPRINT, (int)togglebutton->active);
	}
	SigEnable();
}



void
on_FinDetail_dialog_destroy            (GtkObject       *object,
                                        gpointer         user_data)
{

}

gboolean
on_FinDetail_dialog_delete_event       (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
	if(SigDisable()){
		HideFinDetailsDlg(g_main_window->prop->captfin, ID_CANCEL);
	}
	SigEnable();
	return TRUE;
}


void
on_FinDetail_OK_button_clicked         (GtkButton       *button,
                                        gpointer         user_data)
{
	if(SigDisable()){
		HideFinDetailsDlg(g_main_window->prop->captfin, ID_OK);
	}
	SigEnable();
}


void
on_FinDetail_Cancel_button_clicked     (GtkButton       *button,
                                        gpointer         user_data)
{
	if(SigDisable()){
		HideFinDetailsDlg(g_main_window->prop->captfin, ID_CANCEL);
	}
	SigEnable();
}


gboolean
on_ImgSpecialProc_combo_popwin_event(GtkWidget *widget, GdkEvent *event,
										gpointer user_data)
{
	if(event->type == GDK_MAP){
		g_ImgSpecialProc_mapped = TRUE;
	}else if(event->type == GDK_UNMAP){
		g_ImgSpecialProc_mapped = FALSE;
		if(SigDisable()){
			UpdateDataCombo(ID_CNIMAGESPECIALPROCESS, "ImgSpecialProc_combo_entry");
		}
		SigEnable();
	}
	return FALSE;
}

void
on_ImgSpecialProc_combo_entry_changed
                                        (GtkEditable     *editable,
                                        gpointer         user_data)
{
	if(SigDisable()){
		if(!g_ImgSpecialProc_mapped){
			UpdateDataCombo(ID_CNIMAGESPECIALPROCESS, "ImgSpecialProc_combo_entry");
		}
	}
	SigEnable();
}


gboolean
on_QualityDraftMode_combo_popwin_event(GtkWidget *widget, GdkEvent *event,
										gpointer user_data)
{
	if(event->type == GDK_MAP){
		g_QualityDraftMode_mapped = TRUE;
	}else if(event->type == GDK_UNMAP){
		g_QualityDraftMode_mapped = FALSE;
		if(SigDisable()){
			UpdateDataCombo(ID_CNDRAFTMODE, "QualityDraftMode_combo_entry");
		}
		SigEnable();
	}
	return FALSE;
}

void
on_QualityDraftMode_combo_entry_changed
                                        (GtkEditable     *editable,
                                        gpointer         user_data)
{
	if(SigDisable()){
		if(!g_QualityDraftMode_mapped){
			UpdateDataCombo(ID_CNDRAFTMODE, "QualityDraftMode_combo_entry");
		}
	}
	SigEnable();
}


void
on_Interleaf_checkbutton_toggled
                                        (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	if(SigDisable()){
		UpdateDataCheck(ID_CNINTERLEAFSHEET, (int)togglebutton->active);
	}
	SigEnable();
}

gboolean
on_InterleafMediaType_combo_popwin_event(GtkWidget *widget, GdkEvent *event,
										gpointer user_data)
{
	if(event->type == GDK_MAP){
		g_InterleafMediaType_mapped = TRUE;
	}else if(event->type == GDK_UNMAP){
		g_InterleafMediaType_mapped = FALSE;
		if(SigDisable()){
			UpdateDataCombo(ID_CNINTERLEAFMEDIATYPE, "InterleafMediaType_combo_entry");
		}
		SigEnable();
	}
	return FALSE;
}

void
on_InterleafMediaType_changed
                                        (GtkEditable     *editable,
                                        gpointer         user_data)
{
	if(SigDisable()){
		if(!g_InterleafMediaType_mapped){
			UpdateDataCombo(ID_CNINTERLEAFMEDIATYPE, "InterleafMediaType_combo_entry");
		}
	}
	SigEnable();
}

void
on_PrintInterleaf_checkbutton_toggled
                                        (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	if(SigDisable()){
		UpdateDataCheck(ID_CNINTERLEAFPRINT, (int)togglebutton->active);
	}
	SigEnable();
}


void
on_SourceOption_combo_entry_changed    (GtkEditable     *editable,
                                        gpointer         user_data)
{
	if(SigDisable()){
		if(!g_SourceOption_mapped){
			UpdateDataCombo(ID_CNSRCOPTION, "SourceOption_combo_entry");
		}
	}
	SigEnable();
}

gboolean
on_SourceOption_combo_popwin_event(GtkWidget *widget, GdkEvent *event, gpointer user_data)
{
	if(event->type == GDK_MAP){
		g_SourceOption_mapped = TRUE;
	}else if(event->type == GDK_UNMAP){
		g_SourceOption_mapped = FALSE;
		if(SigDisable()){
			UpdateDataCombo(ID_CNSRCOPTION, "SourceOption_combo_entry");
		}
		SigEnable();
	}
	return FALSE;
}


void
on_FinDetail_DetectPaper_checkbutton_toggled
                                        (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	if(SigDisable()){
		UpdateDataCheck(ID_CNDETECTPAPERSIZE, (int)togglebutton->active);
	}
	SigEnable();
}


void
on_FinDetail_SkipBlank_checkbutton_toggled
                                        (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	if(SigDisable()){
		UpdateDataCheck(ID_CNSKIPBLANK, (int)togglebutton->active);
	}
	SigEnable();
}

void
on_QualityKeepGray_combo_entry_changed (GtkEditable     *editable,
                                        gpointer         user_data)
{
	if(SigDisable()){
		if(!g_KeepGray_mapped){
			UpdateDataCombo(ID_CNKEEPGRAY, "QualityKeepGray_combo_entry");
		}
	}
	SigEnable();
}


void
on_QualityClrHalftone_combo_entry_changed
                                        (GtkEditable     *editable,
                                        gpointer         user_data)
{
	if(SigDisable()){
		if(!g_ColorHalftone_mapped){
			UpdateDataCombo(ID_CNCOLORHALFTONE, "QualityClrHalftone_combo_entry");
		}
	}
	SigEnable();
}

gboolean
on_QualityClrHalftone_combo_popwin_event(GtkWidget *widget, GdkEvent *event, gpointer user_data)
{
	if(event->type == GDK_MAP){
		g_ColorHalftone_mapped = TRUE;
	}else if(event->type == GDK_UNMAP){
		g_ColorHalftone_mapped = FALSE;
		if(SigDisable()){
			UpdateDataCombo(ID_CNCOLORHALFTONE, "QualityClrHalftone_combo_entry");
		}
		SigEnable();
	}
	return FALSE;
}

gboolean
on_QualityKeepGray_combo_popwin_event(GtkWidget *widget, GdkEvent *event, gpointer user_data)
{
	if(event->type == GDK_MAP){
		g_KeepGray_mapped = TRUE;
	}else if(event->type == GDK_UNMAP){
		g_KeepGray_mapped = FALSE;
		if(SigDisable()){
			UpdateDataCombo(ID_CNKEEPGRAY, "QualityKeepGray_combo_entry");
		}
		SigEnable();
	}
	return FALSE;
}

void
on_Cyan_hscale_value_changed	(GtkWidget 	*widget,
					GtkAdjustment	*adjustment)
{
	if(SigDisable()){
		int value = (int)adjustment->value;
		UpdateDataInt(ID_CNCTONERDENSITY, value);
	}
	SigEnable();
}

void
on_Magenta_hscale_value_changed	(GtkWidget 	*widget,
					GtkAdjustment	*adjustment)
{
	if(SigDisable()){
		int value = (int)adjustment->value;
		UpdateDataInt(ID_CNMTONERDENSITY, value);
	}
	SigEnable();
}

void
on_Yellow_hscale_value_changed	(GtkWidget 	*widget,
					GtkAdjustment	*adjustment)
{
	if(SigDisable()){
		int value = (int)adjustment->value;
		UpdateDataInt(ID_CNYTONERDENSITY, value);
	}
	SigEnable();
}

void
on_Black_hscale_value_changed	(GtkWidget 	*widget,
					GtkAdjustment	*adjustment)
{
	if(SigDisable()){
		int value = (int)adjustment->value;
		UpdateDataInt(ID_CNTONERDENSITY, value);
	}
	SigEnable();
}


static GdkPixmap *CyanPixmap = NULL;
static GdkPixmap *MagentaPixmap = NULL;
static GdkPixmap *YellowPixmap = NULL;
static GdkPixmap *BlackPixmap = NULL;
static GdkPixmap *SharpnessPixmap = NULL;

enum {
	CYAN,
	MAGENTA,
	YELLOW,
	BLACK,
	SHARPNESS,
};

void PaintScale(GtkWidget *window, char *area_name, char *hscale_name, GdkPixmap *pixmap)
{
	GdkGC *gc;
	GdkColor color;
	GtkWidget *drawingarea, *hscale;
	int slider = 0, width = 0, init = 0, i, x = 0;
	int value_range = 15;

	if(pixmap == SharpnessPixmap)
		value_range = 6;

	drawingarea = getWidget(window, area_name);
	hscale = getWidget(window, hscale_name);

#ifdef OLD_GTK
	slider = GTK_SCALE_CLASS(GTK_OBJECT(hscale)->klass)->slider_length;
#else
	GValue temp = {0,};
	g_value_init(&temp, G_TYPE_INT);
	gtk_widget_style_get_property(hscale, "slider-length", &temp);
	slider = g_value_get_int(&temp);
#endif
	width = drawingarea->allocation.width;
	init = slider / 2 + 3;

	gc = gdk_gc_new(pixmap);
	gdk_gc_set_line_attributes(gc, 1, GDK_LINE_SOLID,
					GDK_CAP_BUTT, GDK_JOIN_MITER);

	color.red = 0;
	color.green = 0;
	color.blue = 0;
	gdk_color_alloc(gdk_colormap_get_system(), &color);
	gdk_gc_set_foreground(gc, &color);

	for(i = 0; i < (value_range + 1); i++){
		x = ((init * (value_range - i)) + ((width - init) *  i))/value_range;

		if(i == 0 || i == value_range)
			gdk_draw_line(pixmap, gc, x, 7, x, 12);
		else
			gdk_draw_line(pixmap, gc, x, 10, x, 12);
		if(i == value_range / 2){
			int j;
			for(j = 0; j < 3; j++){
				gdk_draw_line(pixmap, gc, x - j, 5 - j, x + 1 + j, 5 - j);
			}
		}
	}

	gdk_gc_destroy(gc);
}

void ConfigureEvent(GtkWidget *window, GdkEventConfigure *event, int nID)
{
	GtkWidget *drawingarea;

	switch(nID){
	case CYAN:
		drawingarea = getWidget(window, "Cyan_drawingarea");
		gdk_draw_rectangle(CyanPixmap, drawingarea->style->bg_gc[GTK_WIDGET_STATE(drawingarea)], TRUE, 0, 0, drawingarea->allocation.width, drawingarea->allocation.height);
		PaintScale(window, "Cyan_drawingarea", "Cyan_hscale", CyanPixmap);
		break;
	case MAGENTA:
		drawingarea = getWidget(window, "Magenta_drawingarea");
		gdk_draw_rectangle(MagentaPixmap, drawingarea->style->bg_gc[GTK_WIDGET_STATE(drawingarea)], TRUE, 0, 0, drawingarea->allocation.width, drawingarea->allocation.height);
		PaintScale(window, "Magenta_drawingarea", "Magenta_hscale", MagentaPixmap);
		break;
	case YELLOW:
		drawingarea = getWidget(window, "Yellow_drawingarea");
		gdk_draw_rectangle(YellowPixmap, drawingarea->style->bg_gc[GTK_WIDGET_STATE(drawingarea)], TRUE, 0, 0, drawingarea->allocation.width, drawingarea->allocation.height);
		PaintScale(window, "Yellow_drawingarea", "Yellow_hscale", YellowPixmap);
		break;
	case BLACK:
		drawingarea = getWidget(window, "Black_drawingarea");
		gdk_draw_rectangle(BlackPixmap, drawingarea->style->bg_gc[GTK_WIDGET_STATE(drawingarea)], TRUE, 0, 0, drawingarea->allocation.width, drawingarea->allocation.height);
		PaintScale(window, "Black_drawingarea", "Black_hscale", BlackPixmap);
		break;
	case SHARPNESS:
		drawingarea = getWidget(window, "Sharpness_drawingarea");
		gdk_draw_rectangle(SharpnessPixmap, drawingarea->style->bg_gc[GTK_WIDGET_STATE(drawingarea)], TRUE, 0, 0, drawingarea->allocation.width, drawingarea->allocation.height);
		PaintScale(window, "Sharpness_drawingarea", "Sharpness_hscale", SharpnessPixmap);
		break;
	}
}

void ExposeEvent(GtkWidget *window, GdkEventExpose *event, int nID)
{
	GtkWidget *drawingarea;
	if(event->count != 0)
		return;

	switch(nID){
	case CYAN:
		drawingarea = getWidget(window, "Cyan_drawingarea");
		gdk_draw_pixmap(drawingarea->window, drawingarea->style->fg_gc[GTK_WIDGET_STATE(drawingarea)], CyanPixmap, event->area.x, event->area.y, event->area.x, event->area.y, event->area.width, event->area.height);
		break;
	case MAGENTA:
		drawingarea = getWidget(window, "Magenta_drawingarea");
		gdk_draw_pixmap(drawingarea->window, drawingarea->style->fg_gc[GTK_WIDGET_STATE(drawingarea)], MagentaPixmap, event->area.x, event->area.y, event->area.x, event->area.y, event->area.width, event->area.height);
		break;
	case YELLOW:
		drawingarea = getWidget(window, "Yellow_drawingarea");
		gdk_draw_pixmap(drawingarea->window, drawingarea->style->fg_gc[GTK_WIDGET_STATE(drawingarea)], YellowPixmap, event->area.x, event->area.y, event->area.x, event->area.y, event->area.width, event->area.height);
		break;
	case BLACK:
		drawingarea = getWidget(window, "Black_drawingarea");
		gdk_draw_pixmap(drawingarea->window, drawingarea->style->fg_gc[GTK_WIDGET_STATE(drawingarea)], BlackPixmap, event->area.x, event->area.y, event->area.x, event->area.y, event->area.width, event->area.height);
		break;
	case SHARPNESS:
		drawingarea = getWidget(window, "Sharpness_drawingarea");
		gdk_draw_pixmap(drawingarea->window, drawingarea->style->fg_gc[GTK_WIDGET_STATE(drawingarea)], SharpnessPixmap, event->area.x, event->area.y, event->area.x, event->area.y, event->area.width, event->area.height);
		break;
	}
}

gboolean
on_Cyan_drawingarea_configure_event    (GtkWidget       *widget,
                                        GdkEventConfigure *event,
                                        gpointer         user_data)
{
	if(CyanPixmap)
		gdk_pixmap_unref(CyanPixmap);

	CyanPixmap = gdk_pixmap_new(widget->window, widget->allocation.width,
				widget->allocation.height, -1);

	ConfigureEvent(UI_DIALOG(g_main_window->prop)->window, event, CYAN);

	return TRUE;
}

gboolean
on_Cyan_drawingarea_expose_event       (GtkWidget       *widget,
                                        GdkEventExpose  *event,
                                        gpointer         user_data)
{
	if(CyanPixmap == NULL)
		return TRUE;
	ExposeEvent(UI_DIALOG(g_main_window->prop)->window, event, CYAN);
	return TRUE;
}


gboolean
on_Magenta_drawingarea_expose_event    (GtkWidget       *widget,
                                        GdkEventExpose  *event,
                                        gpointer         user_data)
{

	if(MagentaPixmap == NULL)
		return TRUE;
	ExposeEvent(UI_DIALOG(g_main_window->prop)->window, event, MAGENTA);
	return TRUE;
}


gboolean
on_Magenta_drawingarea_configure_event (GtkWidget       *widget,
                                        GdkEventConfigure *event,
                                        gpointer         user_data)
{
	if(MagentaPixmap)
		gdk_pixmap_unref(MagentaPixmap);
	MagentaPixmap = gdk_pixmap_new(widget->window, widget->allocation.width,
				widget->allocation.height, -1);
	ConfigureEvent(UI_DIALOG(g_main_window->prop)->window, event, MAGENTA);
	return TRUE;
}


gboolean
on_Yellow_drawingarea_configure_event  (GtkWidget       *widget,
                                        GdkEventConfigure *event,
                                        gpointer         user_data)
{
	if(YellowPixmap)
		gdk_pixmap_unref(YellowPixmap);
	YellowPixmap = gdk_pixmap_new(widget->window, widget->allocation.width,
				widget->allocation.height, -1);
	ConfigureEvent(UI_DIALOG(g_main_window->prop)->window, event, YELLOW);
	return TRUE;
}


gboolean
on_Yellow_drawingarea_expose_event     (GtkWidget       *widget,
                                        GdkEventExpose  *event,
                                        gpointer         user_data)
{

	if(YellowPixmap == NULL)
		return TRUE;
	ExposeEvent(UI_DIALOG(g_main_window->prop)->window, event, YELLOW);
	return TRUE;
}


gboolean
on_Black_drawingarea_configure_event   (GtkWidget       *widget,
                                        GdkEventConfigure *event,
                                        gpointer         user_data)
{
	if(BlackPixmap)
		gdk_pixmap_unref(BlackPixmap);
	BlackPixmap = gdk_pixmap_new(widget->window, widget->allocation.width,
				widget->allocation.height, -1);
	ConfigureEvent(UI_DIALOG(g_main_window->prop)->window, event, BLACK);
	return TRUE;
}


gboolean
on_Black_drawingarea_expose_event      (GtkWidget       *widget,
                                        GdkEventExpose  *event,
                                        gpointer         user_data)
{
	if(BlackPixmap == NULL)
		return TRUE;
	ExposeEvent(UI_DIALOG(g_main_window->prop)->window, event, BLACK);
	return TRUE;
}


gboolean
on_ProfileSettingsDlg_delete_event     (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
	if(SigDisable()){
		HideProfileDlg(g_main_window->prop->profile, ID_CANCEL);
	}
	SigEnable();
	return TRUE;
}


void
on_ProfileSettingsDlg_destroy          (GtkObject       *object,
                                        gpointer         user_data)
{

}


void
on_ProfileDlgOutput_combo_entry_changed
                                        (GtkEditable     *editable,
                                        gpointer         user_data)
{
	if(SigDisable()){
		if(!g_OutputProfile_mapped){
			UpdateDataComboProfileDialog(ID_CNOUTPUTPROFILE, "ProfileDlgOutput_combo_entry");;
		}
	}
	SigEnable();
}


gboolean
on_ProfileDlgOutput_combo_popwin_event	(GtkWidget	*widget, GdkEvent	*event,
					gpointer		user_data)
{
	if(event->type == GDK_MAP){
		g_OutputProfile_mapped = TRUE;
	}else if(event->type == GDK_UNMAP){
		g_OutputProfile_mapped = FALSE;
		if(SigDisable()){
			UpdateDataComboProfileDialog(ID_CNOUTPUTPROFILE, "ProfileDlgOutput_combo_entry");
		}
		SigEnable();
	}
	return FALSE;
}


void
on_ProfileDlgOK_button_clicked         (GtkButton       *button,
                                        gpointer         user_data)
{
	if(SigDisable()){
		HideProfileDlg(g_main_window->prop->profile, ID_OK);
	}
	SigEnable();
}


void
on_ProfileDlgCancel_button_clicked     (GtkButton       *button,
                                        gpointer         user_data)
{
	if(SigDisable()){
		HideProfileDlg(g_main_window->prop->profile, ID_CANCEL);
	}
	SigEnable();
}


void
on_ProfileSettings_button_clicked      (GtkButton       *button,
                                        gpointer         user_data)
{
	ShowProfileDlg(g_main_window->prop->profile);
}


void
on_ProfileDlgUseGrayscale_checkbutton_toggled
                                        (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	if(SigDisable()){
		UpdateDataCheck(ID_CNUSEGRAYSCALEPROFILE, (int)togglebutton->active);
	}
	SigEnable();
}


void
on_ProfileDlgPBText_combo_entry_changed
                                        (GtkEditable     *editable,
                                        gpointer         user_data)
{
	if(SigDisable()){
		if(!g_PureBlackText_mapped){
			UpdateDataComboProfileDialog(ID_CNPUREBLACKTEXT, "ProfileDlgPBText_combo_entry");
		}
	}
	SigEnable();
}


gboolean
on_ProfileDlgPBText_combo_popwin_event	(GtkWidget	*widget, GdkEvent	*event,
					gpointer		user_data)
{
	if(event->type == GDK_MAP){
		g_PureBlackText_mapped = TRUE;
	}else if(event->type == GDK_UNMAP){
		g_PureBlackText_mapped = FALSE;
		if(SigDisable()){
			UpdateDataComboProfileDialog(ID_CNPUREBLACKTEXT, "ProfileDlgPBText_combo_entry");
		}
		SigEnable();
	}
	return FALSE;
}


void
on_ProfileDlgBOverprint_combo_entry_changed
                                        (GtkEditable     *editable,
                                        gpointer         user_data)
{
	if(SigDisable()){
		if(!g_BlackOverprint_mapped){
			UpdateDataComboProfileDialog(ID_CNBLACKOVERPRINT, "ProfileDlgBOverprint_combo_entry");
		}
	}
	SigEnable();
}


gboolean
on_ProfileDlgBOverprint_combo_popwin_event	(GtkWidget	*widget, GdkEvent	*event,
					gpointer		user_data)
{
	if(event->type == GDK_MAP){
		g_BlackOverprint_mapped = TRUE;
	}else if(event->type == GDK_UNMAP){
		g_BlackOverprint_mapped = FALSE;
		if(SigDisable()){
			UpdateDataComboProfileDialog(ID_CNBLACKOVERPRINT, "ProfileDlgBOverprint_combo_entry");
		}
		SigEnable();
	}
	return FALSE;
}


void
on_ProfileDlgSourceProfile_combo_entry_changed
                                        (GtkEditable     *editable,
                                        gpointer         user_data)
{
	if(SigDisable()){
		if(!g_RGBSourceProfile_mapped){
			UpdateDataComboProfileDialog(ID_CNRGBSOURCEPROFILE, "ProfileDlgSourceProfile_combo_entry");
		}
	}
	SigEnable();
}


gboolean
on_ProfileDlgSourceProfile_combo_popwin_event	(GtkWidget	*widget, GdkEvent	*event,
					gpointer		user_data)
{
	if(event->type == GDK_MAP){
		g_RGBSourceProfile_mapped = TRUE;
	}else if(event->type == GDK_UNMAP){
		g_RGBSourceProfile_mapped = FALSE;
		if(SigDisable()){
			UpdateDataComboProfileDialog(ID_CNRGBSOURCEPROFILE, "ProfileDlgSourceProfile_combo_entry");
		}
		SigEnable();
	}
	return FALSE;
}


void
on_ProfileDlgMatchingMethod_combo_entry_changed
                                        (GtkEditable     *editable,
                                        gpointer         user_data)
{
	if(SigDisable()){
		if(!g_RGBMatchingMethod_mapped){
			UpdateDataComboProfileDialog(ID_CNRGBMATCHINGMETHOD, "ProfileDlgMatchingMethod_combo_entry");
		}
	}
	SigEnable();
}


gboolean
on_ProfileDlgMatchingMethod_combo_popwin_event	(GtkWidget	*widget, GdkEvent	*event,
					gpointer		user_data)
{
	if(event->type == GDK_MAP){
		g_RGBMatchingMethod_mapped = TRUE;
	}else if(event->type == GDK_UNMAP){
		g_RGBMatchingMethod_mapped = FALSE;
		if(SigDisable()){
			UpdateDataComboProfileDialog(ID_CNRGBMATCHINGMETHOD, "ProfileDlgMatchingMethod_combo_entry");
		}
		SigEnable();
	}
	return FALSE;
}


void
on_ProfileDlgRGBPBProcess_checkbutton_toggled
                                        (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	if(SigDisable()){
		UpdateDataCheck(ID_CNRGBPUREBLACKPROCESS, (int)togglebutton->active);
	}
	SigEnable();
}


void
on_ProfileDlgCMYKSimulation_combo_entry_changed
                                        (GtkEditable     *editable,
                                        gpointer         user_data)
{
	if(SigDisable()){
		if(!g_CMYKSimulationProfile_mapped){
			UpdateDataComboProfileDialog(ID_CNCMYKSIMULATIONPROFILE, "ProfileDlgCMYKSimulation_combo_entry");
		}
	}
	SigEnable();
}


gboolean
on_ProfileDlgCMYKSimulation_combo_popwin_event	(GtkWidget	*widget, GdkEvent	*event,
					gpointer		user_data)
{
	if(event->type == GDK_MAP){
		g_CMYKSimulationProfile_mapped = TRUE;
	}else if(event->type == GDK_UNMAP){
		g_CMYKSimulationProfile_mapped = FALSE;
		if(SigDisable()){
			UpdateDataComboProfileDialog(ID_CNCMYKSIMULATIONPROFILE, "ProfileDlgCMYKSimulation_combo_entry");
		}
		SigEnable();
	}
	return FALSE;
}


void
on_ProfileDlgCMYKPBProcess_checkbutton_toggled
                                        (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	if(SigDisable()){
		UpdateDataCheck(ID_CNPUREBLACKPROCESS, (int)togglebutton->active);
	}
	SigEnable();
}

void
on_QualityGradeSmooth_combo_entry_changed
                                        (GtkEditable     *editable,
                                        gpointer         user_data)
{
	if(SigDisable()){
		if(!g_QualityGradeMethod_mapped){
			UpdateDataCombo(ID_CNGRADATIONSMOOTHING, "QualityGradeSmooth_combo_entry");
		}
	}
	SigEnable();
}

gboolean
on_QualityGradeSmooth_combo_popwin_event	(GtkWidget	*widget, GdkEvent	*event,
					gpointer		user_data)
{
	if(event->type == GDK_MAP){
		g_QualityGradeMethod_mapped = TRUE;
	}else if(event->type == GDK_UNMAP){
		g_QualityGradeMethod_mapped = FALSE;
		if(SigDisable()){
			UpdateDataCombo(ID_CNGRADATIONSMOOTHING, "QualityGradeSmooth_combo_entry");
		}
		SigEnable();
	}
	return FALSE;
}

void
on_QualityImgRefine_combo_entry_changed
                                        (GtkEditable     *editable,
                                        gpointer         user_data)
{
	if(SigDisable()){
		if(!g_QualityImgRefine_mapped){
			UpdateDataCombo(ID_CNIMAGEREFINEMENT, "QualityImgRefine_combo_entry");
		}
	}
	SigEnable();
}

gboolean
on_QualityImgRefine_combo_popwin_event	(GtkWidget	*widget, GdkEvent	*event,
					gpointer		user_data)
{
	if(event->type == GDK_MAP){
		g_QualityImgRefine_mapped = TRUE;
	}else if(event->type == GDK_UNMAP){
		g_QualityImgRefine_mapped = FALSE;
		if(SigDisable()){
			UpdateDataCombo(ID_CNIMAGEREFINEMENT, "QualityImgRefine_combo_entry");
		}
		SigEnable();
	}
	return FALSE;
}

void
on_QualityLineRefine_combo_entry_changed
                                        (GtkEditable     *editable,
                                        gpointer         user_data)
{
	if(SigDisable()){
		if(!g_QualityLineRefine_mapped){
			UpdateDataCombo(ID_CNLINEREFINEMENT, "QualityLineRefine_combo_entry");
		}
	}
	SigEnable();
}

gboolean
on_QualityLineRefine_combo_popwin_event	(GtkWidget	*widget, GdkEvent	*event,
					gpointer		user_data)
{
	if(event->type == GDK_MAP){
		g_QualityLineRefine_mapped = TRUE;
	}else if(event->type == GDK_UNMAP){
		g_QualityLineRefine_mapped = FALSE;
		if(SigDisable()){
			UpdateDataCombo(ID_CNLINEREFINEMENT, "QualityLineRefine_combo_entry");
		}
		SigEnable();
	}
	return FALSE;
}

void
on_FrontBackCoverSettings_button_clicked
                                        (GtkButton       *button,
                                        gpointer         user_data)
{
	ShowFrontBackCvrDlg(g_main_window->prop->ftbkcvr);
}

void
on_FrontCvr_checkbutton_toggled
                                        (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	if(SigDisable()){
		UpdateDataCheck(ID_CNSET_FRONT_COVER, (int)togglebutton->active);
	}
	SigEnable();
}

void
on_FrontCvrPrintSide_combo_entry_changed
                                        (GtkEditable     *editable,
                                        gpointer         user_data)
{
	if(SigDisable()){
		if(!g_FrontCvrPrintSide_mapped){
			UpdateDataComboFrontBackCvrDialog(ID_CNFRONT_PRINT_SHEET, "FrontCvrPrintSide_combo_entry");
		}

	}
	SigEnable();
}
gboolean
on_FrontCvrPrintSide_combo_popwin_event	(GtkWidget	*widget, GdkEvent	*event,
					gpointer		user_data)
{
	if(event->type == GDK_MAP){
		g_FrontCvrPrintSide_mapped = TRUE;
	}else if(event->type == GDK_UNMAP){
		g_FrontCvrPrintSide_mapped = FALSE;
		if(SigDisable()){
			UpdateDataComboFrontBackCvrDialog(ID_CNFRONT_PRINT_SHEET, "FrontCvrPrintSide_combo_entry");
		}
		SigEnable();
	}
	return FALSE;
}

void
on_FrontCvrPaperSrc_combo_entry_changed
                                        (GtkEditable     *editable,
                                        gpointer         user_data)
{
	if(SigDisable()){
		if(!g_FrontCvrPaperSrc_mapped){
			UpdateDataComboFrontBackCvrDialog(ID_CNFRONT_PAPER_SRC, "FrontCvrPaperSrc_combo_entry");
		}
	}
	SigEnable();
}

gboolean
on_FrontCvrPaperSrc_combo_popwin_event	(GtkWidget	*widget, GdkEvent	*event,
					gpointer		user_data)
{
	if(event->type == GDK_MAP){
		g_FrontCvrPaperSrc_mapped = TRUE;
	}else if(event->type == GDK_UNMAP){
		g_FrontCvrPaperSrc_mapped = FALSE;
		if(SigDisable()){
			UpdateDataComboFrontBackCvrDialog(ID_CNFRONT_PAPER_SRC, "FrontCvrPaperSrc_combo_entry");
		}
		SigEnable();
	}
	return FALSE;
}

void
on_BackCvr_checkbutton_toggled
                                        (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	if(SigDisable()){
		UpdateDataCheck(ID_CNSET_BACK_COVER, (int)togglebutton->active);
	}
	SigEnable();
}

void
on_BackCvrPrintSide_combo_entry_changed
                                        (GtkEditable     *editable,
                                        gpointer         user_data)
{
	if(SigDisable()){
		if(!g_BackCvrPrintSide_mapped){
			UpdateDataComboFrontBackCvrDialog(ID_CNBACK_PRINT_SHEET, "BackCvrPrintSide_combo_entry");
		}
	}
	SigEnable();
}

gboolean
on_BackCvrPrintSide_combo_popwin_event	(GtkWidget	*widget, GdkEvent	*event,
					gpointer		user_data)
{
	if(event->type == GDK_MAP){
		g_BackCvrPrintSide_mapped = TRUE;
	}else if(event->type == GDK_UNMAP){
		g_BackCvrPrintSide_mapped = FALSE;
		if(SigDisable()){
			UpdateDataComboFrontBackCvrDialog(ID_CNBACK_PRINT_SHEET, "BackCvrPrintSide_combo_entry");
		}
		SigEnable();
	}
	return FALSE;
}

void
on_BackCvrPaperSrc_combo_entry_changed (GtkEditable     *editable,
                                        gpointer         user_data)
{
	if(SigDisable()){
		if(!g_BackCvrPaperSrc_mapped){
			UpdateDataComboFrontBackCvrDialog(ID_CNBACK_PAPER_SRC, "BackCvrPaperSrc_combo_entry");
		}
	}
	SigEnable();
}

gboolean
on_BackCvrPaperSrc_combo_popwin_event	(GtkWidget	*widget, GdkEvent	*event,
					gpointer		user_data)
{
	if(event->type == GDK_MAP){
		g_BackCvrPaperSrc_mapped = TRUE;
	}else if(event->type == GDK_UNMAP){
		g_BackCvrPaperSrc_mapped = FALSE;
		if(SigDisable()){
			UpdateDataComboFrontBackCvrDialog(ID_CNBACK_PAPER_SRC, "BackCvrPaperSrc_combo_entry");
		}
		SigEnable();
	}
	return FALSE;
}

void
on_FrontBackCvrSetDlg_OK_button_clicked
                                        (GtkButton       *button,
                                        gpointer         user_data)
{
	if(SigDisable()){
		HideFrontBackCvrDlg(g_main_window->prop->ftbkcvr, ID_OK);
	}
	SigEnable();
}

void
on_FrontBackCvrSetDlg_Cancel_button_clicked
                                        (GtkButton       *button,
                                        gpointer         user_data)
{
	if(SigDisable()){
		int disable;
		int active;

		HideFrontBackCvrDlg(g_main_window->prop->ftbkcvr, ID_CANCEL);

		disable = GetCurrDisable(ID_CNINTERLEAFSHEET, NULL);

		if(disable != -1){
			active = disable > 0 ? 0 : 1;
			SetWidgetSensitive(UI_DIALOG(g_main_window->prop)->window, "Interleaf_checkbutton", active);
		}
	}
	SigEnable();
}

void
on_FrontBackCvrSetDlg_dialog_destroy   (GtkObject       *object,
                                        gpointer         user_data)
{

}

gboolean
on_FrontBackCvrSetDlg_delete_event     (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
	if(SigDisable()){
		HideFrontBackCvrDlg(g_main_window->prop->ftbkcvr, ID_CANCEL);
	}
	SigEnable();
	return TRUE;
}


void
on_SpotColorMatching_combo_entry_changed
                                        (GtkEditable     *editable,
                                        gpointer         user_data)
{
	if(SigDisable()){
		if(!g_SpotColorMatching_mapped){
			UpdateDataCombo(ID_CNSPOTCOLORMATCHING, "SpotColorMatching_combo_entry");
		}
	}
	SigEnable();
}

gboolean
on_SpotColorMatching_combo_popwin_event	(GtkWidget	*widget, GdkEvent	*event,
					gpointer		user_data)
{
	if(event->type == GDK_MAP){
		g_SpotColorMatching_mapped = TRUE;
	}else if(event->type == GDK_UNMAP){
		g_SpotColorMatching_mapped = FALSE;
		if(SigDisable()){
			UpdateDataCombo(ID_CNSPOTCOLORMATCHING, "SpotColorMatching_combo_entry");
		}
		SigEnable();
	}
	return FALSE;
}

void
on_OHPPrintMode_combo_entry_changed    (GtkEditable     *editable,
                                        gpointer         user_data)
{
	if(SigDisable()){
		if(!g_OHPPrintMode_mapped){
			UpdateDataCombo(ID_CNOHPPRINTMODE, "OHPPrintMode_combo_entry");
		}
	}
	SigEnable();
}

gboolean
on_OHPPrintMode_combo_popwin_event	(GtkWidget	*widget, GdkEvent	*event,
					gpointer		user_data)
{
	if(event->type == GDK_MAP){
		g_OHPPrintMode_mapped = TRUE;
	}else if(event->type == GDK_UNMAP){
		g_OHPPrintMode_mapped = FALSE;
		if(SigDisable()){
			UpdateDataCombo(ID_CNOHPPRINTMODE, "OHPPrintMode_combo_entry");
		}
		SigEnable();
	}
	return FALSE;
}

void
on_AdvancedSmooth_combo_entry_changed  (GtkEditable     *editable,
                                        gpointer         user_data)
{
	if(SigDisable()){
		if(!g_AdvancedSmoothing_mapped){
			UpdateDataCombo(ID_CNADVANCEDSMOOTHING, "AdvancedSmooth_combo_entry");
		}
	}
	SigEnable();
}

gboolean
on_AdvancedSmooth_combo_popwin_event	(GtkWidget	*widget, GdkEvent	*event,
					gpointer		user_data)
{
	if(event->type == GDK_MAP){
		g_AdvancedSmoothing_mapped = TRUE;
	}else if(event->type == GDK_UNMAP){
		g_AdvancedSmoothing_mapped = FALSE;
		if(SigDisable()){
			UpdateDataCombo(ID_CNADVANCEDSMOOTHING, "AdvancedSmooth_combo_entry");
		}
		SigEnable();
	}
	return FALSE;
}

void
on_SpecialPrintMode_combo_entry_changed
                                        (GtkEditable     *editable,
                                        gpointer         user_data)
{
	if(SigDisable()){
		if(!g_SpecialPrintMode_mapped){
			UpdateDataCombo(ID_CNSPECIALPRINTINGMODE, "SpecialPrintMode_combo_entry");
		}
	}
	SigEnable();
}

gboolean
on_SpecialPrintMode_combo_popwin_event	(GtkWidget	*widget, GdkEvent	*event,
					gpointer		user_data)
{
	if(event->type == GDK_MAP){
		g_SpecialPrintMode_mapped = TRUE;
	}else if(event->type == GDK_UNMAP){
		g_SpecialPrintMode_mapped = FALSE;
		if(SigDisable()){
			UpdateDataCombo(ID_CNSPECIALPRINTINGMODE, "SpecialPrintMode_combo_entry");
		}
		SigEnable();
	}
	return FALSE;
}

void
on_QualitySmallSizeCurl_combo_entry_changed
                                        (GtkEditable     *editable,
                                        gpointer         user_data)
{
	if(SigDisable()){
		if(!g_SmallSizeCurl_mapped){
			UpdateDataCombo(ID_CNSMALLSIZECURL, "QualitySmallSizeCurl_combo_entry");
		}
	}
	SigEnable();
}

gboolean
on_QualitySmallSizeCurl_combo_popwin_event	(GtkWidget	*widget, GdkEvent	*event,
					gpointer		user_data)
{
	if(event->type == GDK_MAP)
		g_SmallSizeCurl_mapped = TRUE;
	else if(event->type == GDK_UNMAP){
		g_SmallSizeCurl_mapped = FALSE;
		if(SigDisable())
			UpdateDataCombo(ID_CNSMALLSIZECURL, "QualitySmallSizeCurl_combo_entry");
		SigEnable();
	}
	return FALSE;
}

void
on_HoldQueue_EnterName_RadioButton_toggled
                                        (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	if(SigDisable()){
		if(togglebutton->active)
			UpdateDataInt(ID_HOLDQUEUE_DATANAME, 0);
	}
	SigEnable();
}


void
on_HoldQueue_EnterName_Entry_changed   (GtkEditable     *editable,
                                        gpointer         user_data)
{
	if(SigDisable()){
		CheckEnter(g_main_window->prop, CHECK_HOLDQUEUE);
	}
	SigEnable();
}


gboolean
on_HoldQueue_EnterName_Entry_focus_out_event
                                        (GtkWidget       *widget,
                                        GdkEventFocus   *event,
                                        gpointer         user_data)
{
	if(SigDisable()){
		gchar *text;
		text = GetTextEntry(UI_DIALOG(g_main_window->prop->holdqueue)->window, "HoldQueue_EnterName_Entry");
		if(text != NULL)
			UpdateData(ID_HOLD_NAME, text);
	}
	SigEnable();
	return FALSE;
}


void
on_HoldQueue_UseFileName_RadioButton_toggled
                                        (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	if(SigDisable()){
		if(togglebutton->active)
			UpdateDataInt(ID_HOLDQUEUE_DATANAME, 1);
	}
	SigEnable();
}

void
on_HoldQueue_OK_Button_clicked         (GtkButton       *button,
                                        gpointer         user_data)
{
	if(SigDisable())
		HideHoldQueueDlg(g_main_window->prop->holdqueue, ID_OK);
	SigEnable();
}


void
on_HoldQueue_Cancel_Button_clicked     (GtkButton       *button,
                                        gpointer         user_data)
{
	if(SigDisable())
		HideHoldQueueDlg(g_main_window->prop->holdqueue, ID_CANCEL);
	SigEnable();
}

void
on_HoldQueueDlg_destroy                (GtkObject       *object,
                                        gpointer         user_data)
{
}

gboolean
on_HoldQueueDlg_delete_event           (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
	if(SigDisable())
		HideHoldQueueDlg(g_main_window->prop->holdqueue, ID_CANCEL);
	SigEnable();
  	return TRUE;
}
void
on_CaptFinishingCurlCorrection_combo_entry_changed
                                        (GtkEditable     *editable,
                                        gpointer         user_data)

{
	if(SigDisable()){
		if(!g_CaptCurlCorrection_mapped){
			char *text, *tmp;
			tmp = GetCurrComboText(UI_DIALOG(g_main_window->prop->captfin)->window, "CaptFinishingCurlCorrection_combo_entry");
			text = TextToName(ID_CNCURLCORRECTION, tmp);
			UpdateData(ID_CNCURLCORRECTION, text);
		}
	}
	SigEnable();
}

gboolean
on_CaptFinishingCurlCorrection_combo_popwin_event	(GtkWidget	*widget, GdkEvent	*event,
					gpointer		user_data)
{
	if(event->type == GDK_MAP)
		g_CaptCurlCorrection_mapped = TRUE;
	else if(event->type == GDK_UNMAP){
		g_CaptCurlCorrection_mapped = FALSE;
		if(SigDisable()){
			char *text, *tmp;
			tmp = GetCurrComboText(UI_DIALOG(g_main_window->prop->captfin)->window, "CaptFinishingCurlCorrection_combo_entry");
			text = TextToName(ID_CNCURLCORRECTION, tmp);
			UpdateData(ID_CNCURLCORRECTION, text);
		}
		SigEnable();
	}
	return FALSE;
}

void
on_OffsetCopyNum_spinbutton_value_changed
                                        (GtkSpinButton   *spinbutton,
                                        gpointer         user_data)
{
	if(SigDisable()){
		int value;
		value = GetSpinButtonValue(UI_DIALOG(g_main_window->prop)->window, "OffsetCopyNum_spinbutton", 1);
		UpdateDataInt(ID_CNOFFSETNUM, value);
	}
	SigEnable();
}
void
on_AdvancedSettings_button_clicked     (GtkButton       *button,
                                        gpointer         user_data)
{
	cngplpSetData(g_main_window->data, ID_SHOWDLG, "Settings");
	ShowAdvancedSettingsDlg(g_main_window->prop->advsettings);
}

void
on_AdvancedSettingsOK_button_clicked   (GtkButton       *button,
                                        gpointer         user_data)
{
	if(SigDisable())
		HideAdvancedSettingsDlg(g_main_window->prop->advsettings, ID_OK);
	SigEnable();
}

void
on_AdvancedSettingsCancel_button_clicked
                                        (GtkButton       *button,
                                        gpointer         user_data)
{
	if(SigDisable())
		HideAdvancedSettingsDlg(g_main_window->prop->advsettings, ID_CANCEL);
	SigEnable();
}

void
on_AdvancedSettingsDlg_destroy         (GtkObject       *object,
                                        gpointer         user_data)
{

}

gboolean
on_AdvancedSettingsDlg_delete_event    (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
	if(SigDisable())
		HideAdvancedSettingsDlg(g_main_window->prop->advsettings, ID_CANCEL);
	SigEnable();
	return TRUE;
}

void
on_ShiftPosition_checkbutton_toggled   (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	if(SigDisable())
		UpdateDataCheck(ID_CNSHIFTSTARTPRINTPOSITION, (int)togglebutton->active);
	SigEnable();
}

void
on_BackLong_spinbutton_value_changed   (GtkSpinButton   *spinbutton,
                                        gpointer         user_data)
{
	if(SigDisable()){
		int value;
		double value_d;
		char* val;
		if((val = GetCNUIValue("CNEnableDetailShiftPosition")) != NULL){
			if(strcasecmp(val, "True") == 0){
				value_d = GetSpinButtonValueFloat(UI_DIALOG(g_main_window->prop->advsettings)->window, "BackLong_spinbutton");
				UpdateDataDouble(ID_CNSHIFTBKLONGEDGE, value_d);
			}
		}
		if(val == NULL || strcasecmp(val, "False") == 0){
			value = GetSpinButtonValue(UI_DIALOG(g_main_window->prop->advsettings)->window, "BackLong_spinbutton", 1);
			UpdateDataInt(ID_CNSHIFTBKLONGEDGE, value);
		}
		MemFree(val);
	}
	SigEnable();
}

void
on_BackShort_spinbutton_value_changed  (GtkSpinButton   *spinbutton,
                                        gpointer         user_data)
{
	if(SigDisable()){
		int value;
		double value_d;
		char* val;
		if((val = GetCNUIValue("CNEnableDetailShiftPosition")) != NULL){
			if(strcasecmp(val, "True") == 0){
				value_d = GetSpinButtonValueFloat(UI_DIALOG(g_main_window->prop->advsettings)->window, "BackShort_spinbutton");
				UpdateDataDouble(ID_CNSHIFTBKSHORTEDGE, value_d);
			}
		}
		if(val == NULL || strcasecmp(val, "False") == 0){
			value = GetSpinButtonValue(UI_DIALOG(g_main_window->prop->advsettings)->window, "BackShort_spinbutton", 1);
			UpdateDataInt(ID_CNSHIFTBKSHORTEDGE, value);
		}
		MemFree(val);
	}
	SigEnable();
}

void
on_FrontLong_spinbutton_value_changed  (GtkSpinButton   *spinbutton,
                                        gpointer         user_data)
{
	if(SigDisable()){
		int value;
		double value_d;
		char* val;
		if((val = GetCNUIValue("CNEnableDetailShiftPosition")) != NULL){
			if(strcasecmp(val, "True") == 0){
				value_d = GetSpinButtonValueFloat(UI_DIALOG(g_main_window->prop->advsettings)->window, "FrontLong_spinbutton");
				UpdateDataDouble(ID_CNSHIFTFRLONGEDGE, value_d);
			}
		}
		if(val == NULL || strcasecmp(val, "False") == 0){
			value = GetSpinButtonValue(UI_DIALOG(g_main_window->prop->advsettings)->window, "FrontLong_spinbutton", 1);
			UpdateDataInt(ID_CNSHIFTFRLONGEDGE, value);
		}
		MemFree(val);
	}
	SigEnable();
}

void
on_FrontShort_spinbutton_value_changed (GtkSpinButton   *spinbutton,
                                        gpointer         user_data)
{
	if(SigDisable()){
		int value;
		double value_d;
		char* val;

		if((val = GetCNUIValue("CNEnableDetailShiftPosition")) != NULL){
			if(strcasecmp(val, "True") == 0){
				value_d = GetSpinButtonValueFloat(UI_DIALOG(g_main_window->prop->advsettings)->window, "FrontShort_spinbutton");
				UpdateDataDouble(ID_CNSHIFTFRSHORTEDGE, value_d);
			}
		}
		if(val == NULL || strcasecmp(val, "False") == 0){
			value = GetSpinButtonValue(UI_DIALOG(g_main_window->prop->advsettings)->window, "FrontShort_spinbutton", 1);
			UpdateDataInt(ID_CNSHIFTFRSHORTEDGE, value);
		}
		MemFree(val);
	}
	SigEnable();
}

void
on_Sharpness_checkbutton_toggled       (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	if(SigDisable())
		UpdateDataCheck(ID_CNUSESHARPNESS, (int)togglebutton->active);
	SigEnable();

}

gboolean
on_Sharpness_drawingarea_configure_event
                                        (GtkWidget       *widget,
                                        GdkEventConfigure *event,
                                        gpointer         user_data)
{
	if(SharpnessPixmap != NULL)
		gdk_pixmap_unref(SharpnessPixmap);
	SharpnessPixmap = gdk_pixmap_new(widget->window, widget->allocation.width, widget->allocation.height, -1);

	ConfigureEvent(UI_DIALOG(g_main_window->prop)->window, event, SHARPNESS);

	return TRUE;
}

gboolean
on_Sharpness_drawingarea_expose_event  (GtkWidget       *widget,
                                        GdkEventExpose  *event,
                                        gpointer         user_data)
{
	if(SharpnessPixmap == NULL)
		return TRUE;
	ExposeEvent(UI_DIALOG(g_main_window->prop)->window, event, SHARPNESS);
	return TRUE;
}

void
on_Sharpness_hscale_value_changed      (GtkRange        *range,
                                        GtkAdjustment	*adjustment)
{
	if(SigDisable()){
		int value = (int)adjustment->value;
		UpdateDataInt(ID_CNSHARPNESS, value);
	}
	SigEnable();
}

void
on_ImageCompression_combo_entry_changed
                                        (GtkEditable     *editable,
                                        gpointer         user_data)
{
	if(SigDisable()){
		if(g_ImageCompression_mapped == FALSE)
			UpdateDataCombo(ID_CNIMAGECOMPRESSION, "ImageCompression_combo_entry");
	}
	SigEnable();
}

gboolean
on_ImageCompression_combo_popwin_event	(GtkWidget	*widget,
					GdkEvent	*event,
					gpointer	user_data)
{
	if(event->type == GDK_MAP)
		g_ImageCompression_mapped = TRUE;
	else if(event->type == GDK_UNMAP){
		g_ImageCompression_mapped = FALSE;
		if(SigDisable())
			UpdateDataCombo(ID_CNIMAGECOMPRESSION, "ImageCompression_combo_entry");
		SigEnable();
	}
	return FALSE;
}

void
on_JobNote_entry_changed               (GtkEditable     *editable,
                                        gpointer         user_data)
{
	if(SigDisable())
		CheckIDEntry(g_main_window->prop, CHECK_FINDETAILS, "JobNote_entry");
	SigEnable();
}

gboolean
on_JobNote_entry_focus_out_event       (GtkWidget       *widget,
                                        GdkEventFocus   *event,
                                        gpointer         user_data)
{
	if(SigDisable()){
		char *text = NULL;
		text = GetTextEntry(UI_DIALOG(g_main_window->prop->captfin)->window, "JobNote_entry");
		if(text != NULL)
			UpdateData(ID_CNJOBNOTE, text);
	}
	SigEnable();
	return FALSE;
}

void CheckFinDetailsTextView(UIPropDlg *prop, int dlg_type, gchar *textview_name)
{
	gchar ID[256], *tmp = NULL;
	int num = 0, cnt = 0, i;
	GtkWidget *window = NULL;
	int code = 0;

	if(dlg_type == CHECK_FINDETAILS){
		code = prop->captfin->code;
		window = UI_DIALOG(prop->captfin)->window;
	}else
		return;
	tmp = GetTextofTextView(window, textview_name);
	num = strlen(tmp);
	if(code == 0){
		if(128 <= num)
			SetTextofTextView(window, textview_name, tmp, 128);
		return;
	}

	for(i = 0; i < num; i++, cnt++){
		guchar ch = tmp[i];
		if(128 <= cnt)
			break;
		if(ch & 0x80){
			cnt++;
			if(128 <= cnt)
				break;
			switch(code){
			case 1:
				if(ch == 0x8F)
					i += 2;
				else
					i++;
				break;
			case 2:
				if(ch & 0x40){
					if(ch & 0x20){
						if(ch & 0x10)
							i += 3;
						else
							i += 2;
					}else
						i++;
				}
				break;
			}
		}
	}
	memset(ID, 0, 256);
	strncpy(ID, tmp, i);

	if(128 <= cnt)
		SetTextofTextView(window, textview_name, ID, -1);
}

void on_JobDetails_textbuffer_changed	(GtkTextBuffer	  *textbuffer,
					  gpointer        user_data)
{
	if(SigDisable())
		CheckFinDetailsTextView(g_main_window->prop, CHECK_FINDETAILS, "JobDetails_textview");
	SigEnable();
}

gboolean
on_JobDetails_textview_focus_out_event (GtkWidget       *widget,
                                        GdkEventFocus   *event,
                                        gpointer         user_data)
{
	if(SigDisable()){
		char *text = NULL;
		text = GetTextofTextView(UI_DIALOG(g_main_window->prop->captfin)->window, "JobDetails_textview");
		if(text != NULL)
			UpdateData(ID_CNJOBDETAILS, text);
	}
	SigEnable();
	return FALSE;
}


void
on_CopyNumbering_checkbutton_toggled
                                        (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	if(SigDisable())
		UpdateDataCheck(ID_CNCOPYSETNUMBERING, (int)togglebutton->active);
	SigEnable();
}

void
on_StartNumber_spinbutton_changed           (GtkEditable     *editable,
                                        gpointer         user_data)
{
	if(SigDisable()){
		int value;
		value = GetSpinButtonValue(UI_DIALOG(g_main_window->prop->captfin)->window, "StartNumber_spinbutton", 1);
		UpdateDataInt(ID_STARTNUM, value);
	}
	SigEnable();
}

void
on_CreepUse_checkbutton_toggled        (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	if(SigDisable())
		UpdateDataCheck(ID_CNCREEP, (int)togglebutton->active);
	SigEnable();
}

void
on_DeviceSetting_radiobutton_toggled   (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	if(SigDisable())
		if(togglebutton->active)
			UpdateData(ID_CNDISPLACEMENTCORRECTION, "Device");
	SigEnable();
}

void
on_Auto_radiobutton_toggled            (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	if(SigDisable())
		if(togglebutton->active)
			UpdateData(ID_CNDISPLACEMENTCORRECTION, "Auto");
	SigEnable();
}

void
on_Manual_radiobutton_toggled          (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	if(SigDisable())
		if(togglebutton->active)
			UpdateData(ID_CNDISPLACEMENTCORRECTION, "Manual");
	SigEnable();
}

void
on_CorrectWidth_spinbutton_value_changed
                                        (GtkSpinButton   *spinbutton,
                                        gpointer         user_data)
{
	if(SigDisable()){
		double value;
		value = GetSpinButtonValueFloat(UI_DIALOG(g_main_window->prop->booklet)->window, "CorrectWidth_spinbutton");
		UpdateDataDouble(ID_CNGUTTERSHIFTNUM, value);
	}
	SigEnable();
}

void
on_TrimDeviceSetting_radiobutton_toggled
                                        (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	if(SigDisable())
		if(togglebutton->active)
			UpdateData(ID_CNADJUSTTRIM, "None");
	SigEnable();
}

void
on_TrimWidth_spinbutton_value_changed  (GtkSpinButton   *spinbutton,
                                        gpointer         user_data)
{
	if(SigDisable()){
		double value;
		value = GetSpinButtonValueFloat(UI_DIALOG(g_main_window->prop)->window, "TrimWidth_spinbutton");
		UpdateDataDouble(ID_CNADJUSTTRIMNUM, value);
	}
	SigEnable();
}

void
on_TrimManualSetting_radiobutton_toggled
                                        (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	if(SigDisable())
		if(togglebutton->active)
			UpdateData(ID_CNADJUSTTRIM, "Manual");
	SigEnable();
}

void
on_FinCfold_checkbutton_toggled        (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	if(SigDisable())
		UpdateDataCheck(ID_CNCFOLDING, (int)togglebutton->active);
	SigEnable();
}

void
on_FinCfoldSetting_combo_entry_changed (GtkEditable     *editable,
                                        gpointer         user_data)
{
	if(SigDisable())
		if(g_CfoldSetting_mapped == FALSE)
			UpdateDataCombo(ID_CNCFOLDSETTING, "FinCfoldSetting_combo_entry");
	SigEnable();
}

gboolean
on_FinCfoldSetting_combo_popwin_event	(GtkWidget	*widget,
					GdkEvent	*event,
					gpointer	user_data)
{
	if(event->type == GDK_MAP)
		g_CfoldSetting_mapped = TRUE;
	else if(event->type == GDK_UNMAP){
		g_CfoldSetting_mapped = FALSE;
		if(SigDisable())
			UpdateDataCombo(ID_CNCFOLDSETTING, "FinCfoldSetting_combo_entry");
		SigEnable();
	}
	return FALSE;
}

void
on_EnableTrustPrint_checkbutton_toggled
                                        (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	if(SigDisable())
		UpdateDataCheck(ID_CNENABLETRUSTPRINT, (int)togglebutton->active);
	SigEnable();
}

void
on_TrustPrint_checkbutton_toggled      (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	if(SigDisable())
		UpdateDataCheck(ID_CNTRUSTPRINT, (int)togglebutton->active);
	SigEnable();
}

void
on_LineControl_combo_entry_changed     (GtkEditable     *editable,
                                        gpointer         user_data)
{

	if(SigDisable()){
		if(g_LineControl_mapped == FALSE)
			UpdateDataCombo(ID_CNLINECONTROL, "LineControl_combo_entry");
	}
	SigEnable();
}

gboolean
on_LineControl_combo_popwin_event	(GtkWidget     *widget,
                                        GdkEvent       *event,
                                        gpointer       user_data)
{
	if(event->type == GDK_MAP)
		g_LineControl_mapped = TRUE;
	else if(GDK_UNMAP == event->type){
		g_LineControl_mapped = FALSE;
		if(SigDisable())
			UpdateDataCombo(ID_CNLINECONTROL, "LineControl_combo_entry");
		SigEnable();
	}
	return FALSE;
}

void
on_TonerVolumeAdjustment_combo_entry_changed
                                        (GtkEditable     *editable,
                                        gpointer         user_data)
{
	if(SigDisable()){
		if(g_TonerVolumeAdjustment_mapped == FALSE)
			UpdateDataCombo(ID_CNTONERVOLUMEADJUSTMENT, "TonerVolumeAdjustment_combo_entry");
	}
	SigEnable();
}

gboolean
on_TonerVolumeAdjustment_combo_popwin_event
                                        (GtkWidget      *widget,
                                        GdkEvent        *event,
                                        gpointer        user_data)
{
	if(event->type == GDK_MAP)
		g_TonerVolumeAdjustment_mapped = TRUE;
	else if(event->type == GDK_UNMAP){
		g_TonerVolumeAdjustment_mapped = FALSE;
		if(SigDisable())
			UpdateDataCombo(ID_CNTONERVOLUMEADJUSTMENT, "TonerVolumeAdjustment_combo_entry");
		SigEnable();
	}
	return FALSE;
}

void
on_SpecialPrintAdjustmentA_combo_entry_changed
                                        (GtkEditable     *editable,
                                        gpointer         user_data)
{
	if(SigDisable()){
		if(g_SpecialPrintAdjustmentA_mapped == FALSE)
			UpdateDataCombo(ID_CNSPECIALPRINTADJUSTMENTA, "SpecialPrintAdjustmentA_combo_entry");
	}
	SigEnable();
}

gboolean
on_SpecialPrintAdjustmentA_combo_popwin_event	(GtkWidget	*widget,
                                        GdkEvent	*event,
                                        gpointer	user_data)
{
	if(event->type == GDK_MAP)
		g_SpecialPrintAdjustmentA_mapped = TRUE;
	else if(event->type == GDK_UNMAP){
		g_SpecialPrintAdjustmentA_mapped = FALSE;
		if(SigDisable())
			UpdateDataCombo(ID_CNSPECIALPRINTADJUSTMENTA, "SpecialPrintAdjustmentA_combo_entry");
		SigEnable();
	}
	return FALSE;
}
void
on_SpecialPrintAdjustmentB_combo_entry_changed
                                        (GtkEditable     *editable,
                                        gpointer         user_data)
{
	if(SigDisable()){
		if(g_SpecialPrintAdjustmentB_mapped == FALSE)
			UpdateDataCombo(ID_CNSPECIALPRINTADJUSTMENTB, "SpecialPrintAdjustmentB_combo_entry");
	}
	SigEnable();
}

gboolean
on_SpecialPrintAdjustmentB_combo_popwin_event	(GtkWidget	*widget,
                                        GdkEvent	*event,
                                        gpointer	user_data)
{
	if(event->type == GDK_MAP)
		g_SpecialPrintAdjustmentB_mapped = TRUE;
	else if(event->type == GDK_UNMAP){
		g_SpecialPrintAdjustmentB_mapped = FALSE;
		if(SigDisable())
			UpdateDataCombo(ID_CNSPECIALPRINTADJUSTMENTB, "SpecialPrintAdjustmentB_combo_entry");
		SigEnable();
	}
	return FALSE;
}

void
on_Staple_checkbutton_toggled          (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	if(SigDisable())
		UpdateDataCheck(ID_CNOPTIONSTAPLE, (int)togglebutton->active);
	SigEnable();
}

void
on_FinDetail_RevicePostcard_combo_entry_changed
                                        (GtkEditable     *editable,
                                        gpointer         user_data)
{
	if(SigDisable()){
		if(!g_FinDetail_RevicePostcard_mapped){

			char *text, *tmp;
			tmp = GetCurrComboText(UI_DIALOG(g_main_window->prop->captfin)->window, "FinDetail_RevicePostcard_combo_entry");
			text = TextToName(ID_CNREVICEPOSTCARD, tmp);
			UpdateData(ID_CNREVICEPOSTCARD, text);
		}
	}
	SigEnable();
}

gboolean
on_FinDetail_RevicePostcard_combo_popwin_event
					(GtkWidget	*widget,
					GdkEvent	*event,
					gpointer	user_data)
{
	if(event->type == GDK_MAP)
		g_FinDetail_RevicePostcard_mapped = TRUE;
	else if(event->type == GDK_UNMAP){
		g_FinDetail_RevicePostcard_mapped = FALSE;
		if(SigDisable()){
			char *text, *tmp;
			tmp = GetCurrComboText(UI_DIALOG(g_main_window->prop->captfin)->window, "FinDetail_RevicePostcard_combo_entry");
			text = TextToName(ID_CNREVICEPOSTCARD, tmp);
			UpdateData(ID_CNREVICEPOSTCARD, text);
		}
		SigEnable();
	}
	return FALSE;
}

void
on_CaptFinDetail_Wrinkles_combo_entry_changed
                                        (GtkEditable     *editable,
                                        gpointer         user_data)
{
	if(SigDisable()){
		if(!g_CaptFinDetail_WrinklesCorrectionOutput_mapped){
			char *text, *tmp;
			tmp = GetCurrComboText(UI_DIALOG(g_main_window->prop->captfin)->window, "CaptFinDetail_Wrinkles_combo_entry");
			text = TextToName(ID_CNWRINKLESCORRECTIONOUTPUT, tmp);
			UpdateData(ID_CNWRINKLESCORRECTIONOUTPUT, text);
		}
	}
	SigEnable();
}

gboolean
on_CaptFinDetail_Wrinkles_combo_popwin_event
                                        (GtkWidget      *widget,
                                        GdkEvent        *event,
                                        gpointer        user_data)
{
	if(event->type == GDK_MAP)
		g_CaptFinDetail_WrinklesCorrectionOutput_mapped = TRUE;
	else if(event->type == GDK_UNMAP){
		g_CaptFinDetail_WrinklesCorrectionOutput_mapped = FALSE;
		if(SigDisable()){
			char *text, *tmp;
			tmp = GetCurrComboText(UI_DIALOG(g_main_window->prop->captfin)->window, "CaptFinDetail_Wrinkles_combo_entry");
			text = TextToName(ID_CNWRINKLESCORRECTIONOUTPUT, tmp);
			UpdateData(ID_CNWRINKLESCORRECTIONOUTPUT, text);
		}
		SigEnable();
	}
	return FALSE;
}
