/*
 *  Print Dialog for Canon LIPS/PS/LIPSLX/UFR2/CAPT Printer.
 *  Copyright (C) 2004-2008 CANON INC.
 *  All Rights Reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "uimain.h"
#include "widgets.h"
#include "callbacks.h"
#include "interface.h"
#include "holdqueuedlg.h"

const gchar *g_holdqueue_dataname_button_name[] =
{
	"HoldQueue_EnterName_RadioButton",
	"HoldQueue_UseFileName_RadioButton",
	NULL
};

UIHoldQueueDlg* CreateHoldQueueDlg(UIDialog * parent)
{
	UIHoldQueueDlg *dialog;

	dialog = (UIHoldQueueDlg *)CreateDialog(sizeof(UIHoldQueueDlg), parent);

	if(dialog == NULL)
		return NULL;
	UI_DIALOG(dialog)->window = create_HoldQueueDlg();

	return dialog;
}

void ShowHoldQueueDlg(UIHoldQueueDlg *dialog)
{
	dialog->hasfile = UI_DLG_TOP(dialog)->hasfile;

	dialog->code = GetCharSet();
	SigDisable();
	UpdateHoldQueueDlgWidgets(UI_DLG_PROP());
	SigEnable();
	ShowDialog((UIDialog *)dialog, NULL);
}

void HideHoldQueueDlg(UIHoldQueueDlg *dialog, int hide_type)
{
	HideDialog((UIDialog *)dialog);
	cngplpSetData(UI_DLG_TOP(dialog)->data, hide_type, "HoldQueue");
}

void UpdateHoldQueueDlgWidgets(UIPropDlg *prop)
{
	GtkWidget *window;
	int data_name_type;
	char *enter_name = NULL;

	window = UI_DIALOG(prop->holdqueue)->window;

	data_name_type = GetCurrOptInt(ID_HOLDQUEUE_DATANAME, 0);
	if(prop->holdqueue->hasfile == 0){
		SetWidgetSensitive(window, "HoldQueue_UseFileName_RadioButton", FALSE);
		data_name_type = 0;
	}else
		SetWidgetSensitive(window, "HoldQueue_UseFileName_RadioButton", TRUE);

	SetActiveRadioButton(window, g_holdqueue_dataname_button_name, data_name_type);
	enter_name = GetCurrOpt(ID_HOLD_NAME, NULL);
	if(enter_name != NULL){
		SetTextEntry(window, "HoldQueue_EnterName_Entry", enter_name);
		memFree(enter_name);
	}

	if(data_name_type == 0)
		SetWidgetSensitive(window, "HoldQueue_EnterName_HBox", TRUE);
	else
		SetWidgetSensitive(window, "HoldQueue_EnterName_HBox", FALSE);
}
