/*
 * Decompiled with CFR 0.152.
 */
package org.videolan;

import java.lang.reflect.Method;
import java.net.Socket;
import java.net.SocketImpl;
import java.util.Iterator;
import java.util.LinkedList;
import org.videolan.Logger;

class BDJSockets {
    private LinkedList sockets = new LinkedList();
    private boolean closed = false;
    private static final Logger logger = Logger.getLogger(BDJSockets.class.getName());

    protected BDJSockets() {
    }

    protected synchronized void add(Object obj) {
        if (!(obj instanceof SocketImpl)) {
            throw new Error("expected SocketImpl");
        }
        if (this.closed) {
            logger.error("Terminated Xlet tried to create socket at " + Logger.dumpStack());
            throw new Error("Terminated Xlet can not create sockets");
        }
        Iterator it = this.sockets.iterator();
        while (it.hasNext()) {
            SocketImpl socketImpl = (SocketImpl)it.next();
            Socket socket = this.getSocket(socketImpl);
            if (socket == null || !socket.isClosed()) continue;
            it.remove();
        }
        this.sockets.addLast(obj);
    }

    protected synchronized void closeAll() {
        this.closed = true;
        while (!this.sockets.isEmpty()) {
            SocketImpl socketImpl = (SocketImpl)this.sockets.removeFirst();
            Socket socket = this.getSocket(socketImpl);
            if (socket == null || socket.isClosed()) continue;
            logger.warning("Closing " + socket);
            try {
                socket.close();
            }
            catch (Exception e) {
                logger.error("Failed to close socket: " + e);
            }
        }
    }

    private Socket getSocket(SocketImpl socketImpl) {
        try {
            Method getSocket = SocketImpl.class.getDeclaredMethod("getSocket", new Class[0]);
            getSocket.setAccessible(true);
            return (Socket)getSocket.invoke((Object)socketImpl, new Object[0]);
        }
        catch (Exception e) {
            logger.error("Failed to get Socket: " + e + " at " + Logger.dumpStack());
            return null;
        }
    }
}

