/*
 * Decompiled with CFR 0.152.
 */
package org.videolan;

import java.io.BDFileSystem;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.tv.xlet.Xlet;
import org.videolan.BDJClassFileTransformer;
import org.videolan.BDJLoader;
import org.videolan.Logger;
import org.videolan.StrUtil;
import org.videolan.bdjo.AppCache;

public class BDJClassLoader
extends URLClassLoader {
    private String xletClass;
    private static final Logger logger = Logger.getLogger(BDJClassLoader.class.getName());

    public static BDJClassLoader newInstance(AppCache[] appCaches, String basePath, String classPathExt, String xletClass) {
        ArrayList<URL> classPath = new ArrayList<URL>();
        URL url = BDJClassLoader.translateClassPath(appCaches, basePath, null);
        if (url != null) {
            classPath.add(url);
        }
        String[] classPaths = StrUtil.split(classPathExt, ';');
        for (int i = 0; i < classPaths.length; ++i) {
            url = BDJClassLoader.translateClassPath(appCaches, basePath, classPaths[i]);
            if (url == null || classPath.indexOf(url) >= 0) continue;
            classPath.add(url);
        }
        return new BDJClassLoader(classPath.toArray(new URL[classPath.size()]), xletClass);
    }

    private static URL translateClassPath(AppCache[] appCaches, String basePath, String classPath) {
        String path = classPath == null || classPath.length() <= 0 ? basePath : (classPath.charAt(0) == '/' ? classPath.substring(1) : basePath + "/" + classPath);
        if (path.length() < 5) {
            return null;
        }
        String protocol = null;
        String url = path.substring(0, 5);
        for (int i = 0; i < appCaches.length; ++i) {
            if (!appCaches[i].getRefToName().equals(url)) continue;
            if (appCaches[i].getType() == 1) {
                protocol = "file:";
                url = url + ".jar";
                break;
            }
            if (appCaches[i].getType() != 2) break;
            protocol = "file:/";
            break;
        }
        if (protocol == null) {
            return null;
        }
        url = protocol + BDJLoader.getCachedFile(System.getProperty("bluray.vfs.root") + File.separator + "BDMV" + File.separator + "JAR" + File.separator + url) + path.substring(5);
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            System.err.println("" + e + "\n" + Logger.dumpStack(e));
            return null;
        }
    }

    private BDJClassLoader(URL[] urls, String xletClass) {
        super(urls);
        this.xletClass = xletClass;
    }

    protected Xlet loadXlet() throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        return (Xlet)this.loadClass(this.xletClass).newInstance();
    }

    protected void update(AppCache[] appCaches, String basePath, String classPathExt, String xletClass) {
        int i;
        ArrayList<URL> classPath = new ArrayList<URL>();
        URL[] urls = this.getURLs();
        for (int i2 = 0; i2 < urls.length; ++i2) {
            classPath.add(urls[i2]);
        }
        URL url = BDJClassLoader.translateClassPath(appCaches, basePath, null);
        if (url != null) {
            classPath.add(url);
        }
        String[] classPaths = StrUtil.split(classPathExt, ';');
        for (i = 0; i < classPaths.length; ++i) {
            url = BDJClassLoader.translateClassPath(appCaches, basePath, classPaths[i]);
            if (url == null || classPath.indexOf(url) >= 0) continue;
            classPath.add(url);
        }
        for (i = 0; i < classPath.size(); ++i) {
            this.addURL((URL)classPath.get(i));
        }
        this.xletClass = xletClass;
    }

    public Class loadClass(String name) throws ClassNotFoundException {
        if (name.equals("java.io.File")) {
            Class<?> c = super.loadClass(name);
            if (c != null) {
                BDFileSystem.init(c);
            }
            return c;
        }
        try {
            return super.loadClass(name);
        }
        catch (ClassNotFoundException e0) {
            logger.error("ClassNotFoundException: " + name);
            throw e0;
        }
        catch (Error err) {
            logger.error("FATAL: " + err);
            throw err;
        }
    }

    private byte[] loadClassCode(String name) throws ClassNotFoundException {
        String path = name.replace('.', '/').concat(".class");
        URL res = super.findResource(path);
        if (res == null) {
            logger.error("loadClassCode(): resource for class " + name + "not found");
            throw new ClassNotFoundException(name);
        }
        InputStream is = null;
        ByteArrayOutputStream os = null;
        try {
            int r;
            is = res.openStream();
            os = new ByteArrayOutputStream();
            byte[] buffer = new byte[65535];
            while ((r = is.read(buffer)) != -1) {
                os.write(buffer, 0, r);
            }
            byte[] byArray = os.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            logger.error("loadClassCode(" + name + ") failed: " + e);
            throw new ClassNotFoundException(name);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException ioe) {}
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (IOException ioe) {}
        }
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        try {
            return super.findClass(name);
        }
        catch (ClassFormatError ce) {
            byte[] b = this.loadClassCode(name);
            if (b == null) {
                logger.error("loadClassCode(" + name + ") failed");
                throw ce;
            }
            try {
                b = new BDJClassFileTransformer().transform(b, 0, b.length);
                return this.defineClass(b, 0, b.length);
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable t) {
                logger.error("Class rewriting failed: " + t);
                throw new ClassNotFoundException(name);
            }
        }
        catch (Error er) {
            logger.error("Unexpected error: " + er + " " + Logger.dumpStack(er));
            throw er;
        }
    }

    public URL getResource(String name) {
        name = name.replace('\\', '/');
        return super.getResource(name);
    }

    public URL findResource(String name) {
        name = name.replace('\\', '/');
        return super.findResource(name);
    }

    public Enumeration findResources(String name) throws IOException {
        name = name.replace('\\', '/');
        return super.findResources(name);
    }

    public InputStream getResourceAsStream(String name) {
        name = name.replace('\\', '/');
        return super.getResourceAsStream(name);
    }
}

