/*
 * Copyright (C) 2006-2008 the VideoLAN team
 *
 * This file is part of VLMa.
 * 
 * VLMa is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 * 
 * VLMa is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with VLMa. If not, see <http://www.gnu.org/licenses/>.
 *
 */

package org.videolan.vlma.common;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

/**
 * The VLMa configuration. Implements the singleton pattern to provide an easy 
 * way to access the VLMa configuration.
 * 
 * @author jpountz
 */
public class Configuration implements Serializable {

    private static final String defaultWorkDir = "/var/lib/vlma/";

    private static final int defaultVlcTelnetPort = 4212;

    private static final String defaultVlcTelnetPassword = "admin";

    private static final String defaultSnmpCommunity = "public";

    private static Map<String, String> defaultOids = null;

    static {
        Map<String, String> map = new HashMap<String, String>();
        map.put("CPU_LOAD",
                "1.3.6.1.4.1.2021.2016.10.4.1.2.8.99.112.117.95.108.111.97.100.1");
        map.put("TRAFFIC_IN",
                "1.3.6.1.4.1.2021.2016.11.4.1.2.10.116.114.97.102.102.105.99.95.105.110.1");
        map.put("TRAFFIC_OUT",
                "1.3.6.1.4.1.2021.2016.12.4.1.2.11.116.114.97.102.102.105.99.95.111.117.116.1");
        map.put("VLC_CPU",
                "1.3.6.1.4.1.2021.2016.13.4.1.2.7.118.108.99.95.99.112.117.1");
        map.put("VLC_MEM",
                "1.3.6.1.4.1.2021.2016.14.4.1.2.7.118.108.99.95.109.101.109.1");
        defaultOids = map;
    }

    private static Configuration instance;

    public static Configuration getInstance() {
        return (instance == null) ? new Configuration() : instance;
    }

    private String workDir;

    private Integer vlcTelnetPort;

    private String vlcTelnetPassword;

    private String snmpCommunity;

    private Map<String, String> oids;

    private Configuration() {
        this.workDir = defaultWorkDir;
        this.vlcTelnetPort = defaultVlcTelnetPort;
        this.vlcTelnetPassword = defaultVlcTelnetPassword;
        this.snmpCommunity = defaultSnmpCommunity;
        this.oids = defaultOids;
    }

    public int getVlcTelnetPort() {
        return vlcTelnetPort;
    }

    public void setVlcTelnetPort(Integer vlcTelnetPort) {
        if (vlcTelnetPort != null)
            this.vlcTelnetPort = vlcTelnetPort;
    }

    public String getVlcTelnetPassword() {
        return vlcTelnetPassword;
    }

    public void setVlcTelnetPassword(String vlcTelnetPassword) {
        if (vlcTelnetPassword != null)
            this.vlcTelnetPassword = vlcTelnetPassword;
    }

    public String getWorkDir() {
        return workDir;
    }

    public void setWorkDir(String workDir) {
        if (workDir != null)
            this.workDir = workDir;
    }

    public String getSnmpCommunity() {
        return snmpCommunity;
    }

    public void setSnmpCommunity(String snmpCommunity) {
        if (snmpCommunity != null)
            this.snmpCommunity = snmpCommunity;
    }

    public Map<String, String> getoids() {
        return oids;
    }

    public void setOids(Map<String, String> oids) {
        if (oids != null)
            this.oids = oids;
    }

}
