/*
 * Decompiled with CFR 0.152.
 */
package org.videolan.vlma.web.servers;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.validation.BindException;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.SimpleFormController;
import org.videolan.vlma.common.IVlData;
import org.videolan.vlma.common.VlServer;
import org.videolan.vlma.common.adapters.IVlAdapter;
import org.videolan.vlma.common.adapters.VlDVBS;
import org.videolan.vlma.web.servers.ServersAdapterAdd;

public class ServersAdapterAddFormController
extends SimpleFormController {
    private IVlData data;

    public IVlData getData() {
        return this.data;
    }

    public void setData(IVlData data) {
        this.data = data;
    }

    public ModelAndView onSubmit(Object command) throws ServletException, InstantiationException, IllegalAccessException, ClassNotFoundException {
        String adapterName = ((ServersAdapterAdd)command).getName();
        int server = ((ServersAdapterAdd)command).getServer();
        String type = ((ServersAdapterAdd)command).getType();
        this.data.addAdapter(server, adapterName, type);
        IVlAdapter a = this.data.getAdapter(server, adapterName);
        if (a.getClass().equals(VlDVBS.class)) {
            this.data.setAdapterParameter(server, adapterName, "satellite", ((ServersAdapterAdd)command).getSatellite().toUpperCase());
        }
        HashMap<String, VlServer> params = new HashMap<String, VlServer>();
        params.put("server", this.data.getServer(server));
        return new ModelAndView("servers/serversview", params);
    }

    protected Object formBackingObject(HttpServletRequest request) throws ServletException {
        ServersAdapterAdd serversAdapterAdd = new ServersAdapterAdd();
        serversAdapterAdd.setName("");
        serversAdapterAdd.setServer(Integer.parseInt(request.getParameter("server")));
        serversAdapterAdd.setType("DVB-T");
        serversAdapterAdd.setSatellite("");
        serversAdapterAdd.setData(this.data);
        return serversAdapterAdd;
    }

    protected ModelAndView showForm(HttpServletRequest arg0, HttpServletResponse arg1, BindException arg2, Map arg3) throws Exception {
        VlServer server = this.data.getServer(Integer.parseInt(arg0.getParameter("server")));
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("server", server);
        m.put("satellites", this.data.getSatellites());
        return super.showForm(arg0, arg1, arg2, m);
    }
}

