/*
 * Decompiled with CFR 0.152.
 */
package org.videolan.vlma.web.servlet;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.util.Assert;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.videolan.vlma.common.IVlData;
import org.videolan.vlma.common.exceptions.InvalidServerNameException;

public class RrdGraphServlet
extends HttpServlet {
    private static final int bufsize = 32768;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        WebApplicationContext webApplicationContext = WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.getServletContext());
        IVlData data = (IVlData)webApplicationContext.getBean("dataImporter");
        String serverName = request.getParameter("server");
        if (serverName.contains(File.separator)) {
            throw new InvalidServerNameException("Server name musn't contain '" + File.separator + "'.");
        }
        String what = request.getParameter("what");
        Assert.isTrue(("vlc".equals(what) || "cpu_load".equals(what) || "traffic_out".equals(what) ? 1 : 0) != 0);
        File basePath = new File(data.getConfiguration().getWorkDir());
        File rrdDir = new File(basePath, "rrd");
        File file = new File(rrdDir, serverName + "-" + what + ".png");
        FileInputStream in = new FileInputStream(file.getAbsolutePath());
        response.setContentType("image/png");
        ServletOutputStream out = response.getOutputStream();
        byte[] image = new byte[32768];
        in.read(image);
        in.close();
        out.write(image);
    }
}

