
<%@ include file="/WEB-INF/jsp/include.jsp" %>    

<h1>
    <fmt:message key="servers.view">
        <fmt:param value="${server.name}" />
    </fmt:message>
</h1>

<ul>
    <li><fmt:message key="servers.view.name" /> <b><c:out value="${server.name}" /></b></li>
    <li><fmt:message key="servers.view.address" /> <b><c:out value="${server.ip}" /></b></li>
    <li><fmt:message key="servers.view.adapters" />
        <ul>
        <c:forEach items="${server.adapters}" var="adapter">
            <li><b><c:out value="${adapter.key}" /></b>
                <c:choose>
                    <c:when test="${adapter.value.type == 'DVB-S'}">
                        <fmt:message key="servers.view.adapters.dvbs"><fmt:param value="${adapter.value.satellite.name}" /></fmt:message>
                    </c:when>
                    <c:when test="${adapter.value.type == 'DVB-T'}">
                        <fmt:message key="servers.view.adapters.dvbt" />
                    </c:when>
                    <c:when test="${adapter.value.type == 'Files-Adapter'}">
                        <fmt:message key="servers.view.adapters.files-adapter" />
                    </c:when>
                </c:choose>
                <c:url value="serversadapterremove.htm" var="adapterRemoveUrl">
                    <c:param name="server" value="${server.id}" />
                    <c:param name="adapter" value="${adapter.key}" />
                </c:url>
                <a href="${adapterRemoveUrl}"><fmt:message key="servers.view.adapters.remove" /></a>
            </li>
        </c:forEach>
        </ul>
        <c:url value="serversadapteradd.htm" var="adapterAddUrl">
            <c:param name="server" value="${server.id}" />
        </c:url>
        <a href="${adapterAddUrl}"><fmt:message key="servers.view.adapters.add" /></a>
    </li>
    <li><fmt:message key="servers.view.monitoring.load" />
        <img alt="<fmt:message key="servers.view.monitoring.load-alt" />" src="<c:url value="/" />rrdgraph?server=<c:out value="${server.name}" />&what=cpu_load" />
    </li>
    <li><fmt:message key="servers.view.monitoring.traffic" />
        <img alt="<fmt:message key="servers.view.monitoring.traffic-alt" />" src="<c:url value="/" />rrdgraph?server=<c:out value="${server.name}" />&what=traffic_out" />
    </li>
    <li><fmt:message key="servers.view.monitoring.resources" />
        <img alt="<fmt:message key="servers.view.monitoring.resources-alt" />" src="<c:url value="/" />rrdgraph?server=<c:out value="${server.name}" />&what=vlc" />
    </li>        
</ul>
