/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.core;

import org.jrobin.core.RrdException;

public class ArcDef {
    public static final String[] CONSOL_FUNS = new String[]{"AVERAGE", "MAX", "MIN", "LAST"};
    private String consolFun;
    private double xff;
    private int steps;
    private int rows;

    public ArcDef(String string, double d, int n, int n2) throws RrdException {
        this.consolFun = string;
        this.xff = d;
        this.steps = n;
        this.rows = n2;
        this.validate();
    }

    public String getConsolFun() {
        return this.consolFun;
    }

    public double getXff() {
        return this.xff;
    }

    public int getSteps() {
        return this.steps;
    }

    public int getRows() {
        return this.rows;
    }

    private void validate() throws RrdException {
        if (!ArcDef.isValidConsolFun(this.consolFun)) {
            throw new RrdException("Invalid consolidation function specified: " + this.consolFun);
        }
        if (Double.isNaN(this.xff) || this.xff < 0.0 || this.xff >= 1.0) {
            throw new RrdException("Invalid xff, must be >= 0 and < 1: " + this.xff);
        }
        if (this.steps <= 0 || this.rows <= 0) {
            throw new RrdException("Invalid steps/rows number: " + this.steps + "/" + this.rows);
        }
    }

    public String dump() {
        return "RRA:" + this.consolFun + ":" + this.xff + ":" + this.steps + ":" + this.rows;
    }

    public boolean equals(Object object) {
        if (object instanceof ArcDef) {
            ArcDef arcDef = (ArcDef)object;
            return this.consolFun.equals(arcDef.consolFun) && this.steps == arcDef.steps;
        }
        return false;
    }

    public static boolean isValidConsolFun(String string) {
        for (int i = 0; i < CONSOL_FUNS.length; ++i) {
            if (!CONSOL_FUNS[i].equals(string)) continue;
            return true;
        }
        return false;
    }

    void setRows(int n) {
        this.rows = n;
    }

    boolean exactlyEqual(ArcDef arcDef) {
        return this.consolFun.equals(arcDef.consolFun) && this.xff == arcDef.xff && this.steps == arcDef.steps && this.rows == arcDef.rows;
    }
}

